/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.util;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.internal.client.ui.util.Messages;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;

public final class PasswordHelper {
    public static final PasswordHelper INSTANCE = new PasswordHelper();
    private Pattern pattern;
    private String patternExplanation;

    private PasswordHelper() {
        String patternExplanation;
        ESExtensionPoint showPasswordControls = new ESExtensionPoint("org.eclipse.emf.emfstore.client.ui.showPasswordControls");
        String pattern = showPasswordControls.getAttribute("pattern");
        if (pattern != null) {
            try {
                Pattern compiledPattern;
                this.pattern = compiledPattern = Pattern.compile(pattern);
            }
            catch (PatternSyntaxException ex) {
                ModelUtil.logWarning((String)Messages.PasswordHelper_PatternInvalid, (Throwable)ex);
            }
        }
        this.patternExplanation = (patternExplanation = showPasswordControls.getAttribute("patternExplanation")) != null && !StringUtils.isBlank((String)patternExplanation) ? patternExplanation : Messages.PasswordHelper_PasswordDoesNotMatchDefault;
    }

    public boolean matchesPattern(String pwd) {
        if (this.pattern == null) {
            return true;
        }
        return this.pattern.matcher(pwd).matches();
    }

    public String getInvalidPatternMessage() {
        return this.patternExplanation;
    }
}

