/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.impl.api;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ESCompositeOperationHandle;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESRemoteProject;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.callbacks.ESCommitCallback;
import org.eclipse.emf.emfstore.client.callbacks.ESUpdateCallback;
import org.eclipse.emf.emfstore.client.exceptions.ESProjectNotSharedException;
import org.eclipse.emf.emfstore.client.util.ESVoidCallable;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.common.ESObserver;
import org.eclipse.emf.emfstore.common.model.ESModelElementId;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.ChangeConflictException;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.internal.client.model.impl.WorkspaceBase;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESRemoteProjectImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESUsersessionImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.Messages;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.common.api.APIDelegate;
import org.eclipse.emf.emfstore.internal.common.api.AbstractAPIImpl;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.impl.ESModelElementIdImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidVersionSpecException;
import org.eclipse.emf.emfstore.internal.server.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESLocalProjectIdImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.versionspec.ESBranchVersionSpecImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.versionspec.ESPrimaryVersionSpecImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.versionspec.ESTagVersionSpecImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.versionspec.ESVersionSpecImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.exceptions.ESUpdateRequiredException;
import org.eclipse.emf.emfstore.server.model.ESBranchInfo;
import org.eclipse.emf.emfstore.server.model.ESGlobalProjectId;
import org.eclipse.emf.emfstore.server.model.ESHistoryInfo;
import org.eclipse.emf.emfstore.server.model.ESLocalProjectId;
import org.eclipse.emf.emfstore.server.model.query.ESHistoryQuery;
import org.eclipse.emf.emfstore.server.model.versionspec.ESBranchVersionSpec;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versionspec.ESTagVersionSpec;
import org.eclipse.emf.emfstore.server.model.versionspec.ESVersionSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ESLocalProjectImpl
extends AbstractAPIImpl<ESLocalProjectImpl, ProjectSpace>
implements ESLocalProject {
    public ESLocalProjectImpl(ProjectSpace projectSpace) {
        super((APIDelegate)projectSpace);
    }

    @Override
    public ESGlobalProjectId getGlobalProjectId() {
        this.checkIsShared();
        return RunESCommand.runWithResult(new Callable<ESGlobalProjectId>(){

            @Override
            public ESGlobalProjectId call() throws Exception {
                return (ESGlobalProjectId)((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).getProjectId().toAPI();
            }
        });
    }

    @Override
    public String getProjectName() {
        return RunESCommand.runWithResult(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).getProjectName();
            }
        });
    }

    @Override
    public void delete(final IProgressMonitor monitor) throws IOException {
        RunESCommand.WithException.run(IOException.class, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).delete(monitor);
                return null;
            }
        });
    }

    @Override
    public ESPrimaryVersionSpec resolveVersionSpec(ESVersionSpec versionSpec, final IProgressMonitor monitor) throws ESException {
        this.checkIsShared();
        final ESVersionSpecImpl versionSpecImpl = (ESVersionSpecImpl)versionSpec;
        PrimaryVersionSpec resolvedVersionSpec = RunESCommand.WithException.runWithResult(ESException.class, new Callable<PrimaryVersionSpec>(){

            @Override
            public PrimaryVersionSpec call() throws Exception {
                return (PrimaryVersionSpec)new ServerCall<PrimaryVersionSpec>((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI(), monitor){

                    @Override
                    protected PrimaryVersionSpec run() throws ESException {
                        return this.getConnectionManager().resolveVersionSpec(this.getSessionId(), ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).getProjectId(), (VersionSpec)versionSpecImpl.toInternalAPI());
                    }
                }.execute();
            }
        });
        return (ESPrimaryVersionSpec)resolvedVersionSpec.toAPI();
    }

    @Override
    public List<ESBranchInfo> getBranches(final IProgressMonitor monitor) throws ESException {
        this.checkIsShared();
        return RunESCommand.WithException.runWithResult(ESException.class, new Callable<List<ESBranchInfo>>(){

            @Override
            public List<ESBranchInfo> call() throws Exception {
                List branchInfos = (List)new ServerCall<List<BranchInfo>>((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI(), monitor){

                    @Override
                    protected List<BranchInfo> run() throws ESException {
                        return this.getConnectionManager().getBranches(this.getSessionId(), ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).getProjectId());
                    }
                }.execute();
                return APIUtil.mapToAPI(ESBranchInfo.class, (List)branchInfos);
            }
        });
    }

    @Override
    public void addTag(ESPrimaryVersionSpec versionSpec, ESTagVersionSpec tag, final IProgressMonitor monitor) throws ESException {
        this.checkIsShared();
        final PrimaryVersionSpec primaryVersionSpec = (PrimaryVersionSpec)((ESPrimaryVersionSpecImpl)versionSpec).toInternalAPI();
        final TagVersionSpec tagVersionSpec = (TagVersionSpec)((ESTagVersionSpecImpl)tag).toInternalAPI();
        RunESCommand.WithException.run(ESException.class, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                new ServerCall<Void>((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI(), monitor){

                    @Override
                    protected Void run() throws ESException {
                        this.getConnectionManager().addTag(this.getUsersession().getSessionId(), ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).getProjectId(), primaryVersionSpec, tagVersionSpec);
                        return null;
                    }
                }.execute();
                return null;
            }
        });
    }

    @Override
    public void removeTag(ESPrimaryVersionSpec versionSpec, ESTagVersionSpec tag, final IProgressMonitor monitor) throws ESException {
        this.checkIsShared();
        final PrimaryVersionSpec primaryVersionSpec = (PrimaryVersionSpec)((ESPrimaryVersionSpecImpl)versionSpec).toInternalAPI();
        final TagVersionSpec tagVersionSpec = (TagVersionSpec)((ESTagVersionSpecImpl)tag).toInternalAPI();
        RunESCommand.WithException.run(ESException.class, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                new ServerCall<Void>((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI(), monitor){

                    @Override
                    protected Void run() throws ESException {
                        this.getConnectionManager().removeTag(this.getSessionId(), ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).getProjectId(), primaryVersionSpec, tagVersionSpec);
                        return null;
                    }
                }.execute();
                return null;
            }
        });
    }

    public EObject getModelElement(ESModelElementId modelElementId) {
        final ModelElementId internalId = (ModelElementId)((ESModelElementIdImpl)modelElementId).toInternalAPI();
        return RunESCommand.runWithResult(new Callable<EObject>(){

            @Override
            public EObject call() throws Exception {
                return ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).getProject().get((Object)internalId);
            }
        });
    }

    public ESModelElementIdImpl getModelElementId(EObject modelElement) {
        ModelElementId modelElementId = ((ProjectSpace)this.toInternalAPI()).getProject().getModelElementId(modelElement);
        if (modelElementId == null) {
            return null;
        }
        return (ESModelElementIdImpl)modelElementId.toAPI();
    }

    public EList<EObject> getModelElements() {
        return RunESCommand.runWithResult(new Callable<EList<EObject>>(){

            @Override
            public EList<EObject> call() throws Exception {
                return ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).getProject().getModelElements();
            }
        });
    }

    public Set<EObject> getAllModelElements() {
        return RunESCommand.runWithResult(new Callable<Set<EObject>>(){

            @Override
            public Set<EObject> call() throws Exception {
                return ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).getProject().getAllModelElements();
            }
        });
    }

    public <T extends EObject> Set<T> getAllModelElementsByClass(final Class<T> modelElementClass, final Boolean includeSubclasses) {
        return (Set)RunESCommand.runWithResult(new Callable<Set<T>>(){

            @Override
            public Set<T> call() throws Exception {
                return ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).getProject().getAllModelElementsByClass(modelElementClass, includeSubclasses);
            }
        });
    }

    public <T extends EObject> Set<T> getAllModelElementsByClass(final Class<T> modelElementClass) {
        return (Set)RunESCommand.runWithResult(new Callable<Set<T>>(){

            @Override
            public Set<T> call() throws Exception {
                return ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).getProject().getAllModelElementsByClass(modelElementClass);
            }
        });
    }

    public boolean contains(ESModelElementId modelElementId) {
        ModelElementId id = (ModelElementId)((ESModelElementIdImpl)modelElementId).toInternalAPI();
        return ((ProjectSpace)this.toInternalAPI()).getProject().contains(id);
    }

    public boolean contains(EObject modelElement) {
        return ((ProjectSpace)this.toInternalAPI()).getProject().contains(modelElement);
    }

    @Override
    public ESPrimaryVersionSpec commit(final IProgressMonitor monitor) throws ESException {
        PrimaryVersionSpec versionSpec = RunESCommand.WithException.runWithResult(ESException.class, new Callable<PrimaryVersionSpec>(){

            @Override
            public PrimaryVersionSpec call() throws Exception {
                return ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).commit(monitor);
            }
        });
        return (ESPrimaryVersionSpec)versionSpec.toAPI();
    }

    @Override
    public ESPrimaryVersionSpec commit(final String logMessage, final ESCommitCallback callback, final IProgressMonitor monitor) throws ESUpdateRequiredException, ESException {
        this.checkIsShared();
        PrimaryVersionSpec versionSpec = RunESCommand.WithException.runWithResult(ESException.class, new Callable<PrimaryVersionSpec>(){

            @Override
            public PrimaryVersionSpec call() throws Exception {
                return ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).commit(logMessage, callback, monitor);
            }
        });
        return (ESPrimaryVersionSpec)versionSpec.toAPI();
    }

    @Override
    public ESPrimaryVersionSpec commitToBranch(final ESBranchVersionSpec branch, final String logMessage, final ESCommitCallback callback, final IProgressMonitor monitor) throws InvalidVersionSpecException, ESUpdateRequiredException, ESException {
        PrimaryVersionSpec versionSpec = RunESCommand.WithException.runWithResult(ESException.class, new Callable<PrimaryVersionSpec>(){

            @Override
            public PrimaryVersionSpec call() throws Exception {
                BranchVersionSpec versionSpec = null;
                if (branch != null) {
                    versionSpec = (BranchVersionSpec)((ESBranchVersionSpecImpl)branch).toInternalAPI();
                }
                return ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).commitToBranch(versionSpec, logMessage, callback, monitor);
            }
        });
        return (ESPrimaryVersionSpec)versionSpec.toAPI();
    }

    @Override
    public ESPrimaryVersionSpec update(final IProgressMonitor monitor) throws ChangeConflictException, ESException {
        return RunESCommand.WithException.runWithResult(ESException.class, new Callable<ESPrimaryVersionSpec>(){

            @Override
            public ESPrimaryVersionSpec call() throws Exception {
                PrimaryVersionSpec versionSpec = ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).update(monitor);
                return (ESPrimaryVersionSpec)versionSpec.toAPI();
            }
        });
    }

    @Override
    public ESPrimaryVersionSpec update(ESVersionSpec versionSpec, final ESUpdateCallback callback, final IProgressMonitor monitor) throws ChangeConflictException, ESException {
        VersionSpec version;
        if (versionSpec == null) {
            version = null;
        } else {
            ESVersionSpecImpl versionSpecImpl = (ESVersionSpecImpl)versionSpec;
            version = (VersionSpec)versionSpecImpl.toInternalAPI();
        }
        return RunESCommand.WithException.runWithResult(ESException.class, new Callable<ESPrimaryVersionSpec>(){

            @Override
            public ESPrimaryVersionSpec call() throws Exception {
                PrimaryVersionSpec primaryVersionSpec = ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).update(version, callback, monitor);
                return (ESPrimaryVersionSpec)primaryVersionSpec.toAPI();
            }
        });
    }

    @Override
    public void addToWorkspace(IProgressMonitor progressMonitor) {
        RunESCommand.run(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ProjectSpaceBase projectSpace = (ProjectSpaceBase)ESLocalProjectImpl.this.toInternalAPI();
                WorkspaceBase workspace = (WorkspaceBase)ESWorkspaceProviderImpl.getInstance().getInternalWorkspace();
                projectSpace.initResources(workspace.getResourceSet());
                workspace.addProjectSpace(projectSpace);
                workspace.save();
                ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)projectSpace);
                return null;
            }
        });
    }

    @Override
    public void shareProject(final IProgressMonitor monitor) throws ESException {
        RunESCommand.WithException.run(ESException.class, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).shareProject(monitor);
                return null;
            }
        });
    }

    @Override
    public ESRemoteProject shareProject(ESUsersession session, final IProgressMonitor monitor) throws ESException {
        final ESUsersessionImpl usersessionImpl = (ESUsersessionImpl)session;
        return RunESCommand.WithException.runWithResult(ESException.class, new Callable<ESRemoteProject>(){

            @Override
            public ESRemoteProject call() throws Exception {
                ProjectInfo projectInfo = ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).shareProject(usersessionImpl != null ? (Usersession)usersessionImpl.toInternalAPI() : null, monitor);
                return new ESRemoteProjectImpl(((Usersession)ESLocalProjectImpl.this.getUsersession().toInternalAPI()).getServerInfo(), projectInfo);
            }
        });
    }

    @Override
    public boolean isShared() {
        return ((ProjectSpace)this.toInternalAPI()).isShared();
    }

    @Override
    public ESUsersessionImpl getUsersession() {
        return RunESCommand.runWithResult(new Callable<ESUsersessionImpl>(){

            @Override
            public ESUsersessionImpl call() throws Exception {
                if (((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).getUsersession() == null) {
                    return null;
                }
                return (ESUsersessionImpl)((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).getUsersession().toAPI();
            }
        });
    }

    @Override
    public ESPrimaryVersionSpec getBaseVersion() {
        this.checkIsShared();
        return RunESCommand.runWithResult(new Callable<ESPrimaryVersionSpec>(){

            @Override
            public ESPrimaryVersionSpec call() throws Exception {
                PrimaryVersionSpec baseVersion = ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).getBaseVersion();
                return baseVersion != null ? (ESPrimaryVersionSpec)baseVersion.toAPI() : null;
            }
        });
    }

    @Override
    public Date getLastUpdated() {
        this.checkIsShared();
        return RunESCommand.runWithResult(new Callable<Date>(){

            @Override
            public Date call() throws Exception {
                return ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).getLastUpdated();
            }
        });
    }

    @Override
    public List<String> getRecentLogMessages() {
        this.checkIsShared();
        return RunESCommand.runWithResult(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).getOldLogMessages();
            }
        });
    }

    @Override
    public void undoLastOperation() {
        RunESCommand.run(new ESVoidCallable(){

            public void run() {
                ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).undoLastOperation();
            }
        });
    }

    @Override
    public void undoLastOperations(final int nrOperations) {
        RunESCommand.run(new ESVoidCallable(){

            public void run() {
                ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).undoLastOperations(nrOperations);
            }
        });
    }

    @Override
    public boolean isUpdated() throws ESException {
        this.checkIsShared();
        return ((ProjectSpace)this.toInternalAPI()).isUpdated();
    }

    @Override
    public void revert() {
        RunESCommand.run(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).revert();
                return null;
            }
        });
    }

    @Override
    public void save() {
        RunESCommand.run(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).save();
                return null;
            }
        });
    }

    @Override
    public boolean hasUnsavedChanges() {
        return ((ProjectSpace)this.toInternalAPI()).hasUnsavedChanges();
    }

    @Override
    public boolean hasUncommitedChanges() {
        return ((ProjectSpace)this.toInternalAPI()).isDirty();
    }

    @Override
    public ESRemoteProjectImpl getRemoteProject() throws ESException {
        this.checkIsShared();
        return RunESCommand.WithException.runWithResult(ESException.class, new Callable<ESRemoteProjectImpl>(){

            @Override
            public ESRemoteProjectImpl call() throws Exception {
                if (ESLocalProjectImpl.this.getUsersession() == null || ESLocalProjectImpl.this.getUsersession().getServer() == null) {
                    throw new ESException(Messages.ESLocalProjectImpl_No_Usersession_Found);
                }
                ProjectInfo projectInfo = ModelFactory.eINSTANCE.createProjectInfo();
                projectInfo.setProjectId((ProjectId)ModelUtil.clone((EObject)((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).getProjectId()));
                projectInfo.setName(ESLocalProjectImpl.this.getProjectName());
                projectInfo.setVersion((PrimaryVersionSpec)ModelUtil.clone((EObject)((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).getBaseVersion()));
                return new ESRemoteProjectImpl(((Usersession)ESLocalProjectImpl.this.getUsersession().toInternalAPI()).getServerInfo(), projectInfo);
            }
        });
    }

    @Override
    public ESLocalProjectId getLocalProjectId() {
        return RunESCommand.runWithResult(new Callable<ESLocalProjectId>(){

            @Override
            public ESLocalProjectId call() throws Exception {
                return new ESLocalProjectIdImpl(((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).getIdentifier());
            }
        });
    }

    private void checkIsShared() {
        if (!this.isShared()) {
            throw new ESProjectNotSharedException();
        }
    }

    @Override
    public List<ESHistoryInfo> getHistoryInfos(final ESHistoryQuery<? extends ESHistoryQuery<?>> query, final IProgressMonitor monitor) throws ESException {
        return RunESCommand.WithException.runWithResult(ESException.class, new Callable<List<ESHistoryInfo>>(){

            @Override
            public List<ESHistoryInfo> call() throws Exception {
                return APIUtil.copy(ESLocalProjectImpl.this.getRemoteProject().getHistoryInfos(ESLocalProjectImpl.this.getUsersession(), query, monitor));
            }
        });
    }

    @Override
    public ESCompositeOperationHandle beginCompositeOperation() {
        return RunESCommand.runWithResult(new Callable<ESCompositeOperationHandle>(){

            @Override
            public ESCompositeOperationHandle call() throws Exception {
                return ((ProjectSpace)ESLocalProjectImpl.this.toInternalAPI()).beginCompositeOperation().toAPI();
            }
        });
    }
}

