/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxgraph.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fx.ide.fxgraph.fXGraph.BindValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ComponentDefinition;
import org.eclipse.fx.ide.fxgraph.fXGraph.ConstValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ControllerHandledValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.CopyValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Define;
import org.eclipse.fx.ide.fxgraph.fXGraph.Element;
import org.eclipse.fx.ide.fxgraph.fXGraph.FactoryValueElement;
import org.eclipse.fx.ide.fxgraph.fXGraph.IncludeValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ListValueElement;
import org.eclipse.fx.ide.fxgraph.fXGraph.ListValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.LocationValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.MapValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Model;
import org.eclipse.fx.ide.fxgraph.fXGraph.PackageDeclaration;
import org.eclipse.fx.ide.fxgraph.fXGraph.Property;
import org.eclipse.fx.ide.fxgraph.fXGraph.ReferenceType;
import org.eclipse.fx.ide.fxgraph.fXGraph.ReferenceValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ResourceValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Script;
import org.eclipse.fx.ide.fxgraph.fXGraph.ScriptHandlerHandledValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ScriptValueExpression;
import org.eclipse.fx.ide.fxgraph.fXGraph.ScriptValueReference;
import org.eclipse.fx.ide.fxgraph.fXGraph.SimpleValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticCallValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StringValue;
import org.eclipse.fx.ide.fxgraph.fXGraph.ValueProperty;
import org.eclipse.fx.ide.fxgraph.generator.LanguageManager;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class FXGraphGenerator
implements IGenerator {
    public String calculateRelativePath(Resource resource) {
        URI _uRI = resource.getURI();
        boolean _isPlatformResource = _uRI.isPlatformResource();
        if (_isPlatformResource) {
            String _plus_1;
            String[] _segments;
            URI uri = resource.getURI();
            IWorkspace _workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = _workspace.getRoot();
            String _segment = uri.segment(1);
            IProject project = root.getProject(_segment);
            String projectRelativePath = "";
            int i = 0;
            String[] stringArray = _segments = uri.segments();
            int n = _segments.length;
            int n2 = 0;
            while (n2 < n) {
                if (i >= 1) {
                    String _plus;
                    String _segment_1 = uri.segment(i);
                    projectRelativePath = _plus = String.valueOf(projectRelativePath) + "/" + _segment_1;
                }
                ++i;
                ++n2;
            }
            String _name = project.getName();
            int _length = _name.length();
            int _plus = _length + 2;
            String _substring = projectRelativePath.substring(_plus);
            projectRelativePath = _plus_1 = "../" + _substring;
            return projectRelativePath;
        }
        return null;
    }

    public String doGeneratePreview(Resource resource, boolean skipController, boolean skipIncludes) {
        try {
            boolean _notEquals;
            String projectRelativePath = this.calculateRelativePath(resource);
            boolean bl = _notEquals = !Objects.equal((Object)projectRelativePath, null);
            if (_notEquals) {
                CharSequence _createContent = this.createContent(resource, projectRelativePath, true, skipController, skipIncludes);
                return _createContent.toString();
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception cfr_ignored_0 = (Exception)_t;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return null;
    }

    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        try {
            boolean _notEquals;
            String projectRelativePath = this.calculateRelativePath(resource);
            boolean bl = _notEquals = !Objects.equal((Object)projectRelativePath, null);
            if (_notEquals) {
                String relativeOutPath = projectRelativePath.replaceFirst(".fxgraph$", ".fxml");
                CharSequence _createContent = this.createContent(resource, projectRelativePath, false, false, false);
                fsa.generateFile(relativeOutPath, _createContent);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception cfr_ignored_0 = (Exception)_t;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public CharSequence createContent(Resource resource, String projectRelativePath, boolean preview, boolean skipController, boolean skipIncludes) {
        StringConcatenation _builder = new StringConcatenation();
        ImportManager importManager = new ImportManager(true);
        _builder.newLineIfNotEmpty();
        LanguageManager languageManager = new LanguageManager();
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append((Object)"<!-- ");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"Do not edit this file it is generated by e(fx)clipse from ");
        _builder.append((Object)projectRelativePath, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"-->");
        _builder.newLine();
        _builder.newLine();
        EList _contents = resource.getContents();
        EObject _get = (EObject)_contents.get(0);
        EList _eContents = _get.eContents();
        Iterable _filter = Iterables.filter((Iterable)_eContents, ComponentDefinition.class);
        for (ComponentDefinition rootElement : _filter) {
            boolean _notEquals;
            CharSequence body = this.componentDefinition(rootElement, importManager, languageManager, preview, skipController, skipIncludes);
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"<?import java.lang.*?>");
            _builder.newLine();
            List _imports = importManager.getImports();
            for (String i : _imports) {
                _builder.append((Object)"<?import ");
                _builder.append((Object)i, "");
                _builder.append((Object)"?>");
                _builder.newLineIfNotEmpty();
            }
            Collection<String> _languages = languageManager.getLanguages();
            for (String i_1 : _languages) {
                _builder.append((Object)"<?language ");
                _builder.append((Object)i_1, "");
                _builder.append((Object)"?>");
                _builder.newLineIfNotEmpty();
            }
            EList _contents_1 = resource.getContents();
            EObject _get_1 = (EObject)_contents_1.get(0);
            ComponentDefinition _componentDef = ((Model)_get_1).getComponentDef();
            String _previewResourceBundle = _componentDef.getPreviewResourceBundle();
            boolean bl = _notEquals = !Objects.equal((Object)_previewResourceBundle, null);
            if (_notEquals) {
                _builder.append((Object)"<?scenebuilder-preview-i18n-resource ");
                EList _contents_2 = resource.getContents();
                EObject _get_2 = (EObject)_contents_2.get(0);
                ComponentDefinition _componentDef_1 = ((Model)_get_2).getComponentDef();
                String _previewResourceBundle_1 = _componentDef_1.getPreviewResourceBundle();
                _builder.append((Object)_previewResourceBundle_1, "");
                _builder.append((Object)"?>");
                _builder.newLineIfNotEmpty();
            }
            EList _contents_3 = resource.getContents();
            EObject _get_3 = (EObject)_contents_3.get(0);
            ComponentDefinition _componentDef_2 = ((Model)_get_3).getComponentDef();
            EList<String> _previewCssFiles = _componentDef_2.getPreviewCssFiles();
            for (String css : _previewCssFiles) {
                _builder.append((Object)"<?scenebuilder-stylesheet ");
                _builder.append((Object)css, "");
                _builder.append((Object)"?>");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append((Object)body, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence componentDefinition(ComponentDefinition definition, ImportManager importManager, LanguageManager languageManager, boolean preview, boolean skipController, boolean skipIncludes) {
        boolean _isDynamicRoot_1;
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        Element element = definition.getRootNode();
        _builder.newLineIfNotEmpty();
        boolean _isDynamicRoot = definition.isDynamicRoot();
        if (_isDynamicRoot) {
            boolean _hasAttributeProperties;
            boolean _notEquals;
            _builder.append((Object)"<fx:root xmlns:fx=\"http://javafx.com/fxml\" type=\"");
            JvmTypeReference _type = element.getType();
            String _shortName = this.shortName(_type, importManager);
            _builder.append((Object)_shortName, "");
            _builder.append((Object)"\"");
            String _fxElementAttributes = this.fxElementAttributes(element, importManager, skipController);
            _builder.append((Object)_fxElementAttributes, "");
            boolean _and = false;
            JvmTypeReference _controller = definition.getController();
            boolean bl = _notEquals = !Objects.equal((Object)_controller, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean bl2 = _and = !skipController;
            }
            if (_and) {
                _builder.append((Object)" fx:controller=\"");
                JvmTypeReference _controller_1 = definition.getController();
                String _qualifiedName = _controller_1.getQualifiedName();
                _builder.append((Object)_qualifiedName, "");
                _builder.append((Object)"\"");
            }
            if (_hasAttributeProperties = this.hasAttributeProperties(element, preview)) {
                EList<Property> _properties = element.getProperties();
                StringBuilder _elementAttributes = this.elementAttributes((List<Property>)_properties, preview, skipController);
                _builder.append((Object)_elementAttributes, "");
                EList<StaticValueProperty> _staticProperties = element.getStaticProperties();
                StringBuilder _elementStaticAttributes = this.elementStaticAttributes((List<StaticValueProperty>)_staticProperties, importManager, preview, skipController);
                _builder.append((Object)_elementStaticAttributes, "");
                EList<StaticCallValueProperty> _staticCallProperties = element.getStaticCallProperties();
                StringBuilder _elementStaticCallAttributes = this.elementStaticCallAttributes((List<StaticCallValueProperty>)_staticCallProperties, importManager, preview, skipController);
                _builder.append((Object)_elementStaticCallAttributes, "");
            }
            _builder.append((Object)">");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _hasAttributeProperties_1;
            boolean _notEquals_1;
            _builder.append((Object)"<");
            JvmTypeReference _type_1 = element.getType();
            String _shortName_1 = this.shortName(_type_1, importManager);
            _builder.append((Object)_shortName_1, "");
            _builder.append((Object)" xmlns:fx=\"http://javafx.com/fxml\"");
            String _fxElementAttributes_1 = this.fxElementAttributes(element, importManager, skipController);
            _builder.append((Object)_fxElementAttributes_1, "");
            boolean _and_1 = false;
            JvmTypeReference _controller_2 = definition.getController();
            boolean bl = _notEquals_1 = !Objects.equal((Object)_controller_2, null);
            if (!_notEquals_1) {
                _and_1 = false;
            } else {
                boolean bl3 = _and_1 = !skipController;
            }
            if (_and_1) {
                _builder.append((Object)" fx:controller=\"");
                JvmTypeReference _controller_3 = definition.getController();
                String _qualifiedName_1 = _controller_3.getQualifiedName();
                _builder.append((Object)_qualifiedName_1, "");
                _builder.append((Object)"\"");
            }
            if (_hasAttributeProperties_1 = this.hasAttributeProperties(element, preview)) {
                EList<Property> _properties_1 = element.getProperties();
                StringBuilder _elementAttributes_1 = this.elementAttributes((List<Property>)_properties_1, preview, skipController);
                _builder.append((Object)_elementAttributes_1, "");
                EList<StaticValueProperty> _staticProperties_1 = element.getStaticProperties();
                StringBuilder _elementStaticAttributes_1 = this.elementStaticAttributes((List<StaticValueProperty>)_staticProperties_1, importManager, preview, skipController);
                _builder.append((Object)_elementStaticAttributes_1, "");
                EList<StaticCallValueProperty> _staticCallProperties_1 = element.getStaticCallProperties();
                StringBuilder _elementStaticCallAttributes_1 = this.elementStaticCallAttributes((List<StaticCallValueProperty>)_staticCallProperties_1, importManager, preview, skipController);
                _builder.append((Object)_elementStaticCallAttributes_1, "");
            }
            _builder.append((Object)">");
            _builder.newLineIfNotEmpty();
        }
        EList<Define> _defines = definition.getDefines();
        int _size = _defines.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append((Object)"\t");
            _builder.append((Object)"<fx:define>");
            _builder.newLine();
            EList<Define> _defines_1 = definition.getDefines();
            for (Define define : _defines_1) {
                boolean _notEquals_3;
                boolean _notEquals_2;
                Element _element = define.getElement();
                boolean bl4 = _notEquals_2 = !Objects.equal((Object)_element, null);
                if (_notEquals_2) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    Element _element_1 = define.getElement();
                    CharSequence _elementContent = this.elementContent(_element_1, importManager, preview, skipController, skipIncludes);
                    _builder.append((Object)_elementContent, "\t\t");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                IncludeValueProperty _includeElement = define.getIncludeElement();
                boolean bl5 = _notEquals_3 = !Objects.equal((Object)_includeElement, null);
                if (!_notEquals_3 || skipIncludes) continue;
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                IncludeValueProperty _includeElement_1 = define.getIncludeElement();
                CharSequence _includeContent = this.includeContent(_includeElement_1, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_includeContent, "\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"</fx:define>");
            _builder.newLine();
        }
        if (!skipController) {
            EList<Script> _scripts = definition.getScripts();
            for (Script script : _scripts) {
                boolean _notEquals_4;
                _builder.append((Object)"\t");
                String _language = script.getLanguage();
                String _addLanguage = languageManager.addLanguage(_language);
                _builder.append((Object)_addLanguage, "\t");
                _builder.newLineIfNotEmpty();
                String _sourcecode = script.getSourcecode();
                boolean bl6 = _notEquals_4 = !Objects.equal((Object)_sourcecode, null);
                if (_notEquals_4) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"<fx:script>");
                    String _sourcecode_1 = script.getSourcecode();
                    String _sourcecode_2 = script.getSourcecode();
                    int _length = _sourcecode_2.length();
                    int _minus = _length - 2;
                    String _substring = _sourcecode_1.substring(2, _minus);
                    _builder.append((Object)_substring, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"</fx:script>");
                    _builder.newLine();
                    continue;
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"<fx:script source=\"");
                String _source = script.getSource();
                _builder.append((Object)_source, "\t");
                _builder.append((Object)"\"/>");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        boolean _hasNestedProperties = this.hasNestedProperties(element, preview);
        if (_hasNestedProperties) {
            EList<Element> _defaultChildren = element.getDefaultChildren();
            for (Element e : _defaultChildren) {
                _builder.append((Object)"\t");
                CharSequence _elementContent_1 = this.elementContent(e, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_elementContent_1, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            EList<Property> _properties_2 = element.getProperties();
            CharSequence _propContents = this.propContents((List<Property>)_properties_2, importManager, preview, false, skipController, skipIncludes);
            _builder.append((Object)_propContents, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            EList<StaticValueProperty> _staticProperties_2 = element.getStaticProperties();
            CharSequence _statPropContent = this.statPropContent((List<StaticValueProperty>)_staticProperties_2, importManager, preview, skipController, skipIncludes);
            _builder.append((Object)_statPropContent, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            EList<StaticCallValueProperty> _staticCallProperties_2 = element.getStaticCallProperties();
            CharSequence _statCallPropContent = this.statCallPropContent((List<StaticCallValueProperty>)_staticCallProperties_2, importManager, preview, skipController, skipIncludes);
            _builder.append((Object)_statCallPropContent, "\t");
            _builder.newLineIfNotEmpty();
        }
        if (_isDynamicRoot_1 = definition.isDynamicRoot()) {
            _builder.append((Object)"</fx:root>");
            _builder.newLine();
        } else {
            _builder.append((Object)"</");
            JvmTypeReference _type_2 = element.getType();
            String _shortName_2 = this.shortName(_type_2, importManager);
            _builder.append((Object)_shortName_2, "");
            _builder.append((Object)">");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence elementContent(Element element, ImportManager importManager, boolean preview, boolean skipController, boolean skipIncludes) {
        boolean _hasNestedProperties;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<");
        JvmTypeReference _type = element.getType();
        String _shortName = this.shortName(_type, importManager);
        _builder.append((Object)_shortName, "");
        String _fxElementAttributes = this.fxElementAttributes(element, importManager, skipController);
        _builder.append((Object)_fxElementAttributes, "");
        boolean _hasAttributeProperties = this.hasAttributeProperties(element, preview);
        if (_hasAttributeProperties) {
            EList<Property> _properties = element.getProperties();
            StringBuilder _elementAttributes = this.elementAttributes((List<Property>)_properties, preview, skipController);
            _builder.append((Object)_elementAttributes, "");
            EList<StaticValueProperty> _staticProperties = element.getStaticProperties();
            StringBuilder _elementStaticAttributes = this.elementStaticAttributes((List<StaticValueProperty>)_staticProperties, importManager, preview, skipController);
            _builder.append((Object)_elementStaticAttributes, "");
            EList<StaticCallValueProperty> _staticCallProperties = element.getStaticCallProperties();
            StringBuilder _elementStaticCallAttributes = this.elementStaticCallAttributes((List<StaticCallValueProperty>)_staticCallProperties, importManager, preview, skipController);
            _builder.append((Object)_elementStaticCallAttributes, "");
        }
        boolean bl = _not = !(_hasNestedProperties = this.hasNestedProperties(element, preview));
        if (_not) {
            _builder.append((Object)"/");
        }
        _builder.append((Object)"> ");
        _builder.newLineIfNotEmpty();
        boolean _hasNestedProperties_1 = this.hasNestedProperties(element, preview);
        if (_hasNestedProperties_1) {
            EList<Element> _defaultChildren = element.getDefaultChildren();
            for (Element e : _defaultChildren) {
                _builder.append((Object)"\t");
                CharSequence _elementContent = this.elementContent(e, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_elementContent, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            EList<Property> _properties_1 = element.getProperties();
            CharSequence _propContents = this.propContents((List<Property>)_properties_1, importManager, preview, false, skipController, skipIncludes);
            _builder.append((Object)_propContents, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            EList<StaticValueProperty> _staticProperties_1 = element.getStaticProperties();
            CharSequence _statPropContent = this.statPropContent((List<StaticValueProperty>)_staticProperties_1, importManager, preview, skipController, skipIncludes);
            _builder.append((Object)_statPropContent, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            EList<StaticCallValueProperty> _staticCallProperties_1 = element.getStaticCallProperties();
            CharSequence _statCallPropContent = this.statCallPropContent((List<StaticCallValueProperty>)_staticCallProperties_1, importManager, preview, skipController, skipIncludes);
            _builder.append((Object)_statCallPropContent, "\t");
            _builder.newLineIfNotEmpty();
            EList<FactoryValueElement> _values = element.getValues();
            for (FactoryValueElement e_1 : _values) {
                if (e_1 instanceof Element) {
                    _builder.append((Object)"\t");
                    CharSequence _elementContent_1 = this.elementContent((Element)e_1, importManager, preview, skipController, skipIncludes);
                    _builder.append((Object)_elementContent_1, "\t");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                if (!(e_1 instanceof SimpleValueProperty)) continue;
                _builder.append((Object)"\t");
                String _objectLiteral = this.objectLiteral((SimpleValueProperty)e_1);
                _builder.append((Object)_objectLiteral, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"</");
            JvmTypeReference _type_1 = element.getType();
            String _shortName_1 = this.shortName(_type_1, importManager);
            _builder.append((Object)_shortName_1, "");
            _builder.append((Object)">");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public String objectLiteral(SimpleValueProperty value) {
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        String _stringValue = value.getStringValue();
        boolean bl = _notEquals = !Objects.equal((Object)_stringValue, null);
        if (_notEquals) {
            String _stringValue_1 = value.getStringValue();
            String _plus = "<String fx:value=\"" + _stringValue_1;
            return String.valueOf(_plus) + "\" />";
        }
        String _booleanValue = value.getBooleanValue();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_booleanValue, null);
        if (_notEquals_1) {
            String _booleanValue_1 = value.getBooleanValue();
            String _plus_1 = "<Boolean fx:value=\"" + _booleanValue_1;
            return String.valueOf(_plus_1) + "\" />";
        }
        boolean _and = false;
        String _number = value.getNumber();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_number, null);
        if (!_notEquals_2) {
            _and = false;
        } else {
            boolean _isIntNumber;
            String _number_1 = value.getNumber();
            _and = _isIntNumber = FXGraphGenerator.isIntNumber(_number_1);
        }
        if (_and) {
            boolean _isNegative = value.isNegative();
            if (_isNegative) {
                String _number_2 = value.getNumber();
                String _plus_2 = "<Double fx:value=\"-" + _number_2;
                return String.valueOf(_plus_2) + "\" />";
            }
            String _number_3 = value.getNumber();
            String _plus_3 = "<Double fx:value=\"" + _number_3;
            return String.valueOf(_plus_3) + "\" />";
        }
        boolean _isNegative_1 = value.isNegative();
        if (_isNegative_1) {
            String _number_4 = value.getNumber();
            String _plus_4 = "<Integer fx:value=\"-" + _number_4;
            return String.valueOf(_plus_4) + "\" />";
        }
        String _number_5 = value.getNumber();
        String _plus_5 = "<Integer fx:value=\"" + _number_5;
        return String.valueOf(_plus_5) + "\" />";
    }

    public CharSequence propContents(List<Property> properties, ImportManager importManager, final boolean preview, boolean simpleAsElement, boolean skipController, boolean skipIncludes) {
        StringConcatenation _builder = new StringConcatenation();
        if (simpleAsElement) {
            for (Property prop : properties) {
                CharSequence _propContent = this.propContent(prop, importManager, preview, simpleAsElement, skipController, skipIncludes);
                _builder.append((Object)_propContent, "");
                _builder.newLineIfNotEmpty();
            }
        } else {
            Functions.Function1<Property, Boolean> _function = new Functions.Function1<Property, Boolean>(){

                public Boolean apply(Property p) {
                    return FXGraphGenerator.this.previewFilter(p, preview);
                }
            };
            Iterable _filter = IterableExtensions.filter(properties, (Functions.Function1)_function);
            Functions.Function1<Property, Boolean> _function_1 = new Functions.Function1<Property, Boolean>(){

                public Boolean apply(Property p) {
                    return FXGraphGenerator.this.subelementFilter(p);
                }
            };
            Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function_1);
            for (Property prop_1 : _filter_1) {
                CharSequence _propContent_1 = this.propContent(prop_1, importManager, preview, simpleAsElement, skipController, skipIncludes);
                _builder.append((Object)_propContent_1, "");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public CharSequence propContent(Property prop, ImportManager importManager, boolean preview, boolean simpleAsElement, boolean skipController, boolean skipIncludes) {
        StringConcatenation _builder = new StringConcatenation();
        ValueProperty _value = prop.getValue();
        if (_value instanceof SimpleValueProperty) {
            boolean _notEquals;
            ValueProperty _value_1 = prop.getValue();
            String _stringValue = ((SimpleValueProperty)_value_1).getStringValue();
            boolean bl = _notEquals = !Objects.equal((Object)_stringValue, null);
            if (_notEquals) {
                _builder.append((Object)"<");
                String _name = prop.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)">");
                ValueProperty _value_2 = prop.getValue();
                String _stringValue_1 = ((SimpleValueProperty)_value_2).getStringValue();
                _builder.append((Object)_stringValue_1, "");
                _builder.append((Object)"</");
                String _name_1 = prop.getName();
                _builder.append((Object)_name_1, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
            } else if (simpleAsElement) {
                _builder.append((Object)"<");
                String _name_2 = prop.getName();
                _builder.append((Object)_name_2, "");
                _builder.append((Object)">");
                ValueProperty _value_3 = prop.getValue();
                String _simpleAttributeValue = this.simpleAttributeValue((SimpleValueProperty)_value_3);
                _builder.append((Object)_simpleAttributeValue, "");
                _builder.append((Object)"</");
                String _name_3 = prop.getName();
                _builder.append((Object)_name_3, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
            }
        } else {
            ValueProperty _value_4 = prop.getValue();
            if (_value_4 instanceof ConstValueProperty) {
                _builder.append((Object)"<");
                String _name_4 = prop.getName();
                _builder.append((Object)_name_4, "");
                _builder.append((Object)"><");
                ValueProperty _value_5 = prop.getValue();
                JvmTypeReference _type = ((ConstValueProperty)_value_5).getType();
                String _shortName = this.shortName(_type, importManager);
                _builder.append((Object)_shortName, "");
                _builder.append((Object)" fx:constant=\"");
                ValueProperty _value_6 = prop.getValue();
                String _field = ((ConstValueProperty)_value_6).getField();
                _builder.append((Object)_field, "");
                _builder.append((Object)"\" /></");
                String _name_5 = prop.getName();
                _builder.append((Object)_name_5, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
            } else {
                ValueProperty _value_7 = prop.getValue();
                if (_value_7 instanceof ListValueProperty) {
                    _builder.append((Object)"<");
                    String _name_6 = prop.getName();
                    _builder.append((Object)_name_6, "");
                    _builder.append((Object)">");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    ValueProperty _value_8 = prop.getValue();
                    CharSequence _propListContent = this.propListContent((ListValueProperty)_value_8, importManager, preview, skipController, skipIncludes);
                    _builder.append((Object)_propListContent, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"</");
                    String _name_7 = prop.getName();
                    _builder.append((Object)_name_7, "");
                    _builder.append((Object)">");
                    _builder.newLineIfNotEmpty();
                } else {
                    ValueProperty _value_9 = prop.getValue();
                    if (_value_9 instanceof MapValueProperty) {
                        _builder.append((Object)"<");
                        String _name_8 = prop.getName();
                        _builder.append((Object)_name_8, "");
                        _builder.append((Object)">");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        ValueProperty _value_10 = prop.getValue();
                        EList<Property> _properties = ((MapValueProperty)_value_10).getProperties();
                        CharSequence _propContents = this.propContents((List<Property>)_properties, importManager, preview, true, skipController, skipIncludes);
                        _builder.append((Object)_propContents, "\t");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"</");
                        String _name_9 = prop.getName();
                        _builder.append((Object)_name_9, "");
                        _builder.append((Object)">");
                        _builder.newLineIfNotEmpty();
                    } else {
                        ValueProperty _value_11 = prop.getValue();
                        if (_value_11 instanceof Element) {
                            _builder.append((Object)"<");
                            String _name_10 = prop.getName();
                            _builder.append((Object)_name_10, "");
                            _builder.append((Object)">");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            ValueProperty _value_12 = prop.getValue();
                            CharSequence _elementContent = this.elementContent((Element)_value_12, importManager, preview, skipController, skipIncludes);
                            _builder.append((Object)_elementContent, "\t");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"</");
                            String _name_11 = prop.getName();
                            _builder.append((Object)_name_11, "");
                            _builder.append((Object)">");
                            _builder.newLineIfNotEmpty();
                        } else {
                            ValueProperty _value_13 = prop.getValue();
                            if (_value_13 instanceof ReferenceValueProperty) {
                                if (!skipIncludes) {
                                    _builder.append((Object)"<");
                                    String _name_12 = prop.getName();
                                    _builder.append((Object)_name_12, "");
                                    _builder.append((Object)">");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append((Object)"\t");
                                    ValueProperty _value_14 = prop.getValue();
                                    CharSequence _referenceContent = this.referenceContent((ReferenceValueProperty)_value_14, importManager, preview, skipController, skipIncludes);
                                    _builder.append((Object)_referenceContent, "\t");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append((Object)"</");
                                    String _name_13 = prop.getName();
                                    _builder.append((Object)_name_13, "");
                                    _builder.append((Object)">");
                                    _builder.newLineIfNotEmpty();
                                }
                            } else {
                                ValueProperty _value_15 = prop.getValue();
                                if (_value_15 instanceof IncludeValueProperty) {
                                    if (!skipIncludes) {
                                        _builder.append((Object)"<");
                                        String _name_14 = prop.getName();
                                        _builder.append((Object)_name_14, "");
                                        _builder.append((Object)">");
                                        _builder.newLineIfNotEmpty();
                                        _builder.append((Object)"\t");
                                        ValueProperty _value_16 = prop.getValue();
                                        CharSequence _includeContent = this.includeContent((IncludeValueProperty)_value_16, importManager, preview, skipController, skipIncludes);
                                        _builder.append((Object)_includeContent, "\t");
                                        _builder.newLineIfNotEmpty();
                                        _builder.append((Object)"</");
                                        String _name_15 = prop.getName();
                                        _builder.append((Object)_name_15, "");
                                        _builder.append((Object)">");
                                        _builder.newLineIfNotEmpty();
                                    }
                                } else {
                                    ValueProperty _value_17 = prop.getValue();
                                    if (_value_17 instanceof CopyValueProperty) {
                                        _builder.append((Object)"<");
                                        String _name_16 = prop.getName();
                                        _builder.append((Object)_name_16, "");
                                        _builder.append((Object)">");
                                        _builder.newLineIfNotEmpty();
                                        _builder.append((Object)"\t");
                                        _builder.append((Object)"<fx:copy source=\"");
                                        ValueProperty _value_18 = prop.getValue();
                                        Element _reference = ((CopyValueProperty)_value_18).getReference();
                                        String _name_17 = _reference.getName();
                                        _builder.append((Object)_name_17, "\t");
                                        _builder.append((Object)"\" />");
                                        _builder.newLineIfNotEmpty();
                                        _builder.append((Object)"</");
                                        String _name_18 = prop.getName();
                                        _builder.append((Object)_name_18, "");
                                        _builder.append((Object)">");
                                        _builder.newLineIfNotEmpty();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return _builder;
    }

    public CharSequence includeContent(IncludeValueProperty includeElement, ImportManager importManager, boolean preview, boolean skipController, boolean skipIncludes) {
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<fx:include");
        String _name = includeElement.getName();
        boolean bl = _notEquals = !Objects.equal((Object)_name, null);
        if (_notEquals) {
            _builder.append((Object)" fx:id=\"");
            String _name_1 = includeElement.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)"\"");
        }
        _builder.append((Object)" source=\"/");
        ComponentDefinition _source = includeElement.getSource();
        String _fullyQualifiedName = this.fullyQualifiedName(_source);
        String _replaceAll = _fullyQualifiedName.replaceAll("\\.", "/");
        _builder.append((Object)_replaceAll, "");
        _builder.append((Object)".fxml\"");
        EList<StaticValueProperty> _staticProperties = includeElement.getStaticProperties();
        StringBuilder _elementStaticAttributes = this.elementStaticAttributes((List<StaticValueProperty>)_staticProperties, importManager, preview, skipController);
        _builder.append((Object)_elementStaticAttributes, "");
        EList<StaticCallValueProperty> _staticCallProperties = includeElement.getStaticCallProperties();
        StringBuilder _elementStaticCallAttributes = this.elementStaticCallAttributes((List<StaticCallValueProperty>)_staticCallProperties, importManager, preview, skipController);
        _builder.append((Object)_elementStaticCallAttributes, "");
        _builder.append((Object)" ");
        boolean _hasNestedProperties = this.hasNestedProperties(includeElement, preview);
        boolean bl2 = _not = !_hasNestedProperties;
        if (_not) {
            _builder.append((Object)"/");
        }
        _builder.append((Object)">");
        _builder.newLineIfNotEmpty();
        boolean _hasNestedProperties_1 = this.hasNestedProperties(includeElement, preview);
        if (_hasNestedProperties_1) {
            _builder.append((Object)"\t");
            EList<StaticCallValueProperty> _staticCallProperties_1 = includeElement.getStaticCallProperties();
            CharSequence _statCallPropContent = this.statCallPropContent((List<StaticCallValueProperty>)_staticCallProperties_1, importManager, preview, skipController, skipIncludes);
            _builder.append((Object)_statCallPropContent, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            EList<StaticValueProperty> _staticProperties_1 = includeElement.getStaticProperties();
            CharSequence _statPropContent = this.statPropContent((List<StaticValueProperty>)_staticProperties_1, importManager, preview, skipController, skipIncludes);
            _builder.append((Object)_statPropContent, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"</fx:include>");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence referenceContent(ReferenceValueProperty referenceElement, ImportManager importManager, boolean preview, boolean skipController, boolean skipIncludes) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<fx:reference source=\"");
        ReferenceType _reference = referenceElement.getReference();
        String _refname = this.refname(_reference);
        _builder.append((Object)_refname, "");
        _builder.append((Object)"\"");
        EList<StaticValueProperty> _staticProperties = referenceElement.getStaticProperties();
        StringBuilder _elementStaticAttributes = this.elementStaticAttributes((List<StaticValueProperty>)_staticProperties, importManager, preview, skipController);
        _builder.append((Object)_elementStaticAttributes, "");
        EList<StaticCallValueProperty> _staticCallProperties = referenceElement.getStaticCallProperties();
        StringBuilder _elementStaticCallAttributes = this.elementStaticCallAttributes((List<StaticCallValueProperty>)_staticCallProperties, importManager, preview, skipController);
        _builder.append((Object)_elementStaticCallAttributes, "");
        _builder.append((Object)" ");
        boolean _hasNestedProperties = this.hasNestedProperties(referenceElement, preview);
        boolean bl = _not = !_hasNestedProperties;
        if (_not) {
            _builder.append((Object)"/");
        }
        _builder.append((Object)">");
        _builder.newLineIfNotEmpty();
        boolean _hasNestedProperties_1 = this.hasNestedProperties(referenceElement, preview);
        if (_hasNestedProperties_1) {
            _builder.append((Object)"\t");
            EList<StaticCallValueProperty> _staticCallProperties_1 = referenceElement.getStaticCallProperties();
            CharSequence _statCallPropContent = this.statCallPropContent((List<StaticCallValueProperty>)_staticCallProperties_1, importManager, preview, skipController, skipIncludes);
            _builder.append((Object)_statCallPropContent, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            EList<StaticValueProperty> _staticProperties_1 = referenceElement.getStaticProperties();
            CharSequence _statPropContent = this.statPropContent((List<StaticValueProperty>)_staticProperties_1, importManager, preview, skipController, skipIncludes);
            _builder.append((Object)_statPropContent, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"</fx:reference>");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence statCallPropContent(List<StaticCallValueProperty> properties, ImportManager importManager, final boolean preview, boolean skipController, boolean skipIncludes) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1<StaticCallValueProperty, Boolean> _function = new Functions.Function1<StaticCallValueProperty, Boolean>(){

            public Boolean apply(StaticCallValueProperty p) {
                return FXGraphGenerator.this.previewFilter(p, preview);
            }
        };
        Iterable _filter = IterableExtensions.filter(properties, (Functions.Function1)_function);
        Functions.Function1<StaticCallValueProperty, Boolean> _function_1 = new Functions.Function1<StaticCallValueProperty, Boolean>(){

            public Boolean apply(StaticCallValueProperty p) {
                return FXGraphGenerator.this.subelementFilter(p);
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function_1);
        for (StaticCallValueProperty prop : _filter_1) {
            ValueProperty _value = prop.getValue();
            if (_value instanceof SimpleValueProperty) {
                boolean _notEquals;
                ValueProperty _value_1 = prop.getValue();
                String _stringValue = ((SimpleValueProperty)_value_1).getStringValue();
                boolean bl = _notEquals = !Objects.equal((Object)_stringValue, null);
                if (_notEquals) {
                    _builder.append((Object)"<");
                    JvmTypeReference _type = prop.getType();
                    String _shortName = this.shortName(_type, importManager);
                    _builder.append((Object)_shortName, "");
                    _builder.append((Object)".");
                    String _name = prop.getName();
                    _builder.append((Object)_name, "");
                    _builder.append((Object)">");
                    ValueProperty _value_2 = prop.getValue();
                    String _stringValue_1 = ((SimpleValueProperty)_value_2).getStringValue();
                    _builder.append((Object)_stringValue_1, "");
                    _builder.append((Object)"</");
                    JvmTypeReference _type_1 = prop.getType();
                    String _shortName_1 = this.shortName(_type_1, importManager);
                    _builder.append((Object)_shortName_1, "");
                    _builder.append((Object)".");
                    String _name_1 = prop.getName();
                    _builder.append((Object)_name_1, "");
                    _builder.append((Object)">");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append((Object)"<");
                JvmTypeReference _type_2 = prop.getType();
                String _shortName_2 = this.shortName(_type_2, importManager);
                _builder.append((Object)_shortName_2, "");
                _builder.append((Object)".");
                String _name_2 = prop.getName();
                _builder.append((Object)_name_2, "");
                _builder.append((Object)">");
                ValueProperty _value_3 = prop.getValue();
                String _simpleAttributeValue = this.simpleAttributeValue((SimpleValueProperty)_value_3);
                _builder.append((Object)_simpleAttributeValue, "");
                _builder.append((Object)"</");
                JvmTypeReference _type_3 = prop.getType();
                String _shortName_3 = this.shortName(_type_3, importManager);
                _builder.append((Object)_shortName_3, "");
                _builder.append((Object)".");
                String _name_3 = prop.getName();
                _builder.append((Object)_name_3, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_4 = prop.getValue();
            if (_value_4 instanceof ConstValueProperty) {
                _builder.append((Object)"<");
                JvmTypeReference _type_4 = prop.getType();
                String _shortName_4 = this.shortName(_type_4, importManager);
                _builder.append((Object)_shortName_4, "");
                _builder.append((Object)".");
                String _name_4 = prop.getName();
                _builder.append((Object)_name_4, "");
                _builder.append((Object)"><");
                ValueProperty _value_5 = prop.getValue();
                JvmTypeReference _type_5 = ((ConstValueProperty)_value_5).getType();
                String _shortName_5 = this.shortName(_type_5, importManager);
                _builder.append((Object)_shortName_5, "");
                _builder.append((Object)" fx:constant=\"");
                ValueProperty _value_6 = prop.getValue();
                String _field = ((ConstValueProperty)_value_6).getField();
                _builder.append((Object)_field, "");
                _builder.append((Object)"\" /></");
                JvmTypeReference _type_6 = prop.getType();
                String _shortName_6 = this.shortName(_type_6, importManager);
                _builder.append((Object)_shortName_6, "");
                _builder.append((Object)".");
                String _name_5 = prop.getName();
                _builder.append((Object)_name_5, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_7 = prop.getValue();
            if (_value_7 instanceof ListValueProperty) {
                _builder.append((Object)"<");
                JvmTypeReference _type_7 = prop.getType();
                String _shortName_7 = this.shortName(_type_7, importManager);
                _builder.append((Object)_shortName_7, "");
                _builder.append((Object)".");
                String _name_6 = prop.getName();
                _builder.append((Object)_name_6, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                ValueProperty _value_8 = prop.getValue();
                CharSequence _propListContent = this.propListContent((ListValueProperty)_value_8, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_propListContent, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"</");
                JvmTypeReference _type_8 = prop.getType();
                String _shortName_8 = this.shortName(_type_8, importManager);
                _builder.append((Object)_shortName_8, "");
                _builder.append((Object)".");
                String _name_7 = prop.getName();
                _builder.append((Object)_name_7, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_9 = prop.getValue();
            if (_value_9 instanceof MapValueProperty) {
                _builder.append((Object)"<");
                JvmTypeReference _type_9 = prop.getType();
                String _shortName_9 = this.shortName(_type_9, importManager);
                _builder.append((Object)_shortName_9, "");
                _builder.append((Object)".");
                String _name_8 = prop.getName();
                _builder.append((Object)_name_8, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                ValueProperty _value_10 = prop.getValue();
                EList<Property> _properties = ((MapValueProperty)_value_10).getProperties();
                CharSequence _propContents = this.propContents((List<Property>)_properties, importManager, preview, true, skipController, skipIncludes);
                _builder.append((Object)_propContents, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"</");
                JvmTypeReference _type_10 = prop.getType();
                String _shortName_10 = this.shortName(_type_10, importManager);
                _builder.append((Object)_shortName_10, "");
                _builder.append((Object)".");
                String _name_9 = prop.getName();
                _builder.append((Object)_name_9, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_11 = prop.getValue();
            if (_value_11 instanceof Element) {
                _builder.append((Object)"<");
                JvmTypeReference _type_11 = prop.getType();
                String _shortName_11 = this.shortName(_type_11, importManager);
                _builder.append((Object)_shortName_11, "");
                _builder.append((Object)".");
                String _name_10 = prop.getName();
                _builder.append((Object)_name_10, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                ValueProperty _value_12 = prop.getValue();
                CharSequence _elementContent = this.elementContent((Element)_value_12, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_elementContent, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"</");
                JvmTypeReference _type_12 = prop.getType();
                String _shortName_12 = this.shortName(_type_12, importManager);
                _builder.append((Object)_shortName_12, "");
                _builder.append((Object)".");
                String _name_11 = prop.getName();
                _builder.append((Object)_name_11, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_13 = prop.getValue();
            if (_value_13 instanceof ReferenceValueProperty) {
                _builder.append((Object)"<");
                JvmTypeReference _type_13 = prop.getType();
                String _shortName_13 = this.shortName(_type_13, importManager);
                _builder.append((Object)_shortName_13, "");
                _builder.append((Object)".");
                String _name_12 = prop.getName();
                _builder.append((Object)_name_12, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                ValueProperty _value_14 = prop.getValue();
                CharSequence _referenceContent = this.referenceContent((ReferenceValueProperty)_value_14, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_referenceContent, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"</");
                JvmTypeReference _type_14 = prop.getType();
                String _shortName_14 = this.shortName(_type_14, importManager);
                _builder.append((Object)_shortName_14, "");
                _builder.append((Object)".");
                String _name_13 = prop.getName();
                _builder.append((Object)_name_13, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_15 = prop.getValue();
            if (_value_15 instanceof IncludeValueProperty) {
                if (skipIncludes) continue;
                _builder.append((Object)"<");
                JvmTypeReference _type_15 = prop.getType();
                String _shortName_15 = this.shortName(_type_15, importManager);
                _builder.append((Object)_shortName_15, "");
                _builder.append((Object)".");
                String _name_14 = prop.getName();
                _builder.append((Object)_name_14, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                ValueProperty _value_16 = prop.getValue();
                CharSequence _includeContent = this.includeContent((IncludeValueProperty)_value_16, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_includeContent, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"</");
                JvmTypeReference _type_16 = prop.getType();
                String _shortName_16 = this.shortName(_type_16, importManager);
                _builder.append((Object)_shortName_16, "");
                _builder.append((Object)".");
                String _name_15 = prop.getName();
                _builder.append((Object)_name_15, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_17 = prop.getValue();
            if (!(_value_17 instanceof CopyValueProperty)) continue;
            _builder.append((Object)"<");
            JvmTypeReference _type_17 = prop.getType();
            String _shortName_17 = this.shortName(_type_17, importManager);
            _builder.append((Object)_shortName_17, "");
            _builder.append((Object)".");
            String _name_16 = prop.getName();
            _builder.append((Object)_name_16, "");
            _builder.append((Object)">");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"<fx:copy source=\"");
            ValueProperty _value_18 = prop.getValue();
            Element _reference = ((CopyValueProperty)_value_18).getReference();
            String _name_17 = _reference.getName();
            _builder.append((Object)_name_17, "\t");
            _builder.append((Object)"\" />");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"</");
            JvmTypeReference _type_18 = prop.getType();
            String _shortName_18 = this.shortName(_type_18, importManager);
            _builder.append((Object)_shortName_18, "");
            _builder.append((Object)".");
            String _name_18 = prop.getName();
            _builder.append((Object)_name_18, "");
            _builder.append((Object)">");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence statPropContent(List<StaticValueProperty> properties, ImportManager importManager, final boolean preview, boolean skipController, boolean skipIncludes) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1<StaticValueProperty, Boolean> _function = new Functions.Function1<StaticValueProperty, Boolean>(){

            public Boolean apply(StaticValueProperty p) {
                return FXGraphGenerator.this.previewFilter(p, preview);
            }
        };
        Iterable _filter = IterableExtensions.filter(properties, (Functions.Function1)_function);
        Functions.Function1<StaticValueProperty, Boolean> _function_1 = new Functions.Function1<StaticValueProperty, Boolean>(){

            public Boolean apply(StaticValueProperty p) {
                return FXGraphGenerator.this.subelementFilter(p);
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function_1);
        for (StaticValueProperty prop : _filter_1) {
            ValueProperty _value = prop.getValue();
            if (_value instanceof SimpleValueProperty) {
                boolean _notEquals;
                ValueProperty _value_1 = prop.getValue();
                String _stringValue = ((SimpleValueProperty)_value_1).getStringValue();
                boolean bl = _notEquals = !Objects.equal((Object)_stringValue, null);
                if (_notEquals) {
                    _builder.append((Object)"<");
                    JvmTypeReference _type = this.type(prop);
                    String _shortName = this.shortName(_type, importManager);
                    _builder.append((Object)_shortName, "");
                    _builder.append((Object)".");
                    String _name = prop.getName();
                    _builder.append((Object)_name, "");
                    _builder.append((Object)">");
                    ValueProperty _value_2 = prop.getValue();
                    String _stringValue_1 = ((SimpleValueProperty)_value_2).getStringValue();
                    _builder.append((Object)_stringValue_1, "");
                    _builder.append((Object)"</");
                    JvmTypeReference _type_1 = this.type(prop);
                    String _shortName_1 = this.shortName(_type_1, importManager);
                    _builder.append((Object)_shortName_1, "");
                    _builder.append((Object)".");
                    String _name_1 = prop.getName();
                    _builder.append((Object)_name_1, "");
                    _builder.append((Object)">");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                _builder.append((Object)"<");
                JvmTypeReference _type_2 = this.type(prop);
                String _shortName_2 = this.shortName(_type_2, importManager);
                _builder.append((Object)_shortName_2, "");
                _builder.append((Object)".");
                String _name_2 = prop.getName();
                _builder.append((Object)_name_2, "");
                _builder.append((Object)">");
                ValueProperty _value_3 = prop.getValue();
                String _simpleAttributeValue = this.simpleAttributeValue((SimpleValueProperty)_value_3);
                _builder.append((Object)_simpleAttributeValue, "");
                _builder.append((Object)"</");
                JvmTypeReference _type_3 = this.type(prop);
                String _shortName_3 = this.shortName(_type_3, importManager);
                _builder.append((Object)_shortName_3, "");
                _builder.append((Object)".");
                String _name_3 = prop.getName();
                _builder.append((Object)_name_3, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_4 = prop.getValue();
            if (_value_4 instanceof ConstValueProperty) {
                _builder.append((Object)"<");
                JvmTypeReference _type_4 = this.type(prop);
                String _shortName_4 = this.shortName(_type_4, importManager);
                _builder.append((Object)_shortName_4, "");
                _builder.append((Object)".");
                String _name_4 = prop.getName();
                _builder.append((Object)_name_4, "");
                _builder.append((Object)"><");
                ValueProperty _value_5 = prop.getValue();
                JvmTypeReference _type_5 = ((ConstValueProperty)_value_5).getType();
                String _shortName_5 = this.shortName(_type_5, importManager);
                _builder.append((Object)_shortName_5, "");
                _builder.append((Object)" fx:constant=\"");
                ValueProperty _value_6 = prop.getValue();
                String _field = ((ConstValueProperty)_value_6).getField();
                _builder.append((Object)_field, "");
                _builder.append((Object)"\" /></");
                JvmTypeReference _type_6 = this.type(prop);
                String _shortName_6 = this.shortName(_type_6, importManager);
                _builder.append((Object)_shortName_6, "");
                _builder.append((Object)".");
                String _name_5 = prop.getName();
                _builder.append((Object)_name_5, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_7 = prop.getValue();
            if (_value_7 instanceof ListValueProperty) {
                _builder.append((Object)"<");
                JvmTypeReference _type_7 = this.type(prop);
                String _shortName_7 = this.shortName(_type_7, importManager);
                _builder.append((Object)_shortName_7, "");
                _builder.append((Object)".");
                String _name_6 = prop.getName();
                _builder.append((Object)_name_6, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                ValueProperty _value_8 = prop.getValue();
                CharSequence _propListContent = this.propListContent((ListValueProperty)_value_8, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_propListContent, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"</");
                JvmTypeReference _type_8 = this.type(prop);
                String _shortName_8 = this.shortName(_type_8, importManager);
                _builder.append((Object)_shortName_8, "");
                _builder.append((Object)".");
                String _name_7 = prop.getName();
                _builder.append((Object)_name_7, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_9 = prop.getValue();
            if (_value_9 instanceof MapValueProperty) {
                _builder.append((Object)"<");
                JvmTypeReference _type_9 = this.type(prop);
                String _shortName_9 = this.shortName(_type_9, importManager);
                _builder.append((Object)_shortName_9, "");
                _builder.append((Object)".");
                String _name_8 = prop.getName();
                _builder.append((Object)_name_8, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                ValueProperty _value_10 = prop.getValue();
                EList<Property> _properties = ((MapValueProperty)_value_10).getProperties();
                CharSequence _propContents = this.propContents((List<Property>)_properties, importManager, preview, true, skipController, skipIncludes);
                _builder.append((Object)_propContents, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"</");
                JvmTypeReference _type_10 = this.type(prop);
                String _shortName_10 = this.shortName(_type_10, importManager);
                _builder.append((Object)_shortName_10, "");
                _builder.append((Object)".");
                String _name_9 = prop.getName();
                _builder.append((Object)_name_9, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_11 = prop.getValue();
            if (_value_11 instanceof Element) {
                _builder.append((Object)"<");
                JvmTypeReference _type_11 = this.type(prop);
                String _shortName_11 = this.shortName(_type_11, importManager);
                _builder.append((Object)_shortName_11, "");
                _builder.append((Object)".");
                String _name_10 = prop.getName();
                _builder.append((Object)_name_10, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                ValueProperty _value_12 = prop.getValue();
                CharSequence _elementContent = this.elementContent((Element)_value_12, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_elementContent, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"</");
                JvmTypeReference _type_12 = this.type(prop);
                String _shortName_12 = this.shortName(_type_12, importManager);
                _builder.append((Object)_shortName_12, "");
                _builder.append((Object)".");
                String _name_11 = prop.getName();
                _builder.append((Object)_name_11, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_13 = prop.getValue();
            if (_value_13 instanceof ReferenceValueProperty) {
                _builder.append((Object)"<");
                JvmTypeReference _type_13 = this.type(prop);
                String _shortName_13 = this.shortName(_type_13, importManager);
                _builder.append((Object)_shortName_13, "");
                _builder.append((Object)".");
                String _name_12 = prop.getName();
                _builder.append((Object)_name_12, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                ValueProperty _value_14 = prop.getValue();
                CharSequence _referenceContent = this.referenceContent((ReferenceValueProperty)_value_14, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_referenceContent, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"</");
                JvmTypeReference _type_14 = this.type(prop);
                String _shortName_14 = this.shortName(_type_14, importManager);
                _builder.append((Object)_shortName_14, "");
                _builder.append((Object)".");
                String _name_13 = prop.getName();
                _builder.append((Object)_name_13, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_15 = prop.getValue();
            if (_value_15 instanceof IncludeValueProperty) {
                if (skipIncludes) continue;
                _builder.append((Object)"<");
                JvmTypeReference _type_15 = this.type(prop);
                String _shortName_15 = this.shortName(_type_15, importManager);
                _builder.append((Object)_shortName_15, "");
                _builder.append((Object)".");
                String _name_14 = prop.getName();
                _builder.append((Object)_name_14, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                ValueProperty _value_16 = prop.getValue();
                CharSequence _includeContent = this.includeContent((IncludeValueProperty)_value_16, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_includeContent, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"</");
                JvmTypeReference _type_16 = this.type(prop);
                String _shortName_16 = this.shortName(_type_16, importManager);
                _builder.append((Object)_shortName_16, "");
                _builder.append((Object)".");
                String _name_15 = prop.getName();
                _builder.append((Object)_name_15, "");
                _builder.append((Object)">");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_17 = prop.getValue();
            if (!(_value_17 instanceof CopyValueProperty)) continue;
            _builder.append((Object)"<");
            JvmTypeReference _type_17 = this.type(prop);
            String _shortName_17 = this.shortName(_type_17, importManager);
            _builder.append((Object)_shortName_17, "");
            _builder.append((Object)".");
            String _name_16 = prop.getName();
            _builder.append((Object)_name_16, "");
            _builder.append((Object)">");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"<fx:copy source=\"");
            ValueProperty _value_18 = prop.getValue();
            Element _reference = ((CopyValueProperty)_value_18).getReference();
            String _name_17 = _reference.getName();
            _builder.append((Object)_name_17, "\t");
            _builder.append((Object)"\" />");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"</");
            JvmTypeReference _type_18 = this.type(prop);
            String _shortName_18 = this.shortName(_type_18, importManager);
            _builder.append((Object)_shortName_18, "");
            _builder.append((Object)".");
            String _name_18 = prop.getName();
            _builder.append((Object)_name_18, "");
            _builder.append((Object)">");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public JvmTypeReference type(StaticValueProperty prop) {
        EObject el = prop.eContainer();
        while (!Objects.equal((Object)el.eContainer(), null)) {
            EObject _eContainer_2;
            EObject _eContainer = el.eContainer();
            if (_eContainer instanceof Element) {
                EObject _eContainer_1 = el.eContainer();
                Element e = (Element)_eContainer_1;
                return e.getType();
            }
            el = _eContainer_2 = el.eContainer();
        }
        return null;
    }

    public String refname(ReferenceType e) {
        if (e instanceof Element) {
            return ((Element)e).getName();
        }
        return ((IncludeValueProperty)e).getName();
    }

    public CharSequence propListContent(ListValueProperty listProp, ImportManager importManager, boolean preview, boolean skipController, boolean skipIncludes) {
        StringConcatenation _builder = new StringConcatenation();
        EList<ListValueElement> _value = listProp.getValue();
        for (ListValueElement e : _value) {
            if (e instanceof Element) {
                CharSequence _elementContent = this.elementContent((Element)e, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_elementContent, "");
                _builder.newLineIfNotEmpty();
                continue;
            }
            if (e instanceof ReferenceValueProperty) {
                CharSequence _referenceContent = this.referenceContent((ReferenceValueProperty)e, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_referenceContent, "");
                _builder.newLineIfNotEmpty();
                continue;
            }
            if (e instanceof IncludeValueProperty) {
                if (skipIncludes) continue;
                CharSequence _includeContent = this.includeContent((IncludeValueProperty)e, importManager, preview, skipController, skipIncludes);
                _builder.append((Object)_includeContent, "");
                _builder.newLineIfNotEmpty();
                continue;
            }
            if (!(e instanceof SimpleValueProperty)) continue;
            String _objectLiteral = this.objectLiteral((SimpleValueProperty)e);
            _builder.append((Object)_objectLiteral, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public String fullyQualifiedName(ComponentDefinition cp) {
        boolean _notEquals;
        Resource _eResource = cp.eResource();
        EList _contents = _eResource.getContents();
        EObject _get = (EObject)_contents.get(0);
        Model m = (Model)_get;
        PackageDeclaration _package = m.getPackage();
        boolean bl = _notEquals = !Objects.equal((Object)_package, null);
        if (_notEquals) {
            PackageDeclaration _package_1 = m.getPackage();
            String _name = _package_1.getName();
            String _plus = String.valueOf(_name) + ".";
            String _name_1 = cp.getName();
            return String.valueOf(_plus) + _name_1;
        }
        return cp.getName();
    }

    public String fxElementAttributes(Element element, ImportManager importManager, boolean skipController) {
        SimpleValueProperty _value;
        boolean _notEquals_1;
        boolean _notEquals;
        StringBuilder builder = new StringBuilder();
        String _name = element.getName();
        boolean bl = _notEquals = !Objects.equal((Object)_name, null);
        if (_notEquals) {
            String _name_1 = element.getName();
            String _plus = " fx:id=\"" + _name_1;
            String _plus_1 = String.valueOf(_plus) + "\"";
            builder.append(_plus_1);
        }
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)(_value = element.getValue()), null);
        if (_notEquals_1) {
            SimpleValueProperty _value_1 = element.getValue();
            String _simpleAttributeValue = this.simpleAttributeValue(_value_1);
            String _plus_2 = " fx:value=\"" + _simpleAttributeValue;
            String _plus_3 = String.valueOf(_plus_2) + "\"";
            builder.append(_plus_3);
        } else {
            boolean _notEquals_2;
            String _factory = element.getFactory();
            boolean bl3 = _notEquals_2 = !Objects.equal((Object)_factory, null);
            if (_notEquals_2) {
                String _factory_1 = element.getFactory();
                String _plus_4 = " fx:factory=\"" + _factory_1;
                String _plus_5 = String.valueOf(_plus_4) + "\"";
                builder.append(_plus_5);
            }
        }
        return builder.toString();
    }

    public StringBuilder elementAttributes(List<Property> properties, final boolean preview, boolean skipController) {
        StringBuilder builder = new StringBuilder();
        Functions.Function1<Property, Boolean> _function = new Functions.Function1<Property, Boolean>(){

            public Boolean apply(Property p) {
                return FXGraphGenerator.this.previewFilter(p, preview);
            }
        };
        Iterable _filter = IterableExtensions.filter(properties, (Functions.Function1)_function);
        Functions.Function1<Property, Boolean> _function_1 = new Functions.Function1<Property, Boolean>(){

            public Boolean apply(Property p) {
                return FXGraphGenerator.this.elementAttributeFilter(p);
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function_1);
        for (Property p : _filter_1) {
            ValueProperty _value = p.getValue();
            if (_value instanceof SimpleValueProperty) {
                String _name = p.getName();
                String _plus = " " + _name;
                String _plus_1 = String.valueOf(_plus) + "=\"";
                ValueProperty _value_1 = p.getValue();
                String _simpleAttributeValue = this.simpleAttributeValue((SimpleValueProperty)_value_1);
                String _plus_2 = String.valueOf(_plus_1) + _simpleAttributeValue;
                String _plus_3 = String.valueOf(_plus_2) + "\"";
                builder.append(_plus_3);
                continue;
            }
            ValueProperty _value_2 = p.getValue();
            if (_value_2 instanceof ReferenceValueProperty) {
                String _name_1 = p.getName();
                String _plus_4 = " " + _name_1;
                String _plus_5 = String.valueOf(_plus_4) + "=\"$";
                ValueProperty _value_3 = p.getValue();
                ReferenceType _reference = ((ReferenceValueProperty)_value_3).getReference();
                String _refname = this.refname(_reference);
                String _plus_6 = String.valueOf(_plus_5) + _refname;
                String _plus_7 = String.valueOf(_plus_6) + "\"";
                builder.append(_plus_7);
                continue;
            }
            ValueProperty _value_4 = p.getValue();
            if (_value_4 instanceof ControllerHandledValueProperty) {
                if (skipController) continue;
                String _name_2 = p.getName();
                String _plus_8 = " " + _name_2;
                String _plus_9 = String.valueOf(_plus_8) + "=\"#";
                ValueProperty _value_5 = p.getValue();
                String _methodname = ((ControllerHandledValueProperty)_value_5).getMethodname();
                String _plus_10 = String.valueOf(_plus_9) + _methodname;
                String _plus_11 = String.valueOf(_plus_10) + "\"";
                builder.append(_plus_11);
                continue;
            }
            ValueProperty _value_6 = p.getValue();
            if (_value_6 instanceof ScriptHandlerHandledValueProperty) {
                if (skipController) continue;
                String _name_3 = p.getName();
                String _plus_12 = " " + _name_3;
                String _plus_13 = String.valueOf(_plus_12) + "=\"";
                ValueProperty _value_7 = p.getValue();
                String _functionname = ((ScriptHandlerHandledValueProperty)_value_7).getFunctionname();
                String _plus_14 = String.valueOf(_plus_13) + _functionname;
                String _plus_15 = String.valueOf(_plus_14) + "\"";
                builder.append(_plus_15);
                continue;
            }
            ValueProperty _value_8 = p.getValue();
            if (_value_8 instanceof ScriptValueExpression) {
                if (skipController) continue;
                String _name_4 = p.getName();
                String _plus_16 = " " + _name_4;
                String _plus_17 = String.valueOf(_plus_16) + "=\"";
                ValueProperty _value_9 = p.getValue();
                String _sourcecode = ((ScriptValueExpression)_value_9).getSourcecode();
                ValueProperty _value_10 = p.getValue();
                String _sourcecode_1 = ((ScriptValueExpression)_value_10).getSourcecode();
                int _length = _sourcecode_1.length();
                int _minus = _length - 2;
                String _substring = _sourcecode.substring(2, _minus);
                String _trim = _substring.trim();
                String _plus_18 = String.valueOf(_plus_17) + _trim;
                String _plus_19 = String.valueOf(_plus_18) + ";\"";
                builder.append(_plus_19);
                continue;
            }
            ValueProperty _value_11 = p.getValue();
            if (_value_11 instanceof ScriptValueReference) {
                if (skipController) continue;
                String _name_5 = p.getName();
                String _plus_20 = " " + _name_5;
                String _plus_21 = String.valueOf(_plus_20) + "=\"$";
                ValueProperty _value_12 = p.getValue();
                String _reference_1 = ((ScriptValueReference)_value_12).getReference();
                String _plus_22 = String.valueOf(_plus_21) + _reference_1;
                String _plus_23 = String.valueOf(_plus_22) + "\"";
                builder.append(_plus_23);
                continue;
            }
            ValueProperty _value_13 = p.getValue();
            if (_value_13 instanceof LocationValueProperty) {
                String _name_6 = p.getName();
                String _plus_24 = " " + _name_6;
                String _plus_25 = String.valueOf(_plus_24) + "=\"@";
                ValueProperty _value_14 = p.getValue();
                String _value_15 = ((LocationValueProperty)_value_14).getValue();
                String _plus_26 = String.valueOf(_plus_25) + _value_15;
                String _plus_27 = String.valueOf(_plus_26) + "\"";
                builder.append(_plus_27);
                continue;
            }
            ValueProperty _value_16 = p.getValue();
            if (_value_16 instanceof ResourceValueProperty) {
                String _name_7 = p.getName();
                String _plus_28 = " " + _name_7;
                String _plus_29 = String.valueOf(_plus_28) + "=\"%";
                ValueProperty _value_17 = p.getValue();
                StringValue _value_18 = ((ResourceValueProperty)_value_17).getValue();
                String _value_19 = _value_18.getValue();
                String _plus_30 = String.valueOf(_plus_29) + _value_19;
                String _plus_31 = String.valueOf(_plus_30) + "\"";
                builder.append(_plus_31);
                continue;
            }
            ValueProperty _value_20 = p.getValue();
            if (!(_value_20 instanceof BindValueProperty)) continue;
            String _name_8 = p.getName();
            String _plus_32 = " " + _name_8;
            String _plus_33 = String.valueOf(_plus_32) + "=\"${";
            ValueProperty _value_21 = p.getValue();
            Element _elementReference = ((BindValueProperty)_value_21).getElementReference();
            String _name_9 = _elementReference.getName();
            String _plus_34 = String.valueOf(_plus_33) + _name_9;
            String _plus_35 = String.valueOf(_plus_34) + ".";
            ValueProperty _value_22 = p.getValue();
            String _attribute = ((BindValueProperty)_value_22).getAttribute();
            String _plus_36 = String.valueOf(_plus_35) + _attribute;
            String _plus_37 = String.valueOf(_plus_36) + "}\"";
            builder.append(_plus_37);
        }
        return builder;
    }

    public StringBuilder elementStaticCallAttributes(List<StaticCallValueProperty> properties, ImportManager importManager, final boolean preview, boolean skipController) {
        StringBuilder builder = new StringBuilder();
        Functions.Function1<StaticCallValueProperty, Boolean> _function = new Functions.Function1<StaticCallValueProperty, Boolean>(){

            public Boolean apply(StaticCallValueProperty p) {
                return FXGraphGenerator.this.previewFilter(p, preview);
            }
        };
        Iterable _filter = IterableExtensions.filter(properties, (Functions.Function1)_function);
        Functions.Function1<StaticCallValueProperty, Boolean> _function_1 = new Functions.Function1<StaticCallValueProperty, Boolean>(){

            public Boolean apply(StaticCallValueProperty p) {
                return FXGraphGenerator.this.elementAttributeFilter(p);
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function_1);
        for (StaticCallValueProperty p : _filter_1) {
            ValueProperty _value = p.getValue();
            if (_value instanceof SimpleValueProperty) {
                JvmTypeReference _type = p.getType();
                String _shortName = this.shortName(_type, importManager);
                String _plus = " " + _shortName;
                String _plus_1 = String.valueOf(_plus) + ".";
                String _name = p.getName();
                String _plus_2 = String.valueOf(_plus_1) + _name;
                String _plus_3 = String.valueOf(_plus_2) + "=\"";
                ValueProperty _value_1 = p.getValue();
                String _simpleAttributeValue = this.simpleAttributeValue((SimpleValueProperty)_value_1);
                String _plus_4 = String.valueOf(_plus_3) + _simpleAttributeValue;
                String _plus_5 = String.valueOf(_plus_4) + "\"";
                builder.append(_plus_5);
                continue;
            }
            ValueProperty _value_2 = p.getValue();
            if (_value_2 instanceof ReferenceValueProperty) {
                JvmTypeReference _type_1 = p.getType();
                String _shortName_1 = this.shortName(_type_1, importManager);
                String _plus_6 = " " + _shortName_1;
                String _plus_7 = String.valueOf(_plus_6) + ".";
                String _name_1 = p.getName();
                String _plus_8 = String.valueOf(_plus_7) + _name_1;
                String _plus_9 = String.valueOf(_plus_8) + "=\"$";
                ValueProperty _value_3 = p.getValue();
                ReferenceType _reference = ((ReferenceValueProperty)_value_3).getReference();
                String _refname = this.refname(_reference);
                String _plus_10 = String.valueOf(_plus_9) + _refname;
                String _plus_11 = String.valueOf(_plus_10) + "\"";
                builder.append(_plus_11);
                continue;
            }
            ValueProperty _value_4 = p.getValue();
            if (_value_4 instanceof ControllerHandledValueProperty) {
                if (skipController) continue;
                JvmTypeReference _type_2 = p.getType();
                String _shortName_2 = this.shortName(_type_2, importManager);
                String _plus_12 = " " + _shortName_2;
                String _plus_13 = String.valueOf(_plus_12) + ".";
                String _name_2 = p.getName();
                String _plus_14 = String.valueOf(_plus_13) + _name_2;
                String _plus_15 = String.valueOf(_plus_14) + "=\"#";
                ValueProperty _value_5 = p.getValue();
                String _methodname = ((ControllerHandledValueProperty)_value_5).getMethodname();
                String _plus_16 = String.valueOf(_plus_15) + _methodname;
                String _plus_17 = String.valueOf(_plus_16) + "\"";
                builder.append(_plus_17);
                continue;
            }
            ValueProperty _value_6 = p.getValue();
            if (_value_6 instanceof ScriptHandlerHandledValueProperty) {
                if (skipController) continue;
                JvmTypeReference _type_3 = p.getType();
                String _shortName_3 = this.shortName(_type_3, importManager);
                String _plus_18 = " " + _shortName_3;
                String _plus_19 = String.valueOf(_plus_18) + ".";
                String _name_3 = p.getName();
                String _plus_20 = String.valueOf(_plus_19) + _name_3;
                String _plus_21 = String.valueOf(_plus_20) + "=\"";
                ValueProperty _value_7 = p.getValue();
                String _functionname = ((ScriptHandlerHandledValueProperty)_value_7).getFunctionname();
                String _plus_22 = String.valueOf(_plus_21) + _functionname;
                String _plus_23 = String.valueOf(_plus_22) + "\"";
                builder.append(_plus_23);
                continue;
            }
            ValueProperty _value_8 = p.getValue();
            if (_value_8 instanceof ScriptValueExpression) {
                if (skipController) continue;
                JvmTypeReference _type_4 = p.getType();
                String _shortName_4 = this.shortName(_type_4, importManager);
                String _plus_24 = " " + _shortName_4;
                String _plus_25 = String.valueOf(_plus_24) + ".";
                String _name_4 = p.getName();
                String _plus_26 = String.valueOf(_plus_25) + _name_4;
                String _plus_27 = String.valueOf(_plus_26) + "=\"";
                ValueProperty _value_9 = p.getValue();
                String _sourcecode = ((ScriptValueExpression)_value_9).getSourcecode();
                ValueProperty _value_10 = p.getValue();
                String _sourcecode_1 = ((ScriptValueExpression)_value_10).getSourcecode();
                int _length = _sourcecode_1.length();
                int _minus = _length - 2;
                String _substring = _sourcecode.substring(2, _minus);
                String _trim = _substring.trim();
                String _plus_28 = String.valueOf(_plus_27) + _trim;
                String _plus_29 = String.valueOf(_plus_28) + ";\"";
                builder.append(_plus_29);
                continue;
            }
            ValueProperty _value_11 = p.getValue();
            if (_value_11 instanceof ScriptValueReference) {
                if (skipController) continue;
                JvmTypeReference _type_5 = p.getType();
                String _shortName_5 = this.shortName(_type_5, importManager);
                String _plus_30 = " " + _shortName_5;
                String _plus_31 = String.valueOf(_plus_30) + ".";
                String _name_5 = p.getName();
                String _plus_32 = String.valueOf(_plus_31) + _name_5;
                String _plus_33 = String.valueOf(_plus_32) + "=\"$";
                ValueProperty _value_12 = p.getValue();
                String _reference_1 = ((ScriptValueReference)_value_12).getReference();
                String _plus_34 = String.valueOf(_plus_33) + _reference_1;
                String _plus_35 = String.valueOf(_plus_34) + "\"";
                builder.append(_plus_35);
                continue;
            }
            ValueProperty _value_13 = p.getValue();
            if (_value_13 instanceof LocationValueProperty) {
                JvmTypeReference _type_6 = p.getType();
                String _shortName_6 = this.shortName(_type_6, importManager);
                String _plus_36 = " " + _shortName_6;
                String _plus_37 = String.valueOf(_plus_36) + ".";
                String _name_6 = p.getName();
                String _plus_38 = String.valueOf(_plus_37) + _name_6;
                String _plus_39 = String.valueOf(_plus_38) + "=\"@";
                ValueProperty _value_14 = p.getValue();
                String _value_15 = ((LocationValueProperty)_value_14).getValue();
                String _plus_40 = String.valueOf(_plus_39) + _value_15;
                String _plus_41 = String.valueOf(_plus_40) + "\"";
                builder.append(_plus_41);
                continue;
            }
            ValueProperty _value_16 = p.getValue();
            if (_value_16 instanceof ResourceValueProperty) {
                JvmTypeReference _type_7 = p.getType();
                String _shortName_7 = this.shortName(_type_7, importManager);
                String _plus_42 = " " + _shortName_7;
                String _plus_43 = String.valueOf(_plus_42) + ".";
                String _name_7 = p.getName();
                String _plus_44 = String.valueOf(_plus_43) + _name_7;
                String _plus_45 = String.valueOf(_plus_44) + "=\"%";
                ValueProperty _value_17 = p.getValue();
                StringValue _value_18 = ((ResourceValueProperty)_value_17).getValue();
                String _value_19 = _value_18.getValue();
                String _plus_46 = String.valueOf(_plus_45) + _value_19;
                String _plus_47 = String.valueOf(_plus_46) + "\"";
                builder.append(_plus_47);
                continue;
            }
            ValueProperty _value_20 = p.getValue();
            if (!(_value_20 instanceof BindValueProperty)) continue;
            JvmTypeReference _type_8 = p.getType();
            String _shortName_8 = this.shortName(_type_8, importManager);
            String _plus_48 = " " + _shortName_8;
            String _plus_49 = String.valueOf(_plus_48) + ".";
            String _name_8 = p.getName();
            String _plus_50 = String.valueOf(_plus_49) + _name_8;
            String _plus_51 = String.valueOf(_plus_50) + "=\"${";
            ValueProperty _value_21 = p.getValue();
            Element _elementReference = ((BindValueProperty)_value_21).getElementReference();
            String _name_9 = _elementReference.getName();
            String _plus_52 = String.valueOf(_plus_51) + _name_9;
            String _plus_53 = String.valueOf(_plus_52) + ".";
            ValueProperty _value_22 = p.getValue();
            String _attribute = ((BindValueProperty)_value_22).getAttribute();
            String _plus_54 = String.valueOf(_plus_53) + _attribute;
            String _plus_55 = String.valueOf(_plus_54) + "}\"";
            builder.append(_plus_55);
        }
        return builder;
    }

    public StringBuilder elementStaticAttributes(List<StaticValueProperty> properties, ImportManager importManager, final boolean preview, boolean skipController) {
        StringBuilder builder = new StringBuilder();
        Functions.Function1<StaticValueProperty, Boolean> _function = new Functions.Function1<StaticValueProperty, Boolean>(){

            public Boolean apply(StaticValueProperty p) {
                return FXGraphGenerator.this.previewFilter(p, preview);
            }
        };
        Iterable _filter = IterableExtensions.filter(properties, (Functions.Function1)_function);
        Functions.Function1<StaticValueProperty, Boolean> _function_1 = new Functions.Function1<StaticValueProperty, Boolean>(){

            public Boolean apply(StaticValueProperty p) {
                return FXGraphGenerator.this.elementAttributeFilter(p);
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function_1);
        for (StaticValueProperty p : _filter_1) {
            ValueProperty _value = p.getValue();
            if (_value instanceof SimpleValueProperty) {
                JvmTypeReference _type = this.type(p);
                String _shortName = this.shortName(_type, importManager);
                String _plus = " " + _shortName;
                String _plus_1 = String.valueOf(_plus) + ".";
                String _name = p.getName();
                String _plus_2 = String.valueOf(_plus_1) + _name;
                String _plus_3 = String.valueOf(_plus_2) + "=\"";
                ValueProperty _value_1 = p.getValue();
                String _simpleAttributeValue = this.simpleAttributeValue((SimpleValueProperty)_value_1);
                String _plus_4 = String.valueOf(_plus_3) + _simpleAttributeValue;
                String _plus_5 = String.valueOf(_plus_4) + "\"";
                builder.append(_plus_5);
                continue;
            }
            ValueProperty _value_2 = p.getValue();
            if (_value_2 instanceof ReferenceValueProperty) {
                JvmTypeReference _type_1 = this.type(p);
                String _shortName_1 = this.shortName(_type_1, importManager);
                String _plus_6 = " " + _shortName_1;
                String _plus_7 = String.valueOf(_plus_6) + ".";
                String _name_1 = p.getName();
                String _plus_8 = String.valueOf(_plus_7) + _name_1;
                String _plus_9 = String.valueOf(_plus_8) + "=\"$";
                ValueProperty _value_3 = p.getValue();
                ReferenceType _reference = ((ReferenceValueProperty)_value_3).getReference();
                String _refname = this.refname(_reference);
                String _plus_10 = String.valueOf(_plus_9) + _refname;
                String _plus_11 = String.valueOf(_plus_10) + "\"";
                builder.append(_plus_11);
                continue;
            }
            ValueProperty _value_4 = p.getValue();
            if (_value_4 instanceof ControllerHandledValueProperty) {
                if (skipController) continue;
                JvmTypeReference _type_2 = this.type(p);
                String _shortName_2 = this.shortName(_type_2, importManager);
                String _plus_12 = " " + _shortName_2;
                String _plus_13 = String.valueOf(_plus_12) + ".";
                String _name_2 = p.getName();
                String _plus_14 = String.valueOf(_plus_13) + _name_2;
                String _plus_15 = String.valueOf(_plus_14) + "=\"#";
                ValueProperty _value_5 = p.getValue();
                String _methodname = ((ControllerHandledValueProperty)_value_5).getMethodname();
                String _plus_16 = String.valueOf(_plus_15) + _methodname;
                String _plus_17 = String.valueOf(_plus_16) + "\"";
                builder.append(_plus_17);
                continue;
            }
            ValueProperty _value_6 = p.getValue();
            if (_value_6 instanceof ScriptHandlerHandledValueProperty) {
                if (skipController) continue;
                JvmTypeReference _type_3 = this.type(p);
                String _shortName_3 = this.shortName(_type_3, importManager);
                String _plus_18 = " " + _shortName_3;
                String _plus_19 = String.valueOf(_plus_18) + ".";
                String _name_3 = p.getName();
                String _plus_20 = String.valueOf(_plus_19) + _name_3;
                String _plus_21 = String.valueOf(_plus_20) + "=\"";
                ValueProperty _value_7 = p.getValue();
                String _functionname = ((ScriptHandlerHandledValueProperty)_value_7).getFunctionname();
                String _plus_22 = String.valueOf(_plus_21) + _functionname;
                String _plus_23 = String.valueOf(_plus_22) + "\"";
                builder.append(_plus_23);
                continue;
            }
            ValueProperty _value_8 = p.getValue();
            if (_value_8 instanceof ScriptValueExpression) {
                if (skipController) continue;
                JvmTypeReference _type_4 = this.type(p);
                String _shortName_4 = this.shortName(_type_4, importManager);
                String _plus_24 = " " + _shortName_4;
                String _plus_25 = String.valueOf(_plus_24) + ".";
                String _name_4 = p.getName();
                String _plus_26 = String.valueOf(_plus_25) + _name_4;
                String _plus_27 = String.valueOf(_plus_26) + "=\"";
                ValueProperty _value_9 = p.getValue();
                String _sourcecode = ((ScriptValueExpression)_value_9).getSourcecode();
                ValueProperty _value_10 = p.getValue();
                String _sourcecode_1 = ((ScriptValueExpression)_value_10).getSourcecode();
                int _length = _sourcecode_1.length();
                int _minus = _length - 2;
                String _substring = _sourcecode.substring(2, _minus);
                String _trim = _substring.trim();
                String _plus_28 = String.valueOf(_plus_27) + _trim;
                String _plus_29 = String.valueOf(_plus_28) + ";\"";
                builder.append(_plus_29);
                continue;
            }
            ValueProperty _value_11 = p.getValue();
            if (_value_11 instanceof ScriptValueReference) {
                if (skipController) continue;
                JvmTypeReference _type_5 = this.type(p);
                String _shortName_5 = this.shortName(_type_5, importManager);
                String _plus_30 = " " + _shortName_5;
                String _plus_31 = String.valueOf(_plus_30) + ".";
                String _name_5 = p.getName();
                String _plus_32 = String.valueOf(_plus_31) + _name_5;
                String _plus_33 = String.valueOf(_plus_32) + "=\"$";
                ValueProperty _value_12 = p.getValue();
                String _reference_1 = ((ScriptValueReference)_value_12).getReference();
                String _plus_34 = String.valueOf(_plus_33) + _reference_1;
                String _plus_35 = String.valueOf(_plus_34) + "\"";
                builder.append(_plus_35);
                continue;
            }
            ValueProperty _value_13 = p.getValue();
            if (_value_13 instanceof LocationValueProperty) {
                JvmTypeReference _type_6 = this.type(p);
                String _shortName_6 = this.shortName(_type_6, importManager);
                String _plus_36 = " " + _shortName_6;
                String _plus_37 = String.valueOf(_plus_36) + ".";
                String _name_6 = p.getName();
                String _plus_38 = String.valueOf(_plus_37) + _name_6;
                String _plus_39 = String.valueOf(_plus_38) + "=\"@";
                ValueProperty _value_14 = p.getValue();
                String _value_15 = ((LocationValueProperty)_value_14).getValue();
                String _plus_40 = String.valueOf(_plus_39) + _value_15;
                String _plus_41 = String.valueOf(_plus_40) + "\"";
                builder.append(_plus_41);
                continue;
            }
            ValueProperty _value_16 = p.getValue();
            if (_value_16 instanceof ResourceValueProperty) {
                JvmTypeReference _type_7 = this.type(p);
                String _shortName_7 = this.shortName(_type_7, importManager);
                String _plus_42 = " " + _shortName_7;
                String _plus_43 = String.valueOf(_plus_42) + ".";
                String _name_7 = p.getName();
                String _plus_44 = String.valueOf(_plus_43) + _name_7;
                String _plus_45 = String.valueOf(_plus_44) + "=\"%";
                ValueProperty _value_17 = p.getValue();
                StringValue _value_18 = ((ResourceValueProperty)_value_17).getValue();
                String _value_19 = _value_18.getValue();
                String _plus_46 = String.valueOf(_plus_45) + _value_19;
                String _plus_47 = String.valueOf(_plus_46) + "\"";
                builder.append(_plus_47);
                continue;
            }
            ValueProperty _value_20 = p.getValue();
            if (!(_value_20 instanceof BindValueProperty)) continue;
            JvmTypeReference _type_8 = this.type(p);
            String _shortName_8 = this.shortName(_type_8, importManager);
            String _plus_48 = " " + _shortName_8;
            String _plus_49 = String.valueOf(_plus_48) + ".";
            String _name_8 = p.getName();
            String _plus_50 = String.valueOf(_plus_49) + _name_8;
            String _plus_51 = String.valueOf(_plus_50) + "=\"${";
            ValueProperty _value_21 = p.getValue();
            Element _elementReference = ((BindValueProperty)_value_21).getElementReference();
            String _name_9 = _elementReference.getName();
            String _plus_52 = String.valueOf(_plus_51) + _name_9;
            String _plus_53 = String.valueOf(_plus_52) + ".";
            ValueProperty _value_22 = p.getValue();
            String _attribute = ((BindValueProperty)_value_22).getAttribute();
            String _plus_54 = String.valueOf(_plus_53) + _attribute;
            String _plus_55 = String.valueOf(_plus_54) + "}\"";
            builder.append(_plus_55);
        }
        return builder;
    }

    public boolean subelementFilter(Property property) {
        boolean _elementAttributeFilter = this.elementAttributeFilter(property);
        return !_elementAttributeFilter;
    }

    public boolean elementAttributeFilter(Property property) {
        ValueProperty _value = property.getValue();
        return this.elementAttributeFilter(_value);
    }

    public boolean subelementFilter(StaticCallValueProperty property) {
        boolean _elementAttributeFilter = this.elementAttributeFilter(property);
        return !_elementAttributeFilter;
    }

    public boolean elementAttributeFilter(StaticCallValueProperty property) {
        ValueProperty _value = property.getValue();
        return this.elementAttributeFilter(_value);
    }

    public boolean subelementFilter(StaticValueProperty property) {
        boolean _elementAttributeFilter = this.elementAttributeFilter(property);
        return !_elementAttributeFilter;
    }

    public boolean elementAttributeFilter(StaticValueProperty property) {
        ValueProperty _value = property.getValue();
        return this.elementAttributeFilter(_value);
    }

    public boolean elementAttributeFilter(ValueProperty value) {
        if (value instanceof SimpleValueProperty) {
            return true;
        }
        if (value instanceof ReferenceValueProperty) {
            ReferenceValueProperty r = (ReferenceValueProperty)value;
            boolean _and = false;
            EList<StaticCallValueProperty> _staticCallProperties = r.getStaticCallProperties();
            boolean _isEmpty = _staticCallProperties.isEmpty();
            if (!_isEmpty) {
                _and = false;
            } else {
                boolean _isEmpty_1;
                EList<StaticValueProperty> _staticProperties = r.getStaticProperties();
                _and = _isEmpty_1 = _staticProperties.isEmpty();
            }
            return _and;
        }
        if (value instanceof ControllerHandledValueProperty) {
            return true;
        }
        if (value instanceof ScriptHandlerHandledValueProperty) {
            return true;
        }
        if (value instanceof ScriptValueReference) {
            return true;
        }
        if (value instanceof ScriptValueExpression) {
            return true;
        }
        if (value instanceof LocationValueProperty) {
            return true;
        }
        if (value instanceof ResourceValueProperty) {
            return true;
        }
        return value instanceof BindValueProperty;
    }

    public String simpleAttributeValue(SimpleValueProperty value) {
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        String _stringValue = value.getStringValue();
        boolean bl = _notEquals = !Objects.equal((Object)_stringValue, null);
        if (_notEquals) {
            return value.getStringValue();
        }
        String _booleanValue = value.getBooleanValue();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_booleanValue, null);
        if (_notEquals_1) {
            return value.getBooleanValue();
        }
        boolean _and = false;
        String _number = value.getNumber();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_number, null);
        if (!_notEquals_2) {
            _and = false;
        } else {
            boolean _isIntNumber;
            String _number_1 = value.getNumber();
            _and = _isIntNumber = FXGraphGenerator.isIntNumber(_number_1);
        }
        if (_and) {
            boolean _isNegative = value.isNegative();
            if (_isNegative) {
                String _number_2 = value.getNumber();
                return "-" + _number_2;
            }
            return value.getNumber();
        }
        boolean _isNegative_1 = value.isNegative();
        if (_isNegative_1) {
            String _number_3 = value.getNumber();
            return "-" + _number_3;
        }
        return value.getNumber();
    }

    public boolean previewFilter(Property property, boolean preview) {
        String _modifier_1;
        boolean _equals_1;
        String _modifier;
        boolean _equals;
        return !(!preview ? (_equals = "preview".equals(_modifier = property.getModifier())) : (_equals_1 = "runtime-only".equals(_modifier_1 = property.getModifier())));
    }

    public boolean previewFilter(StaticCallValueProperty property, boolean preview) {
        String _modifier_1;
        boolean _equals_1;
        String _modifier;
        boolean _equals;
        return !(!preview ? (_equals = "preview".equals(_modifier = property.getModifier())) : (_equals_1 = "runtime-only".equals(_modifier_1 = property.getModifier())));
    }

    public boolean previewFilter(StaticValueProperty property, boolean preview) {
        String _modifier_1;
        boolean _equals_1;
        String _modifier;
        boolean _equals;
        return !(!preview ? (_equals = "preview".equals(_modifier = property.getModifier())) : (_equals_1 = "runtime-only".equals(_modifier_1 = property.getModifier())));
    }

    public boolean hasAttributeProperties(Element element, final boolean preview) {
        Functions.Function1<Property, Boolean> _function_1;
        Functions.Function1<Property, Boolean> _function;
        EList<Property> _properties_1;
        Iterable _filter;
        Iterable _filter_1;
        boolean _isNullOrEmpty;
        boolean _not;
        boolean _greaterThan;
        boolean _or = false;
        boolean _or_1 = false;
        boolean _and = false;
        EList<Property> _properties = element.getProperties();
        int _size = _properties.size();
        boolean bl = _greaterThan = _size > 0;
        _and = !_greaterThan ? false : (_not = !(_isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)(_filter_1 = IterableExtensions.filter((Iterable)(_filter = IterableExtensions.filter(_properties_1 = element.getProperties(), (Functions.Function1)(_function = new Functions.Function1<Property, Boolean>(){

            public Boolean apply(Property p) {
                return FXGraphGenerator.this.previewFilter(p, preview);
            }
        }))), (Functions.Function1)(_function_1 = new Functions.Function1<Property, Boolean>(){

            public Boolean apply(Property p) {
                return FXGraphGenerator.this.elementAttributeFilter(p);
            }
        }))))));
        if (_and) {
            _or_1 = true;
        } else {
            Functions.Function1<StaticCallValueProperty, Boolean> _function_3;
            Functions.Function1<StaticCallValueProperty, Boolean> _function_2;
            EList<StaticCallValueProperty> _staticCallProperties_1;
            Iterable _filter_2;
            Iterable _filter_3;
            boolean _isNullOrEmpty_1;
            boolean _not_1;
            boolean _greaterThan_1;
            boolean _and_1 = false;
            EList<StaticCallValueProperty> _staticCallProperties = element.getStaticCallProperties();
            int _size_1 = _staticCallProperties.size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            _and_1 = !_greaterThan_1 ? false : (_not_1 = !(_isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)(_filter_3 = IterableExtensions.filter((Iterable)(_filter_2 = IterableExtensions.filter(_staticCallProperties_1 = element.getStaticCallProperties(), (Functions.Function1)(_function_2 = new Functions.Function1<StaticCallValueProperty, Boolean>(){

                public Boolean apply(StaticCallValueProperty p) {
                    return FXGraphGenerator.this.previewFilter(p, preview);
                }
            }))), (Functions.Function1)(_function_3 = new Functions.Function1<StaticCallValueProperty, Boolean>(){

                public Boolean apply(StaticCallValueProperty p) {
                    return FXGraphGenerator.this.elementAttributeFilter(p);
                }
            }))))));
            _or_1 = _and_1;
        }
        if (_or_1) {
            _or = true;
        } else {
            Functions.Function1<StaticValueProperty, Boolean> _function_5;
            Functions.Function1<StaticValueProperty, Boolean> _function_4;
            EList<StaticValueProperty> _staticProperties_1;
            Iterable _filter_4;
            Iterable _filter_5;
            boolean _isNullOrEmpty_2;
            boolean _not_2;
            boolean _greaterThan_2;
            boolean _and_2 = false;
            EList<StaticValueProperty> _staticProperties = element.getStaticProperties();
            int _size_2 = _staticProperties.size();
            boolean bl3 = _greaterThan_2 = _size_2 > 0;
            _and_2 = !_greaterThan_2 ? false : (_not_2 = !(_isNullOrEmpty_2 = IterableExtensions.isNullOrEmpty((Iterable)(_filter_5 = IterableExtensions.filter((Iterable)(_filter_4 = IterableExtensions.filter(_staticProperties_1 = element.getStaticProperties(), (Functions.Function1)(_function_4 = new Functions.Function1<StaticValueProperty, Boolean>(){

                public Boolean apply(StaticValueProperty p) {
                    return FXGraphGenerator.this.previewFilter(p, preview);
                }
            }))), (Functions.Function1)(_function_5 = new Functions.Function1<StaticValueProperty, Boolean>(){

                public Boolean apply(StaticValueProperty p) {
                    return FXGraphGenerator.this.elementAttributeFilter(p);
                }
            }))))));
            _or = _and_2;
        }
        return _or;
    }

    public boolean hasNestedProperties(Element element, final boolean preview) {
        EList<Property> _properties;
        int _size_4;
        boolean _greaterThan_4;
        EList<StaticValueProperty> _staticProperties;
        int _size_3;
        boolean _greaterThan_3;
        boolean _greaterThan_2;
        boolean _greaterThan_1;
        boolean _greaterThan;
        EList<FactoryValueElement> _values = element.getValues();
        int _size = _values.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            return true;
        }
        EList<Element> _defaultChildren = element.getDefaultChildren();
        int _size_1 = _defaultChildren.size();
        boolean bl2 = _greaterThan_1 = _size_1 > 0;
        if (_greaterThan_1) {
            return true;
        }
        EList<StaticCallValueProperty> _staticCallProperties = element.getStaticCallProperties();
        int _size_2 = _staticCallProperties.size();
        boolean bl3 = _greaterThan_2 = _size_2 > 0;
        if (_greaterThan_2) {
            boolean _not;
            Functions.Function1<StaticCallValueProperty, Boolean> _function_1;
            Functions.Function1<StaticCallValueProperty, Boolean> _function;
            EList<StaticCallValueProperty> _staticCallProperties_1 = element.getStaticCallProperties();
            Iterable _filter = IterableExtensions.filter(_staticCallProperties_1, (Functions.Function1)(_function = new Functions.Function1<StaticCallValueProperty, Boolean>(){

                public Boolean apply(StaticCallValueProperty p) {
                    return FXGraphGenerator.this.previewFilter(p, preview);
                }
            }));
            Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)(_function_1 = new Functions.Function1<StaticCallValueProperty, Boolean>(){

                public Boolean apply(StaticCallValueProperty p) {
                    return FXGraphGenerator.this.subelementFilter(p);
                }
            }));
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)_filter_1);
            boolean bl4 = _not = !_isNullOrEmpty;
            if (_not) {
                return true;
            }
        }
        boolean bl5 = _greaterThan_3 = (_size_3 = (_staticProperties = element.getStaticProperties()).size()) > 0;
        if (_greaterThan_3) {
            boolean _not_1;
            Functions.Function1<StaticValueProperty, Boolean> _function_3;
            Functions.Function1<StaticValueProperty, Boolean> _function_2;
            EList<StaticValueProperty> _staticProperties_1 = element.getStaticProperties();
            Iterable _filter_2 = IterableExtensions.filter(_staticProperties_1, (Functions.Function1)(_function_2 = new Functions.Function1<StaticValueProperty, Boolean>(){

                public Boolean apply(StaticValueProperty p) {
                    return FXGraphGenerator.this.previewFilter(p, preview);
                }
            }));
            Iterable _filter_3 = IterableExtensions.filter((Iterable)_filter_2, (Functions.Function1)(_function_3 = new Functions.Function1<StaticValueProperty, Boolean>(){

                public Boolean apply(StaticValueProperty p) {
                    return FXGraphGenerator.this.subelementFilter(p);
                }
            }));
            boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)_filter_3);
            boolean bl6 = _not_1 = !_isNullOrEmpty_1;
            if (_not_1) {
                return true;
            }
        }
        boolean bl7 = _greaterThan_4 = (_size_4 = (_properties = element.getProperties()).size()) > 0;
        if (_greaterThan_4) {
            boolean _not_2;
            Functions.Function1<Property, Boolean> _function_5;
            Functions.Function1<Property, Boolean> _function_4;
            EList<Property> _properties_1 = element.getProperties();
            Iterable _filter_4 = IterableExtensions.filter(_properties_1, (Functions.Function1)(_function_4 = new Functions.Function1<Property, Boolean>(){

                public Boolean apply(Property p) {
                    return FXGraphGenerator.this.previewFilter(p, preview);
                }
            }));
            Iterable _filter_5 = IterableExtensions.filter((Iterable)_filter_4, (Functions.Function1)(_function_5 = new Functions.Function1<Property, Boolean>(){

                public Boolean apply(Property p) {
                    return FXGraphGenerator.this.subelementFilter(p);
                }
            }));
            boolean _isNullOrEmpty_2 = IterableExtensions.isNullOrEmpty((Iterable)_filter_5);
            boolean bl8 = _not_2 = !_isNullOrEmpty_2;
            if (_not_2) {
                return true;
            }
        }
        return false;
    }

    public boolean hasAttributeProperties(IncludeValueProperty element, final boolean preview) {
        Functions.Function1<StaticCallValueProperty, Boolean> _function_1;
        Functions.Function1<StaticCallValueProperty, Boolean> _function;
        EList<StaticCallValueProperty> _staticCallProperties_1;
        Iterable _filter;
        Iterable _filter_1;
        boolean _isNullOrEmpty;
        boolean _not;
        boolean _greaterThan;
        boolean _or = false;
        boolean _and = false;
        EList<StaticCallValueProperty> _staticCallProperties = element.getStaticCallProperties();
        int _size = _staticCallProperties.size();
        boolean bl = _greaterThan = _size > 0;
        _and = !_greaterThan ? false : (_not = !(_isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)(_filter_1 = IterableExtensions.filter((Iterable)(_filter = IterableExtensions.filter(_staticCallProperties_1 = element.getStaticCallProperties(), (Functions.Function1)(_function = new Functions.Function1<StaticCallValueProperty, Boolean>(){

            public Boolean apply(StaticCallValueProperty p) {
                return FXGraphGenerator.this.previewFilter(p, preview);
            }
        }))), (Functions.Function1)(_function_1 = new Functions.Function1<StaticCallValueProperty, Boolean>(){

            public Boolean apply(StaticCallValueProperty p) {
                return FXGraphGenerator.this.elementAttributeFilter(p);
            }
        }))))));
        if (_and) {
            _or = true;
        } else {
            Functions.Function1<StaticValueProperty, Boolean> _function_3;
            Functions.Function1<StaticValueProperty, Boolean> _function_2;
            EList<StaticValueProperty> _staticProperties_1;
            Iterable _filter_2;
            Iterable _filter_3;
            boolean _isNullOrEmpty_1;
            boolean _not_1;
            boolean _greaterThan_1;
            boolean _and_1 = false;
            EList<StaticValueProperty> _staticProperties = element.getStaticProperties();
            int _size_1 = _staticProperties.size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            _and_1 = !_greaterThan_1 ? false : (_not_1 = !(_isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)(_filter_3 = IterableExtensions.filter((Iterable)(_filter_2 = IterableExtensions.filter(_staticProperties_1 = element.getStaticProperties(), (Functions.Function1)(_function_2 = new Functions.Function1<StaticValueProperty, Boolean>(){

                public Boolean apply(StaticValueProperty p) {
                    return FXGraphGenerator.this.previewFilter(p, preview);
                }
            }))), (Functions.Function1)(_function_3 = new Functions.Function1<StaticValueProperty, Boolean>(){

                public Boolean apply(StaticValueProperty p) {
                    return FXGraphGenerator.this.elementAttributeFilter(p);
                }
            }))))));
            _or = _and_1;
        }
        return _or;
    }

    public boolean hasNestedProperties(IncludeValueProperty element, final boolean preview) {
        EList<StaticValueProperty> _staticProperties;
        int _size_1;
        boolean _greaterThan_1;
        boolean _greaterThan;
        EList<StaticCallValueProperty> _staticCallProperties = element.getStaticCallProperties();
        int _size = _staticCallProperties.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            boolean _not;
            Functions.Function1<StaticCallValueProperty, Boolean> _function_1;
            Functions.Function1<StaticCallValueProperty, Boolean> _function;
            EList<StaticCallValueProperty> _staticCallProperties_1 = element.getStaticCallProperties();
            Iterable _filter = IterableExtensions.filter(_staticCallProperties_1, (Functions.Function1)(_function = new Functions.Function1<StaticCallValueProperty, Boolean>(){

                public Boolean apply(StaticCallValueProperty p) {
                    return FXGraphGenerator.this.previewFilter(p, preview);
                }
            }));
            Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)(_function_1 = new Functions.Function1<StaticCallValueProperty, Boolean>(){

                public Boolean apply(StaticCallValueProperty p) {
                    return FXGraphGenerator.this.subelementFilter(p);
                }
            }));
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)_filter_1);
            boolean bl2 = _not = !_isNullOrEmpty;
            if (_not) {
                return true;
            }
        }
        boolean bl3 = _greaterThan_1 = (_size_1 = (_staticProperties = element.getStaticProperties()).size()) > 0;
        if (_greaterThan_1) {
            boolean _not_1;
            Functions.Function1<StaticValueProperty, Boolean> _function_3;
            Functions.Function1<StaticValueProperty, Boolean> _function_2;
            EList<StaticValueProperty> _staticProperties_1 = element.getStaticProperties();
            Iterable _filter_2 = IterableExtensions.filter(_staticProperties_1, (Functions.Function1)(_function_2 = new Functions.Function1<StaticValueProperty, Boolean>(){

                public Boolean apply(StaticValueProperty p) {
                    return FXGraphGenerator.this.previewFilter(p, preview);
                }
            }));
            Iterable _filter_3 = IterableExtensions.filter((Iterable)_filter_2, (Functions.Function1)(_function_3 = new Functions.Function1<StaticValueProperty, Boolean>(){

                public Boolean apply(StaticValueProperty p) {
                    return FXGraphGenerator.this.subelementFilter(p);
                }
            }));
            boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)_filter_3);
            boolean bl4 = _not_1 = !_isNullOrEmpty_1;
            if (_not_1) {
                return true;
            }
        }
        return false;
    }

    public boolean hasNestedProperties(ReferenceValueProperty element, final boolean preview) {
        EList<StaticValueProperty> _staticProperties;
        int _size_1;
        boolean _greaterThan_1;
        boolean _greaterThan;
        EList<StaticCallValueProperty> _staticCallProperties = element.getStaticCallProperties();
        int _size = _staticCallProperties.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            boolean _not;
            Functions.Function1<StaticCallValueProperty, Boolean> _function_1;
            Functions.Function1<StaticCallValueProperty, Boolean> _function;
            EList<StaticCallValueProperty> _staticCallProperties_1 = element.getStaticCallProperties();
            Iterable _filter = IterableExtensions.filter(_staticCallProperties_1, (Functions.Function1)(_function = new Functions.Function1<StaticCallValueProperty, Boolean>(){

                public Boolean apply(StaticCallValueProperty p) {
                    return FXGraphGenerator.this.previewFilter(p, preview);
                }
            }));
            Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)(_function_1 = new Functions.Function1<StaticCallValueProperty, Boolean>(){

                public Boolean apply(StaticCallValueProperty p) {
                    return FXGraphGenerator.this.subelementFilter(p);
                }
            }));
            boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)_filter_1);
            boolean bl2 = _not = !_isNullOrEmpty;
            if (_not) {
                return true;
            }
        }
        boolean bl3 = _greaterThan_1 = (_size_1 = (_staticProperties = element.getStaticProperties()).size()) > 0;
        if (_greaterThan_1) {
            boolean _not_1;
            Functions.Function1<StaticValueProperty, Boolean> _function_3;
            Functions.Function1<StaticValueProperty, Boolean> _function_2;
            EList<StaticValueProperty> _staticProperties_1 = element.getStaticProperties();
            Iterable _filter_2 = IterableExtensions.filter(_staticProperties_1, (Functions.Function1)(_function_2 = new Functions.Function1<StaticValueProperty, Boolean>(){

                public Boolean apply(StaticValueProperty p) {
                    return FXGraphGenerator.this.previewFilter(p, preview);
                }
            }));
            Iterable _filter_3 = IterableExtensions.filter((Iterable)_filter_2, (Functions.Function1)(_function_3 = new Functions.Function1<StaticValueProperty, Boolean>(){

                public Boolean apply(StaticValueProperty p) {
                    return FXGraphGenerator.this.subelementFilter(p);
                }
            }));
            boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty((Iterable)_filter_3);
            boolean bl4 = _not_1 = !_isNullOrEmpty_1;
            if (_not_1) {
                return true;
            }
        }
        return false;
    }

    public String shortName(JvmTypeReference r, ImportManager importManager) {
        String _xblockexpression = null;
        StringBuilder builder = new StringBuilder();
        JvmType _type = r.getType();
        importManager.appendType(_type, builder);
        _xblockexpression = builder.toString();
        return _xblockexpression;
    }

    public static boolean isIntNumber(String number) {
        return number.matches("\\d[\\d|_]*");
    }
}

