/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.ui.mobile.sim.launch;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.fx.ide.ui.mobile.sim.launch.DeviceType;
import org.eclipse.fx.ide.ui.mobile.sim.launch.Orientation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class MobileSimulatorLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        try {
            ICompilationUnit u = (ICompilationUnit)((IStructuredSelection)selection).getFirstElement();
            IType t = u.getTypes()[0];
            this.launch(t, mode);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IJavaElement je = (IJavaElement)input.getAdapter(IJavaElement.class);
        if (je instanceof IMember) {
            this.launch(((IMember)je).getDeclaringType(), mode);
        }
    }

    void launch(IType type, String mode) {
        try {
            ILaunchConfigurationType ctype = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.fx.ide.ui.mobile.sim.launch.launchConfigurationType");
            ILaunchConfiguration launchConfig = this.findLaunchConfig(type, ctype);
            if (launchConfig == null) {
                launchConfig = this.createNew(type, ctype);
            }
            DebugUITools.launch((ILaunchConfiguration)launchConfig, (String)mode);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private ILaunchConfiguration createNew(IType type, ILaunchConfigurationType ctype) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            wc = ctype.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(type.getTypeQualifiedName('.')));
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.eclipse.fx.ide.ui.mobile.sim.device.MobileDeviceSimulator");
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, type.getJavaProject().getElementName());
            wc.setAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.APP_CLASS", type.getFullyQualifiedName());
            wc.setAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.DEVICE_TYPE", DeviceType.IPHONE.name());
            wc.setAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.DEVICE_ORIENTATION", Orientation.VERTICAL.name());
            wc.setAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.DEVICE_SIZE", "640x1136");
            wc.setMappedResources(new IResource[]{type.getUnderlyingResource()});
            config = wc.doSave();
        }
        catch (CoreException exception) {
            exception.printStackTrace();
        }
        return config;
    }

    private ILaunchConfiguration findLaunchConfig(IType type, ILaunchConfigurationType ctype) throws CoreException {
        ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(ctype);
        String typename = type.getFullyQualifiedName();
        String projectname = type.getJavaProject().getElementName();
        ILaunchConfiguration[] iLaunchConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration c = iLaunchConfigurationArray[n2];
            if (c.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(projectname) && c.getAttribute("org.eclipse.fx.ide.ui.mobile.sim.launch.APP_CLASS", "").equals(typename)) {
                return c;
            }
            ++n2;
        }
        return null;
    }
}

