/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.emf.edit.ui;

import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Cell;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.util.Callback;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fx.emf.edit.ui.AdapterFactoryCellFactory;
import org.eclipse.jdt.annotation.NonNull;

public class AdapterFactoryCheckBoxListCellFactory<T>
extends AdapterFactoryCellFactory
implements Callback<ListView<T>, ListCell<T>> {
    private Callback<T, ObservableValue<Boolean>> getSelectedProperty;

    public AdapterFactoryCheckBoxListCellFactory(@NonNull AdapterFactory adapterFactory, Callback<T, ObservableValue<Boolean>> getSelectedProperty) {
        super(adapterFactory);
        this.getSelectedProperty = getSelectedProperty;
    }

    public ListCell<T> call(@NonNull ListView<T> param) {
        CheckBoxListCell listCell = new CheckBoxListCell<T>(this.getSelectedProperty){
            Object currentItem;
            AdapterFactoryCellFactory.ICellEditHandler cellEditHandler;
            AdapterImpl adapter;
            {
                this.currentItem = null;
                this.adapter = new AdapterImpl(){

                    public void notifyChanged(Notification msg) {
                        this.update(msg.getNotifier());
                    }
                };
            }

            public void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (item != this.currentItem) {
                    if (this.currentItem instanceof Notifier) {
                        ((Notifier)this.currentItem).eAdapters().remove((Object)this.adapter);
                    }
                    this.currentItem = item;
                    if (this.currentItem instanceof Notifier) {
                        ((Notifier)this.currentItem).eAdapters().add((Object)this.adapter);
                    }
                }
                for (AdapterFactoryCellFactory.ICellUpdateListener cellUpdateListener : AdapterFactoryCheckBoxListCellFactory.this.cellUpdateListeners) {
                    cellUpdateListener.updateItem((Cell<?>)this, item, empty);
                }
                this.update(item);
            }

            public void startEdit() {
                super.startEdit();
                this.cellEditHandler = AdapterFactoryCheckBoxListCellFactory.this.getCellEditHandler((Cell<?>)this);
                if (this.cellEditHandler != null) {
                    this.cellEditHandler.startEdit((Cell<?>)this);
                }
            }

            public void commitEdit(T newValue) {
                super.commitEdit(newValue);
                if (this.cellEditHandler != null) {
                    this.cellEditHandler.commitEdit((Cell<?>)this, newValue);
                }
            }

            public void cancelEdit() {
                super.cancelEdit();
                if (this.cellEditHandler != null) {
                    this.cellEditHandler.cancelEdit((Cell<?>)this);
                }
                this.update(this.getItem());
            }

            void update(Object item) {
                if (Platform.isFxApplicationThread()) {
                    this.updateOnFxThread(item);
                } else {
                    Platform.runLater(() -> this.updateOnFxThread(item));
                }
            }

            private void updateOnFxThread(Object item) {
                AdapterFactoryCheckBoxListCellFactory.applyItemProviderStyle(item, this, AdapterFactoryCheckBoxListCellFactory.this.adapterFactory);
            }
        };
        for (AdapterFactoryCellFactory.ICellCreationListener cellCreationListener : this.cellCreationListeners) {
            cellCreationListener.cellCreated((Cell<?>)listCell);
        }
        return listCell;
    }
}

