/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.eclipse.internal.xtend.util.WeakInterningHashSet;

public final class QualifiedNameWithDelimiter {
    protected static final char SLASH = '/';
    protected static final String[] EMPTY_ARRAY = new String[0];
    protected static final QualifiedNameCache CACHE = new QualifiedNameCache();
    protected static final StringCache STRING_CACHE = new StringCache();
    protected static final QualifiedNameWithDelimiter EMPTY_WITHOUT_LEADING_SLASH = CACHE.intern(false, false, false, EMPTY_ARRAY);
    protected static final QualifiedNameWithDelimiter EMPTY = CACHE.intern(true, false, false, EMPTY_ARRAY);
    protected final int hashCode;
    protected String[] segments;
    protected WeakReference<String> toString;

    protected QualifiedNameWithDelimiter(String[] segments, int hashCode) {
        this.segments = segments;
        this.hashCode = hashCode;
    }

    public QualifiedNameWithDelimiter append(QualifiedNameWithDelimiter qualifiedName) {
        boolean hasLeadingSlash = this.hasLeadingSlash();
        if (this.segments == EMPTY_ARRAY) {
            if (hasLeadingSlash == !qualifiedName.hasLeadingSlash()) {
                return CACHE.intern(hasLeadingSlash, false, false, qualifiedName.segments);
            }
            return qualifiedName;
        }
        return CACHE.intern(hasLeadingSlash, this.segments, qualifiedName.segments);
    }

    public QualifiedNameWithDelimiter append(String segment) {
        if (this.segments == EMPTY_ARRAY) {
            return this.hasLeadingSlash() ? QualifiedNameWithDelimiter.create(segment) : QualifiedNameWithDelimiter.createWithoutLeadingSlash(segment);
        }
        if (segment.indexOf(47) != -1) {
            return this.append(QualifiedNameWithDelimiter.create(segment));
        }
        return CACHE.intern(this.hasLeadingSlash(), this.segments, segment);
    }

    public String toString() {
        String result;
        int segmentCount = this.segments.length;
        switch (segmentCount) {
            case 0: {
                return this.hasLeadingSlash() ? "/" : "";
            }
            case 1: {
                if (this.hasLeadingSlash()) break;
                return this.segments[0];
            }
        }
        String string = result = this.toString != null ? (String)this.toString.get() : null;
        if (result == null) {
            StringBuilder builder = new StringBuilder(segmentCount * 8);
            if (this.hasLeadingSlash()) {
                builder.append('/');
            }
            builder.append(this.segments[0]);
            int i = 1;
            while (i < segmentCount) {
                builder.append('/');
                builder.append(this.segments[i]);
                ++i;
            }
            result = builder.toString();
            this.toString = new WeakReference<String>(result);
        }
        return result;
    }

    public boolean hasLeadingSlash() {
        return (this.hashCode & 0xF8000000) != 0;
    }

    protected static int setLeadingSlash(boolean hasLeadingSlash, int hashCode) {
        if (hasLeadingSlash) {
            return hashCode | 0xF8000000;
        }
        return hashCode & 0x7FFFFFF;
    }

    public int getSegmentCount() {
        return this.segments.length;
    }

    public String getSegment(int index) {
        return this.segments[index];
    }

    public String getLastSegment() {
        return this.segments[this.segments.length - 1];
    }

    public String getFirstSegment() {
        return this.segments[0];
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean matches(String qualifiedName) {
        int segmentCount = this.segments.length;
        if (segmentCount == 0) {
            boolean hasLeadingSlash = this.hasLeadingSlash();
            int length = qualifiedName.length();
            return hasLeadingSlash ? length == 1 && qualifiedName.charAt(0) == '/' : length == 0;
        }
        if (segmentCount == 1) {
            boolean hasLeadingSlash = this.hasLeadingSlash();
            int length = qualifiedName.length();
            String segment = this.segments[0];
            return hasLeadingSlash ? segment.length() + 1 == length && qualifiedName.charAt(0) == '/' && qualifiedName.endsWith(segment) : segment.equals(qualifiedName);
        }
        if (this.toString != null) {
            String string = (String)this.toString.get();
            if (string != null) {
                return string.equals(qualifiedName);
            }
            this.toString = null;
        }
        boolean hasLeadingSlash = this.hasLeadingSlash();
        String segment = this.segments[0];
        int index = segment.length();
        if (hasLeadingSlash) {
            if (qualifiedName.charAt(0) != '/' || !qualifiedName.startsWith(segment, 1)) {
                return false;
            }
            ++index;
        } else if (!qualifiedName.startsWith(segment)) {
            return false;
        }
        int length = qualifiedName.length();
        int i = 1;
        while (i < segmentCount) {
            if (index >= length || qualifiedName.charAt(index) != '/') {
                return false;
            }
            segment = this.segments[i];
            if (!qualifiedName.startsWith(segment, ++index)) {
                return false;
            }
            index += segment.length();
            ++i;
        }
        this.toString = new WeakReference<String>(qualifiedName);
        return true;
    }

    public static String intern(String string) {
        return STRING_CACHE.intern(string);
    }

    public static String intern(char[] characters, int offset, int count) {
        int hashCode = 0;
        int i = offset;
        int end = offset + count;
        while (i < end) {
            hashCode = hashCode * 31 + characters[i];
            ++i;
        }
        return STRING_CACHE.intern(characters, offset, count, hashCode);
    }

    public static QualifiedNameWithDelimiter create(String qualifiedName) {
        return CACHE.intern(qualifiedName);
    }

    public static QualifiedNameWithDelimiter create(String ... segments) {
        String[] splitSegments = QualifiedNameWithDelimiter.split(segments);
        return CACHE.intern(true, segments == splitSegments, true, splitSegments);
    }

    public static QualifiedNameWithDelimiter createWithoutLeadingSlash(String ... segments) {
        String[] splitSegments = QualifiedNameWithDelimiter.split(segments);
        int length = splitSegments.length;
        if (length > 0 && "".equals(splitSegments[0])) {
            String[] trimmedSegments = new String[--length];
            System.arraycopy(splitSegments, 1, trimmedSegments, 0, length);
            return CACHE.intern(true, false, true, trimmedSegments);
        }
        return CACHE.intern(false, segments == splitSegments, true, splitSegments);
    }

    protected static String[] split(String[] segments) {
        ArrayList<String> expandedSegments = null;
        int i = 0;
        int length = segments.length;
        while (i < length) {
            String segment = segments[i];
            if (segment.indexOf(47) != -1) {
                String[] subsegments = QualifiedNameWithDelimiter.create((String)segment).segments;
                if (expandedSegments == null) {
                    expandedSegments = new ArrayList<String>(length + subsegments.length);
                    int j = 0;
                    while (j < i) {
                        expandedSegments.add(segments[j]);
                        ++j;
                    }
                }
                String[] stringArray = subsegments;
                int n = subsegments.length;
                int n2 = 0;
                while (n2 < n) {
                    String subsegment = stringArray[n2];
                    expandedSegments.add(subsegment);
                    ++n2;
                }
            } else if (expandedSegments != null) {
                expandedSegments.add(segment);
            }
            ++i;
        }
        return expandedSegments == null ? segments : expandedSegments.toArray(new String[expandedSegments.size()]);
    }

    public static void main(String[] args) {
        QualifiedNameWithDelimiter result = QualifiedNameWithDelimiter.create(new String("/a/b"));
        QualifiedNameWithDelimiter result1 = QualifiedNameWithDelimiter.create(new String("/a/b"));
        QualifiedNameWithDelimiter result2 = QualifiedNameWithDelimiter.create(new String("a/b"));
        QualifiedNameWithDelimiter result3 = QualifiedNameWithDelimiter.create(new String("a/b"));
        QualifiedNameWithDelimiter result4 = QualifiedNameWithDelimiter.create(new String("a"));
        QualifiedNameWithDelimiter result5 = QualifiedNameWithDelimiter.create(new String("a"));
        QualifiedNameWithDelimiter result6 = QualifiedNameWithDelimiter.create(new String("/a"));
        QualifiedNameWithDelimiter result7 = QualifiedNameWithDelimiter.create(new String("/a"));
        QualifiedNameWithDelimiter result8 = QualifiedNameWithDelimiter.create(new String(""));
        QualifiedNameWithDelimiter result9 = QualifiedNameWithDelimiter.create(new String(""));
        QualifiedNameWithDelimiter result10 = QualifiedNameWithDelimiter.create(new String("/"));
        QualifiedNameWithDelimiter result11 = QualifiedNameWithDelimiter.create(new String("/"));
        QualifiedNameWithDelimiter result12 = QualifiedNameWithDelimiter.create(new String[0]);
        QualifiedNameWithDelimiter result13 = QualifiedNameWithDelimiter.createWithoutLeadingSlash(new String[0]);
        QualifiedNameWithDelimiter result14 = QualifiedNameWithDelimiter.createWithoutLeadingSlash("");
        QualifiedNameWithDelimiter result15 = QualifiedNameWithDelimiter.create(new String[]{"/a/b"});
        QualifiedNameWithDelimiter result16 = QualifiedNameWithDelimiter.createWithoutLeadingSlash("/a/b");
        QualifiedNameWithDelimiter result17 = QualifiedNameWithDelimiter.createWithoutLeadingSlash("a/b");
        QualifiedNameWithDelimiter result18 = result4.append(QualifiedNameWithDelimiter.create("b"));
        QualifiedNameWithDelimiter result19 = result4.append("b");
        QualifiedNameWithDelimiter result20 = result4.append("/b");
        QualifiedNameWithDelimiter result21 = QualifiedNameWithDelimiter.create("a", "b");
        QualifiedNameWithDelimiter result22 = QualifiedNameWithDelimiter.createWithoutLeadingSlash("a", "b");
        QualifiedNameWithDelimiter result23 = result22.append("c/d");
        QualifiedNameWithDelimiter result24 = QualifiedNameWithDelimiter.createWithoutLeadingSlash("a", "b", "c", "d");
        System.gc();
        System.gc();
        System.out.println("###" + result1);
        System.out.println("###" + result3);
        System.out.println("###" + result4);
        System.out.println("###" + result7);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class QualifiedNameCache
    extends WeakInterningHashSet<QualifiedNameWithDelimiter> {
        private static final long serialVersionUID = 1L;
        protected static int[] POWERS_OF_31;
        protected char[] buffer = new char[100];
        protected String[] segmentBuffer = new String[100];

        protected QualifiedNameCache() {
        }

        protected static int powerOf31(int n) {
            if (POWERS_OF_31 == null || POWERS_OF_31.length <= n) {
                POWERS_OF_31 = new int[Math.max(POWERS_OF_31 == null ? 100 : POWERS_OF_31.length * 2, n + 1)];
                int powerOf31 = 1;
                int i = 0;
                while (i < POWERS_OF_31.length) {
                    QualifiedNameCache.POWERS_OF_31[i] = powerOf31;
                    powerOf31 *= 31;
                    ++i;
                }
            }
            return POWERS_OF_31[n];
        }

        protected static int hashCode(int initialHashCode, String[] segments) {
            int length = segments.length;
            if (length == 0) {
                return initialHashCode;
            }
            String segment = segments[0];
            int hashCode = (initialHashCode == 0 ? 0 : initialHashCode * QualifiedNameCache.powerOf31(segment.length())) + segment.hashCode();
            if (length > 1) {
                int i = 1;
                while (i < length) {
                    hashCode = hashCode * 31 + 47;
                    segment = segments[i];
                    hashCode = hashCode * QualifiedNameCache.powerOf31(segment.length()) + segment.hashCode();
                    ++i;
                }
            }
            return hashCode;
        }

        protected static int hashCode(boolean hasLeadingSlash, String[] segments) {
            return QualifiedNameWithDelimiter.setLeadingSlash(hasLeadingSlash, QualifiedNameCache.hashCode(hasLeadingSlash ? 47 : 0, segments));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public QualifiedNameWithDelimiter intern(boolean hasLeadingSlash, boolean needsCopying, boolean needsToIntern, String[] segments) {
            int hashCode = QualifiedNameCache.hashCode(hasLeadingSlash, segments);
            QualifiedNameCache qualifiedNameCache = this;
            synchronized (qualifiedNameCache) {
                int i;
                WeakInterningHashSet.Entry entry = this.getEntry(hashCode);
                while (entry != null) {
                    QualifiedNameWithDelimiter qualifiedName = (QualifiedNameWithDelimiter)entry.get();
                    if (qualifiedName != null && QualifiedNameCache.equals(qualifiedName.segments, segments)) {
                        return qualifiedName;
                    }
                    entry = entry.getNextEntry();
                }
                int length = segments.length;
                String[] newSegments = segments;
                if (needsCopying) {
                    newSegments = new String[length];
                    if (needsToIntern) {
                        i = 0;
                        while (i < length) {
                            newSegments[i] = STRING_CACHE.intern(segments[i]);
                            ++i;
                        }
                    } else {
                        System.arraycopy(segments, 0, newSegments, 0, length);
                    }
                } else if (needsToIntern) {
                    i = 0;
                    while (i < length) {
                        segments[i] = STRING_CACHE.intern(segments[i]);
                        ++i;
                    }
                }
                QualifiedNameWithDelimiter qualifiedName = new QualifiedNameWithDelimiter(newSegments, hashCode);
                this.addEntry(this.createEntry(qualifiedName, hashCode));
                return qualifiedName;
            }
        }

        protected static int hashCode(boolean hasLeadingSlash, String[] segments, String segment) {
            int hashCode = QualifiedNameCache.hashCode(hasLeadingSlash ? 47 : 0, segments);
            hashCode = hashCode * 31 + 47;
            hashCode = hashCode * QualifiedNameCache.powerOf31(segment.length()) + segment.hashCode();
            return QualifiedNameWithDelimiter.setLeadingSlash(hasLeadingSlash, hashCode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected QualifiedNameWithDelimiter intern(boolean hasLeadingSlash, String[] segments, String segment) {
            int length1 = segments.length;
            int length = length1 + 1;
            int hashCode = QualifiedNameCache.hashCode(hasLeadingSlash, segments, segment);
            QualifiedNameCache qualifiedNameCache = this;
            synchronized (qualifiedNameCache) {
                QualifiedNameWithDelimiter qualifiedName;
                WeakInterningHashSet.Entry entry = this.getEntry(hashCode);
                while (entry != null) {
                    block8: {
                        String[] entrySegments;
                        qualifiedName = (QualifiedNameWithDelimiter)entry.get();
                        if (qualifiedName != null && length == (entrySegments = qualifiedName.segments).length) {
                            int i = 0;
                            while (i < length1) {
                                if (entrySegments[i] == segments[i]) {
                                    ++i;
                                    continue;
                                }
                                break block8;
                            }
                            if (segment.equals(entrySegments[i])) {
                                return qualifiedName;
                            }
                        }
                    }
                    entry = entry.getNextEntry();
                }
                String[] newSegments = new String[length];
                System.arraycopy(segments, 0, newSegments, 0, length1);
                newSegments[length1] = STRING_CACHE.intern(segment);
                qualifiedName = new QualifiedNameWithDelimiter(newSegments, hashCode);
                this.addEntry(this.createEntry(qualifiedName, hashCode));
                return qualifiedName;
            }
        }

        protected static int hashCode(boolean hasLeadingSlash, String[] segments1, String[] segments2) {
            int hashCode = QualifiedNameCache.hashCode(hasLeadingSlash ? 47 : 0, segments1);
            if (segments2.length > 0) {
                hashCode = hashCode * 31 + 47;
                hashCode = QualifiedNameCache.hashCode(hashCode, segments2);
            }
            return QualifiedNameWithDelimiter.setLeadingSlash(hasLeadingSlash, hashCode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected QualifiedNameWithDelimiter intern(boolean hasLeadingSlash, String[] segments1, String[] segments2) {
            int length1 = segments1.length;
            int length2 = segments2.length;
            int length = length1 + length2;
            int hashCode = QualifiedNameCache.hashCode(hasLeadingSlash, segments1, segments2);
            QualifiedNameCache qualifiedNameCache = this;
            synchronized (qualifiedNameCache) {
                QualifiedNameWithDelimiter qualifiedName;
                WeakInterningHashSet.Entry entry = this.getEntry(hashCode);
                while (entry != null) {
                    block9: {
                        String[] segments;
                        qualifiedName = (QualifiedNameWithDelimiter)entry.get();
                        if (qualifiedName != null && length == (segments = qualifiedName.segments).length) {
                            int i = 0;
                            while (i < length1) {
                                if (segments[i] == segments1[i]) {
                                    ++i;
                                    continue;
                                }
                                break block9;
                            }
                            int j = 0;
                            while (j < length2) {
                                if (segments[i] == segments2[j]) {
                                    ++i;
                                    ++j;
                                    continue;
                                }
                                break block9;
                            }
                            return qualifiedName;
                        }
                    }
                    entry = entry.getNextEntry();
                }
                String[] newSegments = new String[length];
                System.arraycopy(segments1, 0, newSegments, 0, length1);
                System.arraycopy(segments2, 0, newSegments, length1, length2);
                qualifiedName = new QualifiedNameWithDelimiter(newSegments, hashCode);
                this.addEntry(this.createEntry(qualifiedName, hashCode));
                return qualifiedName;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected QualifiedNameWithDelimiter intern(String name) {
            int length = name.length();
            if (length == 0) {
                return EMPTY_WITHOUT_LEADING_SLASH;
            }
            boolean hasLeadingSlash = name.charAt(0) == '/';
            int hashCode = QualifiedNameWithDelimiter.setLeadingSlash(hasLeadingSlash, name.hashCode());
            QualifiedNameCache qualifiedNameCache = this;
            synchronized (qualifiedNameCache) {
                int start;
                WeakInterningHashSet.Entry entry = this.getEntry(hashCode);
                while (entry != null) {
                    QualifiedNameWithDelimiter qualifiedName = (QualifiedNameWithDelimiter)entry.get();
                    if (qualifiedName != null && qualifiedName.matches(name)) {
                        return qualifiedName;
                    }
                    entry = entry.getNextEntry();
                }
                if (this.buffer.length < length) {
                    this.buffer = new char[length];
                }
                name.getChars(0, length, this.buffer, 0);
                int segmentCount = 0;
                int segmentHashCode = 0;
                int i = start = hasLeadingSlash ? 1 : 0;
                while (i < length) {
                    char c = this.buffer[i];
                    if (c == '/') {
                        this.ensureSegmentCapacity(segmentCount);
                        this.segmentBuffer[segmentCount++] = STRING_CACHE.intern(this.buffer, start, i - start, segmentHashCode);
                        start = i + 1;
                        segmentHashCode = 0;
                    } else {
                        segmentHashCode = segmentHashCode * 31 + c;
                    }
                    ++i;
                }
                if (start < length) {
                    this.ensureSegmentCapacity(segmentCount);
                    this.segmentBuffer[segmentCount++] = STRING_CACHE.intern(this.buffer, start, length - start, segmentHashCode);
                }
                String[] newSegments = new String[segmentCount];
                System.arraycopy(this.segmentBuffer, 0, newSegments, 0, segmentCount);
                QualifiedNameWithDelimiter qualifiedName = new QualifiedNameWithDelimiter(newSegments, hashCode);
                if (this.segmentBuffer.length > 1 || hasLeadingSlash) {
                    qualifiedName.toString = new WeakReference<String>(name);
                }
                this.addEntry(this.createEntry(qualifiedName, hashCode));
                return qualifiedName;
            }
        }

        protected void ensureSegmentCapacity(int segmentCount) {
            if (segmentCount <= this.segmentBuffer.length) {
                String[] oldSegments = this.segmentBuffer;
                this.segmentBuffer = new String[2 * this.segmentBuffer.length];
                System.arraycopy(oldSegments, 0, this.segmentBuffer, 0, segmentCount);
            }
        }

        protected static boolean equals(String[] segments1, String[] segments2) {
            int length = segments1.length;
            if (segments2.length != length) {
                return false;
            }
            int i = 0;
            while (i < length) {
                if (!segments1[i].equals(segments2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StringCache
    extends WeakInterningHashSet<String> {
        private static final long serialVersionUID = 1L;
        protected char[] buffer = new char[100];

        protected StringCache() {
        }

        protected synchronized String intern(char[] characters, int offset, int count, int hashCode) {
            WeakInterningHashSet.Entry entry = this.getEntry(hashCode);
            block0: while (entry != null) {
                int length;
                String value = (String)entry.get();
                if (value != null && (length = value.length()) == count) {
                    if (this.buffer.length < count) {
                        this.buffer = new char[count];
                    }
                    value.getChars(0, count, this.buffer, 0);
                    int i = 0;
                    while (i < count) {
                        if (characters[offset + i] != this.buffer[i]) break block0;
                        ++i;
                    }
                    return value;
                }
                entry = entry.getNextEntry();
            }
            String value = new String(characters, offset, count);
            this.addEntry(new WeakInterningHashSet.Entry<String>(value, hashCode, this.queue));
            return value;
        }

        @Override
        public synchronized String intern(String object) {
            return super.intern(object);
        }

        @Override
        protected WeakInterningHashSet.Entry<String> createEntry(String object, int hashCode) {
            return super.createEntry(new String(object), hashCode);
        }
    }
}

