/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.documentation.impl;

import com.google.inject.Singleton;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.documentation.IFileHeaderProvider;
import org.eclipse.xtext.documentation.impl.AbstractMultiLineCommentProvider;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;

@Singleton
public class MultiLineFileHeaderProvider
extends AbstractMultiLineCommentProvider
implements IFileHeaderProvider {
    protected String findFileHeader(Resource resource) {
        String returnValue = null;
        List<INode> fileHeaderNodes = this.getFileHeaderNodes(resource);
        if (!fileHeaderNodes.isEmpty()) {
            return fileHeaderNodes.get(0).getText();
        }
        return returnValue;
    }

    @Override
    public List<INode> getFileHeaderNodes(Resource resource) {
        IParseResult parseResult;
        if (resource instanceof XtextResource && (parseResult = ((XtextResource)resource).getParseResult()) != null) {
            ILeafNode leafNode;
            EObject grammarElement;
            Iterator<ILeafNode> iterator = parseResult.getRootNode().getLeafNodes().iterator();
            while (iterator.hasNext() && (grammarElement = (leafNode = iterator.next()).getGrammarElement()) instanceof TerminalRule) {
                String terminalRuleName = ((TerminalRule)grammarElement).getName();
                if (this.ruleName.equalsIgnoreCase(terminalRuleName)) {
                    return Collections.singletonList(leafNode);
                }
                if (this.wsRuleName.equals(terminalRuleName)) continue;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public String getFileHeader(Resource resource) {
        String returnValue = this.findFileHeader(resource);
        return this.getTextFromMultilineComment(returnValue);
    }
}

