/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.sequencer;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.analysis.SerializationContext;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;

public abstract class AbstractSemanticSequencer
implements ISemanticSequencer {
    @Inject
    protected ISemanticSequencerDiagnosticProvider diagnosticProvider;
    protected ISerializationDiagnostic.Acceptor errorAcceptor;
    @Inject
    protected SequenceFeeder.Provider feederProvider;
    protected ISemanticSequencer masterSequencer;
    @Inject
    protected ISemanticNodeProvider nodeProvider;
    protected ISemanticSequenceAcceptor sequenceAcceptor;
    @Inject
    protected ITransientValueService transientValues;
    private final boolean USES_EOBJECT_AS_CONTEXT = this.usesEObjectAsContext();

    protected ISerializationContext createContext(EObject deprecatedContext, EObject semanticObject) {
        return SerializationContext.fromEObject(deprecatedContext, semanticObject);
    }

    protected ISemanticNodeProvider.INodesForEObjectProvider createNodeProvider(EObject semanticObject) {
        return this.nodeProvider.getNodesForSemanticObject(semanticObject, null);
    }

    @Override
    @Deprecated
    public void createSequence(EObject context, EObject semanticObject) {
        throw new UnsupportedOperationException("Either overwrite, or, better, don't call this method.");
    }

    @Override
    public void createSequence(ISerializationContext context, EObject semanticObject) {
        if (this.USES_EOBJECT_AS_CONTEXT) {
            this.createSequence(((SerializationContext)context).getActionOrRule(), semanticObject);
        } else {
            this.sequence(context, semanticObject);
        }
    }

    protected SequenceFeeder createSequencerFeeder(EObject semanticObject) {
        ISemanticNodeProvider.INodesForEObjectProvider nodeProvider = this.createNodeProvider(semanticObject);
        return this.feederProvider.create(semanticObject, nodeProvider, this.masterSequencer, this.sequenceAcceptor, this.errorAcceptor);
    }

    protected SequenceFeeder createSequencerFeeder(EObject semanticObject, ISemanticNodeProvider.INodesForEObjectProvider nodeProvider) {
        return this.feederProvider.create(semanticObject, nodeProvider, this.masterSequencer, this.sequenceAcceptor, this.errorAcceptor);
    }

    protected SequenceFeeder createSequencerFeeder(ISerializationContext context, EObject semanticObject) {
        ISemanticNodeProvider.INodesForEObjectProvider nodeProvider = this.createNodeProvider(semanticObject);
        return this.feederProvider.create(context, semanticObject, nodeProvider, this.masterSequencer, this.sequenceAcceptor, this.errorAcceptor);
    }

    protected SequenceFeeder createSequencerFeeder(ISerializationContext context, EObject semanticObject, ISemanticNodeProvider.INodesForEObjectProvider nodeProvider) {
        return this.feederProvider.create(context, semanticObject, nodeProvider, this.masterSequencer, this.sequenceAcceptor, this.errorAcceptor);
    }

    @Override
    public void init(ISemanticSequenceAcceptor sequenceAcceptor, ISerializationDiagnostic.Acceptor errorAcceptor) {
        this.init(this, sequenceAcceptor, errorAcceptor);
    }

    @Override
    public void init(ISemanticSequencer sequencer, ISemanticSequenceAcceptor sequenceAcceptor, ISerializationDiagnostic.Acceptor errorAcceptor) {
        this.masterSequencer = sequencer;
        this.sequenceAcceptor = sequenceAcceptor;
        this.errorAcceptor = errorAcceptor;
    }

    public void sequence(ISerializationContext context, EObject semanticObject) {
    }

    public void setMasterSequencer(ISemanticSequencer sequencer) {
        this.masterSequencer = sequencer;
    }

    private boolean usesEObjectAsContext() {
        Class<?> eObj = null;
        try {
            eObj = this.getClass().getMethod("createSequence", EObject.class, EObject.class).getDeclaringClass();
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
        Class<?> iContext = null;
        try {
            iContext = this.getClass().getMethod("sequence", ISerializationContext.class, EObject.class).getDeclaringClass();
        }
        catch (NoSuchMethodException e) {
            return true;
        }
        catch (SecurityException e) {
            return true;
        }
        return iContext.isAssignableFrom(eObj);
    }
}

