/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.util;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakCache2<K, V> {
    protected Map<K, WeakReference<V>> map = new HashMap<K, WeakReference<V>>();
    private int min_limit;
    int count;
    int limit;
    long hitCount = 0L;
    long totalCount = 0L;

    public WeakCache2() {
        this(1000);
    }

    public WeakCache2(int min_limit) {
        this.limit = this.min_limit = min_limit;
    }

    public synchronized V get(K key) {
        V result;
        ++this.totalCount;
        WeakReference<V> reference = this.map.get(key);
        V v = result = reference == null ? null : (V)reference.get();
        if (result != null) {
            ++this.hitCount;
        }
        return result;
    }

    public synchronized void put(K key, V value) {
        if (key == value) {
            throw new IllegalArgumentException("Cannot use same instance as key and value, since this would prevent GC of the cache value");
        }
        this.map.put(key, new WeakReference<V>(value));
        if (++this.count > this.limit) {
            this.cleanGCedValues();
        }
    }

    private void cleanGCedValues() {
        Iterator<Map.Entry<K, WeakReference<V>>> i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<K, WeakReference<V>> entry = i.next();
            WeakReference<V> reference = entry.getValue();
            if (reference.get() != null) continue;
            i.remove();
        }
        this.count = 0;
        this.limit = Math.max(this.min_limit, this.map.size() / 2);
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public long getMissCount() {
        return this.totalCount - this.hitCount;
    }

    public double getHitRatio() {
        return new Long(this.hitCount).doubleValue() / (double)this.totalCount;
    }
}

