/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching.macosx;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.LibraryInfo;
import org.eclipse.jdt.internal.launching.MacInstalledJREs;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.internal.launching.macosx.MacOSXLaunchingPlugin;
import org.eclipse.jdt.internal.launching.macosx.MacOSXVMInstall;
import org.eclipse.jdt.internal.launching.macosx.Messages;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.osgi.util.NLS;

public class MacOSXVMInstallType
extends StandardVMType {
    private static final String JVM_VERSION_LOC = "/System/Library/Frameworks/JavaVM.framework/Versions/";
    private static final File JVM_VERSIONS_FOLDER = new File("/System/Library/Frameworks/JavaVM.framework/Versions/");
    private static final String CURRENT_JDK = "CurrentJDK";
    private static final String JVM_HOME = "Home";
    private static final String JAVADOC_LOC = "/Developer/Documentation/Java/Reference/";
    private static final String JAVADOC_SUBDIR = "/doc/api";
    static final String SRC_ZIP = "src.zip";
    static final String SRC_JAR = "src.jar";
    static final String SRC_NAME = "src";
    static final String JVM_CONTENTS = "Contents";
    static final String JVM_CLASSES = "Classes";
    static final String JVM_VERSIONS = "Versions";

    public String getName() {
        return Messages.MacOSXVMInstallType_0;
    }

    public IVMInstall doCreateVMInstall(String id) {
        return new MacOSXVMInstall((IVMInstallType)this, id);
    }

    public File detectInstallLocation() {
        try {
            File defaultLocation = this.getJavaHomeLocation();
            VMStandin[] vms = MacInstalledJREs.getInstalledJREs(null);
            File firstLocation = null;
            IVMInstall firstInstall = null;
            IVMInstall defaultInstall = null;
            int i = 0;
            while (i < vms.length) {
                File location = vms[i].getInstallLocation();
                IVMInstall install = this.findVMInstall(vms[i].getId());
                if (install == null) {
                    install = vms[i].convertToRealVM();
                }
                if (i == 0) {
                    firstLocation = location;
                    firstInstall = install;
                }
                if (defaultInstall == null && defaultLocation != null && defaultLocation.equals(location)) {
                    defaultInstall = install;
                }
                ++i;
            }
            if (defaultInstall == null) {
                if (defaultLocation != null) {
                    String version = System.getProperty("java.version");
                    MacInstalledJREs.MacVMStandin standin = new MacInstalledJREs.MacVMStandin((IVMInstallType)this, defaultLocation, version == null ? Messages.MacOSXVMInstallType_jre : NLS.bind((String)Messages.MacOSXVMInstallType_jre_version, (Object)version), version == null ? "???" : version, String.valueOf(System.currentTimeMillis()));
                    defaultInstall = standin.convertToRealVM();
                } else {
                    defaultInstall = firstInstall;
                    defaultLocation = firstLocation;
                }
            }
            if (defaultInstall != null) {
                try {
                    JavaRuntime.setDefaultVMInstall(defaultInstall, null);
                }
                catch (CoreException e) {
                    LaunchingPlugin.log((Throwable)e);
                }
            }
            return defaultLocation;
        }
        catch (CoreException e) {
            MacOSXLaunchingPlugin.getDefault().getLog().log(e.getStatus());
            return this.detectInstallLocationOld();
        }
    }

    private File detectInstallLocationOld() {
        String javaVMName = System.getProperty("java.vm.name");
        if (javaVMName == null) {
            return null;
        }
        if (!JVM_VERSIONS_FOLDER.exists() || !JVM_VERSIONS_FOLDER.isDirectory()) {
            String message = NLS.bind((String)Messages.MacOSXVMInstallType_1, (Object)JVM_VERSIONS_FOLDER);
            LaunchingPlugin.log((String)message);
            return null;
        }
        File defaultLocation = null;
        File[] versions = this.getAllVersionsOld();
        File currentJDK = this.getCurrentJDKOld();
        int i = 0;
        while (i < versions.length) {
            File versionFile = versions[i];
            String version = versionFile.getName();
            File home = new File(versionFile, JVM_HOME);
            if (home.exists()) {
                boolean isDefault = currentJDK.equals(versionFile);
                IVMInstall install = this.findVMInstall(version);
                if (install == null) {
                    VMStandin vm = new VMStandin((IVMInstallType)this, version);
                    vm.setInstallLocation(home);
                    vm.setName(version);
                    vm.setLibraryLocations(this.getDefaultLibraryLocations(home));
                    vm.setJavadocLocation(this.getDefaultJavadocLocation(home));
                    install = vm.convertToRealVM();
                }
                if (isDefault) {
                    defaultLocation = home;
                    try {
                        JavaRuntime.setDefaultVMInstall((IVMInstall)install, null);
                    }
                    catch (CoreException e) {
                        LaunchingPlugin.log((Throwable)e);
                    }
                }
            }
            ++i;
        }
        return defaultLocation;
    }

    private File[] getAllVersionsOld() {
        File[] versionFiles = JVM_VERSIONS_FOLDER.listFiles();
        int i = 0;
        while (i < versionFiles.length) {
            versionFiles[i] = this.resolveSymbolicLinks(versionFiles[i]);
            ++i;
        }
        return versionFiles;
    }

    private File getCurrentJDKOld() {
        return this.resolveSymbolicLinks(new File(JVM_VERSIONS_FOLDER, CURRENT_JDK));
    }

    private File resolveSymbolicLinks(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file;
        }
    }

    protected LibraryInfo getDefaultLibraryInfo(File installLocation) {
        IPath rtjar = this.getDefaultSystemLibrary(installLocation);
        if (rtjar.toFile().isFile()) {
            return super.getDefaultLibraryInfo(installLocation);
        }
        File classes = new File(installLocation, "../Classes");
        File lib1 = new File(classes, "classes.jar");
        File lib2 = new File(classes, "ui.jar");
        String[] libs = new String[]{lib1.toString(), lib2.toString()};
        File lib = new File(installLocation, "lib");
        File extDir = new File(lib, "ext");
        String[] dirs = null;
        dirs = extDir.exists() ? new String[]{extDir.getAbsolutePath()} : new String[]{};
        File endDir = new File(lib, "endorsed");
        String[] endDirs = null;
        endDirs = endDir.exists() ? new String[]{endDir.getAbsolutePath()} : new String[]{};
        return new LibraryInfo("???", libs, dirs, endDirs);
    }

    protected IPath getDefaultSystemLibrarySource(File libLocation) {
        File parent = libLocation.getParentFile();
        File src = null;
        String pname = parent.getName();
        while (parent != null && !JVM_CONTENTS.equals(pname) && !JVM_VERSIONS.equals(pname)) {
            if (JVM_CLASSES.equals(pname)) {
                src = new File(parent.getParent(), JVM_HOME);
                src = this.getSourceInParent(src);
            } else {
                src = this.getSourceInParent(parent);
            }
            if (src != null) {
                this.setDefaultRootPath(SRC_NAME);
                return new Path(src.getPath());
            }
            parent = parent.getParentFile();
        }
        this.setDefaultRootPath("");
        return Path.EMPTY;
    }

    File getSourceInParent(File parent) {
        if (parent.isDirectory()) {
            File src = new File(parent, SRC_ZIP);
            if (src.isFile()) {
                return src;
            }
            if ((src = new File(src, SRC_JAR)).isFile()) {
                return src;
            }
        }
        return null;
    }

    public IStatus validateInstallLocation(File javaHome) {
        String id = MacOSXLaunchingPlugin.getUniqueIdentifier();
        File java = new File(javaHome, "bin" + File.separator + "java");
        if (java.isFile()) {
            return new Status(0, id, 0, "ok", null);
        }
        return new Status(4, id, 0, Messages.MacOSXVMInstallType_2, null);
    }

    public URL getDefaultJavadocLocation(File installLocation) {
        String id = null;
        try {
            String post = String.valueOf(File.separator) + JVM_HOME;
            String path = installLocation.getCanonicalPath();
            if (path.startsWith(JVM_VERSION_LOC) && path.endsWith(post)) {
                id = path.substring(JVM_VERSION_LOC.length(), path.length() - post.length());
            }
        }
        catch (IOException iOException) {}
        if (id != null) {
            String s = JAVADOC_LOC + id + JAVADOC_SUBDIR;
            File docLocation = new File(s);
            if (!docLocation.exists() && !(docLocation = new File(s = JAVADOC_LOC + id)).exists()) {
                s = null;
            }
            if (s != null) {
                try {
                    return new URL("file", "", s);
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        return super.getDefaultJavadocLocation(installLocation);
    }

    protected String getVMVersion(File javaHome, File javaExecutable) {
        return super.getVMVersion(javaHome, javaExecutable);
    }
}

