/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.xplain;

import java.util.Map;
import java.util.Set;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.xplain.MinimizationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickXplain2001Strategy
implements MinimizationStrategy {
    private static final long serialVersionUID = 1L;
    private boolean computationCanceled;

    @Override
    public void cancelExplanationComputation() {
        this.computationCanceled = true;
    }

    @Override
    public IVecInt explain(ISolver solver, Map<Integer, ?> constrs, IVecInt assumps) throws TimeoutException {
        this.computationCanceled = false;
        VecInt encodingAssumptions = new VecInt(constrs.size() + assumps.size());
        assumps.copyTo(encodingAssumptions);
        IVecInt firstExplanation = solver.unsatExplanation();
        if (solver.isVerbose()) {
            System.out.print(String.valueOf(solver.getLogPrefix()) + "initial unsat core ");
            firstExplanation.sort();
            IteratorInt it = firstExplanation.iterator();
            while (it.hasNext()) {
                System.out.print(constrs.get(-it.next()));
                System.out.print(" ");
            }
            System.out.println();
        }
        Set<Integer> constraintsVariables = constrs.keySet();
        int i = 0;
        while (i < firstExplanation.size()) {
            int p = -firstExplanation.get(i);
            if (constraintsVariables.contains(p)) {
                encodingAssumptions.push(p);
            }
            ++i;
        }
        VecInt results = new VecInt(encodingAssumptions.size());
        this.computeExplanation(solver, encodingAssumptions, assumps.size(), encodingAssumptions.size() - 1, results);
        return results;
    }

    /*
     * Unable to fully structure code
     */
    private void computeExplanation(ISolver solver, IVecInt encodingAssumptions, int start, int end, IVecInt result) throws TimeoutException {
        if (!solver.isSatisfiable(encodingAssumptions)) {
            return;
        }
        i = start;
        encodingAssumptions.set(i, -encodingAssumptions.get(i));
        if (QuickXplain2001Strategy.$assertionsDisabled || encodingAssumptions.get(i) < 0) ** GOTO lbl17
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            if (i == end) {
                j = start;
                while (j <= end) {
                    encodingAssumptions.set(j, -encodingAssumptions.get(j));
                    ++j;
                }
                return;
            }
            if (!QuickXplain2001Strategy.$assertionsDisabled && encodingAssumptions.get(++i) <= 0) {
                throw new AssertionError();
            }
            encodingAssumptions.set(i, -encodingAssumptions.get(i));
lbl17:
            // 2 sources

            ** while (!this.computationCanceled && solver.isSatisfiable((IVecInt)encodingAssumptions))
        }
lbl18:
        // 1 sources

        result.push(-encodingAssumptions.get(i));
        if (start == i) {
            return;
        }
        newend = i - 1;
        split = (newend + start) / 2;
        if (split < newend) {
            j = split + 1;
            while (j < i) {
                encodingAssumptions.set(j, -encodingAssumptions.get(j));
                ++j;
            }
            this.computeExplanation(solver, encodingAssumptions, split + 1, newend, result);
        }
        if (start <= split) {
            j = start;
            while (j <= split) {
                encodingAssumptions.set(j, -encodingAssumptions.get(j));
                ++j;
            }
            this.computeExplanation(solver, encodingAssumptions, start, split, result);
        }
        if (this.computationCanceled) {
            throw new TimeoutException();
        }
    }

    public String toString() {
        return "QuickXplain (IJCAI WS 2001 version) minimization strategy";
    }
}

