/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.p2.repository.helpers.RepositoryHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.Activator;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractApplication {
    protected boolean removeAddedRepositories = true;
    protected List<RepositoryDescriptor> sourceRepositories = new ArrayList<RepositoryDescriptor>();
    protected List<URI> artifactReposToRemove = new ArrayList<URI>();
    protected List<URI> metadataReposToRemove = new ArrayList<URI>();
    protected List<IInstallableUnit> sourceIUs = new ArrayList<IInstallableUnit>();
    private List<RepositoryDescriptor> destinationRepos = new ArrayList<RepositoryDescriptor>();
    protected IArtifactRepository destinationArtifactRepository = null;
    protected IMetadataRepository destinationMetadataRepository = null;
    private CompositeMetadataRepository compositeMetadataRepository = null;
    private CompositeArtifactRepository compositeArtifactRepository = null;
    protected IProvisioningAgent agent;

    public AbstractApplication() {
        try {
            this.setupAgent();
        }
        catch (ProvisionException e) {
            LogHelper.log((ProvisionException)e);
        }
    }

    private void setupAgent() throws ProvisionException {
        ServiceReference providerRef;
        ServiceReference agentRef = Activator.getBundleContext().getServiceReference(IProvisioningAgent.class);
        if (agentRef != null) {
            this.agent = (IProvisioningAgent)Activator.getBundleContext().getService(agentRef);
            if (this.agent != null) {
                return;
            }
        }
        if ((providerRef = Activator.getBundleContext().getServiceReference(IProvisioningAgentProvider.class)) == null) {
            throw new RuntimeException("No provisioning agent provider is available");
        }
        IProvisioningAgentProvider provider = (IProvisioningAgentProvider)Activator.getBundleContext().getService(providerRef);
        if (provider == null) {
            throw new RuntimeException("No provisioning agent provider is available");
        }
        this.agent = provider.createAgent(null);
        Activator.getBundleContext().ungetService(providerRef);
    }

    public void setSourceIUs(List<IInstallableUnit> ius) {
        this.sourceIUs = ius;
    }

    protected void finalizeRepositories() {
        if (this.removeAddedRepositories) {
            IArtifactRepositoryManager artifactRepositoryManager = this.getArtifactRepositoryManager();
            for (URI uri : this.artifactReposToRemove) {
                artifactRepositoryManager.removeRepository(uri);
            }
            IMetadataRepositoryManager metadataRepositoryManager = this.getMetadataRepositoryManager();
            for (URI uri : this.metadataReposToRemove) {
                metadataRepositoryManager.removeRepository(uri);
            }
        }
        this.metadataReposToRemove = null;
        this.artifactReposToRemove = null;
        this.compositeArtifactRepository = null;
        this.compositeMetadataRepository = null;
        this.destinationArtifactRepository = null;
        this.destinationMetadataRepository = null;
    }

    protected IMetadataRepositoryManager getMetadataRepositoryManager() {
        return (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
    }

    protected IArtifactRepositoryManager getArtifactRepositoryManager() {
        return (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
    }

    public void initializeRepos(IProgressMonitor progress) throws ProvisionException {
        IArtifactRepositoryManager artifactRepositoryManager = this.getArtifactRepositoryManager();
        IMetadataRepositoryManager metadataRepositoryManager = this.getMetadataRepositoryManager();
        URI curLocation = null;
        for (RepositoryDescriptor repo : this.sourceRepositories) {
            try {
                curLocation = repo.getRepoLocation();
                if (repo.isBoth()) {
                    this.addRepository(artifactRepositoryManager, curLocation, 0, progress);
                    this.addRepository(metadataRepositoryManager, curLocation, 0, progress);
                    continue;
                }
                if (repo.isArtifact()) {
                    this.addRepository(artifactRepositoryManager, curLocation, 0, progress);
                    continue;
                }
                if (repo.isMetadata()) {
                    this.addRepository(metadataRepositoryManager, curLocation, 0, progress);
                    continue;
                }
                throw new ProvisionException(NLS.bind((String)Messages.unknown_repository_type, (Object)repo.getRepoLocation()));
            }
            catch (ProvisionException e) {
                if (e.getCause() instanceof MalformedURLException) {
                    throw new ProvisionException(NLS.bind((String)Messages.exception_invalidSource, (Object)curLocation), (Throwable)e);
                }
                if (e.getStatus().getCode() == 1000 && repo.isOptional()) continue;
                throw e;
            }
        }
        this.processDestinationRepos(artifactRepositoryManager, metadataRepositoryManager);
    }

    protected IMetadataRepository addRepository(IMetadataRepositoryManager manager, URI location, int flags, IProgressMonitor monitor) throws ProvisionException {
        if (!manager.contains(location)) {
            this.metadataReposToRemove.add(location);
        }
        return manager.loadRepository(location, flags, monitor);
    }

    protected IArtifactRepository addRepository(IArtifactRepositoryManager manager, URI location, int flags, IProgressMonitor monitor) throws ProvisionException {
        if (!manager.contains(location)) {
            this.artifactReposToRemove.add(location);
        }
        return manager.loadRepository(location, flags, monitor);
    }

    private void processDestinationRepos(IArtifactRepositoryManager artifactRepositoryManager, IMetadataRepositoryManager metadataRepositoryManager) throws ProvisionException {
        RepositoryDescriptor artifactRepoDescriptor = null;
        RepositoryDescriptor metadataRepoDescriptor = null;
        Iterator<RepositoryDescriptor> iter = this.destinationRepos.iterator();
        while (iter.hasNext() && (artifactRepoDescriptor == null || metadataRepoDescriptor == null)) {
            RepositoryDescriptor repo = iter.next();
            if (repo.isArtifact() && artifactRepoDescriptor == null) {
                artifactRepoDescriptor = repo;
            }
            if (!repo.isMetadata() || metadataRepoDescriptor != null) continue;
            metadataRepoDescriptor = repo;
        }
        if (artifactRepoDescriptor != null) {
            this.destinationArtifactRepository = this.initializeDestination(artifactRepoDescriptor, artifactRepositoryManager);
        }
        if (metadataRepoDescriptor != null) {
            this.destinationMetadataRepository = this.initializeDestination(metadataRepoDescriptor, metadataRepositoryManager);
        }
        if (this.destinationMetadataRepository == null && this.destinationArtifactRepository == null) {
            throw new ProvisionException(Messages.AbstractApplication_no_valid_destinations);
        }
    }

    public IMetadataRepository getDestinationMetadataRepository() {
        return this.destinationMetadataRepository;
    }

    public IArtifactRepository getDestinationArtifactRepository() {
        return this.destinationArtifactRepository;
    }

    protected IMetadataRepository initializeDestination(RepositoryDescriptor toInit, IMetadataRepositoryManager mgr) throws ProvisionException {
        try {
            IMetadataRepository repository = this.addRepository(mgr, toInit.getRepoLocation(), 1, null);
            if (this.initDestinationRepository((IRepository<?>)repository, toInit)) {
                return repository;
            }
        }
        catch (ProvisionException provisionException) {}
        IMetadataRepository source = null;
        try {
            if (toInit.getFormat() != null) {
                source = mgr.loadRepository(toInit.getFormat(), 0, null);
            }
        }
        catch (ProvisionException provisionException) {}
        try {
            IMetadataRepository result = mgr.createRepository(toInit.getRepoLocation(), toInit.getName() != null ? toInit.getName() : (source != null ? source.getName() : toInit.getRepoLocation().toString()), "org.eclipse.equinox.p2.metadata.repository.simpleRepository", source != null ? source.getProperties() : null);
            if (toInit.isCompressed() && !result.getProperties().containsKey("p2.compressed")) {
                result.setProperty("p2.compressed", "true");
            }
            return (IMetadataRepository)RepositoryHelper.validDestinationRepository((IRepository)result);
        }
        catch (UnsupportedOperationException e) {
            throw new ProvisionException(NLS.bind((String)Messages.exception_invalidDestination, (Object)toInit.getRepoLocation()), e.getCause());
        }
    }

    protected IArtifactRepository initializeDestination(RepositoryDescriptor toInit, IArtifactRepositoryManager mgr) throws ProvisionException {
        try {
            IArtifactRepository repository = this.addRepository(mgr, toInit.getRepoLocation(), 1, null);
            if (this.initDestinationRepository((IRepository<?>)repository, toInit)) {
                return repository;
            }
        }
        catch (ProvisionException provisionException) {}
        IArtifactRepository source = null;
        try {
            if (toInit.getFormat() != null) {
                source = mgr.loadRepository(toInit.getFormat(), 0, null);
            }
        }
        catch (ProvisionException provisionException) {}
        try {
            IArtifactRepository result = mgr.createRepository(toInit.getRepoLocation(), toInit.getName() != null ? toInit.getName() : (source != null ? source.getName() : toInit.getRepoLocation().toString()), "org.eclipse.equinox.p2.artifact.repository.simpleRepository", source != null ? source.getProperties() : null);
            if (toInit.isCompressed() && !result.getProperties().containsKey("p2.compressed")) {
                result.setProperty("p2.compressed", "true");
            }
            return (IArtifactRepository)RepositoryHelper.validDestinationRepository((IRepository)result);
        }
        catch (UnsupportedOperationException e) {
            throw new ProvisionException(NLS.bind((String)Messages.exception_invalidDestination, (Object)toInit.getRepoLocation()), e.getCause());
        }
    }

    protected boolean initDestinationRepository(IRepository<?> repository, RepositoryDescriptor descriptor) {
        if (repository != null && repository.isModifiable()) {
            if (descriptor.getName() != null) {
                repository.setProperty("name", descriptor.getName());
            }
            if (repository instanceof ICompositeRepository && !descriptor.isAppend()) {
                ((ICompositeRepository)repository).removeAllChildren();
            } else if (repository instanceof IMetadataRepository && !descriptor.isAppend()) {
                ((IMetadataRepository)repository).removeAll();
            } else if (repository instanceof IArtifactRepository && !descriptor.isAppend()) {
                ((IArtifactRepository)repository).removeAll();
            }
            return true;
        }
        return false;
    }

    public IMetadataRepository getCompositeMetadataRepository() {
        if (this.compositeMetadataRepository == null) {
            this.compositeMetadataRepository = CompositeMetadataRepository.createMemoryComposite((IProvisioningAgent)this.agent);
            for (RepositoryDescriptor repo : this.sourceRepositories) {
                if (!repo.isMetadata()) continue;
                this.compositeMetadataRepository.addChild(repo.getRepoLocation());
            }
        }
        return this.compositeMetadataRepository;
    }

    public IArtifactRepository getCompositeArtifactRepository() {
        if (this.compositeArtifactRepository == null) {
            this.compositeArtifactRepository = CompositeArtifactRepository.createMemoryComposite((IProvisioningAgent)this.agent);
            for (RepositoryDescriptor repo : this.sourceRepositories) {
                if (!repo.isArtifact()) continue;
                this.compositeArtifactRepository.addChild(repo.getRepoLocation());
            }
        }
        return this.compositeArtifactRepository;
    }

    public boolean hasArtifactSources() {
        return ((ICompositeRepository)this.getCompositeArtifactRepository()).getChildren().size() > 0;
    }

    public boolean hasMetadataSources() {
        return ((ICompositeRepository)this.getCompositeMetadataRepository()).getChildren().size() > 0;
    }

    public abstract IStatus run(IProgressMonitor var1) throws ProvisionException;

    public void addDestination(RepositoryDescriptor descriptor) {
        this.destinationRepos.add(descriptor);
    }

    public void addSource(RepositoryDescriptor repo) {
        this.sourceRepositories.add(repo);
    }
}

