/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.fx;

import java.util.function.Consumer;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.fx.code.editor.Constants;
import org.eclipse.fx.code.editor.Input;
import org.eclipse.fx.code.editor.SourceSelection;
import org.eclipse.fx.code.editor.fx.services.ContextInformationPresenter;
import org.eclipse.fx.code.editor.fx.services.EditorContextMenuProvider;
import org.eclipse.fx.code.editor.services.ContextInformation;
import org.eclipse.fx.code.editor.services.DelegatingEditingContext;
import org.eclipse.fx.code.editor.services.EditingContext;
import org.eclipse.fx.code.editor.services.URIProvider;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.di.ContextValue;
import org.eclipse.fx.core.event.EventBus;
import org.eclipse.fx.core.preferences.Preference;
import org.eclipse.fx.core.text.TextEditAction;
import org.eclipse.fx.text.ui.contentassist.IContextInformation;
import org.eclipse.fx.text.ui.source.ISourceViewer;
import org.eclipse.fx.text.ui.source.SourceViewer;
import org.eclipse.fx.text.ui.source.SourceViewerConfiguration;
import org.eclipse.fx.ui.controls.styledtext.TextSelection;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class TextEditor {
    private IDocument document;
    private SourceViewerConfiguration configuration;
    private IDocumentPartitioner partitioner;
    private Input<?> input;
    private Property<Input<?>> activeInput;
    private SourceViewer viewer;
    private Integer tabAdvance;
    private Boolean spacesForTab;
    private EditingContext editingContext;
    private ContextInformationPresenter contextInformationPresenter;
    private EditorContextMenuProvider contextMenuProvider;

    @Inject
    public void setContextMenuProvider(EditorContextMenuProvider contextMenuProvider) {
        this.contextMenuProvider = contextMenuProvider;
    }

    @Inject
    public void setContextInformationPresenter(ContextInformationPresenter contextInformationPresenter) {
        this.contextInformationPresenter = contextInformationPresenter;
    }

    @Inject
    public void setEditingContext(EditingContext editingContext) {
        if (this.viewer != null) {
            throw new IllegalArgumentException("The EditingContext has to be set before the editor is initialized");
        }
        this.editingContext = editingContext;
    }

    @Inject
    public void setDocument(IDocument document) {
        if (this.viewer != null) {
            throw new IllegalArgumentException("The document has to be set before the editor is initialized");
        }
        this.document = document;
    }

    @Inject
    public void setSourceViewerConfiguration(SourceViewerConfiguration configuration) {
        if (this.viewer != null) {
            throw new IllegalArgumentException("The configuration has to be set before the editor is initialized");
        }
        this.configuration = configuration;
    }

    @Inject
    public void setPartitioner(IDocumentPartitioner partitioner) {
        if (this.viewer != null) {
            throw new IllegalArgumentException("The partitioner has to be set before the editor is initialized");
        }
        this.partitioner = partitioner;
    }

    @Inject
    public void setTabAdvance(@Preference(nodePath="org.eclipse.fx.code.editor", key="tabAdvance") Integer tabAdvance) {
        if (tabAdvance != null && tabAdvance > 0) {
            this.tabAdvance = tabAdvance;
        }
        if (this.viewer != null && tabAdvance != null) {
            this.viewer.getTextWidget().setTabAdvance(tabAdvance.intValue());
        }
    }

    @Inject
    public void setInsertSpacesForTab(@Preference(nodePath="org.eclipse.fx.code.editor", key="spacesForTab") Boolean spacesForTab) {
        this.spacesForTab = spacesForTab;
        if (this.viewer != null && spacesForTab != null) {
            this.viewer.getTextWidget().setInsertSpacesForTab(spacesForTab.booleanValue());
        }
    }

    @Inject
    public void setInput(Input<?> input) {
        if (this.viewer != null) {
            throw new IllegalArgumentException("The input has to be set before the editor is initialized");
        }
        this.input = input;
    }

    @Inject
    @Optional
    public void setActiveInputTracker(@ContextValue(value="activeInput") Property<Input<?>> activeInput) {
        this.activeInput = activeInput;
    }

    @PostConstruct
    public void initUI(BorderPane pane, EventBus eventBus) {
        this.viewer = this.createSourceViewer();
        if (this.tabAdvance != null) {
            this.viewer.getTextWidget().setTabAdvance(this.tabAdvance.intValue());
        }
        if (this.spacesForTab != null) {
            this.viewer.getTextWidget().setInsertSpacesForTab(this.spacesForTab.booleanValue());
        }
        if (this.document instanceof IDocumentExtension3) {
            ((IDocumentExtension3)this.document).setDocumentPartitioner(this.configuration.getConfiguredDocumentPartitioning((ISourceViewer)this.viewer), this.partitioner);
        } else {
            this.document.setDocumentPartitioner(this.partitioner);
        }
        this.document.setDocumentPartitioner(this.partitioner);
        this.partitioner.connect(this.document);
        this.viewer.configure(this.configuration);
        this.viewer.setDocument(this.document, this.configuration.getAnnotationModel());
        pane.setCenter((Node)this.viewer);
        if (this.activeInput != null) {
            this.activeInput.setValue(this.input);
        }
        eventBus.subscribe(Constants.TOPIC_SELECT_SOURCE, EventBus.data(this::onSourceSelect));
        if (this.editingContext instanceof DelegatingEditingContext) {
            DelegatingEditingContext c = (DelegatingEditingContext)this.editingContext;
            c.setDelegate(new EditingContext(){

                private TextSelection convert(IRegion selection) {
                    return new TextSelection(selection.getOffset(), selection.getLength());
                }

                private IRegion convert(TextSelection selection) {
                    return new Region(selection.offset, selection.length);
                }

                public void showContextInformation(ContextInformation info) {
                    if (TextEditor.this.contextInformationPresenter != null) {
                        IContextInformation ci = TextEditor.this.contextInformationPresenter.createInformation(info);
                        TextEditor.this.viewer.showContextInformation(ci);
                    }
                }

                public void triggerAction(TextEditAction action) {
                    TextEditor.this.viewer.getTextWidget().triggerAction(action);
                }

                public void setSelection(IRegion selection) {
                    TextEditor.this.viewer.getTextWidget().setSelection(this.convert(selection));
                }

                public void setCaretOffset(int offset, boolean keepSelection) {
                    TextEditor.this.viewer.getTextWidget().impl_setCaretOffset(offset, keepSelection);
                }

                public void setCaretOffset(int offset) {
                    TextEditor.this.viewer.getTextWidget().setCaretOffset(offset);
                }

                public Subscription registerOnSelectionChanged(Consumer<IRegion> listener) {
                    final ChangeListener l = (x, o, n) -> {
                        if (n != null) {
                            listener.accept(this.convert((TextSelection)n));
                        } else {
                            listener.accept(null);
                        }
                    };
                    TextEditor.this.viewer.getTextWidget().selectionProperty().addListener(l);
                    return new Subscription(){

                        public void dispose() {
                            TextEditor.this.viewer.getTextWidget().selectionProperty().removeListener(l);
                        }
                    };
                }

                public Subscription registerOnCaretOffsetChanged(Consumer<Integer> listener) {
                    final ChangeListener l = (x, o, n) -> listener.accept(n.intValue());
                    TextEditor.this.viewer.getTextWidget().caretOffsetProperty().addListener(l);
                    return new Subscription(){

                        public void dispose() {
                            TextEditor.this.viewer.getTextWidget().caretOffsetProperty().removeListener(l);
                        }
                    };
                }

                public IRegion getSelection() {
                    TextSelection selection = TextEditor.this.viewer.getTextWidget().getSelection();
                    return this.convert(selection);
                }

                public int getCaretOffset() {
                    return TextEditor.this.viewer.getTextWidget().getCaretOffset();
                }
            });
        }
        this.contextMenuProvider.attacheMenu((Control)this.viewer.getTextWidget(), EditorContextMenuProvider.Type.CONTENT);
    }

    private void onSourceSelect(SourceSelection data) {
        if (((URIProvider)this.input).getURI().equals(data.uri)) {
            this.getSourceViewer().getTextWidget().setCaretOffset(data.selection.getOffset() + data.selection.getLength());
            this.getSourceViewer().getTextWidget().setSelection(new TextSelection(data.selection.getOffset(), data.selection.getLength()));
            this.getSourceViewer().getTextWidget().revealCaret();
        }
    }

    protected SourceViewer createSourceViewer() {
        return new SourceViewer();
    }

    public SourceViewer getSourceViewer() {
        return this.viewer;
    }

    @Persist
    public void save() {
        this.input.persist();
        this.documentSaved();
    }

    protected void documentSaved() {
    }

    @Focus
    void focused() {
        if (this.activeInput != null) {
            this.activeInput.setValue(this.input);
        }
        this.viewer.getTextWidget().requestFocus();
        if (this.viewer.getTextWidget().getCaretOffset() == -1 && this.viewer.getTextWidget().getContent().getCharCount() > 0) {
            this.viewer.getTextWidget().setCaretOffset(0);
        }
    }

    @PreDestroy
    void destroy() {
        if (this.activeInput != null && this.activeInput.getValue() == this.input) {
            this.activeInput.setValue(null);
        }
        this.input = null;
    }
}

