/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.internal;

import com.google.common.collect.Range;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.ScrollBar;

public class Scroller {
    private DoubleProperty lineHeight = new SimpleDoubleProperty((Object)this, "lineHeight", 16.0);
    private DoubleProperty lineCount = new SimpleDoubleProperty((Object)this, "lineCount", 0.0);
    private IntegerProperty visibleLineCount = new SimpleIntegerProperty((Object)this, "visibleLineCount", 0);
    private DoubleProperty contentHeight = new SimpleDoubleProperty((Object)this, "contentHeight", 0.0);
    private DoubleProperty contentAreaHeight = new SimpleDoubleProperty((Object)this, "contentAreaHeight", 0.0);
    private ObjectProperty<Range<Integer>> visibleLines = new SimpleObjectProperty((Object)this, "visibleLines", (Object)Range.all());
    private DoubleProperty offset = new SimpleDoubleProperty((Object)this, "offset", 0.01);
    private DoubleProperty min = new SimpleDoubleProperty((Object)this, "min", 0.0);
    private DoubleProperty max = new SimpleDoubleProperty((Object)this, "max", 0.0);

    public DoubleProperty lineHeightProperty() {
        return this.lineHeight;
    }

    public DoubleProperty lineCountProperty() {
        return this.lineCount;
    }

    public ReadOnlyDoubleProperty contentHeightProperty() {
        return this.contentHeight;
    }

    public DoubleProperty contentAreaHeightProperty() {
        return this.contentAreaHeight;
    }

    public ReadOnlyObjectProperty<Range<Integer>> visibleLinesProperty() {
        return this.visibleLines;
    }

    public DoubleProperty offsetProperty() {
        return this.offset;
    }

    public Scroller() {
        this.install();
    }

    private void recomputeContentHeight(Observable x) {
        double contentHeight = this.lineCount.get() * this.lineHeight.get();
        this.contentHeight.set(contentHeight);
    }

    private void recomputeMax(Observable x) {
        double max = Math.max(0.0, this.contentHeight.get() - this.contentAreaHeight.get());
        this.max.set(max);
    }

    private void recomputeVisibleLineCount(Observable x) {
        int visibleLineCount = (int)Math.ceil(this.contentAreaHeight.get() / this.lineHeight.get());
        this.visibleLineCount.set(visibleLineCount);
    }

    private void recomputeVisibleLines(Observable x) {
        int lower = (int)Math.floor(this.offset.get() / this.lineHeight.get());
        int upper = lower + this.visibleLineCount.get();
        Range visibleLines = Range.closed((Comparable)Integer.valueOf(lower), (Comparable)Integer.valueOf(upper));
        this.visibleLines.set((Object)visibleLines);
    }

    private void recomputeAll() {
        this.recomputeContentHeight(null);
        this.recomputeMax(null);
        this.recomputeVisibleLineCount(null);
        this.recomputeVisibleLines(null);
    }

    private void install() {
        this.lineCount.addListener(this::recomputeContentHeight);
        this.lineHeight.addListener(this::recomputeContentHeight);
        this.contentHeight.addListener(this::recomputeMax);
        this.contentAreaHeight.addListener(this::recomputeMax);
        this.lineHeight.addListener(this::recomputeVisibleLineCount);
        this.contentAreaHeight.addListener(this::recomputeVisibleLineCount);
        this.offset.addListener(this::recomputeVisibleLines);
        this.lineHeight.addListener(this::recomputeVisibleLines);
        this.visibleLineCount.addListener(this::recomputeVisibleLines);
    }

    public void bind(ScrollBar bar) {
        bar.minProperty().bind((ObservableValue)this.min);
        bar.maxProperty().bind((ObservableValue)this.max);
        bar.visibleAmountProperty().bind((ObservableValue)this.contentAreaHeight.divide((ObservableNumberValue)this.contentHeight.divide((ObservableNumberValue)this.max)));
        bar.valueProperty().bindBidirectional((Property)this.offset);
        this.recomputeAll();
    }

    public void scrollBy(int lines) {
        this.scrollBy(this.lineHeightProperty().get() * (double)lines);
    }

    public void scrollBy(double units) {
        double newVal = this.offset.get() + units;
        newVal = Math.min(this.max.get(), newVal);
        newVal = Math.max(this.min.get(), newVal);
        this.offset.set(newVal);
    }

    public void scrollIntoView(int line) {
        double lineOffset = (double)line * this.lineHeight.get();
        if (lineOffset < this.offset.get()) {
            this.offset.set(lineOffset);
        }
        double lastLineDelta = this.contentAreaHeight.get() - this.lineHeight.get();
        if (lineOffset > this.offset.get() + lastLineDelta) {
            this.offset.set(lineOffset - lastLineDelta);
        }
    }

    public void scrollTo(int line) {
        this.offset.set((double)line * this.lineHeight.get());
    }

    public void refresh() {
        this.recomputeAll();
    }
}

