/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Method implements Enumerator
{
    ALIGN(0, "align", "align"),
    STRETCH(1, "stretch", "stretch");

    public static final int ALIGN_VALUE = 0;
    public static final int STRETCH_VALUE = 1;
    private static final Method[] VALUES_ARRAY;
    public static final List<Method> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Method[]{ALIGN, STRETCH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Method get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Method result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Method getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Method result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Method get(int value) {
        switch (value) {
            case 0: {
                return ALIGN;
            }
            case 1: {
                return STRETCH;
            }
        }
        return null;
    }

    private Method(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

