/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.di;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.util.BuilderFactory;
import javafx.util.Callback;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.fx.osgi.util.OSGiFXMLLoader;
import org.eclipse.fx.ui.di.FXMLBuilder;
import org.osgi.framework.Bundle;

public abstract class InjectingFXMLLoader<N>
implements FXMLBuilder<N> {
    ResourceBundle resourceBundle;
    BuilderFactory builderFactory;

    public static <N> InjectingFXMLLoader<N> create(final IEclipseContext context, final Class<?> requester, final String relativeFxmlPath) {
        return new InjectingFXMLLoader<N>(){

            @Override
            public N load() throws IOException {
                return OSGiFXMLLoader.load((Class)requester, (String)relativeFxmlPath, (ResourceBundle)this.resourceBundle, (BuilderFactory)this.builderFactory, (Callback)new ControllerFactory(context));
            }

            @Override
            public <C> FXMLBuilder.Data<N, C> loadWithController() throws IOException {
                final OSGiFXMLLoader.FXMLData d = OSGiFXMLLoader.loadWithController((Class)requester, (String)relativeFxmlPath, (ResourceBundle)this.resourceBundle, (BuilderFactory)this.builderFactory, (Callback)new ControllerFactory(context));
                return new FXMLBuilder.Data<N, C>(){

                    @Override
                    public C getController() {
                        return d.controller;
                    }

                    @Override
                    public N getNode() {
                        return d.node;
                    }
                };
            }
        };
    }

    public static <N> InjectingFXMLLoader<N> create(final IEclipseContext context, final Bundle bundle, final String bundleRelativeFxmlPath) {
        return new InjectingFXMLLoader<N>(){

            @Override
            public N load() throws IOException {
                return OSGiFXMLLoader.load((Bundle)bundle, (String)bundleRelativeFxmlPath, (ResourceBundle)this.resourceBundle, (BuilderFactory)this.builderFactory, (Callback)new ControllerFactory(context));
            }

            @Override
            public <C> FXMLBuilder.Data<N, C> loadWithController() throws IOException {
                final OSGiFXMLLoader.FXMLData d = OSGiFXMLLoader.loadWithController((Bundle)bundle, (String)bundleRelativeFxmlPath, (ResourceBundle)this.resourceBundle, (BuilderFactory)this.builderFactory, (Callback)new ControllerFactory(context));
                return new FXMLBuilder.Data<N, C>(){

                    @Override
                    public C getController() {
                        return d.controller;
                    }

                    @Override
                    public N getNode() {
                        return d.node;
                    }
                };
            }
        };
    }

    public static <N> InjectingFXMLLoader<N> create(final IEclipseContext context, final ClassLoader classloader, final URL url) {
        return new InjectingFXMLLoader<N>(){

            @Override
            public N load() throws IOException {
                return OSGiFXMLLoader.load((ClassLoader)classloader, (URL)url, (ResourceBundle)this.resourceBundle, (BuilderFactory)this.builderFactory, (Callback)new ControllerFactory(context));
            }

            @Override
            public <C> FXMLBuilder.Data<N, C> loadWithController() throws IOException {
                final OSGiFXMLLoader.FXMLData d = OSGiFXMLLoader.loadWithController((ClassLoader)classloader, (URL)url, (ResourceBundle)this.resourceBundle, (BuilderFactory)this.builderFactory, (Callback)new ControllerFactory(context));
                return new FXMLBuilder.Data<N, C>(){

                    @Override
                    public C getController() {
                        return d.controller;
                    }

                    @Override
                    public N getNode() {
                        return d.node;
                    }
                };
            }
        };
    }

    @Override
    public InjectingFXMLLoader<N> resourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        return this;
    }

    @Override
    public InjectingFXMLLoader<N> builderFactory(BuilderFactory builderFactory) {
        this.builderFactory = builderFactory;
        return this;
    }

    static class ControllerFactory
    implements Callback<Class<?>, Object> {
        private final IEclipseContext context;

        public ControllerFactory(IEclipseContext context) {
            this.context = context;
        }

        public Object call(Class<?> param) {
            Object o;
            if (param.isInterface() || (param.getModifiers() & 0x400) == 1024) {
                o = this.context.get(param.getName());
            } else {
                o = ContextInjectionFactory.make(param, (IEclipseContext)this.context);
                this.context.set(o.getClass().getName(), o);
            }
            return o;
        }
    }
}

