/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.fx.ui.workbench.renderers.base.BaseItemRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.EventProcessor;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WToolBar;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;

public abstract class BaseToolBarRenderer<N>
extends BaseRenderer<MToolBar, WToolBar<N>>
implements EventProcessor.ChildrenHandler<MToolBar, MToolBarElement> {
    private List<MToolBarElement> widgets = new ArrayList<MToolBarElement>();
    private Thread syncThread = new Thread("ToolItem Enablement Sync"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                MToolBarElement[] iterationCopy;
                List list = BaseToolBarRenderer.this.widgets;
                synchronized (list) {
                    iterationCopy = BaseToolBarRenderer.this.widgets.toArray(new MToolBarElement[0]);
                }
                int i = 0;
                while (i < iterationCopy.length) {
                    MToolBarElement e = iterationCopy[i];
                    if (e.getRenderer() instanceof BaseItemRenderer) {
                        MToolBarElement tmp = e;
                        BaseItemRenderer r = (BaseItemRenderer)((Object)tmp.getRenderer());
                        if (tmp.getRenderer() != null) {
                            r.checkEnablement(tmp);
                        }
                    }
                    ++i;
                }
                try {
                    Thread.sleep(400L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    };

    public BaseToolBarRenderer() {
        this.syncThread.setDaemon(true);
        this.syncThread.start();
    }

    @PostConstruct
    void init(IEventBroker eventBroker) {
        EventProcessor.attachChildProcessor(eventBroker, this);
        EventProcessor.attachVisibleProcessor(eventBroker, this);
    }

    @Override
    public void doProcessContent(MToolBar element) {
        WToolBar toolbar = (WToolBar)this.getWidget((MUIElement)element);
        for (MToolBarElement item : element.getChildren()) {
            Object itemWidget;
            if (!item.isToBeRendered() || (itemWidget = this.engineCreateWidget(item)) == null || !item.isVisible()) continue;
            toolbar.addChild((WWidget<MToolBarElement>)itemWidget);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childRendered(MToolBar parentElement, MUIElement element) {
        List<MToolBarElement> list = this.widgets;
        synchronized (list) {
            this.widgets.add((MToolBarElement)element);
        }
        if (this.inContentProcessing((MUIElement)parentElement)) {
            return;
        }
        int idx = this.getRenderedIndex((MUIElement)parentElement, element);
        WToolBar toolbar = (WToolBar)this.getWidget((MUIElement)parentElement);
        WWidget widget = (WWidget)element.getWidget();
        toolbar.addChild(idx, widget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideChild(MToolBar container, MUIElement changedObj) {
        List<MToolBarElement> list = this.widgets;
        synchronized (list) {
            this.widgets.remove(changedObj);
        }
        WToolBar toolbar = (WToolBar)this.getWidget((MUIElement)container);
        if (toolbar == null) {
            return;
        }
        WWidget widget = (WWidget)changedObj.getWidget();
        if (widget != null) {
            toolbar.removeChild(widget);
        }
    }

    @Override
    public void handleChildrenAddition(MToolBar parent, Collection<MToolBarElement> elements) {
        for (MToolBarElement element : elements) {
            if (!element.isToBeRendered() || !element.isVisible()) continue;
            if (element.getWidget() == null) {
                this.engineCreateWidget(element);
                continue;
            }
            this.childRendered(parent, (MUIElement)element);
        }
    }

    @Override
    public void handleChildrenRemove(MToolBar parent, Collection<MToolBarElement> elements) {
        for (MToolBarElement element : elements) {
            if (!element.isToBeRendered() || !element.isVisible() || element.getWidget() == null) continue;
            this.hideChild(parent, (MUIElement)element);
        }
    }
}

