/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.Collection;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.fx.ui.workbench.renderers.base.BaseItemRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.EventProcessor;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenuElement;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPopupMenu;

public abstract class BasePopupMenuRenderer<N>
extends BaseRenderer<MPopupMenu, WPopupMenu<N>>
implements EventProcessor.ChildrenHandler<MPopupMenu, MMenuElement> {
    @PostConstruct
    void init(IEventBroker eventBroker) {
        EventProcessor.attachChildProcessor(eventBroker, this);
        EventProcessor.attachVisibleProcessor(eventBroker, this);
    }

    @Override
    protected void initWidget(final MPopupMenu element, WPopupMenu<N> widget) {
        super.initWidget(element, widget);
        widget.setShowingCallback(new Runnable(){

            @Override
            public void run() {
                BasePopupMenuRenderer.this.handleShowing(element);
            }
        });
    }

    void handleShowing(MPopupMenu element) {
        for (MMenuElement e : element.getChildren()) {
            if (!(e.getRenderer() instanceof BaseItemRenderer)) continue;
            BaseItemRenderer r = (BaseItemRenderer)((Object)e.getRenderer());
            r.checkEnablement(e);
        }
    }

    @Override
    public void doProcessContent(MPopupMenu element) {
        WPopupMenu menu = (WPopupMenu)this.getWidget((MUIElement)element);
        for (MMenuElement e : element.getChildren()) {
            WMenuElement widget = (WMenuElement)this.engineCreateWidget(e);
            if (widget == null || !e.isVisible()) continue;
            menu.addElement(widget);
        }
    }

    @Override
    public void handleChildrenRemove(MPopupMenu parent, Collection<MMenuElement> elements) {
        for (MMenuElement element : elements) {
            if (!element.isToBeRendered() || !element.isVisible() || element.getWidget() == null) continue;
            this.hideChild(parent, (MUIElement)element);
        }
    }

    @Override
    public void handleChildrenAddition(MPopupMenu parent, Collection<MMenuElement> elements) {
        for (MMenuElement element : elements) {
            if (!element.isToBeRendered() || !element.isVisible()) continue;
            if (element.getWidget() == null) {
                this.engineCreateWidget(element);
                continue;
            }
            this.childRendered(parent, (MUIElement)element);
        }
    }

    public void childRendered(MPopupMenu parentElement, MUIElement element) {
        if (this.inContentProcessing((MUIElement)parentElement)) {
            return;
        }
        int idx = this.getRenderedIndex((MUIElement)parentElement, element);
        WPopupMenu menu = (WPopupMenu)this.getWidget((MUIElement)parentElement);
        WMenuElement menuElement = (WMenuElement)element.getWidget();
        menu.addElement(idx, menuElement);
    }

    public void hideChild(MPopupMenu container, MUIElement changedObj) {
        WPopupMenu menu = (WPopupMenu)this.getWidget((MUIElement)container);
        if (menu == null) {
            return;
        }
        WMenuElement widget = (WMenuElement)changedObj.getWidget();
        if (widget != null) {
            menu.removeElement(widget);
        }
    }
}

