/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.databinding;

import java.util.Iterator;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;

public class TreeUtil {
    public static <T> TreeItem<T> createModel(T root, ObservableFactory<T> factory) {
        return new TreeItemImpl<T>(root, factory);
    }

    public static interface ObservableFactory<T> {
        public IObservableList createObservable(T var1);
    }

    static class TreeItemImpl<T>
    extends TreeItem<T> {
        private IObservableList list;
        private ObservableFactory<T> factory;
        private boolean hasLoadedChildren = false;

        public TreeItemImpl(T element, ObservableFactory<T> factory) {
            this.setValue(element);
            this.factory = factory;
            this.list = factory.createObservable(element);
        }

        public ObservableList<TreeItem<T>> getChildren() {
            if (!this.hasLoadedChildren) {
                this.loadChildren();
            }
            return super.getChildren();
        }

        public boolean isLeaf() {
            if (!this.hasLoadedChildren) {
                this.loadChildren();
            }
            return super.getChildren().isEmpty();
        }

        private void loadChildren() {
            this.hasLoadedChildren = true;
            if (this.list != null) {
                final ObservableList<TreeItem<T>> itemList = this.getChildren();
                this.list.addListChangeListener(new IListChangeListener(){

                    public void handleListChange(ListChangeEvent event) {
                        event.diff.accept(new ListDiffVisitor(){

                            public void handleRemove(int index, Object element) {
                                if (itemList.size() < index) {
                                    TreeItem t = (TreeItem)itemList.get(index);
                                    if (t.getValue() == element) {
                                        itemList.remove(index);
                                    } else {
                                        Iterator it = itemList.iterator();
                                        while (it.hasNext()) {
                                            if (((TreeItem)it.next()).getValue() != element) continue;
                                            it.remove();
                                            break;
                                        }
                                    }
                                }
                            }

                            public void handleAdd(int index, Object element) {
                                if (itemList.size() > index) {
                                    itemList.add(index, new TreeItemImpl<Object>(element, TreeItemImpl.this.factory));
                                } else {
                                    itemList.add(new TreeItemImpl<Object>(element, TreeItemImpl.this.factory));
                                }
                            }
                        });
                    }
                });
                for (Object o : this.list) {
                    itemList.add(new TreeItemImpl(o, this.factory));
                }
            }
        }
    }
}

