/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.tree;

import java.util.HashSet;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.TreeItem;

public class CheckedTreeItemCollector<T> {
    private ObservableSet<T> checkedItems = FXCollections.observableSet(new HashSet());
    private CheckBoxTreeItem<T> root;

    public CheckedTreeItemCollector(CheckBoxTreeItem<T> root) {
        this.root = root;
        root.addEventHandler(CheckBoxTreeItem.TreeModificationEvent.ANY, event -> {
            CheckBoxTreeItem.TreeModificationEvent mod = (CheckBoxTreeItem.TreeModificationEvent)event;
            Object value = mod.getTreeItem().getValue();
            boolean checked = mod.getTreeItem().isSelected();
            ObservableSet<T> observableSet = this.checkedItems;
            synchronized (observableSet) {
                if (checked && !this.checkedItems.contains(value)) {
                    this.checkedItems.add(value);
                } else if (!checked && this.checkedItems.contains(value)) {
                    this.checkedItems.remove(value);
                }
            }
        });
        this.checkedItems.addListener(change -> {
            if (change.getElementAdded() != null) {
                this.setCheckedStateForValue((TreeItem<T>)root, (T)change.getElementAdded(), true);
            }
            if (change.getElementRemoved() != null) {
                this.setCheckedStateForValue((TreeItem<T>)root, (T)change.getElementRemoved(), false);
            }
        });
    }

    private boolean setCheckedStateForValue(TreeItem<T> treeItem, T value, boolean state) {
        if (value.equals(treeItem.getValue())) {
            if (treeItem instanceof CheckBoxTreeItem) {
                this.setCheckedState((CheckBoxTreeItem)treeItem, state);
            }
            return true;
        }
        for (TreeItem child : treeItem.getChildren()) {
            if (!this.setCheckedStateForValue(child, value, state)) continue;
            return true;
        }
        return false;
    }

    private void setCheckedStateRekursiv(TreeItem<T> treeItem, boolean state) {
        if (treeItem instanceof CheckBoxTreeItem) {
            this.setCheckedState((CheckBoxTreeItem)treeItem, state);
        }
        treeItem.getChildren().forEach(child -> this.setCheckedStateRekursiv((TreeItem<T>)child, state));
    }

    private void setCheckedState(CheckBoxTreeItem<T> root, boolean state) {
        if (Platform.isFxApplicationThread()) {
            root.setSelected(state);
        } else {
            Platform.runLater(() -> root.setSelected(state));
        }
    }

    public void checkAll() {
        this.setCheckedStateRekursiv((TreeItem<T>)this.root, true);
    }

    public void uncheckAll() {
        this.setCheckedStateRekursiv((TreeItem<T>)this.root, false);
    }

    public ObservableSet<T> getCheckedItems() {
        return this.checkedItems;
    }
}

