/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.nls;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.FragmentFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationOperation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class NLSFragmentGenerator {
    public static final String PLUGIN_NAME_MACRO = "${plugin_name}";
    public static final String LOCALE_NAME_MACRO = "${locale}";
    private static final String HTML_EXTENSION = ".html";
    private static final String XML_EXTENSION = ".xml";
    private static final String CLASS_EXTENSION = ".class";
    private static final String JAVA_EXTENSION = ".java";
    private static final String PROPERTIES_EXTENSION = ".properties";
    private static final String BIN = "/bin/";
    private static final String EMPTY_STRING = "";
    private static final String BACKSLASH = "\\";
    private static final String SLASH = "/";
    private static final String RESOURCE_FOLDER_PARENT = "/nl";
    private static final double LATEST_ECLIPSE_VERSION = 3.4;
    private static final String ZERO = "0";
    private static final String PERIOD = ".";
    private static final String MIN_MINOR = "0";
    private static final String MAX_MINOR = "9";
    private static final String LEFT_SQUARE_BRACKET = "[";
    private static final String RIGHT_PARENTHESIS = ")";
    private static final String DEFAULT_VERSION = "1.0.0";
    private static final String VERSION_FORMAT_WITH_QUALIFIER = "\\d+\\.\\d+\\.\\d+\\..+";
    private static final String LOCALE_INFIX_SEPERATOR = "_";
    private final IWizardContainer container;
    private final String template;
    private final List<?> plugins;
    private final List<?> locales;
    private final boolean overwriteWithoutAsking;
    private IProgressMonitor monitor;
    private final Filters resourceFilter = new Filters(false){
        {
            this.add(new AbstractFilter(false){

                @Override
                public boolean matches(Object object) {
                    String resource = object.toString();
                    return resource.endsWith(NLSFragmentGenerator.PROPERTIES_EXTENSION) || resource.endsWith(NLSFragmentGenerator.CLASS_EXTENSION) || resource.endsWith(NLSFragmentGenerator.JAVA_EXTENSION);
                }
            });
            this.add(new AbstractFilter(false){

                @Override
                public boolean matches(Object object) {
                    String path = object.toString();
                    return path.indexOf(NLSFragmentGenerator.BIN) != -1 || path.endsWith(NLSFragmentGenerator.SLASH) || path.endsWith("plugin.xml");
                }
            });
            this.add(new AbstractFilter(true){

                @Override
                public boolean matches(Object object) {
                    String path = object.toString();
                    return path.endsWith(NLSFragmentGenerator.XML_EXTENSION) || path.endsWith(NLSFragmentGenerator.HTML_EXTENSION);
                }
            });
        }
    };
    private final Filters propertiesFilter = new Filters(false){
        {
            this.add(new AbstractFilter(false){

                @Override
                public boolean matches(Object object) {
                    String path = object.toString();
                    return path.indexOf(NLSFragmentGenerator.BIN) != -1 || path.endsWith("build.properties");
                }
            });
            this.add(new AbstractFilter(true){

                @Override
                public boolean matches(Object object) {
                    return object.toString().endsWith(NLSFragmentGenerator.PROPERTIES_EXTENSION);
                }
            });
        }
    };
    private Object OVERWRITE = new Object();

    public NLSFragmentGenerator(String template, List<?> plugins, List<?> locales, IWizardContainer container, boolean overwriteWithoutAsking) {
        this.plugins = plugins;
        this.locales = locales;
        this.container = container;
        this.template = template;
        this.overwriteWithoutAsking = overwriteWithoutAsking;
    }

    private synchronized void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    private synchronized IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public boolean generate() {
        try {
            final Map<String, Object> overwrites = this.promptForOverwrite(this.plugins, this.locales);
            this.container.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    NLSFragmentGenerator.this.setProgressMonitor(monitor);
                    try {
                        NLSFragmentGenerator.this.internationalizePlugins(NLSFragmentGenerator.this.plugins, NLSFragmentGenerator.this.locales, overwrites);
                    }
                    catch (Exception ex) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                PDEPlugin.logException(ex, ex.getMessage(), PDEUIMessages.InternationalizeWizard_NLSFragmentGenerator_errorMessage);
                            }
                        });
                    }
                }
            });
        }
        catch (Exception e) {
            PDEPlugin.logException(e);
        }
        return true;
    }

    private void internationalizePlugins(List<?> plugins, List<?> locales, Map<String, Object> overwrites) throws CoreException, IOException, InvocationTargetException, InterruptedException {
        HashSet<IProject> created = new HashSet<IProject>();
        for (IPluginModelBase plugin : plugins) {
            for (Locale locale : locales) {
                IProject project = this.getNLProject(plugin, locale);
                if (!created.contains(project) && !this.overwriteWithoutAsking && project.exists() && this.OVERWRITE != overwrites.get(project.getName())) continue;
                if (!created.contains(project) && project.exists()) {
                    project.delete(true, this.getProgressMonitor());
                }
                if (!created.contains(project)) {
                    this.createNLFragment(plugin, project, locale);
                    created.add(project);
                    project.getFolder(RESOURCE_FOLDER_PARENT).create(false, true, this.getProgressMonitor());
                }
                project.getFolder(RESOURCE_FOLDER_PARENT).getFolder(locale.toString()).create(true, true, this.getProgressMonitor());
                this.createLocaleSpecificPropertiesFile(project, plugin, locale);
            }
        }
    }

    private Map<String, Object> promptForOverwrite(List<?> plugins, List<?> locales) {
        HashMap<String, Object> overwrites = new HashMap<String, Object>();
        if (this.overwriteWithoutAsking) {
            return overwrites;
        }
        for (IPluginModelBase plugin : plugins) {
            for (Locale locale : locales) {
                IProject project = this.getNLProject(plugin, locale);
                if (!project.exists() || overwrites.containsKey(project.getName())) continue;
                boolean overwrite = MessageDialog.openConfirm((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.InternationalizeWizard_NLSFragmentGenerator_overwriteTitle, (String)NLS.bind((String)PDEUIMessages.InternationalizeWizard_NLSFragmentGenerator_overwriteMessage, (Object)this.pluginName(plugin, locale)));
                overwrites.put(project.getName(), overwrite ? this.OVERWRITE : null);
            }
        }
        return overwrites;
    }

    private IProject getNLProject(IPluginModelBase name, Locale locale) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.pluginName(name, locale));
    }

    private void createNLFragment(IPluginModelBase plugin, final IProject project, Locale locale) throws CoreException, InvocationTargetException, InterruptedException {
        FragmentFieldData fragmentData = this.populateFieldData(plugin, locale);
        IProjectProvider projectProvider = new IProjectProvider(){

            @Override
            public String getProjectName() {
                return project.getName();
            }

            @Override
            public IProject getProject() {
                return project;
            }

            @Override
            public IPath getLocationPath() {
                return project.getLocation();
            }
        };
        new NewProjectCreationOperation(fragmentData, projectProvider, null).run(this.getProgressMonitor());
    }

    private String pluginName(IPluginModelBase plugin, Locale locale) {
        return this.template.replaceAll(this.quote(PLUGIN_NAME_MACRO), plugin.getPluginBase().getId()).replaceAll(this.quote(LOCALE_NAME_MACRO), locale.toString());
    }

    private FragmentFieldData populateFieldData(IPluginModelBase plugin, Locale locale) {
        FragmentFieldData fragmentData = new FragmentFieldData();
        fragmentData.setId(this.pluginName(plugin, locale));
        fragmentData.setVersion(DEFAULT_VERSION);
        fragmentData.setMatch(0);
        fragmentData.setPluginId(plugin.getPluginBase().getId());
        fragmentData.setPluginVersion(this.incrementRelease(plugin.getPluginBase().getVersion()));
        fragmentData.setName(String.valueOf(this.pluginName(plugin, locale)) + " Fragment");
        fragmentData.setProvider(EMPTY_STRING);
        fragmentData.setSimple(true);
        if (!(plugin instanceof ExternalPluginModelBase)) {
            fragmentData.setSourceFolderName("src");
            fragmentData.setOutputFolderName("bin");
        }
        fragmentData.setLegacy(false);
        fragmentData.setTargetVersion(Double.toString(this.ensureTargetVersionCompatibility(TargetPlatformHelper.getTargetVersion())));
        fragmentData.setHasBundleStructure(true);
        fragmentData.setOSGiFramework(null);
        fragmentData.setWorkingSets(null);
        return fragmentData;
    }

    private String incrementRelease(String oldVersion) {
        if (oldVersion.matches(VERSION_FORMAT_WITH_QUALIFIER)) {
            oldVersion = oldVersion.substring(0, oldVersion.lastIndexOf(PERIOD));
        }
        String newVersion = LEFT_SQUARE_BRACKET + oldVersion + ',';
        String oldMinor = oldVersion.substring(oldVersion.indexOf(PERIOD) + 1, oldVersion.lastIndexOf(PERIOD));
        if (oldMinor.compareTo(MAX_MINOR) == 0) {
            String major = Integer.toString(Integer.parseInt(oldVersion.substring(0, oldVersion.indexOf(PERIOD))) + 1);
            newVersion = String.valueOf(newVersion) + major + PERIOD + "0" + PERIOD + "0" + RIGHT_PARENTHESIS;
        } else {
            String major = oldVersion.substring(0, oldVersion.indexOf(PERIOD));
            String newMinor = Integer.toString(Integer.parseInt(oldMinor) + 1);
            newVersion = String.valueOf(newVersion) + major + PERIOD + newMinor + PERIOD + "0" + RIGHT_PARENTHESIS;
        }
        return newVersion;
    }

    private void createLocaleSpecificPropertiesFile(final IProject fragmentProject, IPluginModelBase plugin, final Locale locale) throws CoreException, IOException {
        final IFolder localeResourceFolder = fragmentProject.getFolder(RESOURCE_FOLDER_PARENT).getFolder(locale.toString());
        if (plugin instanceof ExternalPluginModelBase) {
            final String installLocation = plugin.getInstallLocation();
            if (new File(installLocation).isFile()) {
                try (ZipFile zf = new ZipFile(installLocation);){
                    Enumeration<? extends ZipEntry> e = zf.entries();
                    while (e.hasMoreElements()) {
                        this.worked();
                        ZipEntry zfe = e.nextElement();
                        String name = zfe.getName();
                        String[] segments = name.split(SLASH);
                        IPath path = Path.fromPortableString((String)this.join(SLASH, segments, 0, segments.length - 1));
                        String resourceName = segments[segments.length - 1];
                        String localizedResourceName = this.localeSpecificName(resourceName, locale);
                        if (this.propertiesFilter.include(name)) {
                            this.createParents(fragmentProject, path);
                            IFile file = fragmentProject.getFile(path.append(localizedResourceName));
                            InputStream is = zf.getInputStream(zfe);
                            file.create(is, false, this.getProgressMonitor());
                            continue;
                        }
                        if (!this.resourceFilter.include(name)) continue;
                        IPath target = localeResourceFolder.getFullPath().append(path).append(resourceName);
                        this.createParents(fragmentProject, target.removeLastSegments(1).removeFirstSegments(1));
                        IFile file = fragmentProject.getFile(target.removeFirstSegments(1));
                        file.create(zf.getInputStream(zfe), false, this.getProgressMonitor());
                    }
                }
            } else {
                Visitor visitor = new Visitor(){

                    @Override
                    public void visit(File file) throws CoreException, FileNotFoundException {
                        NLSFragmentGenerator.this.worked();
                        String relativePath = file.getAbsolutePath().substring(installLocation.length()).replaceAll(File.separator, NLSFragmentGenerator.SLASH);
                        String[] segments = relativePath.split(NLSFragmentGenerator.SLASH);
                        IPath path = Path.fromPortableString((String)NLSFragmentGenerator.this.join(NLSFragmentGenerator.SLASH, segments, 0, segments.length - 1));
                        String resourceName = segments[segments.length - 1];
                        String localizedResourceName = NLSFragmentGenerator.this.localeSpecificName(resourceName, locale);
                        if (NLSFragmentGenerator.this.propertiesFilter.include(String.valueOf(relativePath) + (file.isDirectory() ? NLSFragmentGenerator.SLASH : NLSFragmentGenerator.EMPTY_STRING))) {
                            NLSFragmentGenerator.this.createParents(fragmentProject, path);
                            IFile iFile = fragmentProject.getFile(path.append(localizedResourceName));
                            iFile.create((InputStream)new FileInputStream(file), false, NLSFragmentGenerator.this.getProgressMonitor());
                        } else if (NLSFragmentGenerator.this.resourceFilter.include(String.valueOf(relativePath) + (file.isDirectory() ? NLSFragmentGenerator.SLASH : NLSFragmentGenerator.EMPTY_STRING))) {
                            IPath target = localeResourceFolder.getFullPath().append(relativePath);
                            NLSFragmentGenerator.this.createParents(fragmentProject, target.removeLastSegments(1).removeFirstSegments(1));
                            IFile iFile = fragmentProject.getFile(target.removeFirstSegments(1));
                            iFile.create((InputStream)new FileInputStream(file), false, NLSFragmentGenerator.this.getProgressMonitor());
                        }
                        if (file.isDirectory()) {
                            File[] children = file.listFiles();
                            int i = 0;
                            while (i < children.length) {
                                this.visit(children[i]);
                                ++i;
                            }
                        }
                    }
                };
                visitor.visit(new File(installLocation));
            }
        } else {
            IProject project = plugin.getUnderlyingResource().getProject();
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    NLSFragmentGenerator.this.worked();
                    IPath parent = resource.getFullPath().removeLastSegments(1).removeFirstSegments(1);
                    if (NLSFragmentGenerator.this.propertiesFilter.include(resource)) {
                        String segment = NLSFragmentGenerator.this.localeSpecificName(resource.getFullPath().lastSegment(), locale);
                        IPath fragmentResource = fragmentProject.getFullPath().append(parent).append(segment);
                        NLSFragmentGenerator.this.createParents(fragmentProject, parent);
                        resource.copy(fragmentResource, true, NLSFragmentGenerator.this.getProgressMonitor());
                    } else if (NLSFragmentGenerator.this.resourceFilter.include(resource)) {
                        IPath target = localeResourceFolder.getFullPath().append(parent).append(resource.getFullPath().lastSegment());
                        NLSFragmentGenerator.this.createParents(fragmentProject, target.removeLastSegments(1).removeFirstSegments(1));
                        resource.copy(target, true, NLSFragmentGenerator.this.getProgressMonitor());
                    }
                    return true;
                }
            });
        }
    }

    private void worked() {
        Shell shell = this.container.getShell();
        Display display = shell.getDisplay();
        if (display != null && !shell.isDisposed()) {
            display.readAndDispatch();
        }
    }

    private void createParents(IProject fragmentProject, IPath parent) throws CoreException {
        String[] segments = parent.segments();
        String path = EMPTY_STRING;
        int i = 0;
        while (i < segments.length) {
            IFolder folder = fragmentProject.getFolder(path = String.valueOf(path) + SLASH + segments[i]);
            if (!folder.exists()) {
                folder.create(true, true, this.getProgressMonitor());
            }
            ++i;
        }
    }

    private String join(String delimiter, String[] parts) {
        return this.join(delimiter, parts, 0, parts.length);
    }

    private String join(String delimiter, String[] parts, int offset, int n) {
        StringBuffer builder = new StringBuffer();
        int i = offset;
        while (i < n) {
            builder.append(parts[i]);
            if (i < parts.length - 1) {
                builder.append(delimiter);
            }
            ++i;
        }
        return builder.toString();
    }

    private String localeSpecificName(String name, Locale locale) {
        String[] parts = name.split("\\.");
        parts[0] = String.valueOf(parts[0]) + LOCALE_INFIX_SEPERATOR + locale;
        return this.join(PERIOD, parts);
    }

    private String quote(String pattern) {
        return "\\Q" + pattern + "\\E";
    }

    private double ensureTargetVersionCompatibility(double targetVersion) {
        if (targetVersion < 3.0) {
            return 3.4;
        }
        return targetVersion;
    }

    private static abstract class AbstractFilter
    implements Filter {
        private final boolean inclusive;

        public AbstractFilter(boolean inclusive) {
            this.inclusive = inclusive;
        }

        @Override
        public boolean inclusive() {
            return this.inclusive;
        }
    }

    private static interface Filter {
        public boolean inclusive();

        public boolean matches(Object var1);
    }

    private static class Filters {
        private final List<Filter> filters = new LinkedList<Filter>();
        private final boolean default_;

        public Filters(boolean default_) {
            this.default_ = default_;
        }

        public void add(Filter filter) {
            this.filters.add(filter);
        }

        public boolean include(Object object) {
            if (object instanceof IResource) {
                IResource resource = (IResource)object;
                IPath path = 1 == resource.getType() ? resource.getFullPath() : resource.getFullPath().addTrailingSeparator();
                object = path.toPortableString();
            }
            for (Filter filter : this.filters) {
                if (!filter.matches(object)) continue;
                return filter.inclusive();
            }
            return this.default_;
        }
    }

    private static interface Visitor {
        public void visit(File var1) throws CoreException, FileNotFoundException;
    }
}

