/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;

public class MarkerType {
    private MarkerTypesModel model;
    private String id;
    private String label;
    private String[] supertypeIds;

    public MarkerType(MarkerTypesModel model, String id, String label, String[] supertypeIds) {
        this.model = model;
        this.id = id;
        this.label = label;
        this.supertypeIds = supertypeIds;
    }

    public MarkerType[] getAllSupertypes() {
        ArrayList<MarkerType> result = new ArrayList<MarkerType>();
        this.getAllSupertypes(result);
        return result.toArray(new MarkerType[result.size()]);
    }

    private void getAllSupertypes(ArrayList<MarkerType> result) {
        MarkerType[] supers = this.getSupertypes();
        int i = 0;
        while (i < supers.length) {
            MarkerType sup = supers[i];
            if (!result.contains(sup)) {
                result.add(sup);
                sup.getAllSupertypes(result);
            }
            ++i;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public MarkerType[] getSubtypes() {
        MarkerType[] types = this.model.getTypes();
        ArrayList<MarkerType> result = new ArrayList<MarkerType>();
        int i = 0;
        while (i < types.length) {
            MarkerType type = types[i];
            String[] supers = type.getSupertypeIds();
            int j = 0;
            while (j < supers.length) {
                if (supers[j].equals(this.id)) {
                    result.add(type);
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new MarkerType[result.size()]);
    }

    public MarkerType[] getAllSubTypes() {
        ArrayList<MarkerType> subTypes = new ArrayList<MarkerType>();
        this.addSubTypes(subTypes, this);
        MarkerType[] subs = new MarkerType[subTypes.size()];
        subTypes.toArray(subs);
        return subs;
    }

    private void addSubTypes(List<MarkerType> list, MarkerType superType) {
        MarkerType[] subTypes = superType.getSubtypes();
        int i = 0;
        while (i < subTypes.length) {
            MarkerType subType = subTypes[i];
            if (!list.contains(subType)) {
                list.add(subType);
            }
            this.addSubTypes(list, subType);
            ++i;
        }
    }

    public String[] getSupertypeIds() {
        return this.supertypeIds;
    }

    public MarkerType[] getSupertypes() {
        ArrayList<MarkerType> result = new ArrayList<MarkerType>();
        int i = 0;
        while (i < this.supertypeIds.length) {
            MarkerType sup = this.model.getType(this.supertypeIds[i]);
            if (sup != null) {
                result.add(sup);
            }
            ++i;
        }
        return result.toArray(new MarkerType[result.size()]);
    }

    public boolean isSubtypeOf(MarkerType superType) {
        if (this.id.equals(superType.getId())) {
            return true;
        }
        int i = 0;
        while (i < this.supertypeIds.length) {
            MarkerType sup = this.model.getType(this.supertypeIds[i]);
            if (sup != null && sup.isSubtypeOf(superType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (!(other instanceof MarkerType)) {
            return false;
        }
        return ((MarkerType)other).getId().equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

