/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.debug;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.formatting2.debug.TextRegionListToString;
import org.eclipse.xtext.formatting2.regionaccess.IAstRegion;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPart;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISequentialRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.IWhitespace;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.util.EmfFormatter;

public class TextRegionAccessToString {
    private static final int TITLE_WIDTH = 2;
    private static final String EMPTY_TITLE = Strings.repeat((String)" ", (int)2);
    private static final String EOBJECT_BEGIN_PADDED = Strings.padEnd((String)"B", (int)2, (char)' ');
    private static final String EOBJECT_END_PADDED = Strings.padEnd((String)"E", (int)2, (char)' ');
    private static final String HIDDEN = "H";
    private static final String HIDDEN_PADDED = Strings.padEnd((String)"H", (int)2, (char)' ');
    private static final String SEMANTIC_PADDED = Strings.padEnd((String)"S", (int)2, (char)' ');
    private Function<AbstractElement, String> grammarToString = new GrammarElementTitleSwitch().showRule().showAssignments().showQualified();
    private boolean hideColumnExplanation = false;
    private boolean hideIndentation = false;
    private boolean hightlightOrigin = false;
    private ITextSegment origin;
    private int textWidth = 20;

    public int getTextWidth() {
        return this.textWidth;
    }

    public TextRegionAccessToString hideColumnExplanation() {
        this.hideColumnExplanation = true;
        return this;
    }

    public TextRegionAccessToString hideIndentation() {
        this.hideIndentation = true;
        return this;
    }

    public TextRegionAccessToString hightlightOrigin() {
        this.hightlightOrigin = true;
        return this;
    }

    public boolean isHideColumnExplanation() {
        return this.hideColumnExplanation;
    }

    public boolean isHideIndentation() {
        return this.hideIndentation;
    }

    public boolean isHightlightOrigin() {
        return this.hightlightOrigin;
    }

    protected String quote(String string) {
        if (string == null) {
            return "null";
        }
        string = string.replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
        int textLen = this.textWidth - 2;
        if (string.length() > textLen) {
            return "\"" + string.substring(0, textLen - 3) + "...\"";
        }
        return Strings.padEnd((String)("\"" + string + "\""), (int)this.textWidth, (char)' ');
    }

    protected String toClassWithName(EObject obj) {
        Object name;
        String className = obj.eClass().getName();
        EStructuralFeature nameFeature = obj.eClass().getEStructuralFeature("name");
        if (nameFeature != null && (name = obj.eGet(nameFeature)) != null) {
            return String.valueOf(className) + "'" + name + "'";
        }
        return className;
    }

    public String toString() {
        List<ITextSegment> list = this.toTokenAndGapList();
        if (list.isEmpty()) {
            return "(empty)";
        }
        LinkedListMultimap hiddens = LinkedListMultimap.create();
        ArrayList errors = Lists.newArrayList();
        ITextRegionAccess access = list.get(0).getTextRegionAccess();
        TreeIterator<EObject> all = EcoreUtil2.eAll(access.regionForRootEObject().getSemanticElement());
        while (all.hasNext()) {
            EObject element = (EObject)all.next();
            IEObjectRegion obj = access.regionForEObject(element);
            if (obj == null) continue;
            IHiddenRegion previous = obj.getPreviousHiddenRegion();
            IHiddenRegion next = obj.getNextHiddenRegion();
            if (previous == null) {
                errors.add("ERROR: " + EmfFormatter.objPath((EObject)element) + " has no leading HiddenRegion.");
            } else {
                hiddens.put((Object)previous, (Object)obj);
            }
            if (previous == next) continue;
            if (next == null) {
                errors.add("ERROR: " + EmfFormatter.objPath((EObject)element) + " has no trailing HiddenRegion.");
                continue;
            }
            hiddens.put((Object)next, (Object)obj);
        }
        TextRegionListToString result = new TextRegionListToString();
        if (!this.hideColumnExplanation) {
            result.add("Columns: 1:offset 2:length 3:kind 4: text 5:grammarElement", false);
            result.add("Kind: H=IHiddenRegion S=ISemanticRegion B/E=IEObjectRegion", false);
            result.add("", false);
        }
        for (String error : errors) {
            result.add(error, false);
        }
        int indentation = 0;
        for (ITextSegment region : list) {
            Object obj2;
            ArrayList previous = Lists.newArrayList();
            ArrayList next = Lists.newArrayList();
            ArrayList middle = Lists.newArrayList((Object[])new String[]{this.toString(region)});
            if (region instanceof IHiddenRegion) {
                Collection found = hiddens.get((Object)((IHiddenRegion)region));
                for (Object obj2 : found) {
                    boolean p = obj2.getNextHiddenRegion().equals(region);
                    boolean n = obj2.getPreviousHiddenRegion().equals(region);
                    if (p && n) {
                        middle.add(String.valueOf(EMPTY_TITLE) + "Semantic " + this.toString((IEObjectRegion)obj2));
                        continue;
                    }
                    if (p) {
                        previous.add(obj2);
                        continue;
                    }
                    if (!n) continue;
                    next.add(obj2);
                }
                Collections.sort(previous, AstRegionComparator.CHILDREN_FIRST);
                Collections.sort(next, AstRegionComparator.CONTAINER_FIRST);
            }
            obj2 = previous.iterator();
            while (obj2.hasNext()) {
                IEObjectRegion obj3 = (IEObjectRegion)obj2.next();
                result.add(String.valueOf(this.indent(--indentation)) + EOBJECT_END_PADDED + this.toString(obj3));
            }
            String indent = this.indent(indentation);
            result.add(region, String.valueOf(indent) + Joiner.on((String)"\n").join((Iterable)middle).replace("\n", "\n" + indent));
            for (Object obj2 : next) {
                result.add(String.valueOf(this.indent(indentation)) + EOBJECT_BEGIN_PADDED + this.toString((IEObjectRegion)obj2));
                ++indentation;
            }
        }
        return result.toString();
    }

    protected String indent(int indentation) {
        if (this.hideIndentation) {
            return "";
        }
        return Strings.repeat((String)" ", (int)indentation);
    }

    protected String toString(AbstractRule rule) {
        return rule == null ? "null" : rule.getName();
    }

    protected String toString(EObject ele) {
        if (ele instanceof AbstractElement) {
            return (String)this.grammarToString.apply((Object)((AbstractElement)ele));
        }
        if (ele instanceof AbstractRule) {
            return String.valueOf(ele.eClass().getName()) + "'" + ((AbstractRule)ele).getName() + "'";
        }
        return ele.toString();
    }

    protected String toString(IComment comment) {
        String text = this.quote(comment.getText());
        String gammar = this.toString(comment.getGrammarElement());
        return String.format("%s Comment:%s", text, gammar);
    }

    protected String toString(IEObjectRegion region) {
        EObject obj = region.getSemanticElement();
        StringBuilder builder = new StringBuilder(String.valueOf(Strings.padEnd((String)this.toClassWithName(obj), (int)this.textWidth, (char)' ')) + " ");
        EObject element = region.getGrammarElement();
        if (element instanceof AbstractElement) {
            builder.append((String)this.grammarToString.apply((Object)((AbstractElement)element)));
        } else if (element instanceof AbstractRule) {
            builder.append(((AbstractRule)element).getName());
        } else {
            builder.append(": ERROR: No grammar element.");
        }
        ArrayList segments = Lists.newArrayList();
        EObject current = obj;
        while (current.eContainer() != null) {
            EObject container = current.eContainer();
            EStructuralFeature containingFeature = current.eContainingFeature();
            StringBuilder segment = new StringBuilder();
            segment.append(this.toClassWithName(container));
            segment.append("/");
            segment.append(containingFeature.getName());
            if (containingFeature.isMany()) {
                int index = ((List)container.eGet(containingFeature)).indexOf(current);
                segment.append("[" + index + "]");
            }
            current = container;
            segments.add(segment.toString());
        }
        if (!segments.isEmpty()) {
            builder.append(" path:");
            builder.append(Joiner.on((String)"=").join((Iterable)segments));
        }
        return builder.toString();
    }

    protected String toString(IHiddenRegion hiddens) {
        List<IHiddenRegionPart> parts = hiddens.getParts();
        if (parts.isEmpty()) {
            return HIDDEN;
        }
        ArrayList children = Lists.newArrayListWithExpectedSize((int)parts.size());
        children.add(String.valueOf(HIDDEN_PADDED) + this.toString(parts.get(0)));
        int i = 1;
        while (i < parts.size()) {
            children.add(String.valueOf(EMPTY_TITLE) + this.toString(parts.get(i)));
            ++i;
        }
        return Joiner.on((String)"\n").join((Iterable)children);
    }

    protected String toString(ISemanticRegion token) {
        String text = this.quote(token.getText());
        return String.format("%s%s %s", SEMANTIC_PADDED, text, this.toString(token.getGrammarElement()));
    }

    protected String toString(ITextSegment region) {
        String result = region instanceof IEObjectRegion ? this.toString((IEObjectRegion)region) : (region instanceof ISemanticRegion ? this.toString((ISemanticRegion)region) : (region instanceof IHiddenRegion ? this.toString((IHiddenRegion)region) : (region instanceof IWhitespace ? this.toString((IWhitespace)region) : (region instanceof IComment ? this.toString((IComment)region) : (region != null ? String.valueOf(region.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(region)) : "null")))));
        if (this.hightlightOrigin && region == this.origin) {
            return ">>>" + result + "<<<";
        }
        return result;
    }

    protected String toString(IWhitespace whitespace) {
        String text = this.quote(whitespace.getText());
        String grammar = this.toString(whitespace.getGrammarElement());
        return String.format("%s Whitespace:%s", text, grammar);
    }

    protected List<ITextSegment> toTokenAndGapList() {
        int range = this.hightlightOrigin ? 4 : 0x3FFFFFFF;
        ITextSegment first = null;
        ITextSegment current = this.origin;
        int i = 0;
        while (i < range && current != null) {
            first = current;
            if (current instanceof ITextRegionAccess) {
                current = ((ITextRegionAccess)((Object)current)).regionForRootEObject().getPreviousHiddenRegion();
            } else if (current instanceof ISequentialRegion) {
                current = ((ISequentialRegion)current).getPreviousHiddenRegion();
            } else if (current instanceof IHiddenRegionPart) {
                current = ((IHiddenRegionPart)current).getHiddenRegion();
            } else {
                throw new IllegalStateException("Unexpected Type: " + current.getClass());
            }
            ++i;
        }
        if (first == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        ITextSegment current2 = first;
        int i2 = 0;
        while (i2 <= range * 2 && current2 != null) {
            result.add(current2);
            if (current2 instanceof ISemanticRegion) {
                current2 = ((ISemanticRegion)current2).getNextHiddenRegion();
            } else if (current2 instanceof IHiddenRegion) {
                current2 = ((IHiddenRegion)current2).getNextSemanticRegion();
            } else {
                throw new IllegalStateException("Unexpected Type: " + current2.getClass());
            }
            ++i2;
        }
        return result;
    }

    public TextRegionAccessToString withOrigin(ITextSegment origin) {
        this.origin = origin;
        return this;
    }

    public TextRegionAccessToString withRegionAccess(ITextRegionAccess access) {
        this.origin = access.regionForRootEObject();
        this.hightlightOrigin = false;
        return this;
    }

    public TextRegionAccessToString withTextWidth(int width) {
        this.textWidth = width;
        return this;
    }

    protected static enum AstRegionComparator implements Comparator<IAstRegion>
    {
        CHILDREN_FIRST{

            @Override
            public int compare(IAstRegion o1, IAstRegion o2) {
                EObject e2;
                EObject e1 = o1.getSemanticElement();
                if (e1 == (e2 = o2.getSemanticElement())) {
                    return 0;
                }
                if (EcoreUtil.isAncestor((EObject)e1, (EObject)e2)) {
                    return 1;
                }
                return -1;
            }
        }
        ,
        CONTAINER_FIRST{

            @Override
            public int compare(IAstRegion o1, IAstRegion o2) {
                EObject e2;
                EObject e1 = o1.getSemanticElement();
                if (e1 == (e2 = o2.getSemanticElement())) {
                    return 0;
                }
                if (EcoreUtil.isAncestor((EObject)e1, (EObject)e2)) {
                    return -1;
                }
                return 1;
            }
        };

    }
}

