/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.lens;

import fr.inria.zvtm.lens.FSGaussianLens;
import fr.inria.zvtm.lens.LPDistanceMetrics;

public class LPFSGaussianLens
extends FSGaussianLens
implements LPDistanceMetrics {
    float P = 2.0f;
    float INV_P = 1.0f / this.P;

    public LPFSGaussianLens() {
    }

    public LPFSGaussianLens(float mm, float lp) {
        super(mm);
        this.setDistanceMetrics(lp);
    }

    public LPFSGaussianLens(float mm, float lp, int outerRadius, int innerRadius) {
        super(mm, outerRadius, innerRadius);
        this.setDistanceMetrics(lp);
    }

    public LPFSGaussianLens(float mm, float lp, int outerRadius, int innerRadius, int x, int y) {
        super(mm, outerRadius, innerRadius, x, y);
        this.setDistanceMetrics(lp);
    }

    @Override
    public void setDistanceMetrics(float lp) {
        this.P = lp;
        this.INV_P = 1.0f / this.P;
    }

    @Override
    public float getDistanceMetrics() {
        return this.P;
    }

    @Override
    public void gf(float x, float y, float[] g) {
        this.d = Math.pow(Math.pow(Math.abs(x - (float)this.sw - (float)this.lx), this.P) + Math.pow(Math.abs(y - (float)this.sh - (float)this.ly), this.P), this.INV_P);
        if (this.d <= (double)this.LR2) {
            g[0] = g[1] = this.MM;
        } else if (this.d <= (double)this.LR1) {
            g[0] = g[1] = (float)(this.c * Math.cos(this.a * this.d + this.b) + this.e);
        } else {
            g[1] = 1.0f;
            g[0] = 1.0f;
        }
    }
}

