/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.log.viewer.ResourceListener;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.preferences.PreferencesHandler;
import org.eclipse.titan.log.viewer.views.msc.util.MSCConstants;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static final int RESOURCE_CHANGE_FILTER = 7;
    private Map<String, Resource> guiResourceCache;
    private ResourceListener resourceListener;
    private static Activator plugin;
    private Map<String, Image> imageCache;

    public Activator() {
        plugin = this;
        this.imageCache = new HashMap<String, Image>();
        this.guiResourceCache = new HashMap<String, Resource>();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.resourceListener = new ResourceListener();
        workspace.addResourceChangeListener((IResourceChangeListener)this.resourceListener, 7);
        this.getPreferenceStore().setDefault("org.eclipse.titan.log.viewer_log_file_last_dir_id", "");
        this.getPreferenceStore().setDefault("org.eclipse.titan.log.viewer_log_folder_last_dir_id", "");
    }

    public void stop(BundleContext context) throws Exception {
        PreferencesHandler prefHandler = PreferencesHandler.getInstance();
        prefHandler.removeListener();
        prefHandler.dispose();
        plugin = null;
        this.disposeImages();
        this.disposeGUIResources();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.titan.log.viewer", (String)path);
    }

    public Image getIcon(String iconPath) {
        Image image = this.imageCache.get(iconPath);
        if (image == null) {
            image = Activator.getImageDescriptor(iconPath).createImage();
            this.imageCache.put(iconPath, image);
        }
        return image;
    }

    public ImageDescriptor getCachedImageDescriptor(String path) {
        return ImageDescriptor.createFromImage((Image)Activator.getDefault().getIcon(path));
    }

    private void disposeImages() {
        Iterator<Image> i = this.imageCache.values().iterator();
        while (i.hasNext()) {
            i.next().dispose();
        }
        this.imageCache.clear();
    }

    public Resource getCachedResource(String key) {
        if (this.guiResourceCache.containsKey(key)) {
            return this.guiResourceCache.get(key);
        }
        Resource resource = MSCConstants.getResource(key);
        if (resource == null) {
            TitanLogExceptionHandler.handleException(new TechnicalException("Resource could not be found"));
        }
        return this.addResource(key, resource);
    }

    public Resource getCachedResource(RGB color) {
        String key = String.valueOf(color.red) + "," + String.valueOf(color.green) + "," + String.valueOf(color.blue);
        if (this.guiResourceCache.containsKey(key)) {
            return this.guiResourceCache.get(key);
        }
        Color resource = new Color((Device)Display.getDefault(), color);
        TitanLogExceptionHandler.handleException(new TechnicalException("Resource could not be found"));
        return this.addResource(key, (Resource)resource);
    }

    private Resource addResource(String key, Resource resource) {
        this.guiResourceCache.put(key, resource);
        return resource;
    }

    private void disposeGUIResources() {
        for (Resource resource : this.guiResourceCache.values()) {
            resource.dispose();
        }
        this.guiResourceCache.clear();
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }
}

