/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;

public class CastCorrectionProposal
extends LinkedCorrectionProposal {
    public static final String ADD_CAST_ID = "org.eclipse.jdt.ui.correction.addCast";
    private final Expression fNodeToCast;
    private final ITypeBinding fCastType;

    public CastCorrectionProposal(String label, ICompilationUnit targetCU, Expression nodeToCast, ITypeBinding castType, int relevance) {
        super(label, targetCU, (ASTRewrite)null, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.correction_cast.gif"));
        this.fNodeToCast = nodeToCast;
        this.fCastType = castType;
        this.setCommandId(ADD_CAST_ID);
    }

    private Type getNewCastTypeNode(ASTRewrite rewrite, ImportRewrite importRewrite) {
        MethodInvocation invocation;
        AST ast = rewrite.getAST();
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((CompilationUnit)this.fNodeToCast.getRoot(), this.fNodeToCast.getStartPosition(), importRewrite);
        if (this.fCastType != null) {
            return importRewrite.addImport(this.fCastType, ast, (ImportRewrite.ImportRewriteContext)context);
        }
        Expression node = this.fNodeToCast;
        ASTNode parent = node.getParent();
        if (parent instanceof CastExpression) {
            node = parent;
            parent = parent.getParent();
        }
        while (parent instanceof ParenthesizedExpression) {
            node = parent;
            parent = parent.getParent();
        }
        if (parent instanceof MethodInvocation && (invocation = (MethodInvocation)node.getParent()).getExpression() == node) {
            IBinding targetContext = ASTResolving.getParentMethodOrTypeBinding((ASTNode)node);
            ITypeBinding[] bindings = ASTResolving.getQualifierGuess(node.getRoot(), invocation.getName().getIdentifier(), invocation.arguments(), targetContext);
            if (bindings.length > 0) {
                ITypeBinding first = this.getCastFavorite(bindings, this.fNodeToCast.resolveTypeBinding());
                Type newTypeNode = importRewrite.addImport(first, ast, (ImportRewrite.ImportRewriteContext)context);
                this.addLinkedPosition(rewrite.track((ASTNode)newTypeNode), true, "casttype");
                int i = 0;
                while (i < bindings.length) {
                    this.addLinkedPositionProposal("casttype", bindings[i]);
                    ++i;
                }
                return newTypeNode;
            }
        }
        SimpleType newCastType = ast.newSimpleType((Name)ast.newSimpleName("Object"));
        this.addLinkedPosition(rewrite.track((ASTNode)newCastType), true, "casttype");
        return newCastType;
    }

    private ITypeBinding getCastFavorite(ITypeBinding[] suggestedCasts, ITypeBinding nodeToCastBinding) {
        if (nodeToCastBinding == null) {
            return suggestedCasts[0];
        }
        ITypeBinding favourite = suggestedCasts[0];
        int i = 0;
        while (i < suggestedCasts.length) {
            ITypeBinding curr = suggestedCasts[i];
            if (nodeToCastBinding.isCastCompatible(curr)) {
                return curr;
            }
            if (curr.isInterface()) {
                favourite = curr;
            }
            ++i;
        }
        return favourite;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        AST ast = this.fNodeToCast.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ImportRewrite importRewrite = this.createImportRewrite((CompilationUnit)this.fNodeToCast.getRoot());
        Type newTypeNode = this.getNewCastTypeNode(rewrite, importRewrite);
        if (this.fNodeToCast.getNodeType() == 11) {
            CastExpression expression = (CastExpression)this.fNodeToCast;
            rewrite.replace((ASTNode)expression.getType(), (ASTNode)newTypeNode, null);
        } else {
            Expression expressionCopy = (Expression)rewrite.createCopyTarget((ASTNode)this.fNodeToCast);
            if (CastCorrectionProposal.needsInnerParantheses((ASTNode)this.fNodeToCast)) {
                ParenthesizedExpression parenthesizedExpression = ast.newParenthesizedExpression();
                parenthesizedExpression.setExpression(expressionCopy);
                expressionCopy = parenthesizedExpression;
            }
            CastExpression castExpression = ast.newCastExpression();
            castExpression.setExpression(expressionCopy);
            castExpression.setType(newTypeNode);
            CastExpression replacingNode = castExpression;
            if (CastCorrectionProposal.needsOuterParantheses((ASTNode)this.fNodeToCast)) {
                ParenthesizedExpression parenthesizedExpression = ast.newParenthesizedExpression();
                parenthesizedExpression.setExpression((Expression)castExpression);
                replacingNode = parenthesizedExpression;
            }
            rewrite.replace((ASTNode)this.fNodeToCast, (ASTNode)replacingNode, null);
        }
        return rewrite;
    }

    private static boolean needsInnerParantheses(ASTNode nodeToCast) {
        int nodeType = nodeToCast.getNodeType();
        return nodeType == 27 || nodeType == 16 || nodeType == 7 || nodeType == 62;
    }

    private static boolean needsOuterParantheses(ASTNode nodeToCast) {
        ASTNode parent = nodeToCast.getParent();
        return parent instanceof MethodInvocation ? ((MethodInvocation)parent).getExpression() == nodeToCast : (parent instanceof QualifiedName ? ((QualifiedName)parent).getQualifier() == nodeToCast : parent instanceof FieldAccess && ((FieldAccess)parent).getExpression() == nodeToCast);
    }
}

