/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.jdt.internal.ui.javaeditor.AnnotateClassFileAction;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.ExternalClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlightingReconciler;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.SourceAttachmentBlock;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.actions.RefactorActionGroup;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class ClassFileEditor
extends JavaEditor
implements ClassFileDocumentProvider.InputChangeListener {
    private StackLayout fStackLayout;
    private Composite fParent;
    private Composite fViewerComposite;
    private Control fSourceAttachmentForm;
    private CompositeActionGroup fContextMenuGroup;
    private InputUpdater fInputUpdater = new InputUpdater();
    private IAction fSourceCopyAction;
    private IAction fSelectAllAction;
    private StyledText fNoSourceTextWidget;

    public ClassFileEditor() {
        this.setDocumentProvider((IDocumentProvider)JavaPlugin.getDefault().getClassFileDocumentProvider());
        this.setEditorContextMenuId("#ClassFileEditorContext");
        this.setRulerContextMenuId("#ClassFileRulerContext");
        this.setOutlinerContextMenuId("#ClassFileOutlinerContext");
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.setAction(ITextEditorActionConstants.SAVE, null);
        this.setAction(ITextEditorActionConstants.REVERT_TO_SAVED, null);
        this.fSourceCopyAction = this.getAction(ITextEditorActionConstants.COPY);
        this.fSelectAllAction = this.getAction(ITextEditorActionConstants.SELECT_ALL);
        RefactorActionGroup group = new RefactorActionGroup(this, "group.edit", true);
        this.fActionGroups.addGroup(group);
        this.fContextMenuGroup = new CompositeActionGroup(new ActionGroup[]{group});
        AnnotateClassFileAction action = new AnnotateClassFileAction(this);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.annotate.classFile");
        this.setAction("org.eclipse.jdt.ui.edit.text.java.annotate.classFile", (IAction)action);
    }

    @Override
    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        IAction action = this.getAction("org.eclipse.jdt.ui.edit.text.java.annotate.classFile");
        if (action.isEnabled()) {
            menu.appendToGroup("group.edit", action);
        }
        ActionContext context = new ActionContext(this.getSelectionProvider().getSelection());
        this.fContextMenuGroup.setContext(context);
        this.fContextMenuGroup.fillContextMenu(menu);
        this.fContextMenuGroup.setContext(null);
    }

    @Override
    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.jdt.ui.javaEditorScope", "org.eclipse.jdt.ui.classFileEditorScope"});
    }

    @Override
    protected IJavaElement getElementAt(int offset) {
        if (this.getEditorInput() instanceof IClassFileEditorInput) {
            try {
                IClassFileEditorInput input = (IClassFileEditorInput)this.getEditorInput();
                return input.getClassFile().getElementAt(offset);
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    @Override
    protected IJavaElement getCorrespondingElement(IJavaElement element) {
        if (this.getEditorInput() instanceof IClassFileEditorInput) {
            IClassFileEditorInput input = (IClassFileEditorInput)this.getEditorInput();
            IJavaElement parent = element.getAncestor(6);
            if (input.getClassFile().equals(parent)) {
                return element;
            }
        }
        return null;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean isEditorInputReadOnly() {
        return true;
    }

    protected IEditorInput transformEditorInput(IEditorInput input) {
        IFile file;
        ExternalClassFileEditorInput classFileInput;
        if (input instanceof IFileEditorInput && (classFileInput = new ExternalClassFileEditorInput(file = ((IFileEditorInput)input).getFile())).getClassFile() != null) {
            input = classFileInput;
        }
        return input;
    }

    @Override
    protected void doSetInput(IEditorInput input) throws CoreException {
        this.uninstallOccurrencesFinder();
        input = this.transformEditorInput(input);
        if (!(input instanceof IClassFileEditorInput)) {
            String inputClassName = input != null ? input.getClass().getName() : "null";
            String message = Messages.format(JavaEditorMessages.ClassFileEditor_error_invalid_input_message, inputClassName);
            throw new CoreException(JavaUIStatus.createError(996, message, null));
        }
        JavaModelException e = this.probeInputForSource(input);
        if (e != null) {
            IClassFileEditorInput classFileEditorInput = (IClassFileEditorInput)input;
            IClassFile file = classFileEditorInput.getClassFile();
            IJavaProject javaProject = file.getJavaProject();
            if (!javaProject.exists() || !javaProject.isOnClasspath((IJavaElement)file)) {
                throw new CoreException(JavaUIStatus.createError(995, JavaEditorMessages.ClassFileEditor_error_classfile_not_on_classpath, null));
            }
            throw e;
        }
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider instanceof ClassFileDocumentProvider) {
            ((ClassFileDocumentProvider)documentProvider).removeInputChangeListener(this);
        }
        super.doSetInput(input);
        documentProvider = this.getDocumentProvider();
        if (documentProvider instanceof ClassFileDocumentProvider) {
            ((ClassFileDocumentProvider)documentProvider).addInputChangeListener(this);
        }
        this.verifyInput(this.getEditorInput());
        JavaPlugin.getDefault().getASTProvider().activeJavaEditorChanged((IWorkbenchPart)this);
        if (this.fSemanticManager != null) {
            this.installSemanticHighlighting();
        }
    }

    @Override
    protected void installSemanticHighlighting() {
        super.installSemanticHighlighting();
        Job job = new Job(JavaEditorMessages.OverrideIndicatorManager_intallJob){

            protected IStatus run(IProgressMonitor monitor) {
                SemanticHighlightingReconciler reconciler;
                CompilationUnit ast = SharedASTProvider.getAST(ClassFileEditor.this.getInputJavaElement(), SharedASTProvider.WAIT_YES, null);
                if (ClassFileEditor.this.fOverrideIndicatorManager != null) {
                    ClassFileEditor.this.fOverrideIndicatorManager.reconciled(ast, true, monitor);
                }
                if (ClassFileEditor.this.fSemanticManager != null && (reconciler = ClassFileEditor.this.fSemanticManager.getReconciler()) != null) {
                    reconciler.reconciled(ast, false, monitor);
                }
                if (ClassFileEditor.this.isMarkingOccurrences()) {
                    ClassFileEditor.this.installOccurrencesFinder(false);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(50);
        job.setSystem(true);
        job.schedule();
    }

    @Override
    public void createPartControl(Composite parent) {
        this.fParent = new Composite(parent, 0);
        this.fStackLayout = new StackLayout();
        this.fParent.setLayout((Layout)this.fStackLayout);
        this.fViewerComposite = new Composite(this.fParent, 0);
        this.fViewerComposite.setLayout((Layout)new FillLayout());
        super.createPartControl(this.fViewerComposite);
        this.fStackLayout.topControl = this.fViewerComposite;
        this.fParent.layout();
        try {
            this.verifyInput(this.getEditorInput());
        }
        catch (CoreException e) {
            String title = JavaEditorMessages.ClassFileEditor_error_title;
            String message = JavaEditorMessages.ClassFileEditor_error_message;
            ExceptionHandler.handle(e, this.fParent.getShell(), title, message);
        }
    }

    private JavaModelException probeInputForSource(IEditorInput input) {
        if (input == null) {
            return null;
        }
        IClassFileEditorInput classFileEditorInput = (IClassFileEditorInput)input;
        IClassFile file = classFileEditorInput.getClassFile();
        try {
            file.getSourceRange();
        }
        catch (JavaModelException e) {
            return e;
        }
        return null;
    }

    private void verifyInput(IEditorInput input) throws JavaModelException {
        boolean isUsingSourceCopyAction;
        boolean wasUsingSourceCopyAction;
        if (this.fParent == null || input == null) {
            return;
        }
        IClassFileEditorInput classFileEditorInput = (IClassFileEditorInput)input;
        IClassFile file = classFileEditorInput.getClassFile();
        IAction copyQualifiedName = this.getAction("copyQualifiedName");
        IAction annotateAction = this.getAction("org.eclipse.jdt.ui.edit.text.java.annotate.classFile");
        boolean bl = wasUsingSourceCopyAction = this.fSourceCopyAction == this.getAction(ITextEditorActionConstants.COPY);
        if (file.getSourceRange() == null) {
            if (this.fSourceAttachmentForm != null) {
                this.fSourceAttachmentForm.dispose();
            }
            SourceAttachmentForm form = new SourceAttachmentForm(file);
            this.fStackLayout.topControl = this.fSourceAttachmentForm = form.createControl(this.fParent);
            this.fParent.layout();
            if (this.fNoSourceTextWidget != null) {
                Action copyAction = new Action(){

                    public void run() {
                        ClassFileEditor.this.fNoSourceTextWidget.copy();
                    }
                };
                copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
                this.setAction(ITextEditorActionConstants.COPY, (IAction)copyAction);
                copyAction.setEnabled(this.fNoSourceTextWidget.getSelectionText().length() > 0);
                this.fNoSourceTextWidget.addSelectionListener(new SelectionListener((IAction)copyAction){
                    private final /* synthetic */ IAction val$copyAction;
                    {
                        this.val$copyAction = iAction;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.val$copyAction.setEnabled(ClassFileEditor.this.fNoSourceTextWidget.getSelectionText().length() > 0);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                Action selectAllAction = new Action((IAction)copyAction){
                    private final /* synthetic */ IAction val$copyAction;
                    {
                        this.val$copyAction = iAction;
                    }

                    public void run() {
                        ClassFileEditor.this.fNoSourceTextWidget.selectAll();
                        this.val$copyAction.setEnabled(true);
                    }
                };
                selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
                this.setAction(ITextEditorActionConstants.SELECT_ALL, (IAction)selectAllAction);
                copyAction.setEnabled(this.fNoSourceTextWidget.getSelectionText().length() > 0);
                copyQualifiedName.setEnabled(false);
            }
            annotateAction.setEnabled(false);
        } else {
            if (this.fSourceAttachmentForm != null) {
                this.fSourceAttachmentForm.dispose();
                this.fSourceAttachmentForm = null;
                this.fStackLayout.topControl = this.fViewerComposite;
                this.fParent.layout();
            }
            this.setAction(ITextEditorActionConstants.COPY, this.fSourceCopyAction);
            this.setAction(ITextEditorActionConstants.SELECT_ALL, this.fSelectAllAction);
            copyQualifiedName.setEnabled(true);
            IJavaProject javaProject = file.getJavaProject();
            boolean useExternalAnnotations = javaProject != null && javaProject.getOption("org.eclipse.jdt.core.compiler.annotation.nullanalysis", true).equals("enabled");
            annotateAction.setEnabled(useExternalAnnotations);
        }
        IAction currentCopyAction = this.getAction(ITextEditorActionConstants.COPY);
        boolean bl2 = isUsingSourceCopyAction = this.fSourceCopyAction == currentCopyAction;
        if (wasUsingSourceCopyAction != isUsingSourceCopyAction) {
            IActionBars actionBars = this.getEditorSite().getActionBars();
            if (isUsingSourceCopyAction) {
                this.createNavigationActions();
            } else {
                int i = 0;
                while (i < ACTION_MAP.length) {
                    AbstractTextEditor.IdMapEntry entry = ACTION_MAP[i];
                    actionBars.setGlobalActionHandler(entry.getActionId(), null);
                    this.setAction(entry.getActionId(), null);
                    ++i;
                }
            }
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, currentCopyAction);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.SELECT_ALL, this.getAction(ITextEditorActionConstants.SELECT_ALL));
            actionBars.updateActionBars();
        }
    }

    @Override
    public void inputChanged(IClassFileEditorInput input) {
        this.fInputUpdater.post(input);
    }

    @Override
    protected ISourceViewer createJavaSourceViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean isOverviewRulerVisible, int styles, IPreferenceStore store) {
        return new JavaSourceViewer(parent, ruler, overviewRuler, isOverviewRulerVisible, styles, store){

            public boolean requestWidgetToken(IWidgetTokenKeeper requester) {
                if (PlatformUI.getWorkbench().getHelpSystem().isContextHelpDisplayed()) {
                    return false;
                }
                return super.requestWidgetToken(requester);
            }

            public boolean requestWidgetToken(IWidgetTokenKeeper requester, int priority) {
                if (PlatformUI.getWorkbench().getHelpSystem().isContextHelpDisplayed()) {
                    return false;
                }
                return super.requestWidgetToken(requester, priority);
            }

            @Override
            public boolean canDoOperation(int operation) {
                if (operation == 54) {
                    return true;
                }
                return super.canDoOperation(operation);
            }

            @Override
            public void doOperation(int operation) {
                if (operation == 54) {
                    this.fQuickAssistAssistant.setStatusLineVisible(true);
                    this.fQuickAssistAssistant.setStatusMessage(String.valueOf(JavaEditorMessages.ClassFileEditor_changeExternalAnnotations_caption) + ' ');
                    String msg = this.fQuickAssistAssistant.showPossibleQuickAssists();
                    ClassFileEditor.this.setStatusLineErrorMessage(msg);
                    return;
                }
                super.doOperation(operation);
            }
        };
    }

    @Override
    public void dispose() {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider instanceof ClassFileDocumentProvider) {
            ((ClassFileDocumentProvider)documentProvider).removeInputChangeListener(this);
        }
        super.dispose();
    }

    @Override
    public void setFocus() {
        super.setFocus();
        if (this.fSourceAttachmentForm != null && !this.fSourceAttachmentForm.isDisposed()) {
            this.fSourceAttachmentForm.setFocus();
        }
    }

    private class InputUpdater
    implements Runnable {
        private boolean fPosted = false;
        private IClassFileEditorInput fClassFileEditorInput;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IClassFileEditorInput input;
            InputUpdater inputUpdater = this;
            synchronized (inputUpdater) {
                input = this.fClassFileEditorInput;
            }
            try {
                if (ClassFileEditor.this.getSourceViewer() != null) {
                    ClassFileEditor.this.setInput(input);
                }
            }
            catch (Throwable throwable) {
                InputUpdater inputUpdater2 = this;
                synchronized (inputUpdater2) {
                    this.fPosted = false;
                }
                throw throwable;
            }
            InputUpdater inputUpdater3 = this;
            synchronized (inputUpdater3) {
                this.fPosted = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void post(IClassFileEditorInput input) {
            StyledText textWidget;
            ISourceViewer viewer;
            InputUpdater inputUpdater = this;
            synchronized (inputUpdater) {
                if (this.fPosted) {
                    if (this.isEqualInput(input, this.fClassFileEditorInput)) {
                        this.fClassFileEditorInput = input;
                    }
                    return;
                }
            }
            if (this.isEqualInput(input, ClassFileEditor.this.getEditorInput()) && (viewer = ClassFileEditor.this.getSourceViewer()) != null && (textWidget = viewer.getTextWidget()) != null && !textWidget.isDisposed()) {
                InputUpdater inputUpdater2 = this;
                synchronized (inputUpdater2) {
                    this.fPosted = true;
                    this.fClassFileEditorInput = input;
                }
                textWidget.getDisplay().asyncExec((Runnable)this);
            }
        }

        private boolean isEqualInput(IEditorInput input1, IEditorInput input2) {
            return input1 != null && input1.equals(input2);
        }
    }

    private class SourceAttachmentForm
    implements IPropertyChangeListener {
        private final IClassFile fFile;
        private Composite fComposite;
        private Color fBackgroundColor;
        private Color fForegroundColor;
        private Color fSeparatorColor;
        private List<Label> fBannerLabels = new ArrayList<Label>();
        private List<Label> fHeaderLabels = new ArrayList<Label>();
        private Font fFont;

        public SourceAttachmentForm(IClassFile file) {
            this.fFile = file;
        }

        private IPackageFragmentRoot getPackageFragmentRoot(IClassFile file) {
            IJavaElement element = file.getParent();
            while (element != null && element.getElementType() != 3) {
                element = element.getParent();
            }
            return (IPackageFragmentRoot)element;
        }

        public Control createControl(Composite parent) {
            Display display = parent.getDisplay();
            this.fBackgroundColor = display.getSystemColor(25);
            this.fForegroundColor = display.getSystemColor(24);
            this.fSeparatorColor = new Color((Device)display, 152, 170, 203);
            JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
            this.fComposite = this.createComposite(parent);
            this.fComposite.setLayout((Layout)new GridLayout());
            this.fComposite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)SourceAttachmentForm.this);
                    SourceAttachmentForm.this.fComposite = null;
                    SourceAttachmentForm.this.fSeparatorColor.dispose();
                    SourceAttachmentForm.this.fSeparatorColor = null;
                    SourceAttachmentForm.this.fBannerLabels.clear();
                    SourceAttachmentForm.this.fHeaderLabels.clear();
                    if (SourceAttachmentForm.this.fFont != null) {
                        SourceAttachmentForm.this.fFont.dispose();
                        SourceAttachmentForm.this.fFont = null;
                    }
                }
            });
            this.createTitleLabel(this.fComposite, JavaEditorMessages.SourceAttachmentForm_title);
            this.createLabel(this.fComposite, null);
            this.createLabel(this.fComposite, null);
            this.createHeadingLabel(this.fComposite, JavaEditorMessages.SourceAttachmentForm_heading);
            Composite separator = this.createCompositeSeparator(this.fComposite);
            GridData data = new GridData(768);
            data.heightHint = 2;
            separator.setLayoutData((Object)data);
            try {
                IPackageFragmentRoot root = this.getPackageFragmentRoot(this.fFile);
                if (root != null) {
                    this.createSourceAttachmentControls(this.fComposite, root);
                }
            }
            catch (JavaModelException e) {
                String title = JavaEditorMessages.SourceAttachmentForm_error_title;
                String message = JavaEditorMessages.SourceAttachmentForm_error_message;
                ExceptionHandler.handle((CoreException)((Object)e), this.fComposite.getShell(), title, message);
            }
            separator = this.createCompositeSeparator(this.fComposite);
            data = new GridData(768);
            data.heightHint = 2;
            separator.setLayoutData((Object)data);
            ClassFileEditor.this.fNoSourceTextWidget = this.createCodeView(this.fComposite);
            data = new GridData(1808);
            ClassFileEditor.this.fNoSourceTextWidget.setLayoutData((Object)data);
            this.updateCodeView(ClassFileEditor.this.fNoSourceTextWidget, this.fFile);
            return this.fComposite;
        }

        private void createSourceAttachmentControls(Composite composite, IPackageFragmentRoot root) throws JavaModelException {
            Button button;
            IPath path;
            IClasspathEntry entry;
            try {
                entry = JavaModelUtil.getClasspathEntry(root);
            }
            catch (JavaModelException ex) {
                if (ex.isDoesNotExist()) {
                    entry = null;
                }
                throw ex;
            }
            IPath containerPath = null;
            if (entry == null || root.getKind() != 2) {
                this.createLabel(composite, Messages.format(JavaEditorMessages.SourceAttachmentForm_message_noSource, BasicElementLabels.getFileName((ITypeRoot)this.fFile)));
                return;
            }
            IJavaProject jproject = root.getJavaProject();
            boolean canEditEncoding = true;
            if (entry.getEntryKind() == 5) {
                containerPath = entry.getPath();
                ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)containerPath.segment(0));
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)jproject);
                if (initializer == null || container == null) {
                    this.createLabel(composite, Messages.format(JavaEditorMessages.ClassFileEditor_SourceAttachmentForm_cannotconfigure, BasicElementLabels.getPathLabel(containerPath, false)));
                    return;
                }
                String containerName = container.getDescription();
                IStatus status = initializer.getSourceAttachmentStatus(containerPath, jproject);
                if (status.getCode() == 1) {
                    this.createLabel(composite, Messages.format(JavaEditorMessages.ClassFileEditor_SourceAttachmentForm_notsupported, containerName));
                    return;
                }
                if (status.getCode() == 2) {
                    this.createLabel(composite, Messages.format(JavaEditorMessages.ClassFileEditor_SourceAttachmentForm_readonly, containerName));
                    return;
                }
                IStatus attributeStatus = initializer.getAttributeStatus(containerPath, jproject, "source_encoding");
                canEditEncoding = attributeStatus.getCode() != 1 && attributeStatus.getCode() != 2;
                entry = JavaModelUtil.findEntryInContainer(container, root.getPath());
                Assert.isNotNull((Object)entry);
            }
            if ((path = entry.getSourceAttachmentPath()) == null || path.isEmpty()) {
                String rootLabel = JavaElementLabels.getElementLabel((IJavaElement)root, JavaElementLabels.ALL_DEFAULT);
                this.createLabel(composite, Messages.format(JavaEditorMessages.SourceAttachmentForm_message_noSourceAttachment, rootLabel));
                this.createLabel(composite, JavaEditorMessages.SourceAttachmentForm_message_pressButtonToAttach);
                this.createLabel(composite, null);
                button = this.createButton(composite, JavaEditorMessages.SourceAttachmentForm_button_attachSource);
            } else {
                this.createLabel(composite, Messages.format(JavaEditorMessages.SourceAttachmentForm_message_noSourceInAttachment, BasicElementLabels.getFileName((ITypeRoot)this.fFile)));
                this.createLabel(composite, JavaEditorMessages.SourceAttachmentForm_message_pressButtonToChange);
                this.createLabel(composite, null);
                button = this.createButton(composite, JavaEditorMessages.SourceAttachmentForm_button_changeAttachedSource);
            }
            button.addSelectionListener(this.getButtonListener(entry, containerPath, jproject, canEditEncoding));
        }

        private SelectionListener getButtonListener(final IClasspathEntry entry, final IPath containerPath, final IJavaProject jproject, final boolean canEditEncoding) {
            return new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    Shell shell = ClassFileEditor.this.getSite().getShell();
                    try {
                        IClasspathEntry result = BuildPathDialogAccess.configureSourceAttachment(shell, entry, canEditEncoding);
                        if (result != null) {
                            SourceAttachmentForm.this.applySourceAttachment(shell, result, jproject, containerPath, entry.getReferencingEntry() != null);
                            ClassFileEditor.this.verifyInput(ClassFileEditor.this.getEditorInput());
                        }
                    }
                    catch (CoreException e) {
                        String title = JavaEditorMessages.SourceAttachmentForm_error_title;
                        String message = JavaEditorMessages.SourceAttachmentForm_error_message;
                        ExceptionHandler.handle(e, shell, title, message);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            };
        }

        protected void applySourceAttachment(Shell shell, IClasspathEntry newEntry, IJavaProject project, IPath containerPath, boolean isReferencedEntry) {
            try {
                IRunnableWithProgress runnable = SourceAttachmentBlock.getRunnable(shell, newEntry, project, containerPath, isReferencedEntry);
                PlatformUI.getWorkbench().getProgressService().run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                String title = JavaEditorMessages.SourceAttachmentForm_attach_error_title;
                String message = JavaEditorMessages.SourceAttachmentForm_attach_error_message;
                ExceptionHandler.handle(e, shell, title, message);
            }
            catch (InterruptedException interruptedException) {}
        }

        public void propertyChange(PropertyChangeEvent event) {
            for (Label label : this.fBannerLabels) {
                label.setFont(JFaceResources.getBannerFont());
            }
            for (Label label : this.fHeaderLabels) {
                label.setFont(JFaceResources.getHeaderFont());
            }
            this.fComposite.layout(true);
            this.fComposite.redraw();
        }

        private Composite createComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setBackground(this.fBackgroundColor);
            return composite;
        }

        private Composite createCompositeSeparator(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setBackground(this.fSeparatorColor);
            return composite;
        }

        private StyledText createCodeView(Composite parent) {
            int styles = 66306;
            StyledText styledText = new StyledText(parent, styles);
            styledText.setBackground(this.fBackgroundColor);
            styledText.setForeground(this.fForegroundColor);
            styledText.setEditable(false);
            return styledText;
        }

        private Label createLabel(Composite parent, String text) {
            Label label = new Label(parent, 64);
            if (text != null) {
                label.setText(text);
            }
            label.setBackground(this.fBackgroundColor);
            label.setForeground(this.fForegroundColor);
            GridData gd = new GridData(4, 4, true, false);
            label.setLayoutData((Object)gd);
            return label;
        }

        private Label createTitleLabel(Composite parent, String text) {
            Label label = new Label(parent, 0);
            if (text != null) {
                label.setText(text);
            }
            label.setBackground(this.fBackgroundColor);
            label.setForeground(this.fForegroundColor);
            label.setFont(JFaceResources.getHeaderFont());
            this.fHeaderLabels.add(label);
            return label;
        }

        private Label createHeadingLabel(Composite parent, String text) {
            Label label = new Label(parent, 0);
            if (text != null) {
                label.setText(text);
            }
            label.setBackground(this.fBackgroundColor);
            label.setForeground(this.fForegroundColor);
            label.setFont(JFaceResources.getBannerFont());
            this.fBannerLabels.add(label);
            return label;
        }

        private Button createButton(Composite parent, String text) {
            Button button = new Button(parent, 0x800000);
            button.setBackground(this.fBackgroundColor);
            button.setForeground(this.fForegroundColor);
            if (text != null) {
                button.setText(text);
            }
            return button;
        }

        private void updateCodeView(StyledText styledText, IClassFile classFile) {
            String content = null;
            ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
            try {
                content = disassembler.disassemble(classFile.getBytes(), "\n", 1);
            }
            catch (JavaModelException ex) {
                JavaPlugin.log(ex.getStatus());
            }
            catch (ClassFormatException ex) {
                JavaPlugin.log(ex);
            }
            styledText.setText(content == null ? "" : content);
        }
    }
}

