/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.properties.pages.PropertyStore;
import org.eclipse.ui.IWorkbenchPropertyPage;

public abstract class FieldEditorPropertyPage
extends FieldEditorPreferencePage
implements IWorkbenchPropertyPage {
    private IAdaptable element;
    private IPreferenceStore overlayStore;
    private List<FieldEditor> editors = new ArrayList<FieldEditor>();

    protected FieldEditorPropertyPage(int style) {
        super(style);
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.overlayStore;
    }

    protected void resetPreferenceStore() {
        this.overlayStore = new PropertyStore((IResource)this.getElement(), Activator.getDefault().getPreferenceStore(), this.getPageId());
    }

    protected abstract String getPageId();

    protected Control createContents(Composite parent) {
        this.overlayStore = new PropertyStore((IResource)this.getElement(), Activator.getDefault().getPreferenceStore(), this.getPageId());
        Control result = super.createContents(parent);
        return result;
    }

    protected void addField(FieldEditor editor) {
        this.editors.add(editor);
        super.addField(editor);
    }

    protected void checkState() {
        super.checkState();
        boolean valid = true;
        if (this.editors != null) {
            int size = this.editors.size();
            for (int i = 0; i < size; ++i) {
                FieldEditor editor = this.editors.get(i);
                boolean bl = valid = valid && editor.isValid();
                if (!valid) break;
            }
        }
        this.setValid(valid);
    }

    protected void performDefaults() {
        if (this.editors != null) {
            for (FieldEditor pe : this.editors) {
                pe.loadDefault();
            }
        }
        this.checkState();
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.editors != null) {
            for (FieldEditor pe : this.editors) {
                pe.store();
                pe.getPreferenceStore().setToDefault(pe.getPreferenceName());
            }
        }
        super.performOk();
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_is_valid")) {
            boolean newValue = (Boolean)event.getNewValue();
            if (newValue) {
                this.checkState();
            } else {
                this.setValid(newValue);
            }
        }
    }

    protected void updateFieldEditors(boolean enabled) {
        Composite parent = this.getFieldEditorParent();
        for (FieldEditor editor : this.editors) {
            editor.setEnabled(enabled, parent);
        }
    }
}

