/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.data;

import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public final class ProjectDocumentHandlingUtility {
    private static Map<IProject, Document> documents = new HashMap<IProject, Document>();

    private ProjectDocumentHandlingUtility() {
    }

    public static Document getDocument(IProject project) {
        if (!documents.containsKey(project)) {
            ProjectDocumentHandlingUtility.loadDocument(project);
        }
        return documents.get(project);
    }

    public static Document createDocument(IProject project) {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            ErrorReporter.logExceptionStackTrace((String)("While creating document for `" + project.getName() + "'"), (Throwable)e);
            return null;
        }
        DOMImplementation impl = builder.getDOMImplementation();
        Document document = impl.createDocument(null, "TITAN_Designer_Properties", null);
        ProjectDocumentHandlingUtility.addDocument(project, document);
        return document;
    }

    public static void addDocument(IProject project, Document document) {
        documents.put(project, document);
    }

    private static void loadDocument(IProject project) {
        ProjectFileHandler fileHandler = new ProjectFileHandler(project);
        Document document = fileHandler.getDocumentFromFile(project.getFile("/.TITAN_properties"));
        if (document != null) {
            documents.put(project, document);
        }
    }

    public static void clearDocument(IProject project) {
        documents.remove(project);
    }

    public static void saveDocument(IProject project) {
        if (!documents.containsKey(project)) {
            return;
        }
        Document document = documents.get(project);
        ProjectFileHandler fileHandler = new ProjectFileHandler(project);
        ProjectFileHandler.clearNode(document.getDocumentElement());
        ProjectFileHandler.indentNode(document, document.getDocumentElement(), 1);
        fileHandler.saveDocumentToFile(project.getFile("/.TITAN_properties"), document);
    }
}

