/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.asn1editor;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.titan.designer.editors.ColorManager;
import org.eclipse.titan.designer.editors.StringDetectionPatternRule;
import org.eclipse.titan.designer.editors.WhiteSpaceDetector;
import org.eclipse.titan.designer.editors.asn1editor.WordDetector;

public final class CodeScanner
extends RuleBasedScanner {
    private static final String[] STRING_PIECES = new String[]{"\"", "#", "'", "'B", "'H", "'O"};
    public static final String[] VERBS = new String[]{"ACTIONS", "ADD", "GET", "NOTIFICATIONS", "REPLACE", "REMOVE"};
    public static final String[] COMPARE_TYPES = new String[]{"OPTIONAL", "DEFAULT", "MANAGED", "MODULE-TYPE", "MODULE_IDENTITY", "MODULE-COMPLIANCE", "OBJECT-TYPE", "OBJECT-IDENTITY", "OBJECT-COMPLIANCE", "MODE", "CONFIRMED", "CONDITIONAL", "SUBORDINATE", "SUPERIOR", "CLASS", "TRUE", "FALSE", "NULL", "TEXTUAL-CONVENTION"};
    public static final String[] STATUS_TYPE = new String[]{"current", "deprecated", "mandatory", "obsolete"};
    public static final String[] KEYWORDS = new String[]{"DEFINITIONS", "OBJECTS", "IF", "DERIVED", "INFORMATION", "ACTION", "REPLY", "ANY", "NAMED", "CHARACTERIZED", "BEHAVIOUR", "REGISTERED", "WITH", "AS", "IDENTIFIED", "CONSTRAINED", "BY", "PRESENT", "BEGIN", "IMPORTS", "FROM", "UNITS", "SYNTAX", "MIN-ACCESS", "MAX-ACCESS", "MINACCESS", "MAXACCESS", "REVISION", "STATUS", "DESCRIPTION", "SEQUENCE", "SET", "COMPONENTS", "OF", "CHOICE", "DistinguishedName", "ENUMERATED", "SIZE", "OBJECT-TYPE", "MODULE", "END", "INDEX", "AUGMENTS", "EXTENSIBILITY", "IMPLIED", "EXPORTS"};
    public static final String[] TAGS = new String[]{"APPLICATION", "AUTOMATIC", "EXPLICIT", "IMPLICIT", "PRIVATE", "TAGS", "UNIVERSAL"};
    public static final String[] STORAGE = new String[]{"BOOLEAN", "INTEGER", "InterfaceIndex", "IANAifType", "CMIP-Attribute", "REAL", "PACKAGE", "PACKAGES", "IpAddress", "PhysAddress", "NetworkAddress", "BITS", "BMPString", "TimeStamp", "TimeTicks", "TruthValue", "RowStatus", "DisplayString", "GeneralString", "GraphicString", "IA5String", "NumericString", "PrintableString", "SnmpAdminAtring", "TeletexString", "UTF8String", "VideotexString", "VisibleString", "ISO646String", "T61String", "UniversalString", "Unsigned32", "Integer32", "Gauge", "Gauge32", "Counter", "Counter32", "Counter64"};
    public static final String[] MODIFIER = new String[]{"ATTRIBUTE", "ATTRIBUTES", "MANDATORY-GROUP", "MANDATORY-GROUPS", "GROUP", "GROUPS", "ELEMENTS", "EQUALITY", "ORDERING", "SUBSTRINGS", "DEFINED"};
    public static final String[] ACCESS_TYPE = new String[]{"not-accessible", "accessible-for-notify", "read-only", "read-create", "read-write"};
    public static final String SINGLE_LINE_COMMENT = "__asn1_single_line_comment";
    private static final String[] COMMENT_PIECES = new String[]{"--", "/*", "*/"};

    public CodeScanner(ColorManager colorManager) {
        Token comment = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.comments");
        Token verbs = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.CMIP_Verb");
        Token compareType = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.compare_type");
        Token statusType = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.status_type");
        Token keywords = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.asn1keywords");
        Token tags = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.tag");
        Token storage = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.storage");
        Token modifier = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.modifier");
        Token accesType = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.access_type");
        Token string = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.strings");
        Token other = colorManager.createTokenFromPreference("org.eclipse.titan.designer.color.normalText");
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new PatternRule(COMMENT_PIECES[0], COMMENT_PIECES[0], (IToken)comment, '\u0000', true, true));
        rules.add(new MultiLineRule(COMMENT_PIECES[1], COMMENT_PIECES[2], (IToken)comment, '\u0000', true));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhiteSpaceDetector()));
        rules.add(new SingleLineRule(STRING_PIECES[0], STRING_PIECES[0], (IToken)string, '\\'));
        rules.add(new StringDetectionPatternRule(STRING_PIECES[2], new char[][]{{'\'', 'B'}, {'\'', 'H'}, {'\'', 'O'}}, (IToken)string));
        rules.add(new SingleLineRule("NAME", "BINDING", (IToken)keywords));
        rules.add(new SingleLineRule("OBJECT", "IDENTIFIER", (IToken)keywords));
        rules.add(new SingleLineRule("BIT", "STRING", (IToken)storage));
        rules.add(new SingleLineRule("OCTET", "STRING", (IToken)storage));
        rules.add(new SingleLineRule("MATCHES", "FOR", (IToken)modifier));
        WordRule wordRule = new WordRule((IWordDetector)new WordDetector(), (IToken)other);
        for (String element : VERBS) {
            wordRule.addWord(element, (IToken)verbs);
        }
        for (String element : COMPARE_TYPES) {
            wordRule.addWord(element, (IToken)compareType);
        }
        for (String element : STATUS_TYPE) {
            wordRule.addWord(element, (IToken)statusType);
        }
        for (String element : KEYWORDS) {
            wordRule.addWord(element, (IToken)keywords);
        }
        for (String element : TAGS) {
            wordRule.addWord(element, (IToken)tags);
        }
        for (String element : STORAGE) {
            wordRule.addWord(element, (IToken)storage);
        }
        for (String element : MODIFIER) {
            wordRule.addWord(element, (IToken)modifier);
        }
        for (String element : ACCESS_TYPE) {
            wordRule.addWord(element, (IToken)accesType);
        }
        rules.add(wordRule);
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }
}

