/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.designer.editors.GlobalIntervalHandler;

public final class IntervallBasedDamagerRepairer
extends DefaultDamagerRepairer {
    public IntervallBasedDamagerRepairer(ITokenScanner scanner) {
        super(scanner);
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
        Interval interval = GlobalIntervalHandler.getInterval(this.fDocument);
        if (interval != null) {
            int maxLength = Math.max(0, e.getText() == null ? e.getLength() : e.getText().length());
            int endoffset = e.getOffset() + maxLength;
            Interval smallest = interval.getSmallestEnclosingInterval(e.getOffset(), endoffset);
            Interval canaryInterval = smallest.getSmallestEnclosingInterval(e.getOffset());
            if (Interval.interval_type.MULTILINE_COMMENT.equals((Object)canaryInterval.getType())) {
                return new Region(canaryInterval.getStartOffset(), Math.min(smallest.getEndOffset() - canaryInterval.getStartOffset() + maxLength, this.fDocument.getLength()));
            }
        }
        return super.getDamageRegion(partition, e, documentPartitioningChanged);
    }
}

