/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.types.EnumItem;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class EnumerationItems
extends ASTNode
implements IIncrementallyUpdateable {
    private static final String FULLNAMEPART = ".<unknown_enumeration_item>";
    private final List<EnumItem> items;
    private Location location = NULL_Location.INSTANCE;

    public EnumerationItems() {
        this.items = new ArrayList<EnumItem>();
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        for (EnumItem item : this.items) {
            if (item != child) continue;
            Identifier identifier = item.getId();
            if (identifier != null) {
                return builder.append(".").append(identifier.getDisplayName());
            }
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void addEnumItem(EnumItem enumItem) {
        if (enumItem != null && enumItem.getId() != null) {
            this.items.add(enumItem);
            enumItem.setFullNameParent(this);
        }
    }

    public List<EnumItem> getItems() {
        return this.items;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        for (EnumItem item : this.items) {
            item.setMyScope(scope);
        }
    }

    public void addProposal(ProposalCollector propCollector) {
        for (EnumItem item : this.items) {
            item.addProposal(propCollector);
        }
    }

    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        for (EnumItem item : this.items) {
            item.addDeclaration(declarationCollector, i);
        }
    }

    public void addDeclaration(DeclarationCollector declarationCollector, int i, Location commentLocation) {
        for (EnumItem item : this.items) {
            item.addDeclaration(declarationCollector, i);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        int size = this.items.size();
        for (int i = 0; i < size; ++i) {
            EnumItem item = this.items.get(i);
            item.updateSyntax(reparser, false);
            reparser.updateLocation(item.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.items != null) {
            for (EnumItem ei : this.items) {
                ei.findReferences(referenceFinder, foundIdentifiers);
            }
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.items != null) {
            for (EnumItem ei : this.items) {
                if (ei.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

