/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.templates.CompositeTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITemplateListItem;
import org.eclipse.titan.designer.AST.TTCN3.templates.ListOfTemplates;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimension;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Values;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Template_List
extends CompositeTemplate {
    private SequenceOf_Value asValue = null;

    public Template_List(ListOfTemplates templates) {
        super(templates);
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.TEMPLATE_LIST;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous value list notation";
        }
        return "value list notation";
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            ITemplateListItem template = this.templates.getTemplateByIndex(i);
            builder.append(template.createStringRepresentation());
        }
        builder.append(" }");
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    @Override
    public TTCN3Template setTemplatetype(CompilationTimeStamp timestamp, ITTCN3Template.Template_type newType) {
        switch (newType) {
            case NAMED_TEMPLATE_LIST: {
                return Named_Template_List.convert(timestamp, this);
            }
        }
        return super.setTemplatetype(timestamp, newType);
    }

    @Override
    protected ITTCN3Template getReferencedArrayTemplate(CompilationTimeStamp timestamp, IValue arrayIndex, IReferenceChain referenceChain) {
        ITemplateListItem returnValue;
        IValue indexValue = arrayIndex.setLoweridToReference(timestamp);
        if ((indexValue = indexValue.getValueRefdLast(timestamp, referenceChain)).getIsErroneous(timestamp)) {
            return null;
        }
        long index = 0L;
        if (!indexValue.isUnfoldable(timestamp)) {
            if (!IValue.Value_type.INTEGER_VALUE.equals((Object)indexValue.getValuetype())) {
                arrayIndex.getLocation().reportSemanticError("An integer value was expected as index");
                return null;
            }
        } else {
            return null;
        }
        index = ((Integer_Value)indexValue).getValue();
        IType tempType = this.myGovernor.getTypeRefdLast(timestamp);
        if (tempType.getIsErroneous(timestamp)) {
            return null;
        }
        switch (tempType.getTypetype()) {
            case TYPE_SEQUENCE_OF: {
                if (index < 0L) {
                    String message = MessageFormat.format("A non-negative integer value was expected instead of {0} for indexing a template of `sequence of'' type `{1}''", index, tempType.getTypename());
                    arrayIndex.getLocation().reportSemanticError(message);
                    return null;
                }
                int nofElements = this.getNofTemplates();
                if (index <= (long)nofElements) break;
                String message = MessageFormat.format("Index overflow in a template of `sequence of'' type `{0}'': the index is {1}, but the template has only {2} elements", tempType.getTypename(), index, nofElements);
                arrayIndex.getLocation().reportSemanticError(message);
                return null;
            }
            case TYPE_SET_OF: {
                if (index < 0L) {
                    String message = MessageFormat.format("A non-negative integer value was expected instead of {0} for indexing a template of `set of'' type `{1}''", index, tempType.getTypename());
                    arrayIndex.getLocation().reportSemanticError(message);
                    return null;
                }
                int nofElements = this.getNofTemplates();
                if (index <= (long)nofElements) break;
                String message = MessageFormat.format("Index overflow in a template of `set of'' type `{0}'': the index is {1}, but the template has only {2} elements", tempType.getTypename(), index, nofElements);
                arrayIndex.getLocation().reportSemanticError(message);
                return null;
            }
            case TYPE_ARRAY: {
                ArrayDimension dimension = ((Array_Type)tempType).getDimension();
                dimension.checkIndex(timestamp, indexValue, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
                if (!dimension.getIsErroneous(timestamp)) {
                    if ((index -= dimension.getOffset()) >= 0L && index <= (long)this.getNofTemplates()) break;
                    arrayIndex.getLocation().reportSemanticError(MessageFormat.format("The index value {0} is outside the array indexable range", index + dimension.getOffset()));
                    return null;
                }
                return null;
            }
            default: {
                String message = MessageFormat.format("Invalid array element reference: type `{0}'' cannot be indexed", tempType.getTypename());
                arrayIndex.getLocation().reportSemanticError(message);
                return null;
            }
        }
        if (ITTCN3Template.Template_type.TEMPLATE_NOTUSED.equals((Object)(returnValue = this.getTemplateByIndex((int)index)).getTemplatetype())) {
            if (this.baseTemplate != null) {
                return this.baseTemplate.getTemplateReferencedLast(timestamp, referenceChain).getReferencedArrayTemplate(timestamp, indexValue, referenceChain);
            }
            return null;
        }
        return returnValue;
    }

    @Override
    public boolean isValue(CompilationTimeStamp timestamp) {
        if (this.lengthRestriction != null || this.isIfpresent || this.getIsErroneous(timestamp)) {
            return false;
        }
        int size = this.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (this.templates.getTemplateByIndex(i).isValue(timestamp)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IValue getValue() {
        if (this.asValue != null) {
            return this.asValue;
        }
        Values values = new Values(false);
        int size = this.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            values.addValue(this.templates.getTemplateByIndex(i).getValue());
        }
        this.asValue = new SequenceOf_Value(values);
        this.asValue.setLocation(this.getLocation());
        this.asValue.setMyScope(this.getMyScope());
        this.asValue.setFullNameParent(this.getNameParent());
        return this.asValue;
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            this.templates.getTemplateByIndex(i).checkSpecificValue(timestamp, true);
        }
    }

    @Override
    protected void checkTemplateSpecificLengthRestriction(CompilationTimeStamp timestamp, IType.Type_type typeType) {
        if (IType.Type_type.TYPE_SEQUENCE_OF.equals((Object)typeType) || IType.Type_type.TYPE_SET_OF.equals((Object)typeType)) {
            int nofTemplatesGood = this.getNofTemplatesNotAnyornone(timestamp);
            boolean hasAnyOrNone = this.templateContainsAnyornone();
            this.lengthRestriction.checkNofElements(timestamp, nofTemplatesGood, hasAnyOrNone, false, hasAnyOrNone, this);
        }
    }

    @Override
    public boolean checkValueomitRestriction(CompilationTimeStamp timestamp, String definitionName, boolean omitAllowed, Location usageLocation) {
        if (omitAllowed) {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_OMIT, usageLocation);
        } else {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_VALUE, usageLocation);
        }
        boolean needsRuntimeCheck = false;
        int size = this.templates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (!this.templates.getTemplateByIndex(i).checkValueomitRestriction(timestamp, definitionName, true, usageLocation)) continue;
            needsRuntimeCheck = true;
        }
        return needsRuntimeCheck;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.lengthRestriction != null) {
            this.lengthRestriction.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.asValue != null) {
            this.asValue.findReferences(referenceFinder, foundIdentifiers);
        } else if (this.templates != null) {
            this.templates.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return !(this.asValue != null ? !this.asValue.accept(v) : this.templates != null && !this.templates.accept(v));
    }

    @Override
    protected String getNameForStringRep() {
        return "";
    }
}

