/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.archetype.common.ArchetypeFilesResolver;
import org.apache.maven.archetype.common.util.ListScanner;
import org.apache.maven.archetype.common.util.PathUtils;
import org.apache.maven.archetype.metadata.FileSet;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ArchetypeFilesResolver.class)
public class DefaultArchetypeFilesResolver
extends AbstractLogEnabled
implements ArchetypeFilesResolver {
    @Override
    public List<String> getFilesWithExtension(List<String> files, String extension) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir("");
        scanner.setIncludes("**/*." + extension);
        scanner.setExcludes("");
        return scanner.scan(files);
    }

    @Override
    public List<String> getFilteredFiles(List<String> files, String filtered) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir("");
        scanner.setIncludes(filtered);
        scanner.setExcludes("");
        List<String> result = scanner.scan(files);
        this.getLogger().debug("Scanned " + result.size() + " filtered files in " + files.size() + " files");
        return result;
    }

    @Override
    public List<String> filterFiles(String moduleOffset, FileSet fileSet, List<String> archetypeResources) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir((StringUtils.isEmpty((String)moduleOffset) ? "" : moduleOffset + File.separatorChar) + fileSet.getDirectory());
        scanner.setIncludes(fileSet.getIncludes());
        scanner.setExcludes(fileSet.getExcludes());
        scanner.setCaseSensitive(true);
        return scanner.scan(archetypeResources);
    }

    @Override
    public List<String> findOtherResources(int level, List<String> files, String languages) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir("");
        StringBuilder includes = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            includes.append("*/");
        }
        includes.append("**");
        scanner.setIncludes(includes.toString());
        scanner.setExcludes(languages);
        List<String> result = scanner.scan(files);
        this.getLogger().debug("Scanned " + result.size() + " other resources in " + files.size() + " files at level " + level);
        return result;
    }

    @Override
    public List<String> findOtherResources(int level, List<String> files, List<String> sourcesFiles, String languages) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir("");
        HashSet<String> selectedDirectories = new HashSet<String>();
        ArrayList<String> includes = new ArrayList<String>();
        for (String sourcesFile : sourcesFiles) {
            String directory = PathUtils.getDirectory(sourcesFile, level - 1);
            if (!selectedDirectories.contains(directory)) {
                includes.add(directory + "/**");
            }
            selectedDirectories.add(directory);
        }
        scanner.setExcludes(languages);
        List<String> result = scanner.scan(files);
        this.getLogger().debug("Scanned " + result.size() + " other resources in " + files.size() + " files at level " + level);
        return result;
    }

    @Override
    public List<String> findOtherSources(int level, List<String> files, String languages) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir("");
        StringBuilder levelDirectory = new StringBuilder();
        for (int i = 0; i < level - 1; ++i) {
            levelDirectory.append("*/");
        }
        StringBuilder includes = new StringBuilder();
        String[] languagesAsArray = StringUtils.split((String)languages);
        for (int i = 0; i < languagesAsArray.length; ++i) {
            includes.append((CharSequence)levelDirectory).append(languagesAsArray[i]);
        }
        scanner.setIncludes(includes.toString());
        List<String> result = scanner.scan(files);
        this.getLogger().debug("Scanned " + result.size() + " other sources in " + files.size() + " files at level " + level);
        return result;
    }

    @Override
    public List<String> findResourcesMainFiles(List<String> files, String languages) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir("src/main");
        scanner.setIncludes("**");
        scanner.setExcludes(languages);
        List<String> result = scanner.scan(files);
        this.getLogger().debug("Scanned " + result.size() + " resources in " + files.size() + " files");
        return result;
    }

    @Override
    public List<String> findResourcesTestFiles(List<String> files, String languages) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir("src/test");
        scanner.setIncludes("**");
        scanner.setExcludes(languages);
        List<String> result = scanner.scan(files);
        this.getLogger().debug("Scanned " + result.size() + " test resources in " + files.size() + " files");
        return result;
    }

    @Override
    public List<String> findSiteFiles(List<String> files, String languages) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir("src/site");
        scanner.setIncludes("**");
        scanner.setExcludes(languages);
        List<String> result = scanner.scan(files);
        this.getLogger().debug("Scanned " + result.size() + " site resources in " + files.size() + " files");
        return result;
    }

    @Override
    public List<String> findSourcesMainFiles(List<String> files, String languages) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir("src/main");
        scanner.setIncludes(languages);
        List<String> result = scanner.scan(files);
        this.getLogger().debug("Scanned " + result.size() + " sources in " + files.size() + " files");
        return result;
    }

    @Override
    public List<String> findSourcesTestFiles(List<String> files, String languages) {
        ListScanner scanner = new ListScanner();
        scanner.setBasedir("src/test");
        scanner.setIncludes(languages);
        List<String> result = scanner.scan(files);
        this.getLogger().debug("Scanned " + result.size() + " test sources in " + files.size() + " files");
        return result;
    }

    @Override
    public List<String> getPackagedFiles(List<String> files, String packageName) {
        ArrayList<String> packagedFiles = new ArrayList<String>();
        for (String file : files) {
            if (!file.startsWith(packageName)) continue;
            packagedFiles.add(file.substring(packageName.length() + 1));
        }
        this.getLogger().debug("Scanned " + packagedFiles.size() + " packaged files in " + files.size() + " files");
        return packagedFiles;
    }

    @Override
    public String resolvePackage(File basedir, List<String> languages) throws IOException {
        this.getLogger().debug("Resolving package in " + basedir + " using languages " + languages);
        List<String> files = this.resolveFiles(basedir, languages);
        return this.resolvePackage(files);
    }

    @Override
    public List<String> getUnpackagedFiles(List<String> files, String packageName) {
        ArrayList<String> unpackagedFiles = new ArrayList<String>();
        for (String file : files) {
            if (file.startsWith(packageName)) continue;
            unpackagedFiles.add(file);
        }
        this.getLogger().debug("Scanned " + unpackagedFiles.size() + " unpackaged files in " + files.size() + " files");
        return unpackagedFiles;
    }

    private String getCommonPackage(String packageName, String templatePackage) {
        String common = "";
        String difference = StringUtils.difference((String)packageName, (String)templatePackage);
        if (StringUtils.isNotEmpty((String)difference)) {
            String temporaryCommon = StringUtils.substring((String)templatePackage, (int)0, (int)templatePackage.lastIndexOf(difference));
            common = !difference.startsWith(".") ? StringUtils.substring((String)temporaryCommon, (int)0, (int)temporaryCommon.lastIndexOf(".")) : temporaryCommon;
        } else {
            common = packageName;
        }
        return common;
    }

    private List<String> resolveFiles(File basedir, List<String> languages) throws IOException {
        String[] languagesArray = languages.toArray(new String[languages.size()]);
        Object[] languagesPathesArray = new String[languagesArray.length];
        for (int i = 0; i < languagesArray.length; ++i) {
            languagesPathesArray[i] = "**/src/**/" + languagesArray[i] + "/**";
        }
        String excludes = "target";
        for (String defaultExclude : Arrays.asList(ListScanner.DEFAULTEXCLUDES)) {
            excludes = excludes + "," + defaultExclude + "/**";
        }
        List absoluteFiles = FileUtils.getFiles((File)basedir, (String)StringUtils.join((Object[])languagesPathesArray, (String)","), (String)excludes);
        this.getLogger().debug("Found " + absoluteFiles.size() + " potential archetype files");
        ArrayList<String> files = new ArrayList<String>(absoluteFiles.size());
        for (File file : absoluteFiles) {
            String filePath = StringUtils.prechomp((String)file.getAbsolutePath(), (String)(basedir.getAbsolutePath() + File.separator));
            String minusSrc = StringUtils.prechomp((String)filePath, (String)("src" + File.separator));
            for (int i = 0; i < languagesArray.length; ++i) {
                String language = languagesArray[i];
                if (StringUtils.countMatches((String)minusSrc, (String)(File.separator + language + File.separator)) <= 0) continue;
                String minusLanguage = StringUtils.prechomp((String)minusSrc, (String)(language + File.separator));
                files.add(this.toUnixPath(minusLanguage));
            }
        }
        this.getLogger().debug("Found " + files.size() + " archetype files for package resolution ");
        return files;
    }

    private String resolvePackage(List<String> files) {
        String packageName = null;
        for (String minusLanguage : files) {
            String filePackage = minusLanguage.indexOf("/") >= 0 ? StringUtils.replace((String)minusLanguage.substring(0, minusLanguage.lastIndexOf("/")), (String)"/", (String)".") : "";
            if (packageName == null) {
                packageName = filePackage;
                continue;
            }
            packageName = this.getCommonPackage(packageName, filePackage);
        }
        this.getLogger().debug("Package resolved to " + packageName);
        return packageName;
    }

    private String toUnixPath(String path) {
        return path.replace(File.separatorChar, '/');
    }
}

