/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.usagestats;

import java.util.Map;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.titan.common.usagestats.HttpPoster;
import org.eclipse.titan.common.usagestats.PlatformDataCollector;
import org.eclipse.titan.common.usagestats.UsageStatInfoCollector;

public class UsageStatSender {
    private static final String HOST = "ttcn.ericsson.se";
    private static final String PAGE = "/download/usage_stats/usage_stats.php";
    private static final int PORT = 80;
    private UsageStatInfoCollector infoCollector;

    public UsageStatSender(UsageStatInfoCollector infoCollector) {
        this.infoCollector = infoCollector;
    }

    public void sendSync() {
        Map<String, String> finalData = new PlatformDataCollector().collect();
        finalData.putAll(this.infoCollector.collect());
        new HttpPoster(HOST, PAGE, 80).post(finalData);
    }

    public WorkspaceJob sendAsync() {
        WorkspaceJob job = new WorkspaceJob("Sending Usage statistics"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                UsageStatSender.this.sendSync();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(50);
        job.schedule(1000L);
        return job;
    }
}

