/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import fr.inria.zvtm.glyphs.Glyph;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.claribole.zgrviewer.ColorIndicator;
import net.claribole.zgrviewer.ConfigManager;
import net.claribole.zgrviewer.GraphicsManager;
import net.claribole.zgrviewer.Plugin;
import net.claribole.zgrviewer.TextViewer;
import net.claribole.zgrviewer.Utils;
import net.claribole.zgrviewer.ZGRViewer;

class PrefWindow
extends JFrame
implements ActionListener,
MouseListener {
    ZGRViewer application;
    GraphicsManager grMngr;
    JTabbedPane tabbedPane;
    JButton okPrefs;
    JButton savePrefs;
    JCheckBox saveWindowLayoutCb;
    JCheckBox dynaspotCb;
    JCheckBox antialiascb;
    JCheckBox silentCb;
    JTextField cmdLOptsTf;
    JCheckBox sdZoomCb;
    JSlider sdZoomSlider;
    JSpinner mFactorSpinner;
    ColorIndicator highlightColor;
    JButton browseTmpDirBt;
    JButton browseGraphDirBt;
    JButton browseNeatoBt;
    JButton browseCircoBt;
    JButton browseTwopiBt;
    JButton browseDotBt;
    JButton browseFontDirBt;
    JTextField tmpDirTF;
    JTextField graphDirTF;
    JTextField neatoPathTF;
    JTextField circoPathTF;
    JTextField twopiPathTF;
    JTextField dotPathTF;
    JTextField fontDirTF;
    JCheckBox cb1;
    JRadioButton detectBrowserBt;
    JRadioButton specifyBrowserBt;
    JTextField browserPathTf;
    JTextField browserOptsTf;
    JButton brw6;
    JButton webHelpBt;
    JLabel pathLb;
    JLabel optLb;
    JCheckBox useProxyCb;
    JLabel proxyHostLb;
    JLabel proxyPortLb;
    JTextField proxyHostTf;
    JTextField proxyPortTf;
    JButton proxyHelpBt;

    PrefWindow(ZGRViewer app, GraphicsManager gm) {
        this.application = app;
        this.grMngr = gm;
        this.tabbedPane = new JTabbedPane();
        JPanel miscPane = new JPanel();
        GridBagLayout gridBag0 = new GridBagLayout();
        GridBagConstraints constraints0 = new GridBagConstraints();
        constraints0.fill = 2;
        constraints0.anchor = 17;
        miscPane.setLayout(gridBag0);
        this.saveWindowLayoutCb = new JCheckBox("Save/Restore Window Layout at Startup", ConfigManager.SAVE_WINDOW_LAYOUT);
        Utils.buildConstraints(constraints0, 0, 0, 2, 1, 100, 10);
        gridBag0.setConstraints(this.saveWindowLayoutCb, constraints0);
        miscPane.add(this.saveWindowLayoutCb);
        this.dynaspotCb = new JCheckBox("Activate DynaSpot pointing", ConfigManager.DYNASPOT);
        this.dynaspotCb.addActionListener(this);
        Utils.buildConstraints(constraints0, 0, 1, 2, 1, 100, 10);
        gridBag0.setConstraints(this.dynaspotCb, constraints0);
        miscPane.add(this.dynaspotCb);
        this.antialiascb = new JCheckBox("Antialiasing", ConfigManager.ANTIALIASING);
        this.antialiascb.addActionListener(this);
        Utils.buildConstraints(constraints0, 0, 2, 2, 1, 100, 10);
        gridBag0.setConstraints(this.antialiascb, constraints0);
        miscPane.add(this.antialiascb);
        this.silentCb = new JCheckBox("GraphViz programs should not issue warnings (v1.10 and above)", ConfigManager.FORCE_SILENT);
        this.silentCb.addActionListener(this);
        Utils.buildConstraints(constraints0, 0, 3, 2, 1, 100, 10);
        gridBag0.setConstraints(this.silentCb, constraints0);
        miscPane.add(this.silentCb);
        JLabel cmdLOptsLb = new JLabel("dot/neato command line options (-T will be ignored)");
        Utils.buildConstraints(constraints0, 0, 4, 2, 1, 100, 10);
        gridBag0.setConstraints(cmdLOptsLb, constraints0);
        miscPane.add(cmdLOptsLb);
        this.cmdLOptsTf = new JTextField(ConfigManager.CMD_LINE_OPTS);
        Utils.buildConstraints(constraints0, 0, 5, 2, 1, 100, 10);
        gridBag0.setConstraints(this.cmdLOptsTf, constraints0);
        miscPane.add(this.cmdLOptsTf);
        this.sdZoomCb = new JCheckBox("Enable speed-dependent automatic zooming");
        Utils.buildConstraints(constraints0, 0, 6, 2, 1, 100, 10);
        gridBag0.setConstraints(this.sdZoomCb, constraints0);
        miscPane.add(this.sdZoomCb);
        this.sdZoomCb.setSelected(ZGRViewer.cfgMngr.isSDZoomEnabled());
        ActionListener a31 = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean b = PrefWindow.this.sdZoomCb.isSelected();
                ZGRViewer cfr_ignored_0 = PrefWindow.this.application;
                ZGRViewer.cfgMngr.setSDZoomEnabled(b);
                PrefWindow.this.sdZoomSlider.setEnabled(b);
            }
        };
        this.sdZoomCb.addActionListener(a31);
        this.sdZoomSlider = new JSlider(2, 10, ZGRViewer.cfgMngr.getSDZoomFactor());
        this.sdZoomSlider.setLabelTable(this.sdZoomSlider.createStandardLabels(1));
        this.sdZoomSlider.setPaintLabels(true);
        this.sdZoomSlider.setPaintTicks(true);
        this.sdZoomSlider.setSnapToTicks(true);
        this.sdZoomSlider.setPaintTrack(true);
        this.sdZoomSlider.setEnabled(ZGRViewer.cfgMngr.isSDZoomEnabled());
        Utils.buildConstraints(constraints0, 0, 7, 2, 1, 100, 10);
        gridBag0.setConstraints(this.sdZoomSlider, constraints0);
        miscPane.add(this.sdZoomSlider);
        ChangeListener cl0 = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ZGRViewer cfr_ignored_0 = PrefWindow.this.application;
                ZGRViewer.cfgMngr.setSDZoomFactor(PrefWindow.this.sdZoomSlider.getValue());
            }
        };
        this.sdZoomSlider.addChangeListener(cl0);
        JLabel mFactorLabel = new JLabel("Magnification factor when focusing on a node");
        Utils.buildConstraints(constraints0, 0, 8, 1, 1, 60, 10);
        gridBag0.setConstraints(mFactorLabel, constraints0);
        miscPane.add(mFactorLabel);
        this.mFactorSpinner = new JSpinner(new SpinnerNumberModel(ConfigManager.MAG_FACTOR, 0.1, 10.0, 0.1));
        Utils.buildConstraints(constraints0, 1, 8, 1, 1, 40, 0);
        gridBag0.setConstraints(this.mFactorSpinner, constraints0);
        miscPane.add(this.mFactorSpinner);
        JLabel highlightLb = new JLabel("Color of highlighted elements");
        Utils.buildConstraints(constraints0, 0, 9, 1, 1, 60, 10);
        gridBag0.setConstraints(highlightLb, constraints0);
        miscPane.add(highlightLb);
        this.highlightColor = new ColorIndicator(ConfigManager.HIGHLIGHT_COLOR);
        Utils.buildConstraints(constraints0, 1, 9, 1, 1, 40, 0);
        gridBag0.setConstraints(this.highlightColor, constraints0);
        miscPane.add(this.highlightColor);
        this.highlightColor.addMouseListener(this);
        JPanel p1 = new JPanel();
        Utils.buildConstraints(constraints0, 0, 10, 1, 1, 100, 50);
        gridBag0.setConstraints(p1, constraints0);
        miscPane.add(p1);
        this.tabbedPane.addTab("Misc.", miscPane);
        FocusListener fl0 = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                Object src = e.getSource();
                if (src == PrefWindow.this.tmpDirTF) {
                    File fl = new File(PrefWindow.this.tmpDirTF.getText().trim());
                    if (fl.exists()) {
                        if (fl.isDirectory()) {
                            ConfigManager.m_TmpDir = fl;
                        } else {
                            JOptionPane.showMessageDialog(PrefWindow.this, "The specified path does not point to a directory:\n" + PrefWindow.this.tmpDirTF.getText());
                        }
                    } else {
                        JOptionPane.showMessageDialog(PrefWindow.this, "This path does not point to any existing file or directory:\n" + PrefWindow.this.tmpDirTF.getText());
                    }
                } else if (src == PrefWindow.this.graphDirTF) {
                    File fl = new File(PrefWindow.this.graphDirTF.getText().trim());
                    if (fl.exists()) {
                        if (fl.isDirectory()) {
                            ConfigManager.m_PrjDir = fl;
                        } else {
                            JOptionPane.showMessageDialog(PrefWindow.this, "The specified path does not point to a directory:\n" + PrefWindow.this.graphDirTF.getText());
                        }
                    } else {
                        JOptionPane.showMessageDialog(PrefWindow.this, "This path does not point to any existing file or directory:\n" + PrefWindow.this.graphDirTF.getText());
                    }
                } else if (src == PrefWindow.this.neatoPathTF) {
                    File fl = new File(PrefWindow.this.neatoPathTF.getText().trim());
                    if (fl.exists()) {
                        if (fl.isFile()) {
                            ConfigManager.m_NeatoPath = fl;
                        } else {
                            JOptionPane.showMessageDialog(PrefWindow.this, "The specified path does not point to a directory:\n" + PrefWindow.this.neatoPathTF.getText());
                        }
                    } else {
                        JOptionPane.showMessageDialog(PrefWindow.this, "This path does not point to any existing file or directory:\n" + PrefWindow.this.neatoPathTF.getText());
                    }
                } else if (src == PrefWindow.this.circoPathTF) {
                    File fl = new File(PrefWindow.this.circoPathTF.getText().trim());
                    if (fl.exists()) {
                        if (fl.isFile()) {
                            ConfigManager.m_CircoPath = fl;
                        } else {
                            JOptionPane.showMessageDialog(PrefWindow.this, "The specified path does not point to a directory:\n" + PrefWindow.this.circoPathTF.getText());
                        }
                    } else {
                        JOptionPane.showMessageDialog(PrefWindow.this, "This path does not point to any existing file or directory:\n" + PrefWindow.this.circoPathTF.getText());
                    }
                } else if (src == PrefWindow.this.twopiPathTF) {
                    File fl = new File(PrefWindow.this.twopiPathTF.getText().trim());
                    if (fl.exists()) {
                        if (fl.isFile()) {
                            ConfigManager.m_TwopiPath = fl;
                        } else {
                            JOptionPane.showMessageDialog(PrefWindow.this, "The specified path does not point to a directory:\n" + PrefWindow.this.twopiPathTF.getText());
                        }
                    } else {
                        JOptionPane.showMessageDialog(PrefWindow.this, "This path does not point to any existing file or directory:\n" + PrefWindow.this.twopiPathTF.getText());
                    }
                } else if (src == PrefWindow.this.dotPathTF) {
                    File fl = new File(PrefWindow.this.dotPathTF.getText().trim());
                    if (fl.exists()) {
                        if (fl.isFile()) {
                            ConfigManager.m_DotPath = fl;
                        } else {
                            JOptionPane.showMessageDialog(PrefWindow.this, "The specified path does not point to a file:\n" + PrefWindow.this.dotPathTF.getText());
                        }
                    } else {
                        JOptionPane.showMessageDialog(PrefWindow.this, "This path does not point to any existing file or directory:\n" + PrefWindow.this.dotPathTF.getText());
                    }
                } else if (src == PrefWindow.this.fontDirTF) {
                    File fl = new File(PrefWindow.this.fontDirTF.getText().trim());
                    if (fl.exists()) {
                        if (fl.isDirectory()) {
                            ConfigManager.m_GraphVizFontDir = fl;
                        } else {
                            JOptionPane.showMessageDialog(PrefWindow.this, "The specified path does not point to a directory:\n" + PrefWindow.this.fontDirTF.getText());
                        }
                    } else {
                        JOptionPane.showMessageDialog(PrefWindow.this, "This path does not point to any existing file or directory:\n" + PrefWindow.this.fontDirTF.getText());
                    }
                }
            }
        };
        JPanel dirPane = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 17;
        dirPane.setLayout(gridBag);
        JLabel l1 = new JLabel("Temporary directory");
        Utils.buildConstraints(constraints, 0, 0, 1, 1, 60, 10);
        gridBag.setConstraints(l1, constraints);
        dirPane.add(l1);
        this.cb1 = new JCheckBox("Delete temp files on exit");
        Utils.buildConstraints(constraints, 1, 0, 1, 1, 30, 0);
        gridBag.setConstraints(this.cb1, constraints);
        if (ConfigManager.DELETE_TEMP_FILES) {
            this.cb1.setSelected(true);
        } else {
            this.cb1.setSelected(false);
        }
        this.cb1.addActionListener(this);
        dirPane.add(this.cb1);
        this.browseTmpDirBt = new JButton("Browse...");
        Utils.buildConstraints(constraints, 2, 0, 1, 1, 10, 0);
        gridBag.setConstraints(this.browseTmpDirBt, constraints);
        this.browseTmpDirBt.addActionListener(this);
        dirPane.add(this.browseTmpDirBt);
        this.tmpDirTF = new JTextField(ConfigManager.m_TmpDir.toString());
        Utils.buildConstraints(constraints, 0, 1, 3, 1, 100, 10);
        gridBag.setConstraints(this.tmpDirTF, constraints);
        dirPane.add(this.tmpDirTF);
        this.tmpDirTF.addFocusListener(fl0);
        JLabel l2 = new JLabel("DOT files directory");
        Utils.buildConstraints(constraints, 0, 2, 2, 1, 90, 10);
        gridBag.setConstraints(l2, constraints);
        dirPane.add(l2);
        this.browseGraphDirBt = new JButton("Browse...");
        Utils.buildConstraints(constraints, 2, 2, 1, 1, 10, 0);
        gridBag.setConstraints(this.browseGraphDirBt, constraints);
        this.browseGraphDirBt.addActionListener(this);
        dirPane.add(this.browseGraphDirBt);
        this.graphDirTF = new JTextField(ConfigManager.m_PrjDir.toString());
        Utils.buildConstraints(constraints, 0, 3, 3, 1, 100, 10);
        gridBag.setConstraints(this.graphDirTF, constraints);
        dirPane.add(this.graphDirTF);
        this.graphDirTF.addFocusListener(fl0);
        JLabel l4 = new JLabel("GraphViz/dot executable");
        Utils.buildConstraints(constraints, 0, 4, 2, 1, 90, 10);
        gridBag.setConstraints(l4, constraints);
        dirPane.add(l4);
        this.browseDotBt = new JButton("Browse...");
        Utils.buildConstraints(constraints, 2, 4, 1, 1, 10, 0);
        gridBag.setConstraints(this.browseDotBt, constraints);
        this.browseDotBt.addActionListener(this);
        dirPane.add(this.browseDotBt);
        this.dotPathTF = new JTextField(ConfigManager.m_DotPath.toString());
        Utils.buildConstraints(constraints, 0, 5, 3, 1, 100, 10);
        gridBag.setConstraints(this.dotPathTF, constraints);
        dirPane.add(this.dotPathTF);
        this.dotPathTF.addFocusListener(fl0);
        JLabel l3 = new JLabel("GraphViz/neato executable");
        Utils.buildConstraints(constraints, 0, 6, 2, 1, 90, 10);
        gridBag.setConstraints(l3, constraints);
        dirPane.add(l3);
        this.browseNeatoBt = new JButton("Browse...");
        Utils.buildConstraints(constraints, 2, 6, 1, 1, 10, 0);
        gridBag.setConstraints(this.browseNeatoBt, constraints);
        this.browseNeatoBt.addActionListener(this);
        dirPane.add(this.browseNeatoBt);
        this.neatoPathTF = new JTextField(ConfigManager.m_NeatoPath.toString());
        Utils.buildConstraints(constraints, 0, 7, 3, 1, 100, 10);
        gridBag.setConstraints(this.neatoPathTF, constraints);
        dirPane.add(this.neatoPathTF);
        this.neatoPathTF.addFocusListener(fl0);
        JLabel l3b = new JLabel("GraphViz/circo executable");
        Utils.buildConstraints(constraints, 0, 8, 2, 1, 90, 10);
        gridBag.setConstraints(l3b, constraints);
        dirPane.add(l3b);
        this.browseCircoBt = new JButton("Browse...");
        Utils.buildConstraints(constraints, 2, 8, 1, 1, 10, 0);
        gridBag.setConstraints(this.browseCircoBt, constraints);
        this.browseCircoBt.addActionListener(this);
        dirPane.add(this.browseCircoBt);
        this.circoPathTF = new JTextField(ConfigManager.m_CircoPath.toString());
        Utils.buildConstraints(constraints, 0, 9, 3, 1, 100, 10);
        gridBag.setConstraints(this.circoPathTF, constraints);
        dirPane.add(this.circoPathTF);
        this.circoPathTF.addFocusListener(fl0);
        JLabel l3c = new JLabel("GraphViz/twopi executable");
        Utils.buildConstraints(constraints, 0, 10, 2, 1, 90, 10);
        gridBag.setConstraints(l3c, constraints);
        dirPane.add(l3c);
        this.browseTwopiBt = new JButton("Browse...");
        Utils.buildConstraints(constraints, 2, 10, 1, 1, 10, 0);
        gridBag.setConstraints(this.browseTwopiBt, constraints);
        this.browseTwopiBt.addActionListener(this);
        dirPane.add(this.browseTwopiBt);
        this.twopiPathTF = new JTextField(ConfigManager.m_TwopiPath.toString());
        Utils.buildConstraints(constraints, 0, 11, 3, 1, 100, 10);
        gridBag.setConstraints(this.twopiPathTF, constraints);
        dirPane.add(this.twopiPathTF);
        this.twopiPathTF.addFocusListener(fl0);
        JLabel l5 = new JLabel("GraphViz font directory (optional)");
        Utils.buildConstraints(constraints, 0, 12, 2, 1, 90, 10);
        gridBag.setConstraints(l5, constraints);
        dirPane.add(l5);
        this.browseFontDirBt = new JButton("Browse...");
        Utils.buildConstraints(constraints, 2, 12, 1, 1, 10, 0);
        gridBag.setConstraints(this.browseFontDirBt, constraints);
        this.browseFontDirBt.addActionListener(this);
        dirPane.add(this.browseFontDirBt);
        this.fontDirTF = new JTextField(ConfigManager.m_GraphVizFontDir.toString());
        Utils.buildConstraints(constraints, 0, 13, 3, 1, 100, 10);
        gridBag.setConstraints(this.fontDirTF, constraints);
        dirPane.add(this.fontDirTF);
        this.fontDirTF.addFocusListener(fl0);
        JScrollPane dirSP = new JScrollPane(dirPane);
        dirSP.setVerticalScrollBarPolicy(20);
        dirSP.setHorizontalScrollBarPolicy(30);
        this.tabbedPane.addTab("Directories", dirSP);
        JPanel webPane = new JPanel();
        GridBagLayout gridBag2 = new GridBagLayout();
        GridBagConstraints constraints2 = new GridBagConstraints();
        constraints2.fill = 2;
        constraints2.anchor = 17;
        webPane.setLayout(gridBag2);
        ButtonGroup bg2 = new ButtonGroup();
        this.detectBrowserBt = new JRadioButton("Automatically Detect Default Browser");
        Utils.buildConstraints(constraints2, 0, 0, 3, 1, 100, 1);
        gridBag2.setConstraints(this.detectBrowserBt, constraints2);
        this.detectBrowserBt.addActionListener(this);
        bg2.add(this.detectBrowserBt);
        webPane.add(this.detectBrowserBt);
        this.specifyBrowserBt = new JRadioButton("Specify Browser:");
        Utils.buildConstraints(constraints2, 0, 1, 3, 1, 100, 1);
        gridBag2.setConstraints(this.specifyBrowserBt, constraints2);
        this.specifyBrowserBt.addActionListener(this);
        bg2.add(this.specifyBrowserBt);
        webPane.add(this.specifyBrowserBt);
        JPanel p7 = new JPanel();
        Utils.buildConstraints(constraints2, 0, 2, 1, 1, 10, 1);
        gridBag2.setConstraints(p7, constraints2);
        webPane.add(p7);
        this.pathLb = new JLabel("Path");
        Utils.buildConstraints(constraints2, 1, 2, 1, 1, 80, 0);
        gridBag2.setConstraints(this.pathLb, constraints2);
        webPane.add(this.pathLb);
        this.brw6 = new JButton("Browse...");
        Utils.buildConstraints(constraints2, 2, 2, 1, 1, 10, 0);
        gridBag2.setConstraints(this.brw6, constraints2);
        this.brw6.addActionListener(this);
        webPane.add(this.brw6);
        this.browserPathTf = new JTextField(ConfigManager.browserPath.toString());
        Utils.buildConstraints(constraints2, 1, 3, 2, 1, 90, 1);
        gridBag2.setConstraints(this.browserPathTf, constraints2);
        webPane.add(this.browserPathTf);
        this.optLb = new JLabel("Command Line Options");
        Utils.buildConstraints(constraints2, 1, 4, 2, 1, 90, 1);
        gridBag2.setConstraints(this.optLb, constraints2);
        webPane.add(this.optLb);
        this.browserOptsTf = new JTextField(ConfigManager.browserOptions);
        Utils.buildConstraints(constraints2, 1, 5, 2, 1, 90, 1);
        gridBag2.setConstraints(this.browserOptsTf, constraints2);
        webPane.add(this.browserOptsTf);
        JPanel p8 = new JPanel();
        Utils.buildConstraints(constraints2, 0, 6, 3, 1, 100, 92);
        gridBag2.setConstraints(p8, constraints2);
        webPane.add(p8);
        this.webHelpBt = new JButton("Help");
        Utils.buildConstraints(constraints2, 2, 7, 1, 1, 10, 1);
        gridBag2.setConstraints(this.webHelpBt, constraints2);
        this.webHelpBt.addActionListener(this);
        webPane.add(this.webHelpBt);
        if (ConfigManager.autoDetectBrowser) {
            this.detectBrowserBt.doClick();
        } else {
            this.specifyBrowserBt.doClick();
        }
        this.tabbedPane.addTab("Web Browser", webPane);
        JPanel proxyPane = new JPanel();
        GridBagLayout gridBag5 = new GridBagLayout();
        GridBagConstraints constraints5 = new GridBagConstraints();
        constraints5.fill = 2;
        constraints5.anchor = 17;
        proxyPane.setLayout(gridBag5);
        this.useProxyCb = new JCheckBox("Use Proxy Server");
        Utils.buildConstraints(constraints5, 0, 0, 2, 1, 100, 1);
        gridBag5.setConstraints(this.useProxyCb, constraints5);
        this.useProxyCb.setSelected(ConfigManager.useProxy);
        this.useProxyCb.addActionListener(this);
        proxyPane.add(this.useProxyCb);
        this.proxyHostLb = new JLabel("Hostname:");
        this.proxyHostLb.setEnabled(ConfigManager.useProxy);
        Utils.buildConstraints(constraints5, 0, 1, 1, 1, 80, 1);
        gridBag5.setConstraints(this.proxyHostLb, constraints5);
        proxyPane.add(this.proxyHostLb);
        this.proxyPortLb = new JLabel("Port:");
        this.proxyPortLb.setEnabled(ConfigManager.useProxy);
        Utils.buildConstraints(constraints5, 1, 1, 1, 1, 20, 1);
        gridBag5.setConstraints(this.proxyPortLb, constraints5);
        proxyPane.add(this.proxyPortLb);
        this.proxyHostTf = new JTextField(ConfigManager.proxyHost);
        this.proxyHostTf.setEnabled(ConfigManager.useProxy);
        Utils.buildConstraints(constraints5, 0, 2, 1, 1, 80, 1);
        gridBag5.setConstraints(this.proxyHostTf, constraints5);
        proxyPane.add(this.proxyHostTf);
        this.proxyPortTf = new JTextField(ConfigManager.proxyPort);
        this.proxyPortTf.setEnabled(ConfigManager.useProxy);
        Utils.buildConstraints(constraints5, 1, 2, 1, 1, 20, 1);
        gridBag5.setConstraints(this.proxyPortTf, constraints5);
        proxyPane.add(this.proxyPortTf);
        constraints5.fill = 1;
        constraints5.anchor = 10;
        JPanel p1000 = new JPanel();
        Utils.buildConstraints(constraints5, 0, 5, 2, 1, 100, 90);
        gridBag5.setConstraints(p1000, constraints5);
        proxyPane.add(p1000);
        constraints5.fill = 0;
        constraints5.anchor = 13;
        this.proxyHelpBt = new JButton("Help");
        Utils.buildConstraints(constraints5, 1, 6, 1, 1, 20, 1);
        gridBag5.setConstraints(this.proxyHelpBt, constraints5);
        this.proxyHelpBt.addActionListener(this);
        proxyPane.add(this.proxyHelpBt);
        this.tabbedPane.addTab("Proxy", proxyPane);
        this.tabbedPane.addTab("Plugins", this.initPluginPane());
        Container cpane = this.getContentPane();
        GridBagLayout gridBag3 = new GridBagLayout();
        GridBagConstraints constraints3 = new GridBagConstraints();
        constraints3.fill = 1;
        constraints3.anchor = 17;
        cpane.setLayout(gridBag3);
        Utils.buildConstraints(constraints3, 0, 0, 3, 1, 100, 90);
        gridBag3.setConstraints(this.tabbedPane, constraints3);
        cpane.add(this.tabbedPane);
        JPanel tmp = new JPanel();
        Utils.buildConstraints(constraints3, 0, 1, 1, 1, 70, 10);
        gridBag3.setConstraints(tmp, constraints3);
        cpane.add(tmp);
        constraints3.fill = 2;
        constraints3.anchor = 10;
        this.okPrefs = new JButton("Apply & Close");
        Utils.buildConstraints(constraints3, 1, 1, 1, 1, 15, 10);
        gridBag3.setConstraints(this.okPrefs, constraints3);
        this.okPrefs.addActionListener(this);
        cpane.add(this.okPrefs);
        constraints3.fill = 2;
        constraints3.anchor = 10;
        this.savePrefs = new JButton("Save");
        Utils.buildConstraints(constraints3, 2, 1, 1, 1, 15, 10);
        gridBag3.setConstraints(this.savePrefs, constraints3);
        this.savePrefs.addActionListener(this);
        cpane.add(this.savePrefs);
        this.tabbedPane.setSelectedIndex(0);
        WindowAdapter w0 = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
            }
        };
        this.addWindowListener(w0);
        this.setTitle("Preferences");
        this.pack();
        this.setSize(400, 360);
    }

    private JComponent initPluginPane() {
        JPanel pluginPane = new JPanel();
        int nbPlugins = ZGRViewer.cfgMngr.plugins.length;
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 0;
        pluginPane.setLayout(gridBag);
        int row = 0;
        for (int i = 0; i < nbPlugins; ++i) {
            row = i * 2;
            constraints.anchor = 17;
            final String url = ZGRViewer.cfgMngr.plugins[i].getURL() != null ? ZGRViewer.cfgMngr.plugins[i].getURL().toString() : "";
            JLabel l65 = new JLabel("<html><a href=\"" + url + "\">" + ZGRViewer.cfgMngr.plugins[i].getName() + "</a></html>");
            Utils.buildConstraints(constraints, 0, row, 1, 1, 70, 5);
            gridBag.setConstraints(l65, constraints);
            pluginPane.add(l65);
            MouseListener m65 = new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                    if (url != null && url.length() > 0) {
                        PrefWindow.this.application.displayURLinBrowser(url);
                    }
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }
            };
            l65.addMouseListener(m65);
            constraints.anchor = 13;
            JButton b65 = new JButton("Settings...");
            Utils.buildConstraints(constraints, 1, row, 1, 1, 30, 0);
            gridBag.setConstraints(b65, constraints);
            pluginPane.add(b65);
            final Plugin pg65 = ZGRViewer.cfgMngr.plugins[i];
            ActionListener a65 = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    pg65.showSettings();
                }
            };
            b65.addActionListener(a65);
            constraints.anchor = 17;
            l65 = new JLabel("Author: " + ZGRViewer.cfgMngr.plugins[i].getAuthor());
            Utils.buildConstraints(constraints, 0, row + 1, 1, 1, 0, 5);
            gridBag.setConstraints(l65, constraints);
            pluginPane.add(l65);
            constraints.anchor = 13;
            l65 = new JLabel("Version: " + ZGRViewer.cfgMngr.plugins[i].getVersion());
            Utils.buildConstraints(constraints, 0, row + 1, 1, 1, 0, 0);
            gridBag.setConstraints(l65, constraints);
            pluginPane.add(l65);
        }
        JPanel p47 = new JPanel();
        constraints.fill = 1;
        constraints.anchor = 17;
        Utils.buildConstraints(constraints, 0, row + 2, 2, 1, 100, 90);
        gridBag.setConstraints(p47, constraints);
        pluginPane.add(p47);
        return new JScrollPane(pluginPane, 20, 30);
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.browseTmpDirBt) {
            JFileChooser fc = new JFileChooser(ConfigManager.m_TmpDir);
            fc.setFileSelectionMode(1);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                ConfigManager.m_TmpDir = fc.getSelectedFile();
                this.tmpDirTF.setText(ConfigManager.m_TmpDir.toString());
            }
        } else if (o == this.browseGraphDirBt) {
            JFileChooser fc = new JFileChooser(ConfigManager.m_PrjDir);
            fc.setFileSelectionMode(1);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                ConfigManager.m_PrjDir = fc.getSelectedFile();
                this.graphDirTF.setText(ConfigManager.m_PrjDir.toString());
            }
        } else if (o == this.browseDotBt) {
            JFileChooser fc = new JFileChooser(ConfigManager.m_DotPath);
            fc.setFileSelectionMode(0);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                ConfigManager.m_DotPath = fc.getSelectedFile();
                this.dotPathTF.setText(ConfigManager.m_DotPath.toString());
            }
        } else if (o == this.browseNeatoBt) {
            JFileChooser fc = new JFileChooser(ConfigManager.m_NeatoPath);
            fc.setFileSelectionMode(0);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                ConfigManager.m_NeatoPath = fc.getSelectedFile();
                this.neatoPathTF.setText(ConfigManager.m_NeatoPath.toString());
            }
        } else if (o == this.browseCircoBt) {
            JFileChooser fc = new JFileChooser(ConfigManager.m_CircoPath);
            fc.setFileSelectionMode(0);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                ConfigManager.m_CircoPath = fc.getSelectedFile();
                this.circoPathTF.setText(ConfigManager.m_CircoPath.toString());
            }
        } else if (o == this.browseTwopiBt) {
            JFileChooser fc = new JFileChooser(ConfigManager.m_TwopiPath);
            fc.setFileSelectionMode(0);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                ConfigManager.m_TwopiPath = fc.getSelectedFile();
                this.twopiPathTF.setText(ConfigManager.m_TwopiPath.toString());
            }
        } else if (o == this.browseFontDirBt) {
            JFileChooser fc = new JFileChooser(ConfigManager.m_GraphVizFontDir);
            fc.setFileSelectionMode(1);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                ConfigManager.m_GraphVizFontDir = fc.getSelectedFile();
                this.fontDirTF.setText(ConfigManager.m_GraphVizFontDir.toString());
            }
        } else if (o == this.cb1) {
            ConfigManager.DELETE_TEMP_FILES = this.cb1.isSelected();
        } else if (o == this.detectBrowserBt) {
            if (this.detectBrowserBt.isSelected()) {
                ConfigManager.autoDetectBrowser = true;
                this.browserPathTf.setEnabled(false);
                this.brw6.setEnabled(false);
                this.browserOptsTf.setEnabled(false);
                this.pathLb.setEnabled(false);
                this.optLb.setEnabled(false);
            }
        } else if (o == this.specifyBrowserBt) {
            if (this.specifyBrowserBt.isSelected()) {
                ConfigManager.autoDetectBrowser = false;
                this.browserPathTf.setEnabled(true);
                this.brw6.setEnabled(true);
                this.browserOptsTf.setEnabled(true);
                this.pathLb.setEnabled(true);
                this.optLb.setEnabled(true);
            }
        } else if (o == this.brw6) {
            JFileChooser fc = new JFileChooser(ConfigManager.browserPath);
            fc.setFileSelectionMode(0);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                ConfigManager.browserPath = fc.getSelectedFile();
                this.browserPathTf.setText(ConfigManager.browserPath.toString());
            }
        } else if (o == this.webHelpBt) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            TextViewer help = new TextViewer(new StringBuffer("--------------------------------------\nAUTOMATIC DETECTION\n--------------------------------------\nZGRViewer can try to automatically detect your default web browser.\nThis feature is currently supported under Windows and some POSIX environments.\n\n--------------------------------------\nMANUAL CONFIGURATION\n--------------------------------------\nThe Path value should be the full command line path to your browser's main executable file. It can also be just this file's name if its parent directory is in your PATH environment variable.\n\nExamples:\nmozilla\n/usr/bin/mozilla\nC:\\Program Files\\Internet Explorer\\IEXPLORE.EXE\n\nThe Command Line Options value is an optional field where you can put command line switches, like -remote for the UNIX version of Netscape that will open URLs in an already existing Netscape process (if it exists).\n\nUnder Mac OS X, you can simply use\nopen\nor\nopen -a Safari"), "Web Browser Configuration", 0, (screenSize.width - 400) / 2, (screenSize.height - 300) / 2, 400, 300, false);
        } else if (o == this.useProxyCb) {
            this.proxyHostLb.setEnabled(this.useProxyCb.isSelected());
            this.proxyPortLb.setEnabled(this.useProxyCb.isSelected());
            this.proxyHostTf.setEnabled(this.useProxyCb.isSelected());
            this.proxyPortTf.setEnabled(this.useProxyCb.isSelected());
        } else if (o == this.proxyHelpBt) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            TextViewer help = new TextViewer(new StringBuffer("If you are behind a firewall, you can manually set the proxy server to access remote resources.\n\nHostname should be the full name of the proxy server.\n\nPort should be the port number used to access external resources. This is a number (default value is 80)."), "Proxy Configuration", 0, (screenSize.width - 400) / 2, (screenSize.height - 300) / 2, 400, 300, false);
        } else if (o == this.okPrefs) {
            this.updateVars();
            this.dispose();
        } else if (o == this.savePrefs) {
            this.updateVars();
            this.application.saveConfiguration();
        } else if (o == this.antialiascb) {
            if (this.antialiascb.isSelected()) {
                JOptionPane.showMessageDialog(this, "Antialiasing requires additional computing resources.\nSetting it ON will noticeably reduce the refresh rate.");
            }
            this.grMngr.setAntialiasing(this.antialiascb.isSelected());
        } else if (o == this.dynaspotCb) {
            this.grMngr.activateDynaSpot(this.dynaspotCb.isSelected(), true);
        }
    }

    public void mouseClicked(MouseEvent e) {
        Color newCol;
        Object o = e.getSource();
        if (o == this.highlightColor && (newCol = JColorChooser.showDialog(this, "Highlight Color", this.highlightColor.getColor())) != null) {
            ConfigManager.HIGHLIGHT_COLOR = newCol;
            this.highlightColor.setColor(ConfigManager.HIGHLIGHT_COLOR);
            Glyph.setDefaultCursorInsideHighlightColor(ConfigManager.HIGHLIGHT_COLOR);
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    void updateVars() {
        ConfigManager.SAVE_WINDOW_LAYOUT = this.saveWindowLayoutCb.isSelected();
        ConfigManager.FORCE_SILENT = this.silentCb.isSelected();
        ConfigManager.MAG_FACTOR = ((Double)this.mFactorSpinner.getValue()).floatValue();
        ConfigManager.CMD_LINE_OPTS = this.cmdLOptsTf.getText();
        ConfigManager.browserPath = new File(this.browserPathTf.getText());
        ConfigManager.browserOptions = this.browserOptsTf.getText();
        ConfigManager.updateProxy(this.useProxyCb.isSelected(), this.proxyHostTf.getText(), this.proxyPortTf.getText());
    }
}

