/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.resource.spi.Connector;
import jakarta.servlet.annotation.WebServlet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationHandler;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.AnnotationUtils;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.glassfish.internal.deployment.AnnotationTypesProvider;
import org.jvnet.hk2.annotations.Optional;

public abstract class AbstractHandler
implements AnnotationHandler {
    protected static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(AbstractHandler.class);
    protected static final Logger logger = AnnotationUtils.getLogger();
    @Inject
    @Named(value="EJB")
    @Optional
    protected AnnotationTypesProvider ejbProvider;

    public final Class<? extends Annotation> getAnnotationType() {
        return this.getClass().getAnnotation(AnnotationHandlerFor.class).value();
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return null;
    }

    protected HandlerProcessingResult getDefaultProcessedResult() {
        return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
    }

    protected HandlerProcessingResult getDefaultFailedResult() {
        return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.FAILED);
    }

    protected HandlerProcessingResult getInvalidAnnotatedElementHandlerResult(AnnotatedElementHandler aeHandler, AnnotationInfo ainfo) throws AnnotationProcessorException {
        if (logger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, ainfo, I18N.getLocalString("enterprise.deployment.annotation.handlers.invalidaehandler", "Invalid annotation symbol found for this type of class."));
        }
        logger.log(Level.FINER, "Invalid AnnotatedElementHandler: {0}", aeHandler);
        return this.getDefaultProcessedResult();
    }

    protected void log(Level level, AnnotationInfo ainfo, String localizedMessage) throws AnnotationProcessorException {
        if (Level.SEVERE.equals(level)) {
            ainfo.getProcessingContext().getErrorHandler().error(new AnnotationProcessorException(localizedMessage, ainfo));
        } else if (Level.WARNING.equals(level)) {
            ainfo.getProcessingContext().getErrorHandler().warning(new AnnotationProcessorException(localizedMessage, ainfo));
        } else if (Level.FINE.equals(level)) {
            ainfo.getProcessingContext().getErrorHandler().fine(new AnnotationProcessorException(localizedMessage, ainfo));
        } else if (ainfo != null) {
            ainfo.getProcessingContext().getProcessor().log(level, ainfo, localizedMessage);
        } else {
            logger.log(level, localizedMessage);
        }
    }

    protected String getInjectionMethodPropertyName(Method method, AnnotationInfo ainfo) throws AnnotationProcessorException {
        String methodName = method.getName();
        if (methodName.length() > 3 && methodName.startsWith("set")) {
            return methodName.substring(3, 4).toLowerCase(Locale.US) + methodName.substring(4);
        }
        throw new AnnotationProcessorException(I18N.getLocalString("enterprise.deployment.annotation.handlers.invalidinjectionmethodname", "Injection method name must start with \"set\""), ainfo);
    }

    protected void validateInjectionMethod(Method method, AnnotationInfo ainfo) throws AnnotationProcessorException {
        if (method.getParameterTypes().length != 1) {
            throw new AnnotationProcessorException(I18N.getLocalString("enterprise.deployment.annotation.handlers.invalidinjectionmethod", "Injection on a method requires a JavaBeans setter method type with one parameter "), ainfo);
        }
        if (!Void.TYPE.equals(method.getReturnType())) {
            throw new AnnotationProcessorException(I18N.getLocalString("enterprise.deployment.annotation.handlers.injectionmethodmustreturnvoid", "Injection on a method requires a void return type"), ainfo);
        }
    }

    protected HandlerProcessingResult getOverallProcessingResult(List<HandlerProcessingResult> resultList) {
        HandlerProcessingResult overallProcessingResult = null;
        for (HandlerProcessingResult result : resultList) {
            if (overallProcessingResult != null && result.getOverallResult().compareTo((Enum)overallProcessingResult.getOverallResult()) <= 0) continue;
            overallProcessingResult = result;
        }
        return overallProcessingResult;
    }

    protected Class<? extends Annotation>[] getEjbAnnotationTypes() {
        if (this.ejbProvider == null) {
            return new Class[0];
        }
        return this.ejbProvider.getAnnotationTypes();
    }

    protected Class<? extends Annotation>[] getEjbAndWebAnnotationTypes() {
        Class<? extends Annotation>[] weTypes = null;
        Class<? extends Annotation>[] ejbTypes = this.getEjbAnnotationTypes();
        Class<? extends Annotation>[] webTypes = this.getWebAnnotationTypes();
        if (ejbTypes.length > 0) {
            weTypes = new Class[ejbTypes.length + webTypes.length];
            System.arraycopy(ejbTypes, 0, weTypes, 0, ejbTypes.length);
            System.arraycopy(webTypes, 0, weTypes, ejbTypes.length, webTypes.length);
        } else {
            weTypes = webTypes;
        }
        return weTypes;
    }

    protected Class<? extends Annotation>[] getWebAnnotationTypes() {
        return new Class[]{WebServlet.class};
    }

    protected Class<? extends Annotation>[] getConnectorAnnotationTypes() {
        return new Class[]{Connector.class};
    }
}

