/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import jakarta.websocket.CloseReason;

public enum CloseReasons {
    NORMAL_CLOSURE((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Normal closure."),
    GOING_AWAY((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "Going away."),
    PROTOCOL_ERROR((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, "Protocol error."),
    CANNOT_ACCEPT((CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, "Cannot accept."),
    RESERVED((CloseReason.CloseCode)CloseReason.CloseCodes.RESERVED, "Reserved."),
    NO_STATUS_CODE((CloseReason.CloseCode)CloseReason.CloseCodes.NO_STATUS_CODE, "No status code."),
    CLOSED_ABNORMALLY((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, "Closed abnormally."),
    NOT_CONSISTENT((CloseReason.CloseCode)CloseReason.CloseCodes.NOT_CONSISTENT, "Not consistent."),
    VIOLATED_POLICY((CloseReason.CloseCode)CloseReason.CloseCodes.VIOLATED_POLICY, "Violated policy."),
    TOO_BIG((CloseReason.CloseCode)CloseReason.CloseCodes.TOO_BIG, "Too big."),
    NO_EXTENSION((CloseReason.CloseCode)CloseReason.CloseCodes.NO_EXTENSION, "No extension."),
    UNEXPECTED_CONDITION((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, "Unexpected condition."),
    SERVICE_RESTART((CloseReason.CloseCode)CloseReason.CloseCodes.SERVICE_RESTART, "Service restart."),
    TRY_AGAIN_LATER((CloseReason.CloseCode)CloseReason.CloseCodes.TRY_AGAIN_LATER, "Try again later."),
    TLS_HANDSHAKE_FAILURE((CloseReason.CloseCode)CloseReason.CloseCodes.TLS_HANDSHAKE_FAILURE, "TLS handshake failure.");

    private final CloseReason closeReason;

    private CloseReasons(CloseReason.CloseCode closeCode, String reasonPhrase) {
        this.closeReason = new CloseReason(closeCode, reasonPhrase);
    }

    public CloseReason getCloseReason() {
        return this.closeReason;
    }
}

