/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import jakarta.servlet.ServletContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.LifecycleSupport;

public class StandardManager
extends ManagerBase
implements Lifecycle,
PropertyChangeListener {
    private static final String info = "StandardManager/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private int maxActiveSessions = -1;
    protected static final String name = "StandardManager";
    private String pathname = "SESSIONS.ser";
    private boolean started = false;
    private String absPathName;
    long processingTime = 0L;

    @Override
    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener(this);
        }
        super.setContainer(container);
        if (this.container != null && this.container instanceof Context) {
            this.setMaxInactiveIntervalSeconds(((Context)this.container).getSessionTimeout() * 60);
            ((Context)this.container).addPropertyChangeListener(this);
        }
    }

    @Override
    public String getInfo() {
        return info;
    }

    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setProcessingTime(long processingTime) {
        this.processingTime = processingTime;
    }

    public void setMaxActiveSessions(int max) {
        int oldMaxActiveSessions = this.maxActiveSessions;
        this.maxActiveSessions = max;
        this.support.firePropertyChange("maxActiveSessions", (Object)oldMaxActiveSessions, (Object)this.maxActiveSessions);
    }

    @Override
    public String getName() {
        return name;
    }

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String pathname) {
        String oldPathname = this.pathname;
        this.pathname = pathname;
        this.support.firePropertyChange("pathname", oldPathname, this.pathname);
    }

    @Override
    public Session createSession() {
        if (this.maxActiveSessions >= 0 && this.sessions.size() >= this.maxActiveSessions) {
            ++this.rejectedSessions;
            ((StandardContext)this.container).sessionRejectedEvent(this.maxActiveSessions);
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00381"));
        }
        return super.createSession();
    }

    @Override
    public Session createSession(String sessionId) {
        if (this.maxActiveSessions >= 0 && this.sessions.size() >= this.maxActiveSessions) {
            ++this.rejectedSessions;
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00381"));
        }
        return super.createSession(sessionId);
    }

    @Override
    public void release() {
        super.release();
        this.clearStore();
    }

    public void clearStore() {
        File file = this.file();
        if (file != null && file.exists()) {
            this.deleteFile(file);
        }
    }

    @Override
    public void load() throws ClassNotFoundException, IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedDoLoadFromFile());
            }
            catch (PrivilegedActionException ex) {
                Exception exception = ex.getException();
                if (exception instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)exception;
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Unreported exception in load() " + exception);
                }
            }
        } else {
            this.doLoadFromFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadFromFile() throws ClassNotFoundException, IOException {
        File file;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Start: Loading persisted sessions");
        }
        if ((file = this.file()) == null || !file.exists() || file.length() == 0L) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00382"), this.pathname);
            log.log(Level.FINE, msg);
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file.getAbsolutePath());
            this.readSessions(fis);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Finish: Loading persisted sessions");
            }
        }
        catch (FileNotFoundException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "No persisted data file found");
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
            this.deleteFile(file);
        }
    }

    private void deleteFile(File file) {
        if (!file.delete() && log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Cannot delete file: " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSessions(InputStream is) throws ClassNotFoundException, IOException {
        this.sessions.clear();
        ObjectInputStream ois = null;
        try {
            BufferedInputStream bis = new BufferedInputStream(is);
            ois = this.container != null ? ((StandardContext)this.container).createObjectInputStream(bis) : new ObjectInputStream(bis);
        }
        catch (IOException ioe) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00383"), ioe);
            log.log(Level.SEVERE, msg, ioe);
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ois = null;
            }
            throw ioe;
        }
        Map map = this.sessions;
        synchronized (map) {
            try {
                Integer count = (Integer)ois.readObject();
                int n = count;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Loading " + n + " persisted sessions");
                }
                for (int i = 0; i < n; ++i) {
                    StandardSession session = StandardSession.deserialize(ois, this);
                    session.setManager(this);
                    this.sessions.put(session.getIdInternal(), session);
                    session.activate();
                }
            }
            catch (ClassNotFoundException e) {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00384"), e);
                log.log(Level.SEVERE, msg, e);
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ois = null;
                }
                throw e;
            }
            catch (IOException e) {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00383"), e);
                log.log(Level.SEVERE, msg, e);
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ois = null;
                }
                throw e;
            }
            finally {
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void unload() throws IOException {
        this.unload(true, false);
    }

    public void writeSessions(OutputStream os) throws IOException {
        this.writeSessions(os, true);
    }

    protected void unload(boolean doExpire, boolean isShutdown) throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedDoUnload(doExpire, isShutdown));
            }
            catch (PrivilegedActionException ex) {
                Exception exception = ex.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Unreported exception in unLoad() " + exception);
                }
            }
        } else {
            this.doUnload(doExpire, isShutdown);
        }
    }

    private void doUnload(boolean doExpire, boolean isShutdown) throws IOException {
        if (isShutdown) {
            File file;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Unloading persisted sessions");
            }
            if ((file = this.file()) == null || !this.isDirectoryValidFor(file.getAbsolutePath())) {
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "AS-WEB-CORE-00385", this.pathname);
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file.getAbsolutePath());
                this.writeSessions(fos, doExpire);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Unloading complete");
                }
            }
            catch (IOException ioe) {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    fos = null;
                }
                throw ioe;
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSessions(OutputStream os, boolean doExpire) throws IOException {
        ObjectOutputStream oos = null;
        try {
            oos = this.container != null ? ((StandardContext)this.container).createObjectOutputStream(new BufferedOutputStream(os)) : new ObjectOutputStream(new BufferedOutputStream(os));
        }
        catch (IOException e) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00386"), e);
            log.log(Level.SEVERE, msg, e);
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                oos = null;
            }
            throw e;
        }
        StandardSession[] currentStandardSessions = null;
        Map msg = this.sessions;
        synchronized (msg) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Unloading " + this.sessions.size() + " sessions");
            }
            try {
                Session[] sessionArray = this.findSessions();
                int n = sessionArray.length;
                for (int i = 0; i < n; ++i) {
                    Session actSession = sessionArray[i];
                    StandardSession session = (StandardSession)actSession;
                    session.passivate();
                }
                Session[] currentSessions = this.findSessions();
                int size = currentSessions.length;
                currentStandardSessions = new StandardSession[size];
                oos.writeObject(size);
                for (int i = 0; i < size; ++i) {
                    StandardSession session;
                    currentStandardSessions[i] = session = (StandardSession)currentSessions[i];
                    oos.writeObject(session);
                }
            }
            catch (IOException e) {
                String msg2 = MessageFormat.format(rb.getString("AS-WEB-CORE-00386"), e);
                log.log(Level.SEVERE, msg2, e);
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException i) {
                        // empty catch block
                    }
                    oos = null;
                }
                throw e;
            }
        }
        try {
            oos.flush();
        }
        catch (IOException e) {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                oos = null;
            }
            throw e;
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (doExpire) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Expiring " + currentStandardSessions.length + " persisted sessions");
            }
            for (StandardSession session : currentStandardSessions) {
                try {
                    session.expire(false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isDirectoryValidFor(String fullPathFileName) {
        int lastSlashIdx = fullPathFileName.lastIndexOf(File.separator);
        if (lastSlashIdx == -1) {
            return false;
        }
        String result = fullPathFileName.substring(0, lastSlashIdx);
        return new File(result).isDirectory();
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public List<LifecycleListener> findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public void start() throws LifecycleException {
        if (!this.initialized) {
            this.init();
        }
        if (this.started) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "AS-WEB-CORE-00373");
            }
            return;
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Force random number initialization starting");
        }
        this.generateSessionId();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Force random number initialization completed");
        }
        try {
            this.load();
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00387", t);
        }
    }

    @Override
    public void stop() throws LifecycleException {
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean isShutdown) throws LifecycleException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Stopping");
        }
        if (!this.started) {
            throw new LifecycleException(rb.getString("AS-WEB-CORE-00375"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        try {
            this.unload(false, isShutdown);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00387", e);
        }
        Session[] sessions = this.findSessions();
        if (sessions != null) {
            for (Session session : sessions) {
                if (!session.isValid()) continue;
                try {
                    session.expire();
                }
                catch (Throwable throwable) {
                }
                finally {
                    session.recycle();
                }
            }
        }
        this.resetRandom();
        if (this.initialized) {
            this.destroy();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        if ("sessionTimeout".equals(event.getPropertyName())) {
            try {
                this.setMaxInactiveIntervalSeconds((Integer)event.getNewValue() * 60);
            }
            catch (NumberFormatException e) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00376", event.getNewValue().toString());
            }
        }
    }

    private File file() {
        ServletContext servletContext;
        File tempdir;
        if (this.absPathName != null) {
            return new File(this.absPathName);
        }
        if (this.pathname == null || this.pathname.length() == 0) {
            return null;
        }
        File file = new File(this.pathname);
        if (!file.isAbsolute() && this.container instanceof Context && (tempdir = (File)(servletContext = ((Context)this.container).getServletContext()).getAttribute("jakarta.servlet.context.tempdir")) != null) {
            file = new File(tempdir, this.pathname);
        }
        if (file != null) {
            this.absPathName = file.getAbsolutePath();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processExpires() {
        long timeNow = System.currentTimeMillis();
        Session[] sessions = this.findSessions();
        if (sessions != null) {
            for (Session session : sessions) {
                StandardSession sess = (StandardSession)session;
                if (!sess.lockBackground()) continue;
                try {
                    sess.isValid();
                }
                finally {
                    sess.unlockBackground();
                }
            }
        }
        long timeEnd = System.currentTimeMillis();
        this.processingTime += timeEnd - timeNow;
    }

    private class PrivilegedDoUnload
    implements PrivilegedExceptionAction<Void> {
        private boolean expire;
        private boolean isShutdown;

        PrivilegedDoUnload(boolean expire, boolean shutDown) {
            this.expire = expire;
            this.isShutdown = shutDown;
        }

        @Override
        public Void run() throws Exception {
            StandardManager.this.doUnload(this.expire, this.isShutdown);
            return null;
        }
    }

    private class PrivilegedDoLoadFromFile
    implements PrivilegedExceptionAction<Void> {
        PrivilegedDoLoadFromFile() {
        }

        @Override
        public Void run() throws Exception {
            StandardManager.this.doLoadFromFile();
            return null;
        }
    }
}

