/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.locale;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.mvc.locale.LocaleResolver;
import jakarta.mvc.locale.LocaleResolverContext;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Configuration;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.krazo.jaxrs.JaxRsContext;
import org.eclipse.krazo.locale.LocaleResolverContextImpl;
import org.eclipse.krazo.util.CdiUtils;

@ApplicationScoped
public class LocaleResolverChain {
    @Inject
    @JaxRsContext
    private Configuration configuration;

    @PostConstruct
    public void verify() {
        Objects.requireNonNull(this.configuration, "The Configuration instance was not injected! Please make sure you are using a recent version of Jersey.");
    }

    public Locale resolve(ContainerRequestContext requestContext) {
        LocaleResolverContextImpl context = new LocaleResolverContextImpl(this.configuration, requestContext);
        List<LocaleResolver> resolvers = CdiUtils.getApplicationBeans(LocaleResolver.class, new Annotation[0]);
        List candidates = resolvers.stream().sorted((resolver1, resolver2) -> {
            Priority prio1 = this.getAnnotation(resolver1.getClass(), Priority.class);
            Priority prio2 = this.getAnnotation(resolver2.getClass(), Priority.class);
            int value1 = prio1 != null ? prio1.value() : 1000;
            int value2 = prio2 != null ? prio2.value() : 1000;
            return value2 - value1;
        }).collect(Collectors.toList());
        for (LocaleResolver candidate : candidates) {
            Locale locale = candidate.resolveLocale((LocaleResolverContext)context);
            if (locale == null) continue;
            return locale;
        }
        throw new IllegalStateException("Could not resolve locale with any of the " + candidates.size() + " resolver implementations");
    }

    private <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotationType) {
        if (clazz.getName().endsWith("$$_WeldClientProxy")) {
            return clazz.getSuperclass().getAnnotation(annotationType);
        }
        return clazz.getAnnotation(annotationType);
    }
}

