/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.LocalInstanceCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="stop-local-instance")
@PerLookup
public class StopLocalInstanceCommand
extends LocalInstanceCommand {
    @Param(optional=true, defaultValue="true")
    private Boolean force;
    @Param(name="instance_name", primary=true, optional=true)
    private String userArgInstanceName;
    @Param(optional=true, defaultValue="false")
    Boolean kill;

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        this.instanceName = this.userArgInstanceName;
        super.validate();
    }

    @Override
    protected boolean mkdirs(File f) {
        return false;
    }

    @Override
    protected void initInstance() throws CommandException {
        super.initInstance();
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        File serverDir = this.getServerDirs().getServerDir();
        if (serverDir == null || !serverDir.isDirectory()) {
            return this.noSuchInstance();
        }
        if (this.getServerDirs().getLocalPassword() == null) {
            return this.instanceNotRunning();
        }
        String serverName = this.getServerDirs().getServerName();
        HostAndPort addr = this.getAdminAddress(serverName);
        this.programOpts.setHostAndPort(addr);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Stopping server at " + addr.toString());
        }
        if (!this.isRunning()) {
            return this.instanceNotRunning();
        }
        logger.finer("It's the correct Instance");
        return this.doRemoteCommand();
    }

    protected int instanceNotRunning() throws CommandException {
        if (this.kill.booleanValue()) {
            return this.kill();
        }
        logger.warning(Strings.get("StopInstance.instanceNotRunning"));
        return 0;
    }

    private int noSuchInstance() {
        logger.warning(Strings.get("Instance.noSuchInstance"));
        return 0;
    }

    protected int doRemoteCommand() throws CommandException {
        block4: {
            this.setLocalPassword();
            this.programOpts.setInteractive(false);
            Exception remoteException = null;
            try {
                remoteException = this.runRemoteStop();
                this.waitForDeath();
            }
            catch (CommandException e) {
                if (remoteException != null) {
                    logger.warning("Remote Exception: " + e);
                }
                if (this.kill.booleanValue()) break block4;
                throw e;
            }
        }
        if (this.kill.booleanValue()) {
            this.kill();
        }
        return 0;
    }

    private Exception runRemoteStop() {
        try {
            RemoteCLICommand cmd = new RemoteCLICommand("_stop-instance", this.programOpts, this.env);
            cmd.executeAndReturnOutput(new String[]{"_stop-instance", "--force", this.force.toString()});
            return null;
        }
        catch (CommandException e) {
            return e;
        }
        catch (Exception e) {
            return e;
        }
    }

    private void waitForDeath() throws CommandException {
        if (!this.programOpts.isTerse()) {
            System.out.print(Strings.get("StopInstance.waitForDeath") + " ");
        }
        long startWait = System.currentTimeMillis();
        boolean alive = true;
        int count = 0;
        while (!this.timedOut(startWait)) {
            if (!this.isRunning()) {
                alive = false;
                break;
            }
            try {
                Thread.sleep(100L);
                if (this.programOpts.isTerse() || count++ % 10 != 0) continue;
                System.out.print(".");
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.programOpts.isTerse()) {
            System.out.println();
        }
        if (alive) {
            throw new CommandException(Strings.get("StopInstance.instanceNotDead", 60L));
        }
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > 60000L;
    }

    private int kill() throws CommandException {
        File prevPid = null;
        String pids = null;
        try {
            prevPid = new File(this.getServerDirs().getPidFile().getPath() + ".prev");
            if (!prevPid.canRead()) {
                throw new CommandException(Strings.get("StopInstance.nopidprev", prevPid));
            }
            pids = FileUtils.readSmallFile((File)prevPid).trim();
            String s = ProcessUtils.kill((int)Integer.parseInt(pids));
            if (s != null && logger.isLoggable(Level.FINER)) {
                logger.finer(s);
            }
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception ex) {
            throw new CommandException(Strings.get("StopInstance.pidprevreaderror", prevPid, ex.getMessage()));
        }
        return 0;
    }
}

