/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev.gen;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.modules.schema2beansdev.gen.GenBuffer;
import org.netbeans.modules.schema2beansdev.gen.IndentingWriter;
import org.netbeans.modules.schema2beansdev.gen.JavaUtil;

public class JavaWriter
extends IndentingWriter {
    public int HEADER_SECTION = 0;
    public int DECL_SECTION = 1;
    public int CONSTRUCTOR_SECTION = 2;
    public int BODY_SECTION = 3;
    public int TRAILER_SECTION = 4;
    protected static final int defaultSectionCount = 5;
    public static final int PUBLIC = 0;
    public static final int PROTECTED = 1;
    public static final int PACKAGE_LEVEL = 2;
    public static final int PRIVATE = 3;
    public static final int ACCESS_MASK = 3;
    public static final int STATIC = 16;
    public static final int FINAL = 32;
    public static final int BEANINFO = 256;
    public static final int IO = 512;
    public static final int UNSUPPORTED = 1024;
    public static final int METHOD_SEMANTIC_MASK = 3840;
    protected boolean newlineBeforeCurlyBrace = false;
    public boolean storeMethods = true;
    private Map methods;
    public static final int rightMarginColumn = 76;

    public JavaWriter() {
        super(5);
        this.privateInit();
    }

    public JavaWriter(JavaWriter source) {
        super(source);
        this.HEADER_SECTION = source.HEADER_SECTION;
        this.DECL_SECTION = source.DECL_SECTION;
        this.CONSTRUCTOR_SECTION = source.CONSTRUCTOR_SECTION;
        this.BODY_SECTION = source.BODY_SECTION;
        this.TRAILER_SECTION = source.TRAILER_SECTION;
        this.newlineBeforeCurlyBrace = source.newlineBeforeCurlyBrace;
        this.storeMethods = source.storeMethods;
        this.methods = new LinkedHashMap();
    }

    public int insertSectionAfter(int sectionNum) {
        this.insertAdditionalBuffers(sectionNum, 1);
        if (sectionNum < this.HEADER_SECTION) {
            ++this.HEADER_SECTION;
        }
        if (sectionNum < this.DECL_SECTION) {
            ++this.DECL_SECTION;
        }
        if (sectionNum < this.CONSTRUCTOR_SECTION) {
            ++this.CONSTRUCTOR_SECTION;
        }
        if (sectionNum < this.BODY_SECTION) {
            ++this.BODY_SECTION;
        }
        if (sectionNum < this.TRAILER_SECTION) {
            ++this.TRAILER_SECTION;
        }
        return sectionNum + 1;
    }

    @Override
    public void reset() {
        super.reset();
        this.privateInit();
    }

    private void privateInit() {
        for (int i = 0; i < this.bufferCount; ++i) {
            this.indentLevel[i] = i == this.HEADER_SECTION ? 0 : 1;
        }
        this.methods = new LinkedHashMap();
    }

    @Override
    public void writeTo(Writer out) throws IOException {
        BufferedWriter n2aout = new BufferedWriter(new JavaUtil.N2AFilter(out));
        super.writeTo(n2aout);
        ((Writer)n2aout).flush();
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out);
        this.writeTo(w);
        ((Writer)w).flush();
    }

    @Override
    public void writeTo(GenBuffer o) {
        super.writeTo(o);
        if (o instanceof JavaWriter) {
            JavaWriter out = (JavaWriter)o;
            if (this.storeMethods) {
                out.methods.putAll(this.methods);
            }
        }
    }

    public boolean writeOptions(int options) throws IOException {
        boolean needSpace = this.writeAccess(options);
        if ((options & 0x10) == 16) {
            if (needSpace) {
                this.write(" ");
            }
            this.write("static");
            needSpace = true;
        }
        if ((options & 0x20) == 32) {
            if (needSpace) {
                this.write(" ");
            }
            this.write("final");
            needSpace = true;
        }
        return needSpace;
    }

    public boolean writeAccess(int accessLevel) throws IOException {
        switch (accessLevel & 3) {
            case 0: {
                this.write("public");
                return true;
            }
            case 1: {
                this.write("protected");
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                this.write("private");
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeClassDecl(String name, String extendsStatement, String implementsStatement, int options) throws IOException {
        this.pushSelect(this.HEADER_SECTION);
        try {
            if (this.writeOptions(options)) {
                this.write(" ");
            }
            this.write("class ", name, " ");
            if (extendsStatement != null) {
                this.write("extends ", extendsStatement, " ");
            }
            if (implementsStatement != null) {
                this.write("implements ", implementsStatement, " ");
            }
            this.begin();
            this.popSelect();
            this.pushSelect(this.TRAILER_SECTION);
            this.end();
        }
        finally {
            this.popSelect();
        }
    }

    public void beginMethod(String name) throws IOException {
        this.beginMethod(name, "", null);
    }

    public void beginMethod(String name, String parameters) throws IOException {
        this.beginMethod(name, parameters, null);
    }

    public void beginMethod(String name, String parameters, String exceptions) throws IOException {
        this.beginMethod(name, parameters, exceptions, "void", 0);
    }

    public void beginMethod(String name, String parameters, String exceptions, String returnType) throws IOException {
        this.beginMethod(name, parameters, exceptions, returnType, 0);
    }

    public void beginMethod(String name, String parameters, String exceptions, String returnType, int options) throws IOException {
        this.writeMethod(name, parameters, exceptions, returnType, options);
        this.write(" ");
        this.begin();
    }

    public void endMethod() throws IOException {
        this.end();
        this.cr();
    }

    public void writeMethod(String name, String parameters, String exceptions, String returnType, int options) throws IOException {
        String nameParameters = name + "(" + parameters + ")";
        if (this.storeMethods) {
            this.addToMethodStore(name, parameters, exceptions, returnType, options);
        }
        if (this.writeOptions(options)) {
            this.write(" ");
        }
        this.write(returnType);
        this.write(" ");
        this.write(nameParameters);
        if (exceptions != null) {
            this.write(" throws ", exceptions);
        }
    }

    public void addToMethodStore(String name, String parameters, String exceptions, String returnType) {
        this.addToMethodStore(name, parameters, exceptions, returnType, 0);
    }

    public void addToMethodStore(String name, String parameters, String exceptions, String returnType, int options) {
        Method method = new Method(name, parameters, exceptions, returnType, options);
        this.methods.put(method.getNameParameters(), method);
    }

    public Collection getStoredMethods() {
        return this.methods.values();
    }

    public void beginConstructor(String name) throws IOException {
        this.beginConstructor(name, "", null, 0);
    }

    public void beginConstructor(String name, String parameters) throws IOException {
        this.beginConstructor(name, parameters, null, 0);
    }

    public void beginConstructor(String name, String parameters, String exceptions, int options) throws IOException {
        this.select(this.CONSTRUCTOR_SECTION);
        if (this.writeOptions(options)) {
            this.write(" ");
        }
        this.write(name);
        this.write("(", parameters, ") ");
        if (exceptions != null) {
            this.write("throws ", exceptions, " ");
        }
        this.begin();
        this.addToMethodStore(name, parameters, exceptions, "", options);
    }

    public void writePackage(String pkg) throws IOException {
        this.pushSelect(this.HEADER_SECTION);
        try {
            this.writecr("package ", pkg, ";");
        }
        finally {
            this.popSelect();
        }
    }

    public void writeImport(String pkg) throws IOException {
        this.pushSelect(this.HEADER_SECTION);
        try {
            this.writecr("import ", pkg, ";");
        }
        finally {
            this.popSelect();
        }
    }

    public void begin() throws IOException {
        if (this.newlineBeforeCurlyBrace) {
            this.cr();
        }
        this.writecr("{");
        this.indentRight();
    }

    public void end() throws IOException {
        this.end(true);
    }

    public void end(boolean useCr) throws IOException {
        this.indentLeft();
        this.write("}");
        if (useCr) {
            this.cr();
        }
    }

    public void eol() throws IOException {
        this.eol(true);
    }

    public void eol(boolean useCr) throws IOException {
        this.write(";");
        if (useCr) {
            this.cr();
        }
    }

    public void writeEol(String s) throws IOException {
        this.write(s);
        this.eol();
    }

    public void writeEol(String s1, String s2) throws IOException {
        this.write(s1, s2);
        this.eol();
    }

    public void writeEol(String s1, String s2, String s3) throws IOException {
        this.write(s1, s2, s3);
        this.eol();
    }

    public void writeEol(String s1, String s2, String s3, String s4) throws IOException {
        this.write(s1, s2, s3, s4);
        this.eol();
    }

    public void noI18N() throws IOException {
        this.writecr("\t// NOI18N");
    }

    public void eolNoI18N() throws IOException {
        this.write(";");
        this.noI18N();
    }

    public void writeEolNoI18N(String s) throws IOException {
        this.write(s);
        this.write(";");
        this.noI18N();
    }

    public void writeEolNoI18N(String s1, String s2) throws IOException {
        this.write(s1, s2);
        this.write(";");
        this.noI18N();
    }

    public void writeEolNoI18N(String s1, String s2, String s3) throws IOException {
        this.write(s1, s2, s3);
        this.write(";");
        this.noI18N();
    }

    public void writeEolNoI18N(String s1, String s2, String s3, String s4) throws IOException {
        this.write(s1, s2, s3, s4);
        this.write(";");
        this.noI18N();
    }

    public void beginTry() throws IOException {
        this.write("try ");
        this.begin();
    }

    public void endCatch(String param) throws IOException {
        this.end(false);
        this.write(" catch (", param, ") ");
        this.begin();
    }

    public void endFinallyBegin() throws IOException {
        this.end(false);
        this.write(" finally ");
        this.begin();
    }

    public void beginIf(String predicate) throws IOException {
        this.write("if (", predicate, ") ");
        this.begin();
    }

    public void beginIf(String predicate1, String predicate2) throws IOException {
        this.write("if (", predicate1, predicate2, ") ");
        this.begin();
    }

    public void beginIf(String predicate1, String predicate2, String predicate3) throws IOException {
        this.write("if (", predicate1, predicate2, predicate3);
        this.write(") ");
        this.begin();
    }

    public void endElse() throws IOException {
        this.end(false);
        this.write(" else ");
    }

    public void endElseBegin() throws IOException {
        this.end(false);
        this.write(" else ");
        this.begin();
    }

    public void endElseBeginIf(String predicate) throws IOException {
        this.end(false);
        this.write(" else ");
        this.beginIf(predicate);
    }

    public void beginFor(String init, String predicate, String next) throws IOException {
        int indentLength = "\t".equals(this.indentString) ? 4 : this.indentString.length();
        int horizPosition = indentLength * this.indentLevel[this.curOut];
        this.write("for (");
        horizPosition += 5;
        this.write(init, "; ");
        int nextHorizPosition = (horizPosition += init.length() + 2) + predicate.length() + 2;
        if (nextHorizPosition >= 76) {
            this.cr();
            this.indentOneLevel();
            horizPosition = indentLength * this.indentLevel[this.curOut];
            nextHorizPosition = horizPosition + predicate.length() + 2;
        }
        this.write(predicate, "; ");
        horizPosition = nextHorizPosition;
        nextHorizPosition = horizPosition + next.length() + 2;
        if (nextHorizPosition >= 76) {
            this.cr();
            this.indentOneLevel();
        }
        this.write(next, ") ");
        horizPosition = nextHorizPosition;
        this.begin();
    }

    public void beginWhile(String predicate) throws IOException {
        this.write("while (");
        this.write(predicate);
        this.write(") ");
        this.begin();
    }

    public void writeAssert(String predicate) throws IOException {
        this.write("assert ");
        this.write(predicate);
        this.eol();
    }

    public void comment(String msg) throws IOException {
        this.write("// ", msg);
        this.cr();
    }

    public void bigComment(String msg) throws IOException {
        this.writecr("/**");
        this.write(" * ");
        int length = msg.length();
        for (int i = 0; i < length; ++i) {
            char c = msg.charAt(i);
            if (c == '\n') {
                this.cr();
                this.write(" * ");
                continue;
            }
            if (c == '*' && i + 1 < length && msg.charAt(i + 1) == '/') {
                this.write("* /");
                ++i;
                continue;
            }
            this.write(c);
        }
        this.cr();
        this.writecr(" */");
    }

    public static class Method
    implements Comparable {
        private String name;
        private String parameters;
        private String exceptions;
        private String returnType;
        private int options;

        public Method(String name, String parameters, String exceptions, String returnType, int options) {
            this.name = name;
            this.parameters = parameters.trim();
            this.exceptions = exceptions;
            this.returnType = returnType;
            this.options = options;
        }

        public void beginMethod(JavaWriter out) throws IOException {
            out.beginMethod(this.name, this.parameters, this.exceptions, this.returnType, this.options);
        }

        public void writeMethod(JavaWriter out) throws IOException {
            out.writeMethod(this.name, this.parameters, this.exceptions, this.returnType, this.options);
        }

        public String getNameParameters() {
            return this.name + "(" + this.parameters + ")";
        }

        public String getName() {
            return this.name;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public String getParameters() {
            return this.parameters;
        }

        public String getExceptions() {
            return this.exceptions;
        }

        public int getOptions() {
            return this.options;
        }

        public boolean isStatic() {
            return (this.options & 0x10) == 16;
        }

        public boolean isPublic() {
            return (this.options & 3) == 0;
        }

        public boolean isBeanInfo() {
            return (this.options & 0x100) == 256;
        }

        public boolean isUnsupported() {
            return (this.options & 0x400) == 1024;
        }

        public boolean isConstructor() {
            return "".equals(this.getReturnType());
        }

        public void writeCall(JavaWriter out) throws IOException {
            out.write(this.name);
            out.write("(");
            this.writeParametersNoTypes(out);
            out.write(")");
        }

        public void writeParametersNoTypes(JavaWriter out) throws IOException {
            boolean writeIt = false;
            for (int pos = 0; pos < this.parameters.length(); ++pos) {
                char c = this.parameters.charAt(pos);
                int endFinal = pos + 6;
                if (this.parameters.length() >= endFinal && this.parameters.substring(pos, endFinal).equals("final ")) {
                    pos = endFinal;
                    c = this.parameters.charAt(pos);
                }
                if (writeIt) {
                    out.write(c);
                }
                boolean skipWS = false;
                if (Character.isWhitespace(c)) {
                    writeIt = true;
                    skipWS = true;
                } else if (c == ',') {
                    writeIt = false;
                    skipWS = true;
                }
                if (!skipWS) continue;
                while (pos + 1 < this.parameters.length() && Character.isWhitespace(this.parameters.charAt(pos + 1))) {
                    ++pos;
                }
            }
        }

        public int compareTo(Object o) {
            Method otherMethod = (Method)o;
            return this.getNameParameters().compareTo(otherMethod.getNameParameters());
        }
    }
}

