/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.eglx.lang;

import eglx.java.JavaObjectException;
import eglx.lang.AnyException;
import eglx.lang.InvalidArgumentException;
import eglx.lang.InvalidIndexException;
import eglx.lang.TypeCastException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.Delegate;
import org.eclipse.edt.runtime.java.eglx.lang.EAny;
import org.eclipse.edt.runtime.java.eglx.lang.EBigint;
import org.eclipse.edt.runtime.java.eglx.lang.EBoolean;
import org.eclipse.edt.runtime.java.eglx.lang.EBytes;
import org.eclipse.edt.runtime.java.eglx.lang.EDate;
import org.eclipse.edt.runtime.java.eglx.lang.EDecimal;
import org.eclipse.edt.runtime.java.eglx.lang.EDictionary;
import org.eclipse.edt.runtime.java.eglx.lang.EFloat;
import org.eclipse.edt.runtime.java.eglx.lang.EInt;
import org.eclipse.edt.runtime.java.eglx.lang.ESmallfloat;
import org.eclipse.edt.runtime.java.eglx.lang.ESmallint;
import org.eclipse.edt.runtime.java.eglx.lang.EString;
import org.eclipse.edt.runtime.java.eglx.lang.ETime;
import org.eclipse.edt.runtime.java.eglx.lang.ETimestamp;

public class EList<E>
extends AnyBoxedObject<List<E>> {
    private static final long serialVersionUID = 10L;
    private String signature;
    public static final ListElementFactory<byte[]> BytesFactory = new ListElementFactory<byte[]>(){

        @Override
        public byte[] newElement() {
            return new byte[0];
        }
    };
    public static final ListElementFactory<Integer> IntFactory = new ListElementFactory<Integer>(){

        @Override
        public Integer newElement() {
            return 0;
        }
    };
    public static final ListElementFactory<Long> BigintFactory = new ListElementFactory<Long>(){

        @Override
        public Long newElement() {
            return 0L;
        }
    };
    public static final ListElementFactory<Short> SmallintFactory = new ListElementFactory<Short>(){

        @Override
        public Short newElement() {
            return (short)0;
        }
    };
    public static final ListElementFactory<Boolean> BooleanFactory = new ListElementFactory<Boolean>(){

        @Override
        public Boolean newElement() {
            return Boolean.FALSE;
        }
    };
    public static final ListElementFactory<String> StringFactory = new ListElementFactory<String>(){

        @Override
        public String newElement() {
            return "";
        }
    };
    public static final ListElementFactory<Double> FloatFactory = new ListElementFactory<Double>(){

        @Override
        public Double newElement() {
            return 0.0;
        }
    };
    public static final ListElementFactory<Float> SmallfloatFactory = new ListElementFactory<Float>(){

        @Override
        public Float newElement() {
            return Float.valueOf(0.0f);
        }
    };
    public static final ListElementFactory<BigDecimal> DecimalFactory = new ListElementFactory<BigDecimal>(){

        @Override
        public BigDecimal newElement() {
            return BigDecimal.ZERO;
        }
    };
    public static final ListElementFactory<Calendar> DateFactory = new ListElementFactory<Calendar>(){

        @Override
        public Calendar newElement() {
            return EDate.defaultValue();
        }
    };
    public static final ListElementFactory<Calendar> TimeFactory = new ListElementFactory<Calendar>(){

        @Override
        public Calendar newElement() {
            return ETime.defaultValue();
        }
    };

    private EList(List<E> list, String signature) {
        super(list);
        this.signature = signature;
    }

    public static <T> List<T> ezeNew(Class<? extends T> clazz) {
        return new ArrayList();
    }

    public static <T> List<T> ezeNew(int size, ListElementFactory<? extends T> factory) {
        ArrayList<T> list = new ArrayList<T>(size);
        if (factory != null) {
            int i = 0;
            while (i < size) {
                list.add(factory.newElement());
                ++i;
            }
        } else {
            int i = 0;
            while (i < size) {
                list.add(null);
                ++i;
            }
        }
        return list;
    }

    public static <T> List<T> ezeNew(T ... elements) {
        int size = elements == null ? 0 : elements.length;
        ArrayList<T> list = new ArrayList<T>(size);
        int i = 0;
        while (i < size) {
            list.add(elements[i]);
            ++i;
        }
        return list;
    }

    public static <T> EList<T> ezeBox(List<T> object, String signature) {
        return new EList<T>(object, signature);
    }

    public static boolean ezeIsa(Object object, String signature) {
        return object instanceof EList && ((EList)object).ezeUnbox() != null && ((EList)object).signature.equals(signature);
    }

    public static List ezeCast(Object value, String signature, Object ... args) throws TypeCastException {
        if (value instanceof EList) {
            if (((EList)value).signature.equals(signature)) {
                return EList.copy((List)((EList)value).ezeUnbox(), signature);
            }
            value = ((EList)value).ezeUnbox();
        }
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            List list = (List)value;
            if (EList.signatureMatches(list, signature)) {
                return EList.copy(list, signature);
            }
            if (args.length > 0 && args[0] == EAny.class) {
                return EList.copyAndBoxElements(list, signature);
            }
            if (signature.startsWith("eglx.lang.EList<")) {
                return EList.copyAndCastElements(list, signature, args);
            }
        }
        TypeCastException tcx = new TypeCastException();
        tcx.castToName = signature;
        Object unboxed = value instanceof eglx.lang.EAny ? ((eglx.lang.EAny)value).ezeUnbox() : value;
        tcx.actualTypeName = unboxed.getClass().getName();
        throw tcx.fillInMessage("EGL0007E", value, tcx.actualTypeName, tcx.castToName);
    }

    private static boolean signatureMatches(List list, String signature) {
        if (signature.startsWith("eglx.lang.EList<")) {
            if (list.isEmpty()) {
                return true;
            }
            String elementSig = signature.substring(16, signature.length() - 1);
            return EList.signatureMatches(list.get(0), elementSig);
        }
        return false;
    }

    private static boolean signatureMatches(Object obj, String signature) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof eglx.lang.EAny && signature.equals("eglx.lang.EAny")) {
            return true;
        }
        if (obj instanceof List) {
            return EList.signatureMatches((List)obj, signature);
        }
        if (obj instanceof Integer) {
            return signature.equals("eglx.lang.EInt");
        }
        if (obj instanceof Long) {
            return signature.equals("eglx.lang.EBigint");
        }
        if (obj instanceof Short) {
            return signature.equals("eglx.lang.ESmallint");
        }
        if (obj instanceof Double) {
            return signature.equals("eglx.lang.EFloat");
        }
        if (obj instanceof Float) {
            return signature.equals("eglx.lang.ESmallfloat");
        }
        if (obj instanceof BigDecimal) {
            if (!signature.startsWith("eglx.lang.EDecimal")) {
                return false;
            }
            if (signature.length() == 18) {
                return true;
            }
            int precision = ((BigDecimal)obj).precision();
            int decimals = ((BigDecimal)obj).scale();
            int precStart = 19;
            int precEnd = signature.indexOf(58);
            int decStart = precEnd + 1;
            int decEnd = signature.length() - 1;
            int sigPrecision = Integer.parseInt(signature.substring(precStart, precEnd));
            int sigDecimals = Integer.parseInt(signature.substring(decStart, decEnd));
            return sigPrecision >= precision && sigDecimals >= decimals;
        }
        if (obj instanceof Boolean) {
            return signature.equals("eglx.lang.EBoolean");
        }
        if (obj instanceof byte[]) {
            if (!signature.startsWith("eglx.lang.EBytes")) {
                return false;
            }
            if (signature.length() == 16) {
                return true;
            }
            if (obj instanceof EBytes) {
                obj = ((EBytes)obj).ezeUnbox();
            }
            int closeParenIndex = 18;
            while (signature.charAt(closeParenIndex) != ')') {
                ++closeParenIndex;
            }
            int length = Integer.parseInt(signature.substring(17, closeParenIndex));
            return length == ((byte[])obj).length;
        }
        if (obj instanceof String) {
            if (!signature.startsWith("eglx.lang.EString")) {
                return false;
            }
            if (signature.length() == 17) {
                return true;
            }
            int closeParenIndex = 19;
            while (signature.charAt(closeParenIndex) != ')') {
                ++closeParenIndex;
            }
            int length = Integer.parseInt(signature.substring(18, closeParenIndex));
            return length >= ((String)obj).length();
        }
        if (obj instanceof EDictionary) {
            return signature.equals("eglx.lang.EDictionary");
        }
        if (obj instanceof Delegate) {
            return signature.equals(((Delegate)obj).getSignature());
        }
        if (obj instanceof Calendar) {
            return signature.equals("eglx.lang.EDate") || signature.equals("eglx.lang.ETime") || signature.startsWith("eglx.lang.ETimestamp");
        }
        return signature.equals(obj.getClass().getName());
    }

    private static <T> List<T> copy(List<T> list, String signature) {
        try {
            ArrayList<Object> copy = new ArrayList<Object>(list.size());
            for (T element : list) {
                if (element instanceof List) {
                    String elementSig = signature.substring(16, signature.length() - 1);
                    copy.add(EList.copy((List)element, elementSig));
                    continue;
                }
                if (element instanceof Cloneable) {
                    if (element instanceof byte[]) {
                        copy.add(((byte[])element).clone());
                        continue;
                    }
                    copy.add(element.getClass().getMethod("clone", new Class[0]).invoke(element, new Object[0]));
                    continue;
                }
                copy.add(element);
            }
            return copy;
        }
        catch (Exception exception) {
            TypeCastException tcx = new TypeCastException();
            tcx.castToName = signature;
            tcx.actualTypeName = list.getClass().getName();
            throw tcx.fillInMessage("EGL0007E", list, tcx.actualTypeName, tcx.castToName);
        }
    }

    private static List copyAndBoxElements(List list, String signature) {
        try {
            ArrayList<Object> copy = new ArrayList<Object>(list.size());
            for (Object element : list) {
                Object box = null;
                if (element instanceof List) {
                    String elementSig = signature.substring(16, signature.length() - 1);
                    box = EList.boxElement(EList.copy((List)element, elementSig));
                } else {
                    box = element instanceof Cloneable ? (element instanceof byte[] ? EList.boxElement(((byte[])element).clone()) : EList.boxElement(element.getClass().getMethod("clone", new Class[0]).invoke(element, new Object[0]))) : EList.boxElement(element);
                }
                copy.add(box);
            }
            return copy;
        }
        catch (Exception exception) {
            TypeCastException tcx = new TypeCastException();
            tcx.castToName = signature;
            tcx.actualTypeName = list.getClass().getName();
            throw tcx.fillInMessage("EGL0007E", list, tcx.actualTypeName, tcx.castToName);
        }
    }

    private static Object boxElement(Object obj) {
        if (obj instanceof String) {
            return EString.ezeBox((String)obj);
        }
        if (obj instanceof Integer) {
            return EInt.ezeBox((Integer)obj);
        }
        if (obj instanceof Long) {
            return EBigint.ezeBox((Long)obj);
        }
        if (obj instanceof Short) {
            return ESmallint.ezeBox((Short)obj);
        }
        if (obj instanceof Double) {
            return EFloat.ezeBox((Double)obj);
        }
        if (obj instanceof Float) {
            return ESmallfloat.ezeBox((Float)obj);
        }
        if (obj instanceof BigDecimal) {
            return EDecimal.ezeBox((BigDecimal)obj);
        }
        if (obj instanceof Boolean) {
            return EBoolean.ezeBox((Boolean)obj);
        }
        if (obj instanceof byte[]) {
            return EBytes.ezeBox((byte[])obj);
        }
        if (obj instanceof List) {
            return EList.ezeBox((List)obj, "eglx.lang.EList<eglx.lang.EAny>");
        }
        if (obj instanceof Calendar) {
            return EDate.ezeBox((Calendar)obj);
        }
        return obj;
    }

    private static List copyAndCastElements(List list, String signature, Object ... args) {
        if (args.length > 0 && args[0] instanceof Class) {
            Class toClass = (Class)args[0];
            ArrayList<Object> result = new ArrayList<Object>(list.size());
            try {
                if (args.length == 1) {
                    Method castMethod = toClass.getDeclaredMethod("ezeCast", Object.class);
                    for (Object element : list) {
                        result.add(castMethod.invoke(null, element));
                    }
                    return result;
                }
                if (args.length == 2 && args[1] instanceof Integer) {
                    Method castMethod = toClass.getDeclaredMethod("ezeCast", Object.class, Integer[].class);
                    Integer[] castArg = new Integer[]{(Integer)args[1]};
                    for (Object element : list) {
                        result.add(castMethod.invoke(null, element, castArg));
                    }
                    return result;
                }
                if (args.length == 3 && args[1] instanceof Integer && args[2] instanceof Integer) {
                    Method castMethod = toClass.getDeclaredMethod("ezeCast", Object.class, Integer[].class);
                    Integer[] castArgs = new Integer[]{(Integer)args[1], (Integer)args[2]};
                    for (Object element : list) {
                        result.add(castMethod.invoke(null, element, castArgs));
                    }
                    return result;
                }
                if (args.length > 1 && toClass == EList.class) {
                    String elementSig = (String)args[1];
                    Object[] castArgs = new Object[args.length - 2];
                    System.arraycopy(args, 2, castArgs, 0, castArgs.length);
                    for (Object element : list) {
                        result.add(EList.ezeCast(element, elementSig, castArgs));
                    }
                    return result;
                }
            }
            catch (Exception exception) {}
        }
        TypeCastException tcx = new TypeCastException();
        tcx.castToName = signature;
        tcx.actualTypeName = list.getClass().getName();
        throw tcx.fillInMessage("EGL0007E", list, tcx.actualTypeName, tcx.castToName);
    }

    @Override
    public Object ezeGet(int index) throws AnyException {
        return EAny.asAny(((List)this.ezeUnbox()).get(index));
    }

    public static <T> List<T> appendElement(List<T> list, T element) {
        list.add(element);
        return list;
    }

    public static <T> List<T> appendAll(List<T> list, List<? extends T> other) {
        list.addAll(other);
        return list;
    }

    public static <T> void insertElement(List<T> list, T element, int index) {
        if (index == 0) {
            index = 1;
        }
        if (index < 1 || index - 1 > list.size()) {
            InvalidIndexException ex = new InvalidIndexException();
            ex.index = index;
            throw ex.fillInMessage("EGL0010E", index, list.size());
        }
        list.add(index - 1, element);
    }

    public static void removeElement(List list, int index) {
        if (index < 1 || index > list.size()) {
            InvalidIndexException ex = new InvalidIndexException();
            ex.index = index;
            throw ex.fillInMessage("EGL0010E", index, list.size());
        }
        list.remove(index - 1);
    }

    public static void removeAll(List list) {
        list.clear();
    }

    public static <T> void setElement(List<T> list, T value, int index) {
        if (index < 1 || index > list.size()) {
            InvalidIndexException ex = new InvalidIndexException();
            ex.index = index;
            throw ex.fillInMessage("EGL0010E", index, list.size());
        }
        list.set(index - 1, value);
    }

    public static int getSize(List list) {
        return list.size();
    }

    public static <T> void sort(List<T> list, final Delegate sortFunction) {
        Collections.sort(list, new Comparator<T>(){

            @Override
            public int compare(T obj1, T obj2) {
                Object result = sortFunction.invoke(obj1, obj2);
                if (result instanceof Integer) {
                    return (Integer)result;
                }
                if (result instanceof EInt) {
                    return (Integer)((EInt)result).ezeUnbox();
                }
                return 0;
            }
        });
    }

    public static <T> int indexOfElement(List<T> list, T value) {
        return list.indexOf(value) + 1;
    }

    public static <T> int indexOfElement(List<T> list, T value, int index) {
        if (index < 1 || index - 1 > list.size()) {
            InvalidIndexException ex = new InvalidIndexException();
            ex.index = index;
            throw ex.fillInMessage("EGL0010E", index, list.size());
        }
        return list.subList(index - 1, list.size()).indexOf(value) + index;
    }

    public static <T> List<T> resize(List<T> list, int size, ListElementFactory<? extends T> factory) {
        if (size == 0) {
            list.clear();
        } else if (size > list.size()) {
            if (factory == null) {
                int needed = size - list.size();
                while (needed > 0) {
                    list.add(null);
                    --needed;
                }
            } else {
                int needed = size - list.size();
                while (needed > 0) {
                    list.add(factory.newElement());
                    --needed;
                }
            }
        } else if (size > 0) {
            int index = list.size() - 1;
            while (index >= size) {
                list.remove(index);
                --index;
            }
        } else {
            InvalidArgumentException ex = new InvalidArgumentException();
            throw ex.fillInMessage("EGL0019E", size);
        }
        return list;
    }

    public static class ElementFactory<EltT>
    implements ListElementFactory<EltT> {
        Class<? extends EltT> elementClass;

        public ElementFactory(Class<? extends EltT> elementClass) {
            this.elementClass = elementClass;
        }

        @Override
        public EltT newElement() {
            try {
                return this.elementClass.newInstance();
            }
            catch (Exception ex) {
                JavaObjectException jox = new JavaObjectException();
                jox.exceptionType = ex.getClass().getName();
                jox.initCause(ex);
                throw jox.fillInMessage("EGL0008E", ex);
            }
        }
    }

    public static interface ListElementFactory<EltT> {
        public EltT newElement();
    }

    public static class ListFactory<EltT>
    implements ListElementFactory<List<EltT>> {
        int size;
        ListElementFactory<EltT> subFactory;

        public ListFactory(int size, ListElementFactory<EltT> subFactory) {
            this.size = size;
            this.subFactory = subFactory;
        }

        @Override
        public List<EltT> newElement() {
            ArrayList<EltT> element = new ArrayList<EltT>(this.size + 10);
            if (this.subFactory != null) {
                int i = 0;
                while (i < this.size) {
                    element.add(this.subFactory.newElement());
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.size) {
                    element.add(null);
                    ++i;
                }
            }
            return element;
        }
    }

    public static class TimestampFactory
    implements ListElementFactory<Calendar> {
        int startCode;
        int endCode;

        public TimestampFactory(int startCode, int endCode) {
            this.startCode = startCode;
            this.endCode = endCode;
        }

        @Override
        public Calendar newElement() {
            return ETimestamp.defaultValue(this.startCode, this.endCode);
        }
    }
}

