/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.ui.launching;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.edt.debug.internal.ui.EDTDebugUIPlugin;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class EGLJavaLaunchUtils {
    private static boolean imageRegistryInitialized;
    private static final Object initializeMutex;
    private static ImageRegistry imageRegistry;
    private static URL ICON_BASE_URL;

    static {
        initializeMutex = new Object();
        ICON_BASE_URL = EDTDebugUIPlugin.getDefault().getBundle().getEntry("icons/full/");
    }

    private EGLJavaLaunchUtils() {
    }

    public static Image getImage(String key) {
        if (!imageRegistryInitialized) {
            EGLJavaLaunchUtils.initializeImageRegistry();
        }
        return EGLJavaLaunchUtils.getImageRegistry().get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageRegistry initializeImageRegistry() {
        Object object = initializeMutex;
        synchronized (object) {
            if (!imageRegistryInitialized) {
                imageRegistry = new ImageRegistry(EGLJavaLaunchUtils.getStandardDisplay());
                EGLJavaLaunchUtils.declareImages();
                imageRegistryInitialized = true;
            }
        }
        return imageRegistry;
    }

    private static final void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        try {
            desc = ImageDescriptor.createFromURL((URL)EGLJavaLaunchUtils.makeIconFileURL(path));
        }
        catch (MalformedURLException malformedURLException) {}
        imageRegistry.put(key, desc);
    }

    private static URL makeIconFileURL(String iconPath) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        return new URL(ICON_BASE_URL, iconPath);
    }

    private static void declareImages() {
        EGLJavaLaunchUtils.declareRegistryImage("IMG_LAUNCH_MAIN_TAB", "obj16/main_tab_obj.gif");
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static void addJavaAttributes(String projectName, ILaunchConfigurationWorkingCopy configuration) {
        IProject project;
        if (projectName != null && projectName.length() != 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && project.isAccessible()) {
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
                }
            }
            catch (CoreException coreException) {}
        }
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.eclipse.edt.javart.ide.MainProgramLauncher");
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, false);
    }
}

