/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.ui.launching;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.edt.debug.core.DebugUtil;
import org.eclipse.edt.debug.internal.ui.EDTDebugUIPlugin;
import org.eclipse.edt.debug.ui.launching.AbstractEGLLaunchShortcut;
import org.eclipse.edt.debug.ui.launching.EGLJavaLaunchUtils;
import org.eclipse.edt.debug.ui.launching.EGLLaunchingMessages;
import org.eclipse.edt.ide.core.internal.model.SourcePart;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class EGLJavaLaunchShortcut
extends AbstractEGLLaunchShortcut {
    @Override
    public void doLaunch(IFile eglFile, String mode) {
        try {
            ILaunchConfiguration config = this.findLaunchConfiguration(eglFile.getProject(), eglFile);
            if (config != null) {
                DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
            }
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)DebugUtil.getShell(), (String)EGLLaunchingMessages.launch_error_dialog_title, (String)e.getMessage());
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(IProject project, IFile eglFile) throws CoreException {
        ILaunchConfiguration config;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType("org.eclipse.edt.debug.ui.launching.EGLJavaMainApplication");
        if (configType == null) {
            this.abort(EGLLaunchingMessages.egl_java_main_launch_configuration_type_not_found);
        }
        String fileName = this.getQualifiedFilename(eglFile);
        ILaunchConfiguration[] configs = launchManager.getLaunchConfigurations(configType);
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
        int i = 0;
        while (i < configs.length) {
            config = configs[i];
            if (config.getAttribute("org.eclipse.edt.debug.ui.attr_program_file", "").equals(fileName)) {
                String configProjectName = config.getAttribute("org.eclipse.edt.debug.ui.attr_project_name", "");
                String projectName = "";
                if (project != null && project.getName() != null) {
                    projectName = project.getName();
                }
                if (projectName.equals(configProjectName)) {
                    candidateConfigs.add(config);
                }
            }
            ++i;
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return this.createConfiguration(project, eglFile);
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        config = this.chooseConfiguration(candidateConfigs);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected void abort(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.edt.debug.ui", 4, message, null);
        throw new CoreException((IStatus)status);
    }

    protected String getQualifiedFilename(IFile eglFile) throws CoreException {
        String pathName = eglFile.getFullPath().toString();
        int index = pathName.indexOf(47, 1);
        return pathName.substring(index + 1);
    }

    protected ILaunchConfiguration createConfiguration(IProject project, IFile eglFile) throws CoreException {
        String configName;
        ILaunchConfigurationWorkingCopy configCopy;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType("org.eclipse.edt.debug.ui.launching.EGLJavaMainApplication");
        if (configType == null) {
            this.abort(EGLLaunchingMessages.egl_java_main_launch_configuration_type_not_found);
        }
        String fileName = this.getQualifiedFilename(eglFile);
        String programName = this.getFirstProgram((IEGLFile)EGLCore.create((IFile)eglFile));
        if (programName == null) {
            this.abort(EGLLaunchingMessages.egl_java_main_launch_configuration_no_program_found);
        }
        if ((configCopy = configType.newInstance(null, configName = launchManager.generateLaunchConfigurationName(programName))) == null) {
            this.abort(EGLLaunchingMessages.egl_java_main_launch_configuration_create_config_failed);
        }
        String projectName = null;
        if (project != null) {
            projectName = project.getName();
        }
        configCopy.setAttribute("org.eclipse.edt.debug.ui.attr_project_name", projectName);
        configCopy.setAttribute("org.eclipse.edt.debug.ui.attr_program_file", fileName);
        EGLJavaLaunchUtils.addJavaAttributes(projectName, configCopy);
        return configCopy.doSave();
    }

    protected ILaunchConfiguration chooseConfiguration(List configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(DebugUtil.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(EGLLaunchingMessages.launch_config_selection_dialog_title);
        dialog.setMessage(EGLLaunchingMessages.launch_config_selection_dialog_message);
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected String getFirstProgram(IEGLFile programFile) {
        if (programFile != null) {
            try {
                IPart[] parts = programFile.getParts();
                SourcePart srcPart = null;
                int i = 0;
                while (i < parts.length) {
                    if (parts[i] instanceof SourcePart && (srcPart = (SourcePart)parts[i]).isProgram()) {
                        return srcPart.getFullyQualifiedName();
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                EDTDebugUIPlugin.log(e);
            }
        }
        return null;
    }
}

