/*
 * Decompiled with CFR 0.152.
 */
package eglx.persistence.sql;

import eglx.lang.AnyException;
import eglx.persistence.sql.SQLException;
import eglx.persistence.sql.SQLWarning;
import org.eclipse.edt.javart.util.JavartUtil;

public class SQLUtilities {
    public static AnyException makeEglException(Throwable ex) {
        if (ex instanceof AnyException) {
            return (AnyException)ex;
        }
        String msg = ex.getMessage();
        String className = ex.getClass().getName();
        if (msg == null || msg.length() == 0) {
            msg = className;
        }
        if (ex instanceof java.sql.SQLException) {
            java.sql.SQLWarning nextWarn;
            boolean isWarning = ex instanceof java.sql.SQLWarning;
            SQLException sqlx = isWarning ? new SQLWarning() : new SQLException();
            java.sql.SQLException caught = (java.sql.SQLException)ex;
            String state = caught.getSQLState();
            int code = caught.getErrorCode();
            sqlx.setSQLState(state);
            sqlx.setErrorCode(code);
            sqlx.initCause(ex);
            java.sql.SQLException nextEx = caught.getNextException();
            if (nextEx != null) {
                sqlx.setNextException((SQLException)SQLUtilities.makeEglException(nextEx));
            }
            if (isWarning && (nextWarn = ((java.sql.SQLWarning)caught).getNextWarning()) != null) {
                ((SQLWarning)sqlx).setNextWarning((SQLWarning)SQLUtilities.makeEglException(nextWarn));
            }
            return sqlx.fillInMessage("EGL0009E", new Object[]{msg, state, code});
        }
        return JavartUtil.makeEglException((Throwable)ex);
    }
}

