/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.debug.javascript.internal.utils;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.edt.debug.core.DebugUtil;
import org.eclipse.edt.debug.javascript.EDTJavaScriptDebugPlugin;
import org.eclipse.edt.debug.javascript.internal.model.RUIDebugMessages;
import org.eclipse.edt.debug.javascript.internal.model.RUIDebugTarget;
import org.eclipse.edt.debug.ui.launching.EGLLaunchingMessages;
import org.eclipse.edt.ide.core.internal.model.SourcePart;
import org.eclipse.edt.ide.core.internal.model.SourcePartElementInfo;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPackageDeclaration;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.debug.javascript.internal.server.DebugContext;
import org.eclipse.edt.ide.rui.server.EvServer;
import org.eclipse.edt.mof.utils.NameUtile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class RUIDebugUtil {
    private static boolean imageRegistryInitialized;
    private static final Object initializeMutex;
    private static ImageRegistry imageRegistry;
    private static URL ICON_BASE_URL;

    static {
        initializeMutex = new Object();
        ICON_BASE_URL = EDTJavaScriptDebugPlugin.getDefault().getBundle().getEntry("icons/full/");
    }

    private RUIDebugUtil() {
    }

    public static String getProgramNameFromFile(String filename) {
        int index = filename.lastIndexOf(47);
        int start = index != -1 ? index + 1 : 0;
        int end = DebugUtil.isEGLFileName((String)filename) ? filename.length() - 4 : filename.length();
        return filename.substring(start, end);
    }

    public static void launchRUIHandlerInDebugMode(IFile eglFile) throws CoreException {
        RUIDebugUtil.launchRUIHandler(eglFile == null ? null : eglFile.getProject(), eglFile, "debug");
    }

    public static void launchRUIHandler(IProject project, IFile eglFile, String mode) throws CoreException {
        ILaunchConfiguration config;
        if (eglFile == null) {
            RUIDebugUtil.abort(RUIDebugMessages.rui_debug_utils_missing_program_file);
        }
        if ((config = RUIDebugUtil.findLaunchConfiguration(project, eglFile)) != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    public static void abort(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.edt.debug.javascript", 4, message, null);
        throw new CoreException((IStatus)status);
    }

    public static ILaunchConfiguration findLaunchConfiguration(IProject project, IFile eglFile) throws CoreException {
        ILaunchConfiguration config;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType("org.eclipse.edt.debug.javascript.ruiLaunchConfigurationType");
        if (configType == null) {
            RUIDebugUtil.abort(RUIDebugMessages.rui_debug_utils_config_type_not_found);
        }
        String fileName = RUIDebugUtil.getQualifiedFilename(eglFile);
        ILaunchConfiguration[] configs = launchManager.getLaunchConfigurations(configType);
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
        int i = 0;
        while (i < configs.length) {
            config = configs[i];
            String configFile = config.getAttribute("org.eclipse.edt.debug.javascript.attr_handler_file", "");
            if (RUIDebugUtil.filesMatch(fileName, configFile)) {
                String configProjectName = config.getAttribute("org.eclipse.edt.debug.javascript.attr_project_name", "");
                String projectName = "";
                if (project != null && project.getName() != null) {
                    projectName = project.getName();
                }
                if (projectName.equals(configProjectName)) {
                    candidateConfigs.add(config);
                }
            }
            ++i;
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return RUIDebugUtil.createConfiguration(project, eglFile);
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        config = RUIDebugUtil.chooseConfiguration(candidateConfigs);
        if (config != null) {
            return config;
        }
        return null;
    }

    private static boolean filesMatch(String fileName1, String fileName2) {
        if (fileName1.length() == 0 && fileName2.length() == 0) {
            return true;
        }
        File file1 = new File(fileName1);
        File file2 = new File(fileName2);
        return file1.equals(file2);
    }

    public static ILaunchConfiguration createConfiguration(IProject project, IFile eglFile) throws CoreException {
        String configName;
        ILaunchConfigurationWorkingCopy configCopy;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType("org.eclipse.edt.debug.javascript.ruiLaunchConfigurationType");
        if (configType == null) {
            RUIDebugUtil.abort(RUIDebugMessages.rui_debug_utils_config_type_not_found);
        }
        String fileName = RUIDebugUtil.getQualifiedFilename(eglFile);
        String programName = RUIDebugUtil.getFirstRUIHandler(eglFile);
        if (programName == null) {
            RUIDebugUtil.abort(RUIDebugMessages.rui_debug_utils_no_handler_found);
        }
        if ((configCopy = configType.newInstance(null, configName = launchManager.generateLaunchConfigurationName(programName))) == null) {
            RUIDebugUtil.abort(RUIDebugMessages.rui_debug_utils_create_config_failed);
        }
        String projectName = null;
        if (project != null) {
            projectName = project.getName();
        }
        configCopy.setAttribute("org.eclipse.edt.debug.javascript.attr_project_name", projectName);
        configCopy.setAttribute("org.eclipse.edt.debug.javascript.attr_handler_file", fileName);
        return configCopy.doSave();
    }

    protected static ILaunchConfiguration chooseConfiguration(List configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(DebugUtil.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(EGLLaunchingMessages.launch_config_selection_dialog_title);
        dialog.setMessage(EGLLaunchingMessages.launch_config_selection_dialog_message);
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    public static String getQualifiedFilename(IFile eglFile) throws CoreException {
        String pathName = eglFile.getFullPath().toString();
        int index = pathName.indexOf(47, 1);
        String fileName = pathName.substring(index + 1);
        return fileName;
    }

    public static String getFirstRUIHandler(IFile handlerFile) {
        return RUIDebugUtil.getFirstRUIHandler(EGLCore.createEGLFileFrom((IFile)handlerFile));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFirstRUIHandler(IEGLFile handlerFile) {
        try {
            IPart[] parts = handlerFile.getParts();
            SourcePart srcPart = null;
            int i = 0;
            while (true) {
                if (i >= parts.length) {
                    return null;
                }
                if (parts[i] instanceof SourcePart && (srcPart = (SourcePart)parts[i]).isHandler()) {
                    SourcePartElementInfo partInfo = (SourcePartElementInfo)srcPart.getElementInfo();
                    if (partInfo.getSubTypeName() == null) {
                        return null;
                    }
                    String typeName = NameUtile.getAsName((String)new String(partInfo.getSubTypeName()));
                    if (NameUtile.equals((String)typeName, (String)NameUtile.getAsName((String)"RUIHandler"))) return srcPart.getFullyQualifiedName();
                    if (NameUtile.equals((String)typeName, (String)NameUtile.getAsName((String)"RUIWidget"))) {
                        return srcPart.getFullyQualifiedName();
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static DebugContext createContext(ILaunchConfiguration config, ILaunch launch) throws CoreException {
        RUIDebugTarget target = new RUIDebugTarget(launch);
        String project = config.getAttribute("org.eclipse.edt.debug.javascript.attr_handler_file", "");
        String file = config.getAttribute("org.eclipse.edt.debug.javascript.attr_project_name", "");
        String url = config.getAttribute("org.eclipse.edt.debug.javascript.attr_url", null);
        int key = config.getAttribute("org.eclipse.edt.debug.javascript.attr_key", -1);
        if (key == -1) {
            key = EvServer.getInstance().generateContextKey();
        }
        if (url == null) {
            url = RUIDebugUtil.getDebugURL(project, file);
            url = url.indexOf("?") == -1 ? String.valueOf(url) + "?contextKey=" + key : String.valueOf(url) + "&contextKey=" + key;
        }
        DebugContext context = new DebugContext(url, new Integer(key), target, config.getName());
        target.setContext(context);
        return context;
    }

    public static void relaunchContext(DebugContext context) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType("org.eclipse.edt.debug.javascript.ruiLaunchConfigurationType");
        ILaunchConfiguration[] configs = launchManager.getLaunchConfigurations(configType);
        String configName = context.getLaunchConfigName();
        int size = configs == null ? 0 : configs.length;
        ILaunchConfiguration config = null;
        int i = 0;
        while (i < size) {
            if (configName.equals(configs[i].getName())) {
                config = configs[i];
                break;
            }
            ++i;
        }
        if (config != null) {
            ILaunchConfigurationWorkingCopy copy = config.getWorkingCopy();
            copy.setAttribute("org.eclipse.edt.debug.javascript.attr_url", context.getUrl());
            copy.setAttribute("org.eclipse.edt.debug.javascript.attr_key", context.getKey().intValue());
            copy.launch("debug", null);
        }
    }

    public static String getDebugURL(String file, String project) {
        String strPortNumber;
        block14: {
            strPortNumber = Integer.toString(EvServer.getInstance().getPortNumber());
            IEGLFile eglFile = EGLCore.createEGLFileFrom((IFile)ResourcesPlugin.getWorkspace().getRoot().getProject(project).getFile((IPath)new Path(file)));
            if (eglFile != null && eglFile.exists()) {
                try {
                    try {
                        IPackageDeclaration[] pkgs = eglFile.getPackageDeclarations();
                        file = pkgs != null && pkgs.length != 0 ? String.valueOf(pkgs[0].getElementName().replaceAll("\\.", "/")) + '/' + eglFile.getElementName() : eglFile.getElementName();
                    }
                    catch (EGLModelException eGLModelException) {
                        try {
                            eglFile.close();
                        }
                        catch (EGLModelException eGLModelException2) {}
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        eglFile.close();
                    }
                    catch (EGLModelException eGLModelException) {}
                    throw throwable;
                }
                try {
                    eglFile.close();
                }
                catch (EGLModelException eGLModelException) {}
            } else {
                int lastSlash = (file = file.replace("EGLSource/", "")).lastIndexOf(47);
                if (lastSlash != -1) {
                    file = String.valueOf(file.substring(0, lastSlash)) + '/' + file.substring(lastSlash);
                }
            }
        }
        file = file.substring(0, file.length() - 4);
        StringBuffer strb = new StringBuffer();
        strb.append("http://localhost:");
        strb.append(strPortNumber);
        strb.append('/');
        strb.append(project);
        strb.append('/');
        strb.append(file);
        strb.append(".html");
        return strb.toString();
    }

    public static Image getImage(String key) {
        if (!RUIDebugUtil.isImageRegistryInitialized()) {
            RUIDebugUtil.initializeImageRegistry();
        }
        return RUIDebugUtil.getImageRegistry().get(key);
    }

    public static boolean isImageRegistryInitialized() {
        return imageRegistryInitialized;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageRegistry initializeImageRegistry() {
        Object object = initializeMutex;
        synchronized (object) {
            if (!imageRegistryInitialized) {
                imageRegistry = new ImageRegistry(RUIDebugUtil.getStandardDisplay());
                RUIDebugUtil.declareImages();
                imageRegistryInitialized = true;
            }
        }
        return imageRegistry;
    }

    private static final void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        try {
            desc = ImageDescriptor.createFromURL((URL)RUIDebugUtil.makeIconFileURL(path));
        }
        catch (MalformedURLException malformedURLException) {}
        imageRegistry.put(key, desc);
    }

    private static URL makeIconFileURL(String iconPath) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        return new URL(ICON_BASE_URL, iconPath);
    }

    private static void declareImages() {
        RUIDebugUtil.declareRegistryImage("RUI_ICON_VARIABLE", "obj16/variable_obj.gif");
        RUIDebugUtil.declareRegistryImage("RUI_ICON_DEBUG_EXC", "etool16/debug_exc.gif");
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    public static String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return value.replaceAll(" ", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        }
    }

    public static String decodeValue(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8").replaceAll("\\%20", " ").replaceAll("\\!", "\\%21").replaceAll("\\'", "\\%27").replaceAll("\\(", "\\%28").replaceAll("\\)", "\\%29").replaceAll("\\~", "\\%7E");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return value.replaceAll("\\%20", " ").replaceAll("\\!", "\\%21").replaceAll("\\'", "\\%27").replaceAll("\\(", "\\%28").replaceAll("\\)", "\\%29").replaceAll("\\~", "\\%7E");
        }
    }
}

