/*******************************************************************************
 * Copyright © 2011, 2012 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.gen.deployment.javascript;

import org.eclipse.edt.compiler.internal.interfaces.IGenerationMessageRequestor;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.mof.egl.Part;

public abstract class ErrorHTMLGenerator extends HTMLGenerator {
	private String message;
	
	public ErrorHTMLGenerator(AbstractGeneratorCommand processor,
			IGenerationMessageRequestor requestor, String message) {
		super(processor, requestor);
		this.message = message;
	}
	
	protected void invokeGeneration(Part part, String methodName) {
		context.invoke(methodName, part, context, out, message);
	}

}
