/*******************************************************************************
 * Copyright © 2011, 2012 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.compiler.core.ast;

import java.util.*;

public class NodeNameUtility {

private static Map terminalIntToStringMap = new HashMap();
private static Map nonterminalIntToStringMap = new HashMap();
private static Map terminalStringToIntMap = new HashMap();
private static Map nonterminalStringToIntMap = new HashMap();

static {
terminalIntToStringMap.put(new Integer(85), "IMPLEMENTS");
terminalStringToIntMap.put("IMPLEMENTS", new Integer(85));
terminalIntToStringMap.put(new Integer(115), "EXIT");
terminalStringToIntMap.put("EXIT", new Integer(115));
terminalIntToStringMap.put(new Integer(107), "BIGINTLIT");
terminalStringToIntMap.put("BIGINTLIT", new Integer(107));
terminalIntToStringMap.put(new Integer(20), ">");
terminalStringToIntMap.put(">", new Integer(20));
terminalIntToStringMap.put(new Integer(129), "GET");
terminalStringToIntMap.put("GET", new Integer(129));
terminalIntToStringMap.put(new Integer(168), "HOLD");
terminalStringToIntMap.put("HOLD", new Integer(168));
terminalIntToStringMap.put(new Integer(44), "BITANDEQ");
terminalStringToIntMap.put("BITANDEQ", new Integer(44));
terminalIntToStringMap.put(new Integer(49), "DIVEQ");
terminalStringToIntMap.put("DIVEQ", new Integer(49));
terminalIntToStringMap.put(new Integer(7), "ERRORSQLSTMTLIT");
terminalStringToIntMap.put("ERRORSQLSTMTLIT", new Integer(7));
terminalIntToStringMap.put(new Integer(29), ">=");
terminalStringToIntMap.put(">=", new Integer(29));
terminalIntToStringMap.put(new Integer(112), "CALL");
terminalStringToIntMap.put("CALL", new Integer(112));
terminalIntToStringMap.put(new Integer(51), "CONCATEQ");
terminalStringToIntMap.put("CONCATEQ", new Integer(51));
terminalIntToStringMap.put(new Integer(157), "STACK");
terminalStringToIntMap.put("STACK", new Integer(157));
terminalIntToStringMap.put(new Integer(6), "ERRORBLOCKCOMMENT");
terminalStringToIntMap.put("ERRORBLOCKCOMMENT", new Integer(6));
terminalIntToStringMap.put(new Integer(11), "BITAND");
terminalStringToIntMap.put("BITAND", new Integer(11));
terminalIntToStringMap.put(new Integer(56), ")");
terminalStringToIntMap.put(")", new Integer(56));
terminalIntToStringMap.put(new Integer(136), "INTO");
terminalStringToIntMap.put("INTO", new Integer(136));
terminalIntToStringMap.put(new Integer(159), "BYPOSITION");
terminalStringToIntMap.put("BYPOSITION", new Integer(159));
terminalIntToStringMap.put(new Integer(138), "DECREMENT");
terminalStringToIntMap.put("DECREMENT", new Integer(138));
terminalIntToStringMap.put(new Integer(175), "WHERE");
terminalStringToIntMap.put("WHERE", new Integer(175));
terminalIntToStringMap.put(new Integer(35), "*");
terminalStringToIntMap.put("*", new Integer(35));
terminalIntToStringMap.put(new Integer(48), "TIMESEQ");
terminalStringToIntMap.put("TIMESEQ", new Integer(48));
terminalIntToStringMap.put(new Integer(74), "RECORD");
terminalStringToIntMap.put("RECORD", new Integer(74));
terminalIntToStringMap.put(new Integer(69), "BLOCK_COMMENT");
terminalStringToIntMap.put("BLOCK_COMMENT", new Integer(69));
terminalIntToStringMap.put(new Integer(116), "GOTO");
terminalStringToIntMap.put("GOTO", new Integer(116));
terminalIntToStringMap.put(new Integer(66), "UMINUS");
terminalStringToIntMap.put("UMINUS", new Integer(66));
terminalIntToStringMap.put(new Integer(132), "REPLACE");
terminalStringToIntMap.put("REPLACE", new Integer(132));
terminalIntToStringMap.put(new Integer(17), "==");
terminalStringToIntMap.put("==", new Integer(17));
terminalIntToStringMap.put(new Integer(45), "BITOREQ");
terminalStringToIntMap.put("BITOREQ", new Integer(45));
terminalIntToStringMap.put(new Integer(77), "PROGRAM");
terminalStringToIntMap.put("PROGRAM", new Integer(77));
terminalIntToStringMap.put(new Integer(104), "BYTESLIT");
terminalStringToIntMap.put("BYTESLIT", new Integer(104));
terminalIntToStringMap.put(new Integer(37), "**");
terminalStringToIntMap.put("**", new Integer(37));
terminalIntToStringMap.put(new Integer(126), "ADD");
terminalStringToIntMap.put("ADD", new Integer(126));
terminalIntToStringMap.put(new Integer(50), "TIMESTIMESEQ");
terminalStringToIntMap.put("TIMESTIMESEQ", new Integer(50));
terminalIntToStringMap.put(new Integer(87), "TYPE");
terminalStringToIntMap.put("TYPE", new Integer(87));
terminalIntToStringMap.put(new Integer(151), "RELATIVE");
terminalStringToIntMap.put("RELATIVE", new Integer(151));
terminalIntToStringMap.put(new Integer(36), "/");
terminalStringToIntMap.put("/", new Integer(36));
terminalIntToStringMap.put(new Integer(3), "EOS");
terminalStringToIntMap.put("EOS", new Integer(3));
terminalIntToStringMap.put(new Integer(63), "=");
terminalStringToIntMap.put("=", new Integer(63));
terminalIntToStringMap.put(new Integer(164), "LABEL");
terminalStringToIntMap.put("LABEL", new Integer(164));
terminalIntToStringMap.put(new Integer(109), "NULL");
terminalStringToIntMap.put("NULL", new Integer(109));
terminalIntToStringMap.put(new Integer(131), "PREPARE");
terminalStringToIntMap.put("PREPARE", new Integer(131));
terminalIntToStringMap.put(new Integer(147), "PREVIOUS");
terminalStringToIntMap.put("PREVIOUS", new Integer(147));
terminalIntToStringMap.put(new Integer(95), "PRIVATE");
terminalStringToIntMap.put("PRIVATE", new Integer(95));
terminalIntToStringMap.put(new Integer(0), "EOF");
terminalStringToIntMap.put("EOF", new Integer(0));
terminalIntToStringMap.put(new Integer(33), "-");
terminalStringToIntMap.put("-", new Integer(33));
terminalIntToStringMap.put(new Integer(78), "LIBRARY");
terminalStringToIntMap.put("LIBRARY", new Integer(78));
terminalIntToStringMap.put(new Integer(172), "LANGUAGEBUNDLE");
terminalStringToIntMap.put("LANGUAGEBUNDLE", new Integer(172));
terminalIntToStringMap.put(new Integer(42), "QUESTION");
terminalStringToIntMap.put("QUESTION", new Integer(42));
terminalIntToStringMap.put(new Integer(118), "MOVE");
terminalStringToIntMap.put("MOVE", new Integer(118));
terminalIntToStringMap.put(new Integer(72), "IMPORT");
terminalStringToIntMap.put("IMPORT", new Integer(72));
terminalIntToStringMap.put(new Integer(71), "PACKAGE");
terminalStringToIntMap.put("PACKAGE", new Integer(71));
terminalIntToStringMap.put(new Integer(144), "USING");
terminalStringToIntMap.put("USING", new Integer(144));
terminalIntToStringMap.put(new Integer(38), "::");
terminalStringToIntMap.put("::", new Integer(38));
terminalIntToStringMap.put(new Integer(167), "ELSE");
terminalStringToIntMap.put("ELSE", new Integer(167));
terminalIntToStringMap.put(new Integer(158), "BYNAME");
terminalStringToIntMap.put("BYNAME", new Integer(158));
terminalIntToStringMap.put(new Integer(122), "TRY");
terminalStringToIntMap.put("TRY", new Integer(122));
terminalIntToStringMap.put(new Integer(53), "MODULOEQ");
terminalStringToIntMap.put("MODULOEQ", new Integer(53));
terminalIntToStringMap.put(new Integer(152), "ABSOLUTE");
terminalStringToIntMap.put("ABSOLUTE", new Integer(152));
terminalIntToStringMap.put(new Integer(82), "DELEGATE");
terminalStringToIntMap.put("DELEGATE", new Integer(82));
terminalIntToStringMap.put(new Integer(73), "END");
terminalStringToIntMap.put("END", new Integer(73));
terminalIntToStringMap.put(new Integer(8), "||");
terminalStringToIntMap.put("||", new Integer(8));
terminalIntToStringMap.put(new Integer(148), "FIRST");
terminalStringToIntMap.put("FIRST", new Integer(148));
terminalIntToStringMap.put(new Integer(26), "RIGHTSHIFTLOGICALEQ");
terminalStringToIntMap.put("RIGHTSHIFTLOGICALEQ", new Integer(26));
terminalIntToStringMap.put(new Integer(75), "HANDLER");
terminalStringToIntMap.put("HANDLER", new Integer(75));
terminalIntToStringMap.put(new Integer(154), "WHEN");
terminalStringToIntMap.put("WHEN", new Integer(154));
terminalIntToStringMap.put(new Integer(9), "&&");
terminalStringToIntMap.put("&&", new Integer(9));
terminalIntToStringMap.put(new Integer(150), "CURRENT");
terminalStringToIntMap.put("CURRENT", new Integer(150));
terminalIntToStringMap.put(new Integer(92), "THIS");
terminalStringToIntMap.put("THIS", new Integer(92));
terminalIntToStringMap.put(new Integer(173), "OF");
terminalStringToIntMap.put("OF", new Integer(173));
terminalIntToStringMap.put(new Integer(137), "BY");
terminalStringToIntMap.put("BY", new Integer(137));
terminalIntToStringMap.put(new Integer(146), "NEXT");
terminalStringToIntMap.put("NEXT", new Integer(146));
terminalIntToStringMap.put(new Integer(89), "RETURNS");
terminalStringToIntMap.put("RETURNS", new Integer(89));
terminalIntToStringMap.put(new Integer(61), ";");
terminalStringToIntMap.put(";", new Integer(61));
terminalIntToStringMap.put(new Integer(171), "GROUP");
terminalStringToIntMap.put("GROUP", new Integer(171));
terminalIntToStringMap.put(new Integer(149), "LAST");
terminalStringToIntMap.put("LAST", new Integer(149));
terminalIntToStringMap.put(new Integer(125), "CLOSE");
terminalStringToIntMap.put("CLOSE", new Integer(125));
terminalIntToStringMap.put(new Integer(93), "NEW");
terminalStringToIntMap.put("NEW", new Integer(93));
terminalIntToStringMap.put(new Integer(127), "DELETE");
terminalStringToIntMap.put("DELETE", new Integer(127));
terminalIntToStringMap.put(new Integer(174), "REF");
terminalStringToIntMap.put("REF", new Integer(174));
terminalIntToStringMap.put(new Integer(83), "EXTERNALTYPE");
terminalStringToIntMap.put("EXTERNALTYPE", new Integer(83));
terminalIntToStringMap.put(new Integer(94), "SUPER");
terminalStringToIntMap.put("SUPER", new Integer(94));
terminalIntToStringMap.put(new Integer(47), "MINUSEQ");
terminalStringToIntMap.put("MINUSEQ", new Integer(47));
terminalIntToStringMap.put(new Integer(81), "INTERFACE");
terminalStringToIntMap.put("INTERFACE", new Integer(81));
terminalIntToStringMap.put(new Integer(60), "}");
terminalStringToIntMap.put("}", new Integer(60));
terminalIntToStringMap.put(new Integer(18), "!=");
terminalStringToIntMap.put("!=", new Integer(18));
terminalIntToStringMap.put(new Integer(40), "@");
terminalStringToIntMap.put("@", new Integer(40));
terminalIntToStringMap.put(new Integer(30), "AS");
terminalStringToIntMap.put("AS", new Integer(30));
terminalIntToStringMap.put(new Integer(113), "CASE");
terminalStringToIntMap.put("CASE", new Integer(113));
terminalIntToStringMap.put(new Integer(46), "PLUSEQ");
terminalStringToIntMap.put("PLUSEQ", new Integer(46));
terminalIntToStringMap.put(new Integer(24), "LEFTSHIFTEQ");
terminalStringToIntMap.put("LEFTSHIFTEQ", new Integer(24));
terminalIntToStringMap.put(new Integer(32), "+");
terminalStringToIntMap.put("+", new Integer(32));
terminalIntToStringMap.put(new Integer(123), "THROW");
terminalStringToIntMap.put("THROW", new Integer(123));
terminalIntToStringMap.put(new Integer(76), "CLASS");
terminalStringToIntMap.put("CLASS", new Integer(76));
terminalIntToStringMap.put(new Integer(55), "(");
terminalStringToIntMap.put("(", new Integer(55));
terminalIntToStringMap.put(new Integer(161), "ALL");
terminalStringToIntMap.put("ALL", new Integer(161));
terminalIntToStringMap.put(new Integer(58), "]");
terminalStringToIntMap.put("]", new Integer(58));
terminalIntToStringMap.put(new Integer(124), "WHILE");
terminalStringToIntMap.put("WHILE", new Integer(124));
terminalIntToStringMap.put(new Integer(67), "UPLUS");
terminalStringToIntMap.put("UPLUS", new Integer(67));
terminalIntToStringMap.put(new Integer(62), "CONST");
terminalStringToIntMap.put("CONST", new Integer(62));
terminalIntToStringMap.put(new Integer(12), "XOR");
terminalStringToIntMap.put("XOR", new Integer(12));
terminalIntToStringMap.put(new Integer(130), "OPEN");
terminalStringToIntMap.put("OPEN", new Integer(130));
terminalIntToStringMap.put(new Integer(156), "RUNUNIT");
terminalStringToIntMap.put("RUNUNIT", new Integer(156));
terminalIntToStringMap.put(new Integer(153), "INPARENT");
terminalStringToIntMap.put("INPARENT", new Integer(153));
terminalIntToStringMap.put(new Integer(65), ",");
terminalStringToIntMap.put(",", new Integer(65));
terminalIntToStringMap.put(new Integer(19), "<");
terminalStringToIntMap.put("<", new Integer(19));
terminalIntToStringMap.put(new Integer(108), "SMALLINTLIT");
terminalStringToIntMap.put("SMALLINTLIT", new Integer(108));
terminalIntToStringMap.put(new Integer(176), "WRAP");
terminalStringToIntMap.put("WRAP", new Integer(176));
terminalIntToStringMap.put(new Integer(139), "RETURNING");
terminalStringToIntMap.put("RETURNING", new Integer(139));
terminalIntToStringMap.put(new Integer(34), "%");
terminalStringToIntMap.put("%", new Integer(34));
terminalIntToStringMap.put(new Integer(80), "SERVICE");
terminalStringToIntMap.put("SERVICE", new Integer(80));
terminalIntToStringMap.put(new Integer(84), "ENUMERATION");
terminalStringToIntMap.put("ENUMERATION", new Integer(84));
terminalIntToStringMap.put(new Integer(21), "<=");
terminalStringToIntMap.put("<=", new Integer(21));
terminalIntToStringMap.put(new Integer(169), "SCROLL");
terminalStringToIntMap.put("SCROLL", new Integer(169));
terminalIntToStringMap.put(new Integer(14), "NOT");
terminalStringToIntMap.put("NOT", new Integer(14));
terminalIntToStringMap.put(new Integer(91), "OUT");
terminalStringToIntMap.put("OUT", new Integer(91));
terminalIntToStringMap.put(new Integer(57), "[");
terminalStringToIntMap.put("[", new Integer(57));
terminalIntToStringMap.put(new Integer(70), "LINEBREAKS");
terminalStringToIntMap.put("LINEBREAKS", new Integer(70));
terminalIntToStringMap.put(new Integer(28), "RIGHTSHIFTARITHMETICEQ");
terminalStringToIntMap.put("RIGHTSHIFTARITHMETICEQ", new Integer(28));
terminalIntToStringMap.put(new Integer(140), "WITH");
terminalStringToIntMap.put("WITH", new Integer(140));
terminalIntToStringMap.put(new Integer(23), "LEFTSHIFT");
terminalStringToIntMap.put("LEFTSHIFT", new Integer(23));
terminalIntToStringMap.put(new Integer(16), "!");
terminalStringToIntMap.put("!", new Integer(16));
terminalIntToStringMap.put(new Integer(143), "SINGLEROW");
terminalStringToIntMap.put("SINGLEROW", new Integer(143));
terminalIntToStringMap.put(new Integer(43), "QUESTIONQUESTION");
terminalStringToIntMap.put("QUESTIONQUESTION", new Integer(43));
terminalIntToStringMap.put(new Integer(141), "FORUPDATE");
terminalStringToIntMap.put("FORUPDATE", new Integer(141));
terminalIntToStringMap.put(new Integer(120), "RETURN");
terminalStringToIntMap.put("RETURN", new Integer(120));
terminalIntToStringMap.put(new Integer(4), "WS");
terminalStringToIntMap.put("WS", new Integer(4));
terminalIntToStringMap.put(new Integer(105), "FLOATLIT");
terminalStringToIntMap.put("FLOATLIT", new Integer(105));
terminalIntToStringMap.put(new Integer(68), "LINE_COMMENT");
terminalStringToIntMap.put("LINE_COMMENT", new Integer(68));
terminalIntToStringMap.put(new Integer(133), "FOR");
terminalStringToIntMap.put("FOR", new Integer(133));
terminalIntToStringMap.put(new Integer(79), "FUNCTION");
terminalStringToIntMap.put("FUNCTION", new Integer(79));
terminalIntToStringMap.put(new Integer(162), "TRANSACTION");
terminalStringToIntMap.put("TRANSACTION", new Integer(162));
terminalIntToStringMap.put(new Integer(54), "XOREQ");
terminalStringToIntMap.put("XOREQ", new Integer(54));
terminalIntToStringMap.put(new Integer(100), "INTEGER");
terminalStringToIntMap.put("INTEGER", new Integer(100));
terminalIntToStringMap.put(new Integer(41), ".");
terminalStringToIntMap.put(".", new Integer(41));
terminalIntToStringMap.put(new Integer(160), "WITHV60COMPAT");
terminalStringToIntMap.put("WITHV60COMPAT", new Integer(160));
terminalIntToStringMap.put(new Integer(145), "USINGKEYS");
terminalStringToIntMap.put("USINGKEYS", new Integer(145));
terminalIntToStringMap.put(new Integer(97), "ABSTRACT");
terminalStringToIntMap.put("ABSTRACT", new Integer(97));
terminalIntToStringMap.put(new Integer(103), "STRING");
terminalStringToIntMap.put("STRING", new Integer(103));
terminalIntToStringMap.put(new Integer(2), "BOS");
terminalStringToIntMap.put("BOS", new Integer(2));
terminalIntToStringMap.put(new Integer(166), "INSERT");
terminalStringToIntMap.put("INSERT", new Integer(166));
terminalIntToStringMap.put(new Integer(98), "CONSTRUCTOR");
terminalStringToIntMap.put("CONSTRUCTOR", new Integer(98));
terminalIntToStringMap.put(new Integer(114), "CONTINUE");
terminalStringToIntMap.put("CONTINUE", new Integer(114));
terminalIntToStringMap.put(new Integer(25), "RIGHTSHIFTLOGICAL");
terminalStringToIntMap.put("RIGHTSHIFTLOGICAL", new Integer(25));
terminalIntToStringMap.put(new Integer(88), "USE");
terminalStringToIntMap.put("USE", new Integer(88));
terminalIntToStringMap.put(new Integer(135), "FROM");
terminalStringToIntMap.put("FROM", new Integer(135));
terminalIntToStringMap.put(new Integer(10), "BITOR");
terminalStringToIntMap.put("BITOR", new Integer(10));
terminalIntToStringMap.put(new Integer(155), "OTHERWISE");
terminalStringToIntMap.put("OTHERWISE", new Integer(155));
terminalIntToStringMap.put(new Integer(134), "FOREACH");
terminalStringToIntMap.put("FOREACH", new Integer(134));
terminalIntToStringMap.put(new Integer(13), "IS");
terminalStringToIntMap.put("IS", new Integer(13));
terminalIntToStringMap.put(new Integer(39), "NULLCONCAT");
terminalStringToIntMap.put("NULLCONCAT", new Integer(39));
terminalIntToStringMap.put(new Integer(163), "URL");
terminalStringToIntMap.put("URL", new Integer(163));
terminalIntToStringMap.put(new Integer(106), "SMALLFLOATLIT");
terminalStringToIntMap.put("SMALLFLOATLIT", new Integer(106));
terminalIntToStringMap.put(new Integer(15), "IN");
terminalStringToIntMap.put("IN", new Integer(15));
terminalIntToStringMap.put(new Integer(101), "DECIMALLIT");
terminalStringToIntMap.put("DECIMALLIT", new Integer(101));
terminalIntToStringMap.put(new Integer(1), "error");
terminalStringToIntMap.put("error", new Integer(1));
terminalIntToStringMap.put(new Integer(117), "IF");
terminalStringToIntMap.put("IF", new Integer(117));
terminalIntToStringMap.put(new Integer(99), "ID");
terminalStringToIntMap.put("ID", new Integer(99));
terminalIntToStringMap.put(new Integer(96), "STATIC");
terminalStringToIntMap.put("STATIC", new Integer(96));
terminalIntToStringMap.put(new Integer(102), "BOOLEANLIT");
terminalStringToIntMap.put("BOOLEANLIT", new Integer(102));
terminalIntToStringMap.put(new Integer(27), "RIGHTSHIFTARITHMETIC");
terminalStringToIntMap.put("RIGHTSHIFTARITHMETIC", new Integer(27));
terminalIntToStringMap.put(new Integer(22), "NEGATE");
terminalStringToIntMap.put("NEGATE", new Integer(22));
terminalIntToStringMap.put(new Integer(110), "SQLSTMTLIT");
terminalStringToIntMap.put("SQLSTMTLIT", new Integer(110));
terminalIntToStringMap.put(new Integer(142), "NOCURSOR");
terminalStringToIntMap.put("NOCURSOR", new Integer(142));
terminalIntToStringMap.put(new Integer(64), ":");
terminalStringToIntMap.put(":", new Integer(64));
terminalIntToStringMap.put(new Integer(121), "SET");
terminalStringToIntMap.put("SET", new Integer(121));
terminalIntToStringMap.put(new Integer(31), "ISA");
terminalStringToIntMap.put("ISA", new Integer(31));
terminalIntToStringMap.put(new Integer(111), "SQLCONDITION");
terminalStringToIntMap.put("SQLCONDITION", new Integer(111));
terminalIntToStringMap.put(new Integer(59), "{");
terminalStringToIntMap.put("{", new Integer(59));
terminalIntToStringMap.put(new Integer(128), "EXECUTE");
terminalStringToIntMap.put("EXECUTE", new Integer(128));
terminalIntToStringMap.put(new Integer(5), "ERRORSTRING");
terminalStringToIntMap.put("ERRORSTRING", new Integer(5));
terminalIntToStringMap.put(new Integer(52), "NULLCONCATEQ");
terminalStringToIntMap.put("NULLCONCATEQ", new Integer(52));
terminalIntToStringMap.put(new Integer(86), "EXTENDS");
terminalStringToIntMap.put("EXTENDS", new Integer(86));
terminalIntToStringMap.put(new Integer(170), "ONEXCEPTION");
terminalStringToIntMap.put("ONEXCEPTION", new Integer(170));
terminalIntToStringMap.put(new Integer(165), "UPDATE");
terminalStringToIntMap.put("UPDATE", new Integer(165));
terminalIntToStringMap.put(new Integer(119), "TO");
terminalStringToIntMap.put("TO", new Integer(119));
terminalIntToStringMap.put(new Integer(90), "INOUT");
terminalStringToIntMap.put("INOUT", new Integer(90));
nonterminalIntToStringMap.put(new Integer(24), "executeOption");
nonterminalStringToIntMap.put("executeOption", new Integer(24));
nonterminalIntToStringMap.put(new Integer(81), "whenClause");
nonterminalStringToIntMap.put("whenClause", new Integer(81));
nonterminalIntToStringMap.put(new Integer(42), "importDecl");
nonterminalStringToIntMap.put("importDecl", new Integer(42));
nonterminalIntToStringMap.put(new Integer(41), "implementsOpt");
nonterminalStringToIntMap.put("implementsOpt", new Integer(41));
nonterminalIntToStringMap.put(new Integer(96), "executeOption_plus");
nonterminalStringToIntMap.put("executeOption_plus", new Integer(96));
nonterminalIntToStringMap.put(new Integer(2), "connector");
nonterminalStringToIntMap.put("connector", new Integer(2));
nonterminalIntToStringMap.put(new Integer(117), "openTarget_star");
nonterminalStringToIntMap.put("openTarget_star", new Integer(117));
nonterminalIntToStringMap.put(new Integer(100), "externalTypeContent_star");
nonterminalStringToIntMap.put("externalTypeContent_star", new Integer(100));
nonterminalIntToStringMap.put(new Integer(94), "enumerationField_plus");
nonterminalStringToIntMap.put("enumerationField_plus", new Integer(94));
nonterminalIntToStringMap.put(new Integer(77), "stmt");
nonterminalStringToIntMap.put("stmt", new Integer(77));
nonterminalIntToStringMap.put(new Integer(1), "UltraRoot");
nonterminalStringToIntMap.put("UltraRoot", new Integer(1));
nonterminalIntToStringMap.put(new Integer(80), "useTypeOpt");
nonterminalStringToIntMap.put("useTypeOpt", new Integer(80));
nonterminalIntToStringMap.put(new Integer(26), "expr");
nonterminalStringToIntMap.put("expr", new Integer(26));
nonterminalIntToStringMap.put(new Integer(127), "settingsBlock_plus");
nonterminalStringToIntMap.put("settingsBlock_plus", new Integer(127));
nonterminalIntToStringMap.put(new Integer(105), "getByKeyOption_plus");
nonterminalStringToIntMap.put("getByKeyOption_plus", new Integer(105));
nonterminalIntToStringMap.put(new Integer(15), "handlerContent");
nonterminalStringToIntMap.put("handlerContent", new Integer(15));
nonterminalIntToStringMap.put(new Integer(95), "executeOption_star");
nonterminalStringToIntMap.put("executeOption_star", new Integer(95));
nonterminalIntToStringMap.put(new Integer(9), "callSynchronizationOpt");
nonterminalStringToIntMap.put("callSynchronizationOpt", new Integer(9));
nonterminalIntToStringMap.put(new Integer(93), "enumerationField_star");
nonterminalStringToIntMap.put("enumerationField_star", new Integer(93));
nonterminalIntToStringMap.put(new Integer(98), "expr_plus");
nonterminalStringToIntMap.put("expr_plus", new Integer(98));
nonterminalIntToStringMap.put(new Integer(76), "stepOpt");
nonterminalStringToIntMap.put("stepOpt", new Integer(76));
nonterminalIntToStringMap.put(new Integer(131), "structureContent_plus");
nonterminalStringToIntMap.put("structureContent_plus", new Integer(131));
nonterminalIntToStringMap.put(new Integer(34), "functionInvocation");
nonterminalStringToIntMap.put("functionInvocation", new Integer(34));
nonterminalIntToStringMap.put(new Integer(114), "name_plus");
nonterminalStringToIntMap.put("name_plus", new Integer(114));
nonterminalIntToStringMap.put(new Integer(126), "settingsBlock_star");
nonterminalStringToIntMap.put("settingsBlock_star", new Integer(126));
nonterminalIntToStringMap.put(new Integer(104), "getByKeyOption_star");
nonterminalStringToIntMap.put("getByKeyOption_star", new Integer(104));
nonterminalIntToStringMap.put(new Integer(92), "deleteOption_plus");
nonterminalStringToIntMap.put("deleteOption_plus", new Integer(92));
nonterminalIntToStringMap.put(new Integer(14), "classContent");
nonterminalStringToIntMap.put("classContent", new Integer(14));
nonterminalIntToStringMap.put(new Integer(97), "expr_star");
nonterminalStringToIntMap.put("expr_star", new Integer(97));
nonterminalIntToStringMap.put(new Integer(28), "singleExtendsOpt");
nonterminalStringToIntMap.put("singleExtendsOpt", new Integer(28));
nonterminalIntToStringMap.put(new Integer(43), "initializerOpt");
nonterminalStringToIntMap.put("initializerOpt", new Integer(43));
nonterminalIntToStringMap.put(new Integer(51), "lvalue");
nonterminalStringToIntMap.put("lvalue", new Integer(51));
nonterminalIntToStringMap.put(new Integer(84), "addOption_plus");
nonterminalStringToIntMap.put("addOption_plus", new Integer(84));
nonterminalIntToStringMap.put(new Integer(58), "openTarget");
nonterminalStringToIntMap.put("openTarget", new Integer(58));
nonterminalIntToStringMap.put(new Integer(130), "structureContent_star");
nonterminalStringToIntMap.put("structureContent_star", new Integer(130));
nonterminalIntToStringMap.put(new Integer(122), "replaceOption_plus");
nonterminalStringToIntMap.put("replaceOption_plus", new Integer(122));
nonterminalIntToStringMap.put(new Integer(71), "settingsBlock");
nonterminalStringToIntMap.put("settingsBlock", new Integer(71));
nonterminalIntToStringMap.put(new Integer(22), "enumerationField");
nonterminalStringToIntMap.put("enumerationField", new Integer(22));
nonterminalIntToStringMap.put(new Integer(113), "setTarget_plus");
nonterminalStringToIntMap.put("setTarget_plus", new Integer(113));
nonterminalIntToStringMap.put(new Integer(90), "eglClassContent_plus");
nonterminalStringToIntMap.put("eglClassContent_plus", new Integer(90));
nonterminalIntToStringMap.put(new Integer(75), "abstractModifierOpt");
nonterminalStringToIntMap.put("abstractModifierOpt", new Integer(75));
nonterminalIntToStringMap.put(new Integer(91), "deleteOption_star");
nonterminalStringToIntMap.put("deleteOption_star", new Integer(91));
nonterminalIntToStringMap.put(new Integer(79), "structureContent");
nonterminalStringToIntMap.put("structureContent", new Integer(79));
nonterminalIntToStringMap.put(new Integer(6), "arrayAccess");
nonterminalStringToIntMap.put("arrayAccess", new Integer(6));
nonterminalIntToStringMap.put(new Integer(4), "wsPair");
nonterminalStringToIntMap.put("wsPair", new Integer(4));
nonterminalIntToStringMap.put(new Integer(31), "file");
nonterminalStringToIntMap.put("file", new Integer(31));
nonterminalIntToStringMap.put(new Integer(133), "whenClause_plus");
nonterminalStringToIntMap.put("whenClause_plus", new Integer(133));
nonterminalIntToStringMap.put(new Integer(83), "addOption_star");
nonterminalStringToIntMap.put("addOption_star", new Integer(83));
nonterminalIntToStringMap.put(new Integer(25), "exitModifierOpt");
nonterminalStringToIntMap.put("exitModifierOpt", new Integer(25));
nonterminalIntToStringMap.put(new Integer(86), "classContent_plus");
nonterminalStringToIntMap.put("classContent_plus", new Integer(86));
nonterminalIntToStringMap.put(new Integer(121), "replaceOption_star");
nonterminalStringToIntMap.put("replaceOption_star", new Integer(121));
nonterminalIntToStringMap.put(new Integer(23), "integerLiteralEnumValue");
nonterminalStringToIntMap.put("integerLiteralEnumValue", new Integer(23));
nonterminalIntToStringMap.put(new Integer(10), "callReturnTo");
nonterminalStringToIntMap.put("callReturnTo", new Integer(10));
nonterminalIntToStringMap.put(new Integer(37), "getByPositionOption");
nonterminalStringToIntMap.put("getByPositionOption", new Integer(37));
nonterminalIntToStringMap.put(new Integer(89), "eglClassContent_star");
nonterminalStringToIntMap.put("eglClassContent_star", new Integer(89));
nonterminalIntToStringMap.put(new Integer(99), "argumentsOpt");
nonterminalStringToIntMap.put("argumentsOpt", new Integer(99));
nonterminalIntToStringMap.put(new Integer(48), "interfaceContent");
nonterminalStringToIntMap.put("interfaceContent", new Integer(48));
nonterminalIntToStringMap.put(new Integer(35), "functionParameter");
nonterminalStringToIntMap.put("functionParameter", new Integer(35));
nonterminalIntToStringMap.put(new Integer(29), "fieldAccess");
nonterminalStringToIntMap.put("fieldAccess", new Integer(29));
nonterminalIntToStringMap.put(new Integer(132), "whenClause_star");
nonterminalStringToIntMap.put("whenClause_star", new Integer(132));
nonterminalIntToStringMap.put(new Integer(36), "getByKeyOption");
nonterminalStringToIntMap.put("getByKeyOption", new Integer(36));
nonterminalIntToStringMap.put(new Integer(85), "classContent_star");
nonterminalStringToIntMap.put("classContent_star", new Integer(85));
nonterminalIntToStringMap.put(new Integer(17), "continueModifierOpt");
nonterminalStringToIntMap.put("continueModifierOpt", new Integer(17));
nonterminalIntToStringMap.put(new Integer(0), "$START");
nonterminalStringToIntMap.put("$START", new Integer(0));
nonterminalIntToStringMap.put(new Integer(82), "withNameOpt");
nonterminalStringToIntMap.put("withNameOpt", new Integer(82));
nonterminalIntToStringMap.put(new Integer(33), "fromExprOpt");
nonterminalStringToIntMap.put("fromExprOpt", new Integer(33));
nonterminalIntToStringMap.put(new Integer(107), "getByPositionOption_plus");
nonterminalStringToIntMap.put("getByPositionOption_plus", new Integer(107));
nonterminalIntToStringMap.put(new Integer(18), "defaultClauseOpt");
nonterminalStringToIntMap.put("defaultClauseOpt", new Integer(18));
nonterminalIntToStringMap.put(new Integer(45), "inlineSQLStatementOpt");
nonterminalStringToIntMap.put("inlineSQLStatementOpt", new Integer(45));
nonterminalIntToStringMap.put(new Integer(125), "objExprEntry_plus");
nonterminalStringToIntMap.put("objExprEntry_plus", new Integer(125));
nonterminalIntToStringMap.put(new Integer(70), "objExprEntry");
nonterminalStringToIntMap.put("objExprEntry", new Integer(70));
nonterminalIntToStringMap.put(new Integer(72), "settingsBlockOpt");
nonterminalStringToIntMap.put("settingsBlockOpt", new Integer(72));
nonterminalIntToStringMap.put(new Integer(56), "onException");
nonterminalStringToIntMap.put("onException", new Integer(56));
nonterminalIntToStringMap.put(new Integer(21), "elseOpt");
nonterminalStringToIntMap.put("elseOpt", new Integer(21));
nonterminalIntToStringMap.put(new Integer(120), "part_plus");
nonterminalStringToIntMap.put("part_plus", new Integer(120));
nonterminalIntToStringMap.put(new Integer(106), "getByPositionOption_star");
nonterminalStringToIntMap.put("getByPositionOption_star", new Integer(106));
nonterminalIntToStringMap.put(new Integer(30), "fieldsOpt");
nonterminalStringToIntMap.put("fieldsOpt", new Integer(30));
nonterminalIntToStringMap.put(new Integer(62), "withClause");
nonterminalStringToIntMap.put("withClause", new Integer(62));
nonterminalIntToStringMap.put(new Integer(124), "setting_plus");
nonterminalStringToIntMap.put("setting_plus", new Integer(124));
nonterminalIntToStringMap.put(new Integer(16), "eglClassContent");
nonterminalStringToIntMap.put("eglClassContent", new Integer(16));
nonterminalIntToStringMap.put(new Integer(119), "part_star");
nonterminalStringToIntMap.put("part_star", new Integer(119));
nonterminalIntToStringMap.put(new Integer(103), "functionParameter_plus");
nonterminalStringToIntMap.put("functionParameter_plus", new Integer(103));
nonterminalIntToStringMap.put(new Integer(108), "ID_plus");
nonterminalStringToIntMap.put("ID_plus", new Integer(108));
nonterminalIntToStringMap.put(new Integer(88), "handlerContent_plus");
nonterminalStringToIntMap.put("handlerContent_plus", new Integer(88));
nonterminalIntToStringMap.put(new Integer(8), "callParametersOpt");
nonterminalStringToIntMap.put("callParametersOpt", new Integer(8));
nonterminalIntToStringMap.put(new Integer(53), "name");
nonterminalStringToIntMap.put("name", new Integer(53));
nonterminalIntToStringMap.put(new Integer(123), "setting_star");
nonterminalStringToIntMap.put("setting_star", new Integer(123));
nonterminalIntToStringMap.put(new Integer(112), "interfaceContent_plus");
nonterminalStringToIntMap.put("interfaceContent_plus", new Integer(112));
nonterminalIntToStringMap.put(new Integer(59), "packageDeclarationOpt");
nonterminalStringToIntMap.put("packageDeclarationOpt", new Integer(59));
nonterminalIntToStringMap.put(new Integer(66), "replaceOption");
nonterminalStringToIntMap.put("replaceOption", new Integer(66));
nonterminalIntToStringMap.put(new Integer(116), "onException_plus");
nonterminalStringToIntMap.put("onException_plus", new Integer(116));
nonterminalIntToStringMap.put(new Integer(102), "functionParameter_star");
nonterminalStringToIntMap.put("functionParameter_star", new Integer(102));
nonterminalIntToStringMap.put(new Integer(13), "callReturns");
nonterminalStringToIntMap.put("callReturns", new Integer(13));
nonterminalIntToStringMap.put(new Integer(55), "constOpt");
nonterminalStringToIntMap.put("constOpt", new Integer(55));
nonterminalIntToStringMap.put(new Integer(87), "handlerContent_star");
nonterminalStringToIntMap.put("handlerContent_star", new Integer(87));
nonterminalIntToStringMap.put(new Integer(7), "assignment");
nonterminalStringToIntMap.put("assignment", new Integer(7));
nonterminalIntToStringMap.put(new Integer(67), "returnsOpt");
nonterminalStringToIntMap.put("returnsOpt", new Integer(67));
nonterminalIntToStringMap.put(new Integer(5), "addOption");
nonterminalStringToIntMap.put("addOption", new Integer(5));
nonterminalIntToStringMap.put(new Integer(63), "primary");
nonterminalStringToIntMap.put("primary", new Integer(63));
nonterminalIntToStringMap.put(new Integer(111), "interfaceContent_star");
nonterminalStringToIntMap.put("interfaceContent_star", new Integer(111));
nonterminalIntToStringMap.put(new Integer(19), "deleteOption");
nonterminalStringToIntMap.put("deleteOption", new Integer(19));
nonterminalIntToStringMap.put(new Integer(49), "intoClauseOpt");
nonterminalStringToIntMap.put("intoClauseOpt", new Integer(49));
nonterminalIntToStringMap.put(new Integer(115), "onException_star");
nonterminalStringToIntMap.put("onException_star", new Integer(115));
nonterminalIntToStringMap.put(new Integer(39), "IDOpt");
nonterminalStringToIntMap.put("IDOpt", new Integer(39));
nonterminalIntToStringMap.put(new Integer(69), "setting");
nonterminalStringToIntMap.put("setting", new Integer(69));
nonterminalIntToStringMap.put(new Integer(78), "strItemDecl");
nonterminalStringToIntMap.put("strItemDecl", new Integer(78));
nonterminalIntToStringMap.put(new Integer(11), "callOnException");
nonterminalStringToIntMap.put("callOnException", new Integer(11));
nonterminalIntToStringMap.put(new Integer(129), "stmt_plus");
nonterminalStringToIntMap.put("stmt_plus", new Integer(129));
nonterminalIntToStringMap.put(new Integer(57), "openModifierOpt");
nonterminalStringToIntMap.put("openModifierOpt", new Integer(57));
nonterminalIntToStringMap.put(new Integer(60), "part");
nonterminalStringToIntMap.put("part", new Integer(60));
nonterminalIntToStringMap.put(new Integer(3), "ErrorNode");
nonterminalStringToIntMap.put("ErrorNode", new Integer(3));
nonterminalIntToStringMap.put(new Integer(20), "direction");
nonterminalStringToIntMap.put("direction", new Integer(20));
nonterminalIntToStringMap.put(new Integer(73), "simpleNameOpt");
nonterminalStringToIntMap.put("simpleNameOpt", new Integer(73));
nonterminalIntToStringMap.put(new Integer(27), "extendsOpt");
nonterminalStringToIntMap.put("extendsOpt", new Integer(27));
nonterminalIntToStringMap.put(new Integer(46), "inparentOpt");
nonterminalStringToIntMap.put("inparentOpt", new Integer(46));
nonterminalIntToStringMap.put(new Integer(110), "importDecl_plus");
nonterminalStringToIntMap.put("importDecl_plus", new Integer(110));
nonterminalIntToStringMap.put(new Integer(52), "moveModifierOpt");
nonterminalStringToIntMap.put("moveModifierOpt", new Integer(52));
nonterminalIntToStringMap.put(new Integer(65), "privateAccessModifierOpt");
nonterminalStringToIntMap.put("privateAccessModifierOpt", new Integer(65));
nonterminalIntToStringMap.put(new Integer(44), "inlineSQLStatement");
nonterminalStringToIntMap.put("inlineSQLStatement", new Integer(44));
nonterminalIntToStringMap.put(new Integer(47), "externalTypeContent");
nonterminalStringToIntMap.put("externalTypeContent", new Integer(47));
nonterminalIntToStringMap.put(new Integer(128), "stmt_star");
nonterminalStringToIntMap.put("stmt_star", new Integer(128));
nonterminalIntToStringMap.put(new Integer(40), "questionOpt");
nonterminalStringToIntMap.put("questionOpt", new Integer(40));
nonterminalIntToStringMap.put(new Integer(109), "importDecl_star");
nonterminalStringToIntMap.put("importDecl_star", new Integer(109));
nonterminalIntToStringMap.put(new Integer(68), "setTarget");
nonterminalStringToIntMap.put("setTarget", new Integer(68));
nonterminalIntToStringMap.put(new Integer(32), "foreachTarget");
nonterminalStringToIntMap.put("foreachTarget", new Integer(32));
nonterminalIntToStringMap.put(new Integer(38), "getByPositionSource");
nonterminalStringToIntMap.put("getByPositionSource", new Integer(38));
nonterminalIntToStringMap.put(new Integer(61), "partSubTypeOpt");
nonterminalStringToIntMap.put("partSubTypeOpt", new Integer(61));
nonterminalIntToStringMap.put(new Integer(64), "primaryNoNew");
nonterminalStringToIntMap.put("primaryNoNew", new Integer(64));
nonterminalIntToStringMap.put(new Integer(50), "literal");
nonterminalStringToIntMap.put("literal", new Integer(50));
nonterminalIntToStringMap.put(new Integer(118), "openTarget_plus");
nonterminalStringToIntMap.put("openTarget_plus", new Integer(118));
nonterminalIntToStringMap.put(new Integer(101), "externalTypeContent_plus");
nonterminalStringToIntMap.put("externalTypeContent_plus", new Integer(101));
nonterminalIntToStringMap.put(new Integer(12), "callUsingOpt");
nonterminalStringToIntMap.put("callUsingOpt", new Integer(12));
nonterminalIntToStringMap.put(new Integer(54), "namedType");
nonterminalStringToIntMap.put("namedType", new Integer(54));
nonterminalIntToStringMap.put(new Integer(74), "staticAccessModifierOpt");
nonterminalStringToIntMap.put("staticAccessModifierOpt", new Integer(74));
}

private NodeNameUtility() { }

public static int getNonterminalCount() {
return nonterminalStringToIntMap.size();
}

public static String getTerminalName(int terminalType) {
return (String)(terminalIntToStringMap.get(new Integer(terminalType)));
}

public static String getNonterminalName(int nonterminalType) {
return (String)(nonterminalIntToStringMap.get(new Integer(nonterminalType)));
}

public static int getTerminalType(String terminalName) {
return ((Integer)(terminalStringToIntMap.get(terminalName))).intValue();
}

public static int getNonterminalType(String nonterminalName) {
return ((Integer)(nonterminalStringToIntMap.get(nonterminalName))).intValue();
}

}
