/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.debug.core.EDTDebugCorePlugin;
import org.eclipse.edt.debug.core.SMAPTransformer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class SMAPBuilder
extends IncrementalProjectBuilder {
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        switch (kind) {
            case 6: {
                this.buildAll();
                break;
            }
            default: {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    this.buildAll();
                    break;
                }
                delta.accept((IResourceDeltaVisitor)new ResourceDeltaVisitor());
            }
        }
        return null;
    }

    private void buildAll() throws CoreException {
        IJavaProject project = JavaCore.create((IProject)this.getProject());
        IClasspathEntry[] cp = project.getResolvedClasspath(true);
        HashSet<IPath> binDirectories = new HashSet<IPath>(cp.length);
        IClasspathEntry[] iClasspathEntryArray = cp;
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            IPath outputLocation;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && (outputLocation = entry.getOutputLocation()) != null) {
                binDirectories.add(outputLocation);
            }
            ++n2;
        }
        IPath outputLocation = project.getOutputLocation();
        if (outputLocation != null) {
            binDirectories.add(outputLocation);
        }
        ResourceVisitor visitor = new ResourceVisitor();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (IPath path : binDirectories) {
            IResource resource = root.findMember(path);
            if (resource == null) continue;
            resource.accept((IResourceVisitor)visitor);
        }
    }

    private void transform(IFile file) throws CoreException {
        byte[] classBytes;
        byte[] smapBytes;
        IResource smapFile;
        if ("class".equals(file.getFileExtension()) && (smapFile = ResourcesPlugin.getWorkspace().getRoot().findMember(file.getFullPath().removeFileExtension().addFileExtension("eglsmap"))) != null && smapFile.getType() == 1 && (smapBytes = this.getBytes((IFile)smapFile)) != null && (classBytes = this.getBytes(file)) != null) {
            try {
                byte[] newBytes = new SMAPTransformer.TransformerWorker().transform(file.getFullPath().toString(), classBytes, smapBytes);
                if (newBytes != null) {
                    file.setContents((InputStream)new BufferedInputStream(new ByteArrayInputStream(newBytes)), true, false, null);
                }
            }
            catch (IllegalClassFormatException e) {
                EDTDebugCorePlugin.log(e);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] getBytes(IFile file) {
        BufferedInputStream is = null;
        is = new BufferedInputStream(file.getContents());
        byte[] contents = new byte[((InputStream)is).available()];
        ((InputStream)is).read(contents);
        byte[] byArray = contents;
        if (is == null) return byArray;
        try {
            ((InputStream)is).close();
            return byArray;
        }
        catch (IOException iOException) {}
        return byArray;
        catch (IOException iOException) {
            if (is == null) return null;
            try {
                ((InputStream)is).close();
                return null;
            }
            catch (IOException iOException2) {}
            return null;
        }
        catch (CoreException coreException) {
            if (is == null) return null;
            {
                catch (Throwable throwable) {
                    if (is == null) throw throwable;
                    try {
                        ((InputStream)is).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                ((InputStream)is).close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    private class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource;
            if ((delta.getKind() == 4 || delta.getKind() == 1) && (resource = delta.getResource()).getType() == 1) {
                SMAPBuilder.this.transform((IFile)resource);
            }
            return true;
        }
    }

    private class ResourceVisitor
    implements IResourceVisitor {
        private ResourceVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 1) {
                SMAPBuilder.this.transform((IFile)resource);
            }
            return true;
        }
    }
}

